"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

/*
  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var Syntax = require("estraverse").Syntax;

var esrecurse = _interopRequire(require("esrecurse"));

function getLast(xs) {
    return xs[xs.length - 1] || null;
}

var PatternVisitor = (function (_esrecurse$Visitor) {
    function PatternVisitor(rootPattern, callback) {
        _classCallCheck(this, PatternVisitor);

        _get(Object.getPrototypeOf(PatternVisitor.prototype), "constructor", this).call(this);
        this.rootPattern = rootPattern;
        this.callback = callback;
        this.assignments = [];
        this.rightHandNodes = [];
        this.restElements = [];
    }

    _inherits(PatternVisitor, _esrecurse$Visitor);

    _createClass(PatternVisitor, {
        Identifier: {
            value: function Identifier(pattern) {
                var lastRestElement = getLast(this.restElements);
                this.callback(pattern, {
                    topLevel: pattern === this.rootPattern,
                    rest: lastRestElement != null && lastRestElement.argument === pattern,
                    assignments: this.assignments
                });
            }
        },
        Property: {
            value: function Property(property) {
                // Computed property's key is a right hand node.
                if (property.computed) {
                    this.rightHandNodes.push(property.key);
                }

                // If it's shorthand, its key is same as its value.
                // If it's shorthand and has its default value, its key is same as its value.left (the value is AssignmentPattern).
                // If it's not shorthand, the name of new variable is its value's.
                this.visit(property.value);
            }
        },
        ArrayPattern: {
            value: function ArrayPattern(pattern) {
                var i, iz, element;
                for (i = 0, iz = pattern.elements.length; i < iz; ++i) {
                    element = pattern.elements[i];
                    this.visit(element);
                }
            }
        },
        AssignmentPattern: {
            value: function AssignmentPattern(pattern) {
                this.assignments.push(pattern);
                this.visit(pattern.left);
                this.rightHandNodes.push(pattern.right);
                this.assignments.pop();
            }
        },
        RestElement: {
            value: function RestElement(pattern) {
                this.restElements.push(pattern);
                this.visit(pattern.argument);
                this.restElements.pop();
            }
        },
        MemberExpression: {
            value: function MemberExpression(node) {
                // Computed property's key is a right hand node.
                if (node.computed) {
                    this.rightHandNodes.push(node.property);
                }
                // the object is only read, write to its property.
                this.rightHandNodes.push(node.object);
            }
        },
        SpreadElement: {

            //
            // ForInStatement.left and AssignmentExpression.left are LeftHandSideExpression.
            // By spec, LeftHandSideExpression is Pattern or MemberExpression.
            //   (see also: https://github.com/estree/estree/pull/20#issuecomment-74584758)
            // But espree 2.0 and esprima 2.0 parse to ArrayExpression, ObjectExpression, etc...
            //

            value: function SpreadElement(node) {
                this.visit(node.argument);
            }
        },
        ArrayExpression: {
            value: function ArrayExpression(node) {
                node.elements.forEach(this.visit, this);
            }
        },
        AssignmentExpression: {
            value: function AssignmentExpression(node) {
                this.assignments.push(node);
                this.visit(node.left);
                this.rightHandNodes.push(node.right);
                this.assignments.pop();
            }
        },
        CallExpression: {
            value: function CallExpression(node) {
                var _this = this;

                // arguments are right hand nodes.
                node.arguments.forEach(function (a) {
                    _this.rightHandNodes.push(a);
                });
                this.visit(node.callee);
            }
        }
    }, {
        isPattern: {
            value: function isPattern(node) {
                var nodeType = node.type;
                return nodeType === Syntax.Identifier || nodeType === Syntax.ObjectPattern || nodeType === Syntax.ArrayPattern || nodeType === Syntax.SpreadElement || nodeType === Syntax.RestElement || nodeType === Syntax.AssignmentPattern;
            }
        }
    });

    return PatternVisitor;
})(esrecurse.Visitor);

module.exports = PatternVisitor;

/* vim: set sw=4 ts=4 et tw=80 : */
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhdHRlcm4tdmlzaXRvci5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUF3QlMsTUFBTSxXQUFRLFlBQVksRUFBMUIsTUFBTTs7SUFDUixTQUFTLDJCQUFNLFdBQVc7O0FBRWpDLFNBQVMsT0FBTyxDQUFDLEVBQUUsRUFBRTtBQUNqQixXQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxJQUFJLElBQUksQ0FBQztDQUNwQzs7SUFFb0IsY0FBYztBQWFwQixhQWJNLGNBQWMsQ0FhbkIsV0FBVyxFQUFFLFFBQVEsRUFBRTs4QkFibEIsY0FBYzs7QUFjM0IsbUNBZGEsY0FBYyw2Q0FjbkI7QUFDUixZQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQztBQUMvQixZQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztBQUN6QixZQUFJLENBQUMsV0FBVyxHQUFHLEVBQUUsQ0FBQztBQUN0QixZQUFJLENBQUMsY0FBYyxHQUFHLEVBQUUsQ0FBQztBQUN6QixZQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQztLQUMxQjs7Y0FwQmdCLGNBQWM7O2lCQUFkLGNBQWM7QUFzQi9CLGtCQUFVO21CQUFBLG9CQUFDLE9BQU8sRUFBRTtBQUNoQixvQkFBTSxlQUFlLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUNuRCxvQkFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLEVBQUU7QUFDbkIsNEJBQVEsRUFBRSxPQUFPLEtBQUssSUFBSSxDQUFDLFdBQVc7QUFDdEMsd0JBQUksRUFBRSxlQUFlLElBQUksSUFBSSxJQUFJLGVBQWUsQ0FBQyxRQUFRLEtBQUssT0FBTztBQUNyRSwrQkFBVyxFQUFFLElBQUksQ0FBQyxXQUFXO2lCQUNoQyxDQUFDLENBQUM7YUFDTjs7QUFFRCxnQkFBUTttQkFBQSxrQkFBQyxRQUFRLEVBQUU7O0FBRWYsb0JBQUksUUFBUSxDQUFDLFFBQVEsRUFBRTtBQUNuQix3QkFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2lCQUMxQzs7Ozs7QUFLRCxvQkFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7YUFDOUI7O0FBRUQsb0JBQVk7bUJBQUEsc0JBQUMsT0FBTyxFQUFFO0FBQ2xCLG9CQUFJLENBQUMsRUFBRSxFQUFFLEVBQUUsT0FBTyxDQUFDO0FBQ25CLHFCQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7QUFDbkQsMkJBQU8sR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzlCLHdCQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2lCQUN2QjthQUNKOztBQUVELHlCQUFpQjttQkFBQSwyQkFBQyxPQUFPLEVBQUU7QUFDdkIsb0JBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQy9CLG9CQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUN6QixvQkFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3hDLG9CQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsRUFBRSxDQUFDO2FBQzFCOztBQUVELG1CQUFXO21CQUFBLHFCQUFDLE9BQU8sRUFBRTtBQUNqQixvQkFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDaEMsb0JBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBQzdCLG9CQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDO2FBQzNCOztBQUVELHdCQUFnQjttQkFBQSwwQkFBQyxJQUFJLEVBQUU7O0FBRW5CLG9CQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7QUFDZix3QkFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO2lCQUMzQzs7QUFFRCxvQkFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2FBQ3pDOztBQVNELHFCQUFhOzs7Ozs7Ozs7bUJBQUEsdUJBQUMsSUFBSSxFQUFFO0FBQ2hCLG9CQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQzthQUM3Qjs7QUFFRCx1QkFBZTttQkFBQSx5QkFBQyxJQUFJLEVBQUU7QUFDbEIsb0JBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7YUFDM0M7O0FBRUQsNEJBQW9CO21CQUFBLDhCQUFDLElBQUksRUFBRTtBQUN2QixvQkFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDNUIsb0JBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ3RCLG9CQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDckMsb0JBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxFQUFFLENBQUM7YUFDMUI7O0FBRUQsc0JBQWM7bUJBQUEsd0JBQUMsSUFBSSxFQUFFOzs7O0FBRWpCLG9CQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxVQUFBLENBQUMsRUFBSTtBQUFFLDBCQUFLLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7aUJBQUUsQ0FBQyxDQUFDO0FBQzlELG9CQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQzthQUMzQjs7O0FBbEdNLGlCQUFTO21CQUFBLG1CQUFDLElBQUksRUFBRTtBQUNuQixvQkFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQztBQUN6Qix1QkFDSSxRQUFRLEtBQUssTUFBTSxDQUFDLFVBQVUsSUFDOUIsUUFBUSxLQUFLLE1BQU0sQ0FBQyxhQUFhLElBQ2pDLFFBQVEsS0FBSyxNQUFNLENBQUMsWUFBWSxJQUNoQyxRQUFRLEtBQUssTUFBTSxDQUFDLGFBQWEsSUFDakMsUUFBUSxLQUFLLE1BQU0sQ0FBQyxXQUFXLElBQy9CLFFBQVEsS0FBSyxNQUFNLENBQUMsaUJBQWlCLENBQ3ZDO2FBQ0w7Ozs7V0FYZ0IsY0FBYztHQUFTLFNBQVMsQ0FBQyxPQUFPOztpQkFBeEMsY0FBYyIsImZpbGUiOiJwYXR0ZXJuLXZpc2l0b3IuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICBDb3B5cmlnaHQgKEMpIDIwMTUgWXVzdWtlIFN1enVraSA8dXRhdGFuZS50ZWFAZ21haWwuY29tPlxuXG4gIFJlZGlzdHJpYnV0aW9uIGFuZCB1c2UgaW4gc291cmNlIGFuZCBiaW5hcnkgZm9ybXMsIHdpdGggb3Igd2l0aG91dFxuICBtb2RpZmljYXRpb24sIGFyZSBwZXJtaXR0ZWQgcHJvdmlkZWQgdGhhdCB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnMgYXJlIG1ldDpcblxuICAgICogUmVkaXN0cmlidXRpb25zIG9mIHNvdXJjZSBjb2RlIG11c3QgcmV0YWluIHRoZSBhYm92ZSBjb3B5cmlnaHRcbiAgICAgIG5vdGljZSwgdGhpcyBsaXN0IG9mIGNvbmRpdGlvbnMgYW5kIHRoZSBmb2xsb3dpbmcgZGlzY2xhaW1lci5cbiAgICAqIFJlZGlzdHJpYnV0aW9ucyBpbiBiaW5hcnkgZm9ybSBtdXN0IHJlcHJvZHVjZSB0aGUgYWJvdmUgY29weXJpZ2h0XG4gICAgICBub3RpY2UsIHRoaXMgbGlzdCBvZiBjb25kaXRpb25zIGFuZCB0aGUgZm9sbG93aW5nIGRpc2NsYWltZXIgaW4gdGhlXG4gICAgICBkb2N1bWVudGF0aW9uIGFuZC9vciBvdGhlciBtYXRlcmlhbHMgcHJvdmlkZWQgd2l0aCB0aGUgZGlzdHJpYnV0aW9uLlxuXG4gIFRISVMgU09GVFdBUkUgSVMgUFJPVklERUQgQlkgVEhFIENPUFlSSUdIVCBIT0xERVJTIEFORCBDT05UUklCVVRPUlMgXCJBUyBJU1wiXG4gIEFORCBBTlkgRVhQUkVTUyBPUiBJTVBMSUVEIFdBUlJBTlRJRVMsIElOQ0xVRElORywgQlVUIE5PVCBMSU1JVEVEIFRPLCBUSEVcbiAgSU1QTElFRCBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSBBTkQgRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0VcbiAgQVJFIERJU0NMQUlNRUQuIElOIE5PIEVWRU5UIFNIQUxMIDxDT1BZUklHSFQgSE9MREVSPiBCRSBMSUFCTEUgRk9SIEFOWVxuICBESVJFQ1QsIElORElSRUNULCBJTkNJREVOVEFMLCBTUEVDSUFMLCBFWEVNUExBUlksIE9SIENPTlNFUVVFTlRJQUwgREFNQUdFU1xuICAoSU5DTFVESU5HLCBCVVQgTk9UIExJTUlURUQgVE8sIFBST0NVUkVNRU5UIE9GIFNVQlNUSVRVVEUgR09PRFMgT1IgU0VSVklDRVM7XG4gIExPU1MgT0YgVVNFLCBEQVRBLCBPUiBQUk9GSVRTOyBPUiBCVVNJTkVTUyBJTlRFUlJVUFRJT04pIEhPV0VWRVIgQ0FVU0VEIEFORFxuICBPTiBBTlkgVEhFT1JZIE9GIExJQUJJTElUWSwgV0hFVEhFUiBJTiBDT05UUkFDVCwgU1RSSUNUIExJQUJJTElUWSwgT1IgVE9SVFxuICAoSU5DTFVESU5HIE5FR0xJR0VOQ0UgT1IgT1RIRVJXSVNFKSBBUklTSU5HIElOIEFOWSBXQVkgT1VUIE9GIFRIRSBVU0UgT0ZcbiAgVEhJUyBTT0ZUV0FSRSwgRVZFTiBJRiBBRFZJU0VEIE9GIFRIRSBQT1NTSUJJTElUWSBPRiBTVUNIIERBTUFHRS5cbiovXG5cbmltcG9ydCB7IFN5bnRheCB9IGZyb20gJ2VzdHJhdmVyc2UnO1xuaW1wb3J0IGVzcmVjdXJzZSBmcm9tICdlc3JlY3Vyc2UnO1xuXG5mdW5jdGlvbiBnZXRMYXN0KHhzKSB7XG4gICAgcmV0dXJuIHhzW3hzLmxlbmd0aCAtIDFdIHx8IG51bGw7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFBhdHRlcm5WaXNpdG9yIGV4dGVuZHMgZXNyZWN1cnNlLlZpc2l0b3Ige1xuICAgIHN0YXRpYyBpc1BhdHRlcm4obm9kZSkge1xuICAgICAgICB2YXIgbm9kZVR5cGUgPSBub2RlLnR5cGU7XG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICBub2RlVHlwZSA9PT0gU3ludGF4LklkZW50aWZpZXIgfHxcbiAgICAgICAgICAgIG5vZGVUeXBlID09PSBTeW50YXguT2JqZWN0UGF0dGVybiB8fFxuICAgICAgICAgICAgbm9kZVR5cGUgPT09IFN5bnRheC5BcnJheVBhdHRlcm4gfHxcbiAgICAgICAgICAgIG5vZGVUeXBlID09PSBTeW50YXguU3ByZWFkRWxlbWVudCB8fFxuICAgICAgICAgICAgbm9kZVR5cGUgPT09IFN5bnRheC5SZXN0RWxlbWVudCB8fFxuICAgICAgICAgICAgbm9kZVR5cGUgPT09IFN5bnRheC5Bc3NpZ25tZW50UGF0dGVyblxuICAgICAgICApO1xuICAgIH1cblxuICAgIGNvbnN0cnVjdG9yKHJvb3RQYXR0ZXJuLCBjYWxsYmFjaykge1xuICAgICAgICBzdXBlcigpO1xuICAgICAgICB0aGlzLnJvb3RQYXR0ZXJuID0gcm9vdFBhdHRlcm47XG4gICAgICAgIHRoaXMuY2FsbGJhY2sgPSBjYWxsYmFjaztcbiAgICAgICAgdGhpcy5hc3NpZ25tZW50cyA9IFtdO1xuICAgICAgICB0aGlzLnJpZ2h0SGFuZE5vZGVzID0gW107XG4gICAgICAgIHRoaXMucmVzdEVsZW1lbnRzID0gW107XG4gICAgfVxuXG4gICAgSWRlbnRpZmllcihwYXR0ZXJuKSB7XG4gICAgICAgIGNvbnN0IGxhc3RSZXN0RWxlbWVudCA9IGdldExhc3QodGhpcy5yZXN0RWxlbWVudHMpO1xuICAgICAgICB0aGlzLmNhbGxiYWNrKHBhdHRlcm4sIHtcbiAgICAgICAgICAgIHRvcExldmVsOiBwYXR0ZXJuID09PSB0aGlzLnJvb3RQYXR0ZXJuLFxuICAgICAgICAgICAgcmVzdDogbGFzdFJlc3RFbGVtZW50ICE9IG51bGwgJiYgbGFzdFJlc3RFbGVtZW50LmFyZ3VtZW50ID09PSBwYXR0ZXJuLFxuICAgICAgICAgICAgYXNzaWdubWVudHM6IHRoaXMuYXNzaWdubWVudHNcbiAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgUHJvcGVydHkocHJvcGVydHkpIHtcbiAgICAgICAgLy8gQ29tcHV0ZWQgcHJvcGVydHkncyBrZXkgaXMgYSByaWdodCBoYW5kIG5vZGUuXG4gICAgICAgIGlmIChwcm9wZXJ0eS5jb21wdXRlZCkge1xuICAgICAgICAgICAgdGhpcy5yaWdodEhhbmROb2Rlcy5wdXNoKHByb3BlcnR5LmtleSk7XG4gICAgICAgIH1cblxuICAgICAgICAvLyBJZiBpdCdzIHNob3J0aGFuZCwgaXRzIGtleSBpcyBzYW1lIGFzIGl0cyB2YWx1ZS5cbiAgICAgICAgLy8gSWYgaXQncyBzaG9ydGhhbmQgYW5kIGhhcyBpdHMgZGVmYXVsdCB2YWx1ZSwgaXRzIGtleSBpcyBzYW1lIGFzIGl0cyB2YWx1ZS5sZWZ0ICh0aGUgdmFsdWUgaXMgQXNzaWdubWVudFBhdHRlcm4pLlxuICAgICAgICAvLyBJZiBpdCdzIG5vdCBzaG9ydGhhbmQsIHRoZSBuYW1lIG9mIG5ldyB2YXJpYWJsZSBpcyBpdHMgdmFsdWUncy5cbiAgICAgICAgdGhpcy52aXNpdChwcm9wZXJ0eS52YWx1ZSk7XG4gICAgfVxuXG4gICAgQXJyYXlQYXR0ZXJuKHBhdHRlcm4pIHtcbiAgICAgICAgdmFyIGksIGl6LCBlbGVtZW50O1xuICAgICAgICBmb3IgKGkgPSAwLCBpeiA9IHBhdHRlcm4uZWxlbWVudHMubGVuZ3RoOyBpIDwgaXo7ICsraSkge1xuICAgICAgICAgICAgZWxlbWVudCA9IHBhdHRlcm4uZWxlbWVudHNbaV07XG4gICAgICAgICAgICB0aGlzLnZpc2l0KGVsZW1lbnQpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgQXNzaWdubWVudFBhdHRlcm4ocGF0dGVybikge1xuICAgICAgICB0aGlzLmFzc2lnbm1lbnRzLnB1c2gocGF0dGVybik7XG4gICAgICAgIHRoaXMudmlzaXQocGF0dGVybi5sZWZ0KTtcbiAgICAgICAgdGhpcy5yaWdodEhhbmROb2Rlcy5wdXNoKHBhdHRlcm4ucmlnaHQpO1xuICAgICAgICB0aGlzLmFzc2lnbm1lbnRzLnBvcCgpO1xuICAgIH1cblxuICAgIFJlc3RFbGVtZW50KHBhdHRlcm4pIHtcbiAgICAgICAgdGhpcy5yZXN0RWxlbWVudHMucHVzaChwYXR0ZXJuKTtcbiAgICAgICAgdGhpcy52aXNpdChwYXR0ZXJuLmFyZ3VtZW50KTtcbiAgICAgICAgdGhpcy5yZXN0RWxlbWVudHMucG9wKCk7XG4gICAgfVxuXG4gICAgTWVtYmVyRXhwcmVzc2lvbihub2RlKSB7XG4gICAgICAgIC8vIENvbXB1dGVkIHByb3BlcnR5J3Mga2V5IGlzIGEgcmlnaHQgaGFuZCBub2RlLlxuICAgICAgICBpZiAobm9kZS5jb21wdXRlZCkge1xuICAgICAgICAgICAgdGhpcy5yaWdodEhhbmROb2Rlcy5wdXNoKG5vZGUucHJvcGVydHkpO1xuICAgICAgICB9XG4gICAgICAgIC8vIHRoZSBvYmplY3QgaXMgb25seSByZWFkLCB3cml0ZSB0byBpdHMgcHJvcGVydHkuXG4gICAgICAgIHRoaXMucmlnaHRIYW5kTm9kZXMucHVzaChub2RlLm9iamVjdCk7XG4gICAgfVxuXG4gICAgLy9cbiAgICAvLyBGb3JJblN0YXRlbWVudC5sZWZ0IGFuZCBBc3NpZ25tZW50RXhwcmVzc2lvbi5sZWZ0IGFyZSBMZWZ0SGFuZFNpZGVFeHByZXNzaW9uLlxuICAgIC8vIEJ5IHNwZWMsIExlZnRIYW5kU2lkZUV4cHJlc3Npb24gaXMgUGF0dGVybiBvciBNZW1iZXJFeHByZXNzaW9uLlxuICAgIC8vICAgKHNlZSBhbHNvOiBodHRwczovL2dpdGh1Yi5jb20vZXN0cmVlL2VzdHJlZS9wdWxsLzIwI2lzc3VlY29tbWVudC03NDU4NDc1OClcbiAgICAvLyBCdXQgZXNwcmVlIDIuMCBhbmQgZXNwcmltYSAyLjAgcGFyc2UgdG8gQXJyYXlFeHByZXNzaW9uLCBPYmplY3RFeHByZXNzaW9uLCBldGMuLi5cbiAgICAvL1xuXG4gICAgU3ByZWFkRWxlbWVudChub2RlKSB7XG4gICAgICAgIHRoaXMudmlzaXQobm9kZS5hcmd1bWVudCk7XG4gICAgfVxuXG4gICAgQXJyYXlFeHByZXNzaW9uKG5vZGUpIHtcbiAgICAgICAgbm9kZS5lbGVtZW50cy5mb3JFYWNoKHRoaXMudmlzaXQsIHRoaXMpO1xuICAgIH1cblxuICAgIEFzc2lnbm1lbnRFeHByZXNzaW9uKG5vZGUpIHtcbiAgICAgICAgdGhpcy5hc3NpZ25tZW50cy5wdXNoKG5vZGUpO1xuICAgICAgICB0aGlzLnZpc2l0KG5vZGUubGVmdCk7XG4gICAgICAgIHRoaXMucmlnaHRIYW5kTm9kZXMucHVzaChub2RlLnJpZ2h0KTtcbiAgICAgICAgdGhpcy5hc3NpZ25tZW50cy5wb3AoKTtcbiAgICB9XG5cbiAgICBDYWxsRXhwcmVzc2lvbihub2RlKSB7XG4gICAgICAgIC8vIGFyZ3VtZW50cyBhcmUgcmlnaHQgaGFuZCBub2Rlcy5cbiAgICAgICAgbm9kZS5hcmd1bWVudHMuZm9yRWFjaChhID0+IHsgdGhpcy5yaWdodEhhbmROb2Rlcy5wdXNoKGEpOyB9KTtcbiAgICAgICAgdGhpcy52aXNpdChub2RlLmNhbGxlZSk7XG4gICAgfVxufVxuXG4vKiB2aW06IHNldCBzdz00IHRzPTQgZXQgdHc9ODAgOiAqL1xuIl0sInNvdXJjZVJvb3QiOiIvc291cmNlLyJ9
