# Node Foundation CTC Meeting 2016-07-27

## Links

* **Audio Recording**: https://www.youtube.com/watch?v=QAufnqo4ElY
* **GitHub Issue**: https://github.com/nodejs/node/issues/7881
* **Minutes Google Doc**: <https://docs.google.com/document/d/1rHxRb-ImjwFPOCOapgRDLdhqr4LJvie7eDNPOnDu2UA>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1Gr1XX-DuzgGXON5uAzrZHjWwXoQ4AIJEAJ2DK5jNmp4>_

## Present

* Anna Henningsen @addaleax (observer)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Fedor Indutny @indutny (CTC)
* James M Snell @jasnell (CTC)
* Julien Gilli @misterdjules (CTC)
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
* Brian White @mscdex (CTC)
* Alexis Campailla @orangemocha (CTC)
* Rod Vagg @rvagg (CTC)
* Steven R Loomis @srl295 (observer/IBM/ICU)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)
* William Kapke @williamkapke (observer)


## Standup

* Anna Henningsen @addaleax (observer)
    * Issues & PRs
    * Some realpath work
* Сковорода Никита Андреевич @ChALkeR (CTC)
    * Mostly comments and reviews, nothing significant
* Fedor Indutny @indutny (CTC)
    * Issues, PRs, Direct-to-BIO experiments
* James M Snell @jasnell (CTC)
    * Glorious vacation …
    * Catching up
    * Small clarification PR for IRC moderation
* Julien Gilli @misterdjules (CTC)
    * PR reviews, especially https://github.com/nodejs/node/pull/7827, which looks like a very solid first contribution from a new contributor.
* Brian White @mscdex (CTC)
    * Continued reworking of API docs
    * Reviewed PRs, commented on issues
* Alexis Campailla @orangemocha (CTC)
    * Investigating issues related to fs.realPath
    * Investigating binary compatibility between Node and native modules compiled with different VS versions
    * Working with team on various Windows issues in Node and libuv
* Rod Vagg @rvagg (CTC)
    * NodeSummit / travel, Node v5 blog post nearly ready to post, bug in require() (still need to post in nodejs/node)
    * Steven R Loomis @srl295 (observer/IBM/ICU)
    * @ NodeSummit / prep… thinking about how to keep an eye on upcoming v8 changes. Did some more work on https://github.com/nodejs/node/issues/3460 (detect full-icu module).
* Trevor Norris @trevnorris (CTC)
    * NodeSummit talk
    * fs.realpath()
    * Prepping AsyncWrap, target end of August
* Rich Trott @Trott (CTC)
    * Updating governance text and whatnot
    * Flaky tests
    * NodeSummit talk
* William Kapke @williamkapke (Observer)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Role of CTC in semver-major changes needs clarification [#7848](https://github.com/nodejs/node/issues/7848)
* Revert fs changes [#7846](https://github.com/nodejs/node/pull/7846)
* doc: add information about CTC quorum rules [#7813](https://github.com/nodejs/node/pull/7813)
* meta: provide example activities [#7744](https://github.com/nodejs/node/pull/7744)
* meta: realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)
* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)
* punycode: deprecate punycode module [#7552](https://github.com/nodejs/node/pull/7552)
* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

### nodejs/post-mortem

* Repositories to contribute collaboratively [#30](https://github.com/nodejs/post-mortem/issues/30)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)


## Previous Meeting

### nodejs/node

* [meta] realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)
* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

## Minutes


### Role of CTC in semver-major changes needs clarification [#7848](https://github.com/nodejs/node/issues/7848)




### Revert fs changes [#7846](https://github.com/nodejs/node/pull/7846)


James: has to do with recent changes - making callback mandatory on all async functions apparently _broke the planet_, quite a few modules broke including a number used by npm, so `npm set` failed to work for example.

James: technically this should be viewed as a bugfix but we’ve already treated things involving errors as sensitive but this is on master and things a broken right now so suggesting that we revert this. Some alternatives are: not revert and get fixes in the ecosystem, revert and add warning.

Rich: Myles endorsed [#7897](https://github.com/nodejs/node/pull/7897) as a better alternative to reverting as it includes a warning. What’s the preferred approach here James?

James: revert, even though I don’t like it, we should revert and revisit.

Trevor: the fact that it was allowed was a bad decision because throwing can lead to hard-to-debug situations. Reverting is the _only course of action_.

Rod: wanted to clarify as a matter of culture - we should fix master as soon as we’re aware of breakage in the ecosystem and deal with things more cleanly as we can.

Julien: multiple commits in the revert PR, we should have separate discussions about them.

James: will ask on the PR that they be split into two.

James: second question here is whether we want to emit a warning instead?

Rod: the graceful-fs warnings are still widespread because lots of packages rely on very old versions and it’s taking a long time to get updates through the ecosystem. We have to be careful about (1) warning fatigue, (2) users not understanding the subtlety and interpreting warnings as errors. Would be good if we go a bit slower on moving to warnings.

James: we could run with warnings off by default as a way of dealing warning fatigue but that’s another discussion we can have on GitHub.

Rich: moving on, this can be done on Github.

### doc: add information about CTC quorum rules [#7813](https://github.com/nodejs/node/pull/7813)

Rich: there was a counter-proposal which seemed to be better so I updated to use Chalker’s alternative wording. **If anyone doesn’t want this to land please comment on it within the next 24 hours or so**. There hasn’t been too much discussion or disagreement.

### meta: provide example activities [#7744](https://github.com/nodejs/node/pull/7744)

Rich: Similar to the previous issue - have not got a whole lot of response, or a luke-warm response at least. Please comment in there if you have any problems with it, there are no negatives so it’ll land in the next 24 hours or so so please comment!

### \[meta\] realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)

Trevor: ran some benchmarks in CI to see how much time it would take to require() with and without cache in realpath. Haven’t done Windows but on the others there was between 10% to 100%, which is between 30us to 300us difference per require().

Alexis: [#7899](https://github.com/nodejs/node/pull/7899) reverts and also includes Myles’ reversions from the other fs issues.

Trevor: probably should revert and leave cache out, we might take a small hit now in perf but will lead to greater potential in the future.

Alexis: the cache was never a great API in the first place anyway.

Trevor: propose we revert and leave the cache and introduce a better fix.

Anna: agree with Trevor and Alexis.

Rod: should we get benchmarks on Windows?

Alexis: much more concerned about correctness than performance.

Trevor: this is a short-term fix, so we shouldn’t have a problem bringing it in.

Rich asked for disagreement with moving forward with reversion without cache? No disagreement. Need to comment on 7899, review & lgtm. Anna, Trevor or Alexis will move it forward.

### v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

James: because this adds some semver-minor’s Myles is very concerned about stability.

Julien: any ideas on how we might be able to get more testers for these?

James: maybe in a week, will get some suggestions posted to the LTS repo that we can discuss.

### punycode: deprecate punycode module [#7552](https://github.com/nodejs/node/pull/7552)

James: this is a 3rd party dependency that we expose and there’s some fairly extensive usage out there but there is a newer version out there in npm that people should be using.

Rich: no more comments? Please post on the repo.

Rod: deprecation is fine but would really like a long deprecation cycle.

James: how about soft deprecation in v7 and hard in v8?

Rod: soft in v7 and revisit decision to hard prior to v8.

Brian: if people build without ICU what would happen to punycode since we need it?

James: This particular PR introduces a hard deprecation that moves it to internal/ and has a shim that exposes it, so we could still use it internally but just deprecate the external API.

Brian: are we going to continue updating the non-ICU version for people going forward or just leave it?

James: would prefer to just leave it as is.

Chalker: on npm it has 5.7M downloads per month so people are already using it.

James: clarify: soft deprecate now and revisit hard deprecation prior to v8?

### http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

Rod: wanted to mention that Chris Dickinson expressed concerns on Twitter about us doing this same thing on querystring and that it was causing problems for him and didn’t like that it crept in to v6.

James: Doug, from the express side, thinks this is a good decision and cleans up things for users. The querystring thing has

… discussion tended towards accepting the change but CTC would like to solicit input from Chris Dickinson before getting it landed since he had raised some objections

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

Mikeal Rogers: discussing the SPDX stuff and restoration of licenses in the files. Mikeal and Rod will take the lead on moving forward with this.

### Repositories to contribute collaboratively [post-mortem#30](https://github.com/nodejs/post-mortem/issues/30)

Move to TSC meeting

### proposal: WHATWG URL standard implementation [node-eps#28](https://github.com/nodejs/node-eps/pull/28)

James: Passing WHATWG tests except some intentional ones. Performance is slower than our own url impl because of tests we fail. Any objections to moving forward?

Rod: we’re going to have two implementations, this seems like a difficult thing to agree on.

James: would like to eventually deprecate existing url.parse.

Rich: let’s move on because this will be a big conversation. Let’s have a brief conversation next week and slot a bigger discussion next week.

## Q/A on public fora

No questions.

## Upcoming Meetings

* CTC: 2016-08-03
* TSC: 2016-07-28
* Build: 2016-08-09
* Diagnostics: 2016-08-03
* Post-Mortem: August
* API: August
