# Node Foundation CTC Meeting 2016-10-19

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#9143](https://github.com/nodejs/node/issues/9143)
* **Minutes Google Doc**: <https://docs.google.com/document/d/18rnF8IfO10aQ0gRRasH3zSuv397-lm_x1fX1FSGcV7E>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/16l9D_OvAkeG6JoM_HRomHcFl--FTB61quvIWo9QfsVw>_

## Present

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* James M Snell @jasnell (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Julien Gilli @misterdjules (CTC)
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
* Steven R. Loomis @srl295 (observer)
* Sakthipriyan Vairamani @thefourtheye (observer)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Standup

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Vacation, work on import changes for ES spec
* Colin Ihrig @cjihrig (CTC)
  * Reviewed issues and PRs. Revisited an old PR.
* Evan Lucas @evanlucas (CTC)
  * cut v6.8.1 release
  * opened small doc PR
  * issue/pr review
* James M Snell @jasnell (CTC)
  * Preparing v7.0.0 release
  * HTTP/2 implementation
  * PRs
* Josh Gavant @joshgav (observer/Microsoft)
  * PR’s to improve user experience with new debugger
  * investigating how to integrate guides with API docs
  * off this week
* Michael Dawson @mhdawson (CTC)
  * couple days vacation
  * Added code coverage nightly job and PR for doc
  * misc issue review/comment/lands
  * Some Abi stable node discussion/work
  * A number of benchmarking issues to look at
* Julien Gilli @misterdjules (CTC)
  * nothing too significant
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
  * Putting together bugeting stuff
* Brian White @mscdex (CTC)
  * Continued work on improving string encoding/decoding
  performance.
  * Commented on issues, reviewed PRs.
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Some V8 backport triage. Not much else notable.
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
  * Just observing, no update
* Steven R. Loomis @srl295 (observer)
  * ICU 58 going GA  end of week so will submit PR to update - [#7844](https://github.com/nodejs/node/issues/7844)
  * Backported break iterator fix to v4.x [#9008](https://github.com/nodejs/node/pull/9008)
* Sakthipriyan Vairamani @thefourtheye (observer)
  * mostly PR reviews
* Trevor Norris @trevnorris (CTC)
  * Worked with Matt Loring, proposed promise hooks api is
  sufficient combined with debugger API.
* Rich Trott @Trott (CTC)
  * Outreachy
  * flaky tests
  * linting tools and rules

---

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* doc: add ctc-review label information [#9072](https://github.com/nodejs/node/pull/9072) @Trott
* http: improve invalid character in header error message [#9010](https://github.com/nodejs/node/pull/9010) @evanlucas
* net: multiple listen() events fail silently [#8419](https://github.com/nodejs/node/pull/8419) @jasnell

### nodejs/TSC

* Consider folding TSC into CTC [#146](https://github.com/nodejs/TSC/issues/146) @rvagg


---

## Previous Meeting Review

### nodejs/node

* governance: expand use of CTC issue tracker [#8945](https://github.com/nodejs/node/pull/8945)

    * Finalize through GitHub discussions.
    * Consider `ctc-review` label (#9072).

* doc: add supported platforms list [#8922](https://github.com/nodejs/node/pull/8922)

    * Complete, remove from agenda.

* net: multiple listen() events fail silently [#8419](https://github.com/nodejs/node/pull/8419)

    * Back to GitHub for further discussion.

### nodejs/TSC

* Consider folding TSC into CTC [#146](https://github.com/nodejs/TSC/issues/146)

---

## Minutes

### doc: add ctc-review label information [#9072](https://github.com/nodejs/node/pull/9072) @Trott

@trott: Has landed. If any objections speak now. Goal is more resolutions within tracker, less in meetings.

---

### http: improve invalid character in header error message [#9010](https://github.com/nodejs/node/pull/9010) @evanlucas

@evanlucas: Concerns about this leading to an information leak, because header name is displayed.

Would like to land this for v7. Would have to be merged today.

@trott: Question is if people are uncomfortable moving forward now before information from @Chalker is available.

@mhdawson: Seems there are already some hits (problems).

@evanlucas: Package `http-node` had problems, seems they copied `_http_outgoing.js`.

@evanlucas: Perhaps we can just add a debug message, that would not be semver-major.

@mhdawson: Seems better to do that than introduce a semver-major change this late.

@evanlucas: That seems fine, as long as we can get the needed info.

@trott: So land the debug message now, perhaps land standard output in v8.x.

**Next steps**:

* Create new PR with debug-based message, defer including in stderr/stdout till v8.x.

---

### net: multiple listen() events fail silently [#8419](https://github.com/nodejs/node/pull/8419) @jasnell

@jasnell: Question is whether to land in v7.x. If so please take it up today!

---

### Consider folding TSC into CTC [#146](https://github.com/nodejs/TSC/issues/146) @rvagg

@trott: Mainly to bring this to people’s attention, continue conversation in tracker.

---

### Info text in `--inspect` output [#8978](https://github.com/nodejs/node/pull/8978)

@joshgav: Should we land this for v7.x?

@trott: Is this a semver-major change?

@jasnell: No, especially cause this is an experimental feature.

@evanlucas: I’d prefer to wait till Chrome automatically lists Node.js targets via chrome://inspect, which is 55.

@ofrobots: No urgency to land this change now and it will make it harder to get started.

@mhdawson: Agreed, no urgency to land this before v7.x.

@joshgav: So I’ll update PR to include generic URL but not remove the chrome-devtools URL for now.

**Next steps**:

* Josh to update PR to still include chrome-devtools URL.
* Consider removing chrome-devtools URL when 55 is released (early December).

---

## Q/A on public channels


---

## Upcoming Meetings

* CTC: 2016-10-26, 9am Pacific
* TSC: 2016-10-20, 1pm Pacific
* Build: 2016-10-24 (?)
* Diagnostics: first week of November
* Benchmarking:
* LTS:
* Post-Mortem:
* API:
