# Node Foundation CTC Meeting 2016-09-28

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8802](https://github.com/nodejs/node/issues/8802)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1ZsLMM29guCBPGh7KhuhZEq6YQCKybiTfTUIXajTBalM/>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1-PS20PGCJQIi4_quBHqVgrQNJeJP10NH21wUelcMhfw>


## Present

* Anna Henningsen @addaleax (CTC)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
* Rod Vagg @rvagg (CTC)
* Seth Thompson @s3ththompson (observer/Google)
* Myles Borins @TheAlphaNerd (CTC)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Standup

* Anna Henningsen @addaleax (CTC)
  * The usual, issues and PR reviews
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Some issue and PR comments and reviews as usual.
  * Some more work on docs linting.
* Colin Ihrig @cjihrig (CTC)
  * Reviewing issues and PRs.
  * Evan Lucas @evanlucas (CTC)
  * v6.7.0 release
  * More work on types eps
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Issue / PR Review … general stuff
  * Working towards ES Modules prototype implementations with Chris Dickinson
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
  * getting the Outreachy info on website
* Josh Gavant @joshgav (observer/Microsoft)
  * helping bring in some new MS contributors
  * scheduled diag meeting for next week
* Michael Dawson @mhdawson (CTC)
  * Finishing off PPC migration
  * Fixing AIX issues when building from node-private
  * Some work on ABI-stable node
  * Misc PR review/lands
  * Keeping up with issues
  * Post-mortem nodereport review
* Brian White @mscdex (CTC)
  * Worked on various performance improvements in node core
  * Reviewed PRs, commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Looking at node+V8 (5.5) integration build failures that seem related to recent parser improvements
  * Investigating performance with the new interpreter
  * Working with @matthewloring on FFI
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
  * No update, just observing
* Rod Vagg @rvagg (CTC)
  * Security releases, supposed to be on vacation
* Seth Thompson @s3ththompson (observer/Google)
  * async/await landed in V8 Tip of Tree. on track to ship with V8 5.5
  * expect a doc from V8 language team on promise hook API to allow microtask introspection in the near future
* Myles Borins @TheAlphaNerd (CTC)
  * issue / pr review
  * helping with security release
  * backporting inspector
  * auditing v4 backlog
  * really have to get to that tap reporter
  * coming up with outreachy mentor project
* Trevor Norris @trevnorris (CTC)
  * AsyncHooks
* Rich Trott @Trott (CTC)
  * mentoring more first-time contributors (via Node Todo)
  * doc, test PRs
  * ramping up a tiny bit on Build WG stuff, but just a tiny bit


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/CTC

* Scheduling Meetings [#14](https://github.com/nodejs/CTC/issues/14)

### nodejs/node

* meta: update NODE_MODULE_VERSION to 51 [#8808](https://github.com/nodejs/node/pull/8808)
* General v7.0.0 / v6 LTS Planning / Discussion


## Previous Meeting Review

* deps: update V8 to 5.4 [#8317](https://github.com/nodejs/node/pull/8317)
* Scheduling Meetings [#14](https://github.com/nodejs/CTC/issues/14)
* Decide on what problem points for ES Modules we care about the most. [#15](https://github.com/nodejs/CTC/issues/15)


## Minutes

### Scheduling Meetings [ctc#14](https://github.com/nodejs/CTC/issues/14)

@trott: This is a status report. Initial proposal was to dive in and start rotating meetings. Some were on board, some were concerned. Nikita started Google spreadsheet to figure things out.

One proposal is to move back one hour (12pm Pacific) which would be a mild improvement for Ben and Nikita.

Input received from NA and EU but not Asia and Australia. Once we have that information we can figure out what might work.

---

### meta: update NODE_MODULE_VERSION to 51 [#8808](https://github.com/nodejs/node/pull/8808)

`process.versions.modules` == 48 for v6.7.0.

Set in build script, we bump this number for each semver-minor. We’d update to 49, but Electron has been bumping in between, so we need to go to 51.

@thealphanerd: Had a way to do this in the past, but never landed a version of V8 on master [before a release]. So those using master cannot rely on this check.

Proposal is to add this to master now and v7.x when released. But should we wait to bump till the actual release?

@rvagg: If you’re using master, it’s been a bit “buyer beware” in the past.

@thealphanerd: Node-pre-gyp uses the module version number to determine whether to pull the pre-built binary or to rebuild. So that’s causing problems.

@ofrobots: Is there a disadvantage to doing this now?

@rvagg: Doesn’t seem to be.

@joshgav: Any concern that we’d have to bump again at v7.x release?

@rvagg: We’ll just bump again.

@addaleax: We should watch what Electron is doing cause they pull in every V8 version.

@trevnorris: Could it happen that newer version of V8 has a lower module version number?

@trott: if module version mapped to V8 version we could always be in sync.

@ofrobots: Problem is that ABI is more than just V8. Also, we’re moving to a VM-neutral API/ABI in the future and that will remove the relationship to a V8 version.

@rvagg: We should coordinate with Electron and draw from the same pool of numbers.

@ofrobots: A good point for a bump would be when we bring a new V8 into master.

@rvagg: This would make testing those nightlies easier.

@trevnorris: Sounds to me that we can’t map reliably map a version of Node to a version of V8. So pulling from the same pool as Electron might be misleading to developers. If the number in Electron doesn’t match a Node version there would be a conflict.

@rvagg: People are tracking which module versions map to what, so they could follow this too.

@trevnorris: Maybe we can give Electron the minor numbers.

@rvagg: NW.js also had a similar issue.

@thealphanerd: Electron bumped to 5.1 in an ABI-breaking way, so we have two versions of Node ABIs out there, cause they needed to stay closer to Chromium.

@rvagg: They don’t need to keep up with the latest version of V8.

@thealphanerd: Let’s talk offline.

@rvagg: Back to GitHub? Or do we need to decide now?

@thealphanerd : PR has a lot of LGTMs, would like to see this land today or tomorrow so we can unbreak master.

@ofrobots: Two points - one, what to do now; two, what to do going forward?

Ali and Myles will work on a policy going forward.

@rvagg: Might belong in LTS repo as we’ve been doing a lot of versioning stuff there.

**Next steps**:

* If there are objections raise them in the issue, otherwise ready to merge.

---

### General v7.0.0 / v6 LTS Planning / Discussion

@Fishrock123: Make sure all are in the loop.

Throw v0.10 in too since it’s end of life at end of October.

@rvagg: LTS map says *first* of October. Some people expect that cause the docs say that.

@Fishrock123: We discussed keeping it alive till end of December like v0.12, cause that’s when OpenSSL is EOL’ed.

@mhdawson: If the doc says Oct 1 what’s the downside to sticking with that?

@rvagg: We may have communicated Oct 31 through some channels, so some people may expect that.

Or perhaps when v7.x is first released.

Having said that, it’s been >2 years, so people have had time to migrate.

@rvagg: Originally 0.12 was slated for EOL in April 2017, we moved it back because of the OpenSSL issue.

@Fishrock123: Official LTS policy is target date is when the next release/LTS is cut. That’s usually midway through month.

@rvagg: Push to LTS WG to resolve ASAP.

@rvagg: James pushing another beta later this week or early next week.

@Fishrock123: v7.x is now on semver-major freeze.

@rvagg: There are some semver-major commits in master which aren’t in v7 release.

@Fishrock123: Might still need to update? Might have been left out by James intentionally?

@thealphanerd: Not a ton of semver-major things on master. There are the V8 upgrades (patches), and a move of a method to fs/internal.

Big one is npm@4 coming through the pipeline 1-2 weeks before Node release, should we include that.

@rvagg: npm@3 had problems originally so we delayed. Should we do the same for npm@4?

@addaleax: I’d feel comfortable with landing it. Kat said they aren’t concerned if 4 is included now or not.

@Fishrock123: Things which are deprecated in v4 will still be deprecated (not removed) in v5, so we could bump all the way to v5 in a later release.

@rvagg: We don’t have to synchronize all these dates to one, we can be flexible if needed.

@thealphanerd: If we have a date other than late October it might be a good idea to offer a date.

@ofrobots: Tentatively Oct 18 is the target stable date for V8 5.4. As tentative as usual, not clear till the last moment. Low chance that V8 will be moving a lot around Oct 18. Haven’t seen this date slip by more than 1-2 days. Very low chance that V8 will destablizie us.

@thealphanerd: Oct 25 as a tentative date for v7.x?

@rvagg: Ali and Seth, what’s the risk of setting that date now?

@ofrobots: Close to Oct 18 I can highlight any potential risk.

@rvagg: Let’s say that - 25th is tentative date, we’ll communicate if there’s any change. Any objections? (No.)

That will also be the day we switch v6 to LTS.

@thealphanerd: Doing release of v6 LTS earlier might be helpful so we have that out of the way for potential v7 issues.

@rvagg: Discussion on this will move to LTS WG. Join the LTS WG on Monday to discuss.

@thealphanerd: Could use someone to be responsible for v6 LTS, please volunteer.

@rvagg: It’s been helpful to have a single person for v4 LTS, but we need to find a model that scales in the future.

@Fishrock123: Would be helpful to schedule LTS a week earlier to avoid problems.

---

### Supported platforms proposal from  Build WG [#488](https://github.com/nodejs/build/issues/488)

Current proposal: <https://github.com/nodejs/build/issues/488#issuecomment-250155697>

@trott should make a CTC agenda item next week?

@rvagg: Give input on that issue before it comes to CTC. Build WG must review and sign off on as well.

@rvagg: Some discussion about tiers, this affects OS vendors.

---

### Other

@thealphanerd: Node.js is going to be working with Outreachy project to help people from underrepresented groups get involved.

We need projects for these people to work on in 3 months. If you can think of good parts of the project to assign… would love to hear your suggestions.

@rvagg: GitHub thread?

@hackygolucky: I’ll create a new one and ping @nodejs/collaborators.

@rvagg: Are we getting a satisfactory response on the call for mentors?

@hackygolucky: 5 primary mentors and a number of supplementals. 4 sponsors, which means we can accept 4 mentees.

@rvagg: If someone wants to be a supplemental is that still open?

@hackygolucky: Thread is still open: https://github.com/nodejs/education/issues/7

---

## Q/A on public channels

None.

---

## Upcoming Meetings

* CTC: 2016-10-05
* TSC: 2016-10-06
* Build: 2016-10-11
* Diagnostics: 2016-10-05, 12pm Pacific
* Benchmarking:
* LTS: 2016-10-03
* Post-Mortem:
* API:
