# Node Foundation CTC Meeting 2016-10-05

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8915](https://github.com/nodejs/node/issues/8915)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1ZsLMM29guCBPGh7KhuhZEq6YQCKybiTfTUIXajTBalM/>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1-PS20PGCJQIi4_quBHqVgrQNJeJP10NH21wUelcMhfw>


## Present

* Anna Henningsen @addaleax (CTC)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* Michael Dawson @mhdawson (CTC)
* Julien Gilli @misterdjules (CTC)
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
* Rod Vagg @rvagg (CTC)
* Seth Thompson @s3ththompson (observer/Google)
* Myles Borins @TheAlphaNerd (CTC)
* Sakthipriyan Vairamani @thefourtheye (observer)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)
* Josh Gavant @joshgav (observer/Microsoft)


## Standup

* Anna Henningsen @addaleax (CTC)
  * Nothing noteworthy
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Went to TC39, got late linking and re-linking fully discussed
  * Working on live named imports talks and spec changes
* Colin Ihrig @cjihrig (CTC)
  * Reviewing of issues and PRs.
* Evan Lucas @evanlucas (CTC)
  * Worked a little on improving the commit linter
  * Submitted a PR improving process.nextTick perf by 10-20% in some cases
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * merged existsSync undeprecation
  * other PRs & Issues
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
  * Outreachy application drive, issue open in the CTC repo
  * Met last week to talk about code & lean @ Austin event
* Michael Dawson @mhdawson (CTC)
  * Miscellaneous PR review
  * fix a v8 test issue
  * ABI Stable API meeting, reviews, discussion
  * Closed out PPC migration
* Julien Gilli @misterdjules (CTC)
  * Investigated SmartOS-specific issues.
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
  * Working on new budget for 2017 for the NF
  * @ TC39 last week, very productive, looking for a way to be involved longer-term
* Brian White @mscdex (CTC)
  * Continued work on various optimizations in core
  * Submitted a few misc. cleanup PRs
  * Reviewed PRs, commented on issues
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
  * No update, observing
* Rod Vagg @rvagg (CTC)
  * Little build of build, little bit of LTS, little bit of NF work
* Seth Thompson @s3ththompson (observer/Google)
  * async await on track to ship
  * V8 inspector work ongoing
* Steven R Loomis @srl295 (observer/IBM/ICU)
  * Regrets for today (and out next week) - ICU 58 will be out in a couple of weeks and will have an updated PR at that time…
* Myles Borins @TheAlphaNerd (CTC)
  * v4.x backporting
  * define outreachy project
  * fix regressions in citgm
  * work on new communication plan for LTS dates
* Sakthipriyan Vairamani @thefourtheye (observer)
  * was sick for much of the week, so not much to report
* Trevor Norris @trevnorris (CTC)
  * Fix performance regressions from async hooks
  * Almost finished bringing PR compliant with EP. Soon tests and proper API documentation will follow.
  * Engaged with the V8 team regarding the MicrotaskQueue API (https://bugs.chromium.org/p/v8/issues/detail?id=4643#c19)
* Rich Trott @Trott (CTC)
  * CTC meeting rotation proposal
  * 2FA for Collaborators
  * miscellaneous issue tracker/commit activity
* Josh Gavant @joshgav (observer)
  * time away
  * diagnostics WG meeting


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* doc: add supported platforms list [#8922](https://github.com/nodejs/node/pull/8922)
* Intl: Consider deprecating Intl.v8BreakIterator [#8865](https://github.com/nodejs/node/issues/8865)
* net: multiple listen() events fail silently [#8419](https://github.com/nodejs/node/pull/8419)

### nodejs/CTC

* Scheduling Meetings [#14](https://github.com/nodejs/CTC/issues/14)


## Previous Meeting Review

* Scheduling Meetings [#14](https://github.com/nodejs/CTC/issues/14)
* meta: update NODE_MODULE_VERSION to 51 [#8808](https://github.com/nodejs/node/pull/8808)
  * If there are objections raise them in the issue, otherwise ready to merge.
* General v7.0.0 / v6 LTS Planning / Discussion


## Minutes

### doc: add supported platforms list [#8922](https://github.com/nodejs/node/pull/8922)

@johanbergstrom put this together in collaboration with libuv and v8 teams.

@rvagg: Has everyone reviewed that would like to?

We rely on a few dependencies that make us who we are — most importantly V8 and libuv. We therefore need to adopt their supported platforms and potentially add to their lists based on test and/or release coverage.

@trott: Do we mean that we support whatever they support?

@Fishrock123: Could be clarified. Intent is that we must start with what they offer and anything additional falls to us (Node).

@rvagg: Our supported platform list is narrower than that of libuv and v8.

@?: It should say we’re a subset due to the constraints.

@rvagg: Removing that might be the way to go.

Any objections to list as it stands?

Applies to v6, probably the same for v7. Will need to be changed for v4.

If there are concerns, raise in issue.

**Next steps**:

* Raise any concerns in issue.

---

### Intl: Consider deprecating Intl.v8BreakIterator [#8865](https://github.com/nodejs/node/issues/8865)

Want to move to a different API: `Intl.Segmentor`, so want to deprecate this one.

@mikeal: We need to discourage community from using this API so we can move to a more standards-compliant implementation.

@rvagg: We expose this API because V8 exposes it.

@bmeck: APIs exposed by V8 can be removed…

@rvagg: New API is before TC-39, could take a while. Also, what is the timeframe for removal?

Is it possible this will be removed in 5.5 or 5.6, which may land in Node v7.x, in which case it would be a breaking change we’d have to polyfill.

Or will it be removed later and we can include it in Node v8.x.

@mikeal: V8 (Daniel) wants to remove this as soon as possible, but depends on TC-39.

@bmeck: Also some small percentage of web uses this so not able to completely remove yet anyway.

@seththompson: We wait till stage 3 at TC-39 to implement. As far as removing v8BreakIterator, we don’t necessarily rely on usage.

Will investigate this further with Daniel.

@rvagg: No problem with removing it, but need a signal as to when it will be removed.

@seththompson: Dan is out of office through next week.

**Next steps**:

* Continue discussion in GitHub.

---

### net: multiple listen() events fail silently [#8419](https://github.com/nodejs/node/pull/8419)

see also: <https://github.com/nodejs/node/pull/8294>

@jasnell added this item, would be a semver-major change, can it be landed in v7.

@rvagg: Adds error message when `.listen()` is called twice, EADDRINUSE.

@addaleax: (#8294)[https://github.com/nodejs/node/pull/8294] documented that .listen() twice restarts the server. Does that conflict with this?

@Fishrock123: When `close()` is called it resets the listen listener to `false`.

@rvagg: Is this the only way to close?

@addaleax: Might be…

@rvagg: Will keep on agenda for James to discuss.

@Fishrock123: Is anyone opposed to this?

@evanlucas: Have we tested against the ecosystem?

No, but it’s a poor usage anyway.

@trott: delay until next week when James is here.

@trevnorris: If you run this twice on the same server object, it overwrites the `_handle` property, orphaning the original handle.

@mhdawson: Do they get a new handle to use?

@trott: Put this into the issue.

**Next steps**:

* Discuss again next week.

---

### Scheduling Meetings [#14](https://github.com/nodejs/CTC/issues/14)

@trott: All possibilities are bad. Choosing the best of bad options. Hope to give proposed schedule a shot for 4 weeks and then evaluate. Or should we shoot this down and move on?

@rvagg: To start next week, Oct 12?

@trott: Yes.

@rvagg: Any objections to next week: UTC 4:00pm, US Pacific 9am, US East 12 noon.

Better for Europe and India.

No.

Next steps:

* Do next week at new time.

---

### General v7.0.0 / v6 LTS Planning / Discussion

LTS group agreed to put out v6 LTS week of 10/17.

Week after would be v7 final.

@thealphanerd: We should do a release the week before v6 LTS to include all semver-minor changes we want in.

@Fishrock123 will manage this release next week (10/10).

@rvagg will manage v6 LTS the week after (10/17).

@rvagg: What is status on V8 5.4 for 10/18?

@seththompson: @ofrobots to confirm, no known problems.

@rvagg: Still looking for someone to handle backports and releases for v6 LTS.

@Fishrock123: We could switch Myles to v6 and someone else can pick up v4.

@thealphanerd: As long as v4 is still “active” we have to go through everything. Some discussion of how to automate process.

There will be more backports to v6, but also that stuff will be a lot clearer, if it can be backported.

Would be good to come up with a better process for how things end up in staging. Instead of getting everything in there in the last minute.

@Fishrock123: I disagree that if v4 is active it needs to have the same amount of activity all the way through. There has been an understanding that it would get more and more difficult to backport features, focus only on backporting security fixes.

@thealphanerd: I found non-trivial number of items which would’ve been missed by automation.

I’m a little bit uncomfortable with not auditing everything. Things that would get missed are more important than they sometimes seem.

Myles, Evan, and Jeremiah to discuss tooling to help make auditing less work.

@rvagg: Need to resolve Intl.v8BreakIterator for v7 - if we need to deprecate or remove it would be good to do so now.

@SethThompson: Plan is to not deprecate anything until Intl.Segmentor reaches more conclusiveness in TC-39. But team would be fine if Node deprecates sooner.

Current open issues for v7: https://github.com/nodejs/node/milestone/15

@rvagg: We won’t have OpenSSL 1.1.0 in Node in the near future, but it may be possible to compile against it. This isn’t a blocker for v7, doesn’t require semver-major.

@rvagg: Should we ship another version of 0.10 with npm updated to include updated license? Comment in LTS WG.

---

## Q/A on public channels

Alex: Can we get a comment on stability of v6 at this point?

@rvagg: We’ll have a standard v6 release next Tuesday, and the following Tuesday we’ll drop to LTS and stability push will start. Expect it to be as stable as the v4 releases.

If you’re planning to move to v6 LTS, it’s worth testing now.

@Fishrock123: Not many new features in next week’s v6.x.x release. Some regressions early in v6 lifecycle, none now.

@evanlucas: Regression in inspector.

@rvagg: Inspector is still marked experimental for now. That may change in the v6 lifetime. But for now it shouldn’t be treated as stable as the other features.

---

## Upcoming Meetings

* CTC: 2016-10-12, 9am Pacific
* TSC: 2016-10-06, 1pm Pacific
* Build: 2016-10-11
* Diagnostics: first week of November
* Benchmarking:
* LTS: 2016-10-17
* Post-Mortem:
* API:
