# Copyright 2017 the V8 project authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can
# be found in the LICENSE file.

# List of known V8 instance types.
INSTANCE_TYPES = {
  0: "INTERNALIZED_STRING_TYPE",
  2: "EXTERNAL_INTERNALIZED_STRING_TYPE",
  8: "ONE_BYTE_INTERNALIZED_STRING_TYPE",
  10: "EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  18: "EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  34: "SHORT_EXTERNAL_INTERNALIZED_STRING_TYPE",
  42: "SHORT_EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  50: "SHORT_EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  64: "STRING_TYPE",
  65: "CONS_STRING_TYPE",
  66: "EXTERNAL_STRING_TYPE",
  67: "SLICED_STRING_TYPE",
  69: "THIN_STRING_TYPE",
  72: "ONE_BYTE_STRING_TYPE",
  73: "CONS_ONE_BYTE_STRING_TYPE",
  74: "EXTERNAL_ONE_BYTE_STRING_TYPE",
  75: "SLICED_ONE_BYTE_STRING_TYPE",
  77: "THIN_ONE_BYTE_STRING_TYPE",
  82: "EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  98: "SHORT_EXTERNAL_STRING_TYPE",
  106: "SHORT_EXTERNAL_ONE_BYTE_STRING_TYPE",
  114: "SHORT_EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  128: "SYMBOL_TYPE",
  129: "HEAP_NUMBER_TYPE",
  130: "ODDBALL_TYPE",
  131: "MAP_TYPE",
  132: "CODE_TYPE",
  133: "MUTABLE_HEAP_NUMBER_TYPE",
  134: "FOREIGN_TYPE",
  135: "BYTE_ARRAY_TYPE",
  136: "BYTECODE_ARRAY_TYPE",
  137: "FREE_SPACE_TYPE",
  138: "FIXED_INT8_ARRAY_TYPE",
  139: "FIXED_UINT8_ARRAY_TYPE",
  140: "FIXED_INT16_ARRAY_TYPE",
  141: "FIXED_UINT16_ARRAY_TYPE",
  142: "FIXED_INT32_ARRAY_TYPE",
  143: "FIXED_UINT32_ARRAY_TYPE",
  144: "FIXED_FLOAT32_ARRAY_TYPE",
  145: "FIXED_FLOAT64_ARRAY_TYPE",
  146: "FIXED_UINT8_CLAMPED_ARRAY_TYPE",
  147: "FIXED_DOUBLE_ARRAY_TYPE",
  148: "FILLER_TYPE",
  149: "ACCESSOR_INFO_TYPE",
  150: "ACCESSOR_PAIR_TYPE",
  151: "ACCESS_CHECK_INFO_TYPE",
  152: "INTERCEPTOR_INFO_TYPE",
  153: "CALL_HANDLER_INFO_TYPE",
  154: "FUNCTION_TEMPLATE_INFO_TYPE",
  155: "OBJECT_TEMPLATE_INFO_TYPE",
  156: "ALLOCATION_SITE_TYPE",
  157: "ALLOCATION_MEMENTO_TYPE",
  158: "SCRIPT_TYPE",
  159: "TYPE_FEEDBACK_INFO_TYPE",
  160: "ALIASED_ARGUMENTS_ENTRY_TYPE",
  161: "PROMISE_RESOLVE_THENABLE_JOB_INFO_TYPE",
  162: "PROMISE_REACTION_JOB_INFO_TYPE",
  163: "DEBUG_INFO_TYPE",
  164: "BREAK_POINT_INFO_TYPE",
  165: "PROTOTYPE_INFO_TYPE",
  166: "TUPLE2_TYPE",
  167: "TUPLE3_TYPE",
  168: "CONTEXT_EXTENSION_TYPE",
  169: "CONSTANT_ELEMENTS_PAIR_TYPE",
  170: "MODULE_TYPE",
  171: "MODULE_INFO_ENTRY_TYPE",
  172: "FIXED_ARRAY_TYPE",
  173: "TRANSITION_ARRAY_TYPE",
  174: "SHARED_FUNCTION_INFO_TYPE",
  175: "CELL_TYPE",
  176: "WEAK_CELL_TYPE",
  177: "PROPERTY_CELL_TYPE",
  178: "JS_PROXY_TYPE",
  179: "JS_GLOBAL_OBJECT_TYPE",
  180: "JS_GLOBAL_PROXY_TYPE",
  181: "JS_SPECIAL_API_OBJECT_TYPE",
  182: "JS_VALUE_TYPE",
  183: "JS_MESSAGE_OBJECT_TYPE",
  184: "JS_DATE_TYPE",
  185: "JS_API_OBJECT_TYPE",
  186: "JS_OBJECT_TYPE",
  187: "JS_ARGUMENTS_TYPE",
  188: "JS_CONTEXT_EXTENSION_OBJECT_TYPE",
  189: "JS_GENERATOR_OBJECT_TYPE",
  190: "JS_MODULE_NAMESPACE_TYPE",
  191: "JS_ARRAY_TYPE",
  192: "JS_ARRAY_BUFFER_TYPE",
  193: "JS_TYPED_ARRAY_TYPE",
  194: "JS_DATA_VIEW_TYPE",
  195: "JS_SET_TYPE",
  196: "JS_MAP_TYPE",
  197: "JS_SET_ITERATOR_TYPE",
  198: "JS_MAP_ITERATOR_TYPE",
  199: "JS_WEAK_MAP_TYPE",
  200: "JS_WEAK_SET_TYPE",
  201: "JS_PROMISE_CAPABILITY_TYPE",
  202: "JS_PROMISE_TYPE",
  203: "JS_REGEXP_TYPE",
  204: "JS_ERROR_TYPE",
  205: "JS_ASYNC_FROM_SYNC_ITERATOR_TYPE",
  206: "JS_STRING_ITERATOR_TYPE",
  207: "JS_TYPED_ARRAY_KEY_ITERATOR_TYPE",
  208: "JS_FAST_ARRAY_KEY_ITERATOR_TYPE",
  209: "JS_GENERIC_ARRAY_KEY_ITERATOR_TYPE",
  210: "JS_UINT8_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  211: "JS_INT8_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  212: "JS_UINT16_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  213: "JS_INT16_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  214: "JS_UINT32_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  215: "JS_INT32_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  216: "JS_FLOAT32_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  217: "JS_FLOAT64_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  218: "JS_UINT8_CLAMPED_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  219: "JS_FAST_SMI_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  220: "JS_FAST_HOLEY_SMI_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  221: "JS_FAST_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  222: "JS_FAST_HOLEY_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  223: "JS_FAST_DOUBLE_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  224: "JS_FAST_HOLEY_DOUBLE_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  225: "JS_GENERIC_ARRAY_KEY_VALUE_ITERATOR_TYPE",
  226: "JS_UINT8_ARRAY_VALUE_ITERATOR_TYPE",
  227: "JS_INT8_ARRAY_VALUE_ITERATOR_TYPE",
  228: "JS_UINT16_ARRAY_VALUE_ITERATOR_TYPE",
  229: "JS_INT16_ARRAY_VALUE_ITERATOR_TYPE",
  230: "JS_UINT32_ARRAY_VALUE_ITERATOR_TYPE",
  231: "JS_INT32_ARRAY_VALUE_ITERATOR_TYPE",
  232: "JS_FLOAT32_ARRAY_VALUE_ITERATOR_TYPE",
  233: "JS_FLOAT64_ARRAY_VALUE_ITERATOR_TYPE",
  234: "JS_UINT8_CLAMPED_ARRAY_VALUE_ITERATOR_TYPE",
  235: "JS_FAST_SMI_ARRAY_VALUE_ITERATOR_TYPE",
  236: "JS_FAST_HOLEY_SMI_ARRAY_VALUE_ITERATOR_TYPE",
  237: "JS_FAST_ARRAY_VALUE_ITERATOR_TYPE",
  238: "JS_FAST_HOLEY_ARRAY_VALUE_ITERATOR_TYPE",
  239: "JS_FAST_DOUBLE_ARRAY_VALUE_ITERATOR_TYPE",
  240: "JS_FAST_HOLEY_DOUBLE_ARRAY_VALUE_ITERATOR_TYPE",
  241: "JS_GENERIC_ARRAY_VALUE_ITERATOR_TYPE",
  242: "JS_BOUND_FUNCTION_TYPE",
  243: "JS_FUNCTION_TYPE",
}

# List of known V8 maps.
KNOWN_MAPS = {
  0x02201: (137, "FreeSpaceMap"),
  0x02259: (131, "MetaMap"),
  0x022b1: (130, "NullMap"),
  0x02309: (172, "FixedArrayMap"),
  0x02361: (8, "OneByteInternalizedStringMap"),
  0x023b9: (148, "OnePointerFillerMap"),
  0x02411: (148, "TwoPointerFillerMap"),
  0x02469: (130, "UninitializedMap"),
  0x024c1: (130, "UndefinedMap"),
  0x02519: (129, "HeapNumberMap"),
  0x02571: (130, "TheHoleMap"),
  0x025c9: (130, "BooleanMap"),
  0x02621: (135, "ByteArrayMap"),
  0x02679: (172, "FixedCOWArrayMap"),
  0x026d1: (172, "HashTableMap"),
  0x02729: (128, "SymbolMap"),
  0x02781: (72, "OneByteStringMap"),
  0x027d9: (172, "ScopeInfoMap"),
  0x02831: (174, "SharedFunctionInfoMap"),
  0x02889: (132, "CodeMap"),
  0x028e1: (172, "FunctionContextMap"),
  0x02939: (175, "CellMap"),
  0x02991: (176, "WeakCellMap"),
  0x029e9: (177, "GlobalPropertyCellMap"),
  0x02a41: (134, "ForeignMap"),
  0x02a99: (173, "TransitionArrayMap"),
  0x02af1: (130, "ArgumentsMarkerMap"),
  0x02b49: (172, "NativeContextMap"),
  0x02ba1: (172, "ModuleContextMap"),
  0x02bf9: (172, "EvalContextMap"),
  0x02c51: (172, "ScriptContextMap"),
  0x02ca9: (172, "BlockContextMap"),
  0x02d01: (172, "CatchContextMap"),
  0x02d59: (172, "WithContextMap"),
  0x02db1: (147, "FixedDoubleArrayMap"),
  0x02e09: (133, "MutableHeapNumberMap"),
  0x02e61: (172, "OrderedHashTableMap"),
  0x02eb9: (172, "SloppyArgumentsElementsMap"),
  0x02f11: (183, "JSMessageObjectMap"),
  0x02f69: (136, "BytecodeArrayMap"),
  0x02fc1: (172, "ModuleInfoMap"),
  0x03019: (175, "NoClosuresCellMap"),
  0x03071: (175, "OneClosureCellMap"),
  0x030c9: (175, "ManyClosuresCellMap"),
  0x03121: (64, "StringMap"),
  0x03179: (73, "ConsOneByteStringMap"),
  0x031d1: (65, "ConsStringMap"),
  0x03229: (77, "ThinOneByteStringMap"),
  0x03281: (69, "ThinStringMap"),
  0x032d9: (67, "SlicedStringMap"),
  0x03331: (75, "SlicedOneByteStringMap"),
  0x03389: (66, "ExternalStringMap"),
  0x033e1: (82, "ExternalStringWithOneByteDataMap"),
  0x03439: (74, "ExternalOneByteStringMap"),
  0x03491: (98, "ShortExternalStringMap"),
  0x034e9: (114, "ShortExternalStringWithOneByteDataMap"),
  0x03541: (0, "InternalizedStringMap"),
  0x03599: (2, "ExternalInternalizedStringMap"),
  0x035f1: (18, "ExternalInternalizedStringWithOneByteDataMap"),
  0x03649: (10, "ExternalOneByteInternalizedStringMap"),
  0x036a1: (34, "ShortExternalInternalizedStringMap"),
  0x036f9: (50, "ShortExternalInternalizedStringWithOneByteDataMap"),
  0x03751: (42, "ShortExternalOneByteInternalizedStringMap"),
  0x037a9: (106, "ShortExternalOneByteStringMap"),
  0x03801: (172, "FeedbackVectorMap"),
  0x03859: (130, "ExceptionMap"),
  0x038b1: (130, "TerminationExceptionMap"),
  0x03909: (130, "OptimizedOutMap"),
  0x03961: (130, "StaleRegisterMap"),
  0x039b9: (172, "DebugEvaluateContextMap"),
  0x03a11: (172, "ScriptContextTableMap"),
  0x03a69: (172, "UnseededNumberDictionaryMap"),
  0x03ac1: (186, "ExternalMap"),
  0x03b19: (106, "NativeSourceStringMap"),
  0x03b71: (139, "FixedUint8ArrayMap"),
  0x03bc9: (138, "FixedInt8ArrayMap"),
  0x03c21: (141, "FixedUint16ArrayMap"),
  0x03c79: (140, "FixedInt16ArrayMap"),
  0x03cd1: (143, "FixedUint32ArrayMap"),
  0x03d29: (142, "FixedInt32ArrayMap"),
  0x03d81: (144, "FixedFloat32ArrayMap"),
  0x03dd9: (145, "FixedFloat64ArrayMap"),
  0x03e31: (146, "FixedUint8ClampedArrayMap"),
  0x03e89: (158, "ScriptMap"),
  0x03ee1: (152, "InterceptorInfoMap"),
  0x03f39: (201, "JSPromiseCapabilityMap"),
  0x03f91: (149, "AccessorInfoMap"),
  0x03fe9: (150, "AccessorPairMap"),
  0x04041: (151, "AccessCheckInfoMap"),
  0x04099: (153, "CallHandlerInfoMap"),
  0x040f1: (154, "FunctionTemplateInfoMap"),
  0x04149: (155, "ObjectTemplateInfoMap"),
  0x041a1: (156, "AllocationSiteMap"),
  0x041f9: (157, "AllocationMementoMap"),
  0x04251: (159, "TypeFeedbackInfoMap"),
  0x042a9: (160, "AliasedArgumentsEntryMap"),
  0x04301: (161, "PromiseResolveThenableJobInfoMap"),
  0x04359: (162, "PromiseReactionJobInfoMap"),
  0x043b1: (163, "DebugInfoMap"),
  0x04409: (164, "BreakPointInfoMap"),
  0x04461: (165, "PrototypeInfoMap"),
  0x044b9: (166, "Tuple2Map"),
  0x04511: (167, "Tuple3Map"),
  0x04569: (168, "ContextExtensionMap"),
  0x045c1: (169, "ConstantElementsPairMap"),
  0x04619: (170, "ModuleMap"),
  0x04671: (171, "ModuleInfoEntryMap"),
}

# List of known V8 objects.
KNOWN_OBJECTS = {
  ("OLD_SPACE", 0x02201): "NullValue",
  ("OLD_SPACE", 0x02231): "EmptyDescriptorArray",
  ("OLD_SPACE", 0x02241): "EmptyFixedArray",
  ("OLD_SPACE", 0x02291): "UninitializedValue",
  ("OLD_SPACE", 0x02311): "UndefinedValue",
  ("OLD_SPACE", 0x02341): "NanValue",
  ("OLD_SPACE", 0x02351): "TheHoleValue",
  ("OLD_SPACE", 0x023a1): "HoleNanValue",
  ("OLD_SPACE", 0x023b1): "TrueValue",
  ("OLD_SPACE", 0x02421): "FalseValue",
  ("OLD_SPACE", 0x02471): "empty_string",
  ("OLD_SPACE", 0x02489): "ArgumentsMarker",
  ("OLD_SPACE", 0x024e1): "EmptyByteArray",
  ("OLD_SPACE", 0x024f1): "EmptyWeakCell",
  ("OLD_SPACE", 0x02509): "InfinityValue",
  ("OLD_SPACE", 0x02519): "MinusZeroValue",
  ("OLD_SPACE", 0x02529): "MinusInfinityValue",
  ("OLD_SPACE", 0x04979): "EmptyScopeInfo",
  ("OLD_SPACE", 0x04989): "Exception",
  ("OLD_SPACE", 0x049e1): "TerminationException",
  ("OLD_SPACE", 0x04a41): "OptimizedOut",
  ("OLD_SPACE", 0x04a99): "StaleRegister",
  ("OLD_SPACE", 0x04af1): "EmptyFixedUint8Array",
  ("OLD_SPACE", 0x04b11): "EmptyFixedInt8Array",
  ("OLD_SPACE", 0x04b31): "EmptyFixedUint16Array",
  ("OLD_SPACE", 0x04b51): "EmptyFixedInt16Array",
  ("OLD_SPACE", 0x04b71): "EmptyFixedUint32Array",
  ("OLD_SPACE", 0x04b91): "EmptyFixedInt32Array",
  ("OLD_SPACE", 0x04bb1): "EmptyFixedFloat32Array",
  ("OLD_SPACE", 0x04bd1): "EmptyFixedFloat64Array",
  ("OLD_SPACE", 0x04bf1): "EmptyFixedUint8ClampedArray",
  ("OLD_SPACE", 0x04c11): "EmptyScript",
  ("OLD_SPACE", 0x04c99): "UndefinedCell",
  ("OLD_SPACE", 0x04ca9): "EmptySloppyArgumentsElements",
  ("OLD_SPACE", 0x04cc9): "EmptySlowElementDictionary",
  ("OLD_SPACE", 0x04d19): "EmptyPropertyCell",
  ("OLD_SPACE", 0x04d39): "ArrayProtector",
  ("OLD_SPACE", 0x04d59): "IsConcatSpreadableProtector",
  ("OLD_SPACE", 0x04d69): "SpeciesProtector",
  ("OLD_SPACE", 0x04d79): "StringLengthProtector",
  ("OLD_SPACE", 0x04d99): "FastArrayIterationProtector",
  ("OLD_SPACE", 0x04da9): "ArrayIteratorProtector",
  ("OLD_SPACE", 0x04dc9): "ArrayBufferNeuteringProtector",
  ("OLD_SPACE", 0x04de9): "NumberStringCache",
  ("OLD_SPACE", 0x05df9): "SingleCharacterStringCache",
  ("OLD_SPACE", 0x06669): "StringSplitCache",
  ("OLD_SPACE", 0x06e79): "RegExpMultipleCache",
  ("OLD_SPACE", 0x07689): "NativesSourceCache",
  ("OLD_SPACE", 0x07931): "ExtraNativesSourceCache",
  ("OLD_SPACE", 0x07969): "ExperimentalExtraNativesSourceCache",
  ("OLD_SPACE", 0x07981): "EmptyPropertiesDictionary",
  ("OLD_SPACE", 0x079d1): "ScriptList",
  ("OLD_SPACE", 0x22019): "CodeStubs",
  ("OLD_SPACE", 0x2f199): "WeakObjectToCodeTable",
  ("OLD_SPACE", 0x2f3c1): "WeakNewSpaceObjectToCodeList",
  ("OLD_SPACE", 0x2f451): "NoScriptSharedFunctionInfos",
  ("OLD_SPACE", 0x4abd9): "MessageListeners",
  ("OLD_SPACE", 0x4abf9): "NoOpInterceptorInfo",
  ("OLD_SPACE", 0x531d1): "StringTable",
  ("CODE_SPACE", 0x2cde1): "JsEntryCode",
  ("CODE_SPACE", 0x31241): "JsConstructEntryCode",
}

# List of known V8 Frame Markers.
FRAME_MARKERS = (
  "ENTRY",
  "ENTRY_CONSTRUCT",
  "EXIT",
  "JAVA_SCRIPT",
  "OPTIMIZED",
  "WASM_COMPILED",
  "WASM_TO_JS",
  "JS_TO_WASM",
  "WASM_INTERPRETER_ENTRY",
  "INTERPRETED",
  "STUB",
  "STUB_FAILURE_TRAMPOLINE",
  "INTERNAL",
  "CONSTRUCT",
  "ARGUMENTS_ADAPTOR",
  "BUILTIN",
  "BUILTIN_EXIT",
)
