# Node.js 9 ChangeLog

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#9.0.0">9.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="9.0.0"></a>
## 2017-10-31, Version 9.0.0 (Current), @jasnell

### Notable Changes

* **async_hooks**
  * Older experimental `async_hooks` APIs have been removed [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] **(SEMVER-MAJOR)** [#14414](https://github.com/nodejs/node/pull/14414)

* **Errors**
  * Multiple built in modules have been migrated to use static error codes

* **Domains**
  * The long deprecated `.dispose()` method has been removed [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] **(SEMVER-MAJOR)** [#15412](https://github.com/nodejs/node/pull/15412)

* **File system**
  * `fs.ReadStream` and `fs.WriteStream` now make use of `.destroy()` [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] **(SEMVER-MAJOR)** [#15407](https://github.com/nodejs/node/pull/15407)
  * `fs` callbacks are now invoked with an undefined `this` context [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] **(SEMVER-MAJOR)** [#14645](https://github.com/nodejs/node/pull/14645)

* **HTTP**
  * Socket timeout is set when the socket connects [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] **(SEMVER-MAJOR)** [#8895](https://github.com/nodejs/node/pull/8895)
  * A bug causing the request `error` event to fire twice has been fixed [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] **(SEMVER-MAJOR)** [#14659](https://github.com/nodejs/node/pull/14659)
  * The `pipe` method on `OutgoingMessage` has been disabled [[`156549d8ff`](https://github.com/nodejs/node/commit/156549d8ff)] **(SEMVER-MAJOR)** [#14358](https://github.com/nodejs/node/pull/14358)

* **HTTP/2**
  * The `--expose-http2` command-line argument is no longer required [[`f55ee6e24a`](https://github.com/nodejs/node/commit/f55ee6e24a)] **(SEMVER-MAJOR)** [#15535](https://github.com/nodejs/node/pull/15535)

* **Internationalization**
  * The `Intl.v8BreakIterator` class has been removed [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] **(SEMVER-MAJOR)** [#15238](https://github.com/nodejs/node/pull/15238)

* **OS**
  * `os.EOL` is now read-only [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] **(SEMVER-MAJOR)** [#14622](https://github.com/nodejs/node/pull/14622)

* **Process**
  * It is now possible to pass additional flags to `dlopen` [[`5f22375922`](https://github.com/nodejs/node/commit/5f22375922)] **(SEMVER-MAJOR)** [#12794](https://github.com/nodejs/node/pull/12794)

* **Timers**
  * Using a timeout duration larger than 32-bits will now emit a warning [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] **(SEMVER-MAJOR)** [#15627](https://github.com/nodejs/node/pull/15627)

* **TLS**
  * `parseCertString` has been deprecated [[`468110b327`](https://github.com/nodejs/node/commit/468110b327)] **(SEMVER-MAJOR)** [#14249](https://github.com/nodejs/node/pull/14249)
  * Type-checking for `key`, `cert`, and `ca` options has been added [[`a7dccd040d`](https://github.com/nodejs/node/commit/a7dccd040d)] **(SEMVER-MAJOR)** [#14807](https://github.com/nodejs/node/pull/14807)

### Commits

* [[`c246716305`](https://github.com/nodejs/node/commit/c246716305)] - **assert**: fix actual and expected order (Steve Jenkins) [#15866](https://github.com/nodejs/node/pull/15866)
* [[`db2e093e05`](https://github.com/nodejs/node/commit/db2e093e05)] - **(SEMVER-MAJOR)** **assert**: handle enumerable symbol keys (Ruben Bridgewater) [#15169](https://github.com/nodejs/node/pull/15169)
* [[`b0d3bec95c`](https://github.com/nodejs/node/commit/b0d3bec95c)] - **(SEMVER-MAJOR)** **assert**: use Same-value equality in deepStrictEqual (Ruben Bridgewater) [#15398](https://github.com/nodejs/node/pull/15398)
* [[`e13d1df89b`](https://github.com/nodejs/node/commit/e13d1df89b)] - **(SEMVER-MAJOR)** **assert**: support custom errors (geek) [#15304](https://github.com/nodejs/node/pull/15304)
* [[`ea2e6363f2`](https://github.com/nodejs/node/commit/ea2e6363f2)] - **(SEMVER-MAJOR)** **assert**: use SameValueZero in deepStrictEqual (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`c53db1e8e9`](https://github.com/nodejs/node/commit/c53db1e8e9)] - **(SEMVER-MAJOR)** **assert**: show thrown message in doesNotThrow() (Ruslan Bekenev) [#12167](https://github.com/nodejs/node/pull/12167)
* [[`6e86a70da2`](https://github.com/nodejs/node/commit/6e86a70da2)] - **assert**: replace many if's with if-else statement (kuroljov) [#14043](https://github.com/nodejs/node/pull/14043)
* [[`fc463639fa`](https://github.com/nodejs/node/commit/fc463639fa)] - **(SEMVER-MAJOR)** **assert**: fix assert.fail with zero arguments (Ruben Bridgewater) [#13974](https://github.com/nodejs/node/pull/13974)
* [[`3ea3c089cb`](https://github.com/nodejs/node/commit/3ea3c089cb)] - **async_hooks**: replace concat w template literals (Rob Adelmann) [#15968](https://github.com/nodejs/node/pull/15968)
* [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] - **(SEMVER-MAJOR)** **async_hooks**: remove deprecated APIs (Anna Henningsen) [#14414](https://github.com/nodejs/node/pull/14414)
* [[`c2cf47a239`](https://github.com/nodejs/node/commit/c2cf47a239)] - **benchmark**: remove writing to benchmark directory (Rich Trott) [#16144](https://github.com/nodejs/node/pull/16144)
* [[`5dbd32c80c`](https://github.com/nodejs/node/commit/5dbd32c80c)] - **benchmark**: remove misc/v8-bench.js (Joyee Cheung) [#16126](https://github.com/nodejs/node/pull/16126)
* [[`f547db131f`](https://github.com/nodejs/node/commit/f547db131f)] - **benchmark**: add util/type-check (Timothy Gu) [#15663](https://github.com/nodejs/node/pull/15663)
* [[`97c43940c8`](https://github.com/nodejs/node/commit/97c43940c8)] - **(SEMVER-MAJOR)** **benchmark**: cover more nextTick() code (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`095c0de94d`](https://github.com/nodejs/node/commit/095c0de94d)] - **benchmark,lib,test**: use braces for multiline block (Rich Trott) [#13828](https://github.com/nodejs/node/pull/13828)
* [[`9e0f771224`](https://github.com/nodejs/node/commit/9e0f771224)] - **(SEMVER-MAJOR)** **buffer**: improve error messages (Weijia Wang) [#14975](https://github.com/nodejs/node/pull/14975)
* [[`355523fcfb`](https://github.com/nodejs/node/commit/355523fcfb)] - **buffer**: refactor module.exports, imports (James M Snell) [#13807](https://github.com/nodejs/node/pull/13807)
* [[`e0340af455`](https://github.com/nodejs/node/commit/e0340af455)] - **buffer**: fix indentation nits (Rich Trott) [#14224](https://github.com/nodejs/node/pull/14224)
* [[`cc443cb447`](https://github.com/nodejs/node/commit/cc443cb447)] - **build**: set disable_glibcxx_debug flag (Anna Henningsen) [#16159](https://github.com/nodejs/node/pull/16159)
* [[`411695e1d2`](https://github.com/nodejs/node/commit/411695e1d2)] - **build**: lint benchmark addon (Ben Noordhuis) [#16160](https://github.com/nodejs/node/pull/16160)
* [[`4157342744`](https://github.com/nodejs/node/commit/4157342744)] - **build**: use local node-gyp for benchmark addon (Ben Noordhuis) [#16160](https://github.com/nodejs/node/pull/16160)
* [[`88d05aa43b`](https://github.com/nodejs/node/commit/88d05aa43b)] - **build**: restore mistakenly dropped suites (Refael Ackermann) [#16132](https://github.com/nodejs/node/pull/16132)
* [[`6cc4cf75b9`](https://github.com/nodejs/node/commit/6cc4cf75b9)] - **build**: correct minor typo in lttng help message (Daniel Bevenius) [#16101](https://github.com/nodejs/node/pull/16101)
* [[`7da45f87da`](https://github.com/nodejs/node/commit/7da45f87da)] - **build**: ignore empty folders in test-addons (Gregor) [#16031](https://github.com/nodejs/node/pull/16031)
* [[`c5eb5bfc2e`](https://github.com/nodejs/node/commit/c5eb5bfc2e)] - **(SEMVER-MAJOR)** **build**: enable runtime linking (jBarz) [#15286](https://github.com/nodejs/node/pull/15286)
* [[`2062a69879`](https://github.com/nodejs/node/commit/2062a69879)] - **(SEMVER-MAJOR)** **build**: stop support building addons with VS 2013 (Michaël Zasso) [#14764](https://github.com/nodejs/node/pull/14764)
* [[`aa011a111d`](https://github.com/nodejs/node/commit/aa011a111d)] - ***Revert*** "**build**: don't add libraries when --enable-static" (Ben Noordhuis) [#14893](https://github.com/nodejs/node/pull/14893)
* [[`be63c26e8c`](https://github.com/nodejs/node/commit/be63c26e8c)] - **build**: don't add libraries when --enable-static (Daniel Bevenius) [#14837](https://github.com/nodejs/node/pull/14837)
* [[`d78086bd8a`](https://github.com/nodejs/node/commit/d78086bd8a)] - **build,win**: enable lint option to run "standalone" (Daniel Bevenius) [#16176](https://github.com/nodejs/node/pull/16176)
* [[`7832e69eaf`](https://github.com/nodejs/node/commit/7832e69eaf)] - **build,win**: include addons-napi in linter (Daniel Bevenius) [#16181](https://github.com/nodejs/node/pull/16181)
* [[`3b7a9a2589`](https://github.com/nodejs/node/commit/3b7a9a2589)] - **child_process**: add windowsHide option (cjihrig) [#15380](https://github.com/nodejs/node/pull/15380)
* [[`2e59ec0c2d`](https://github.com/nodejs/node/commit/2e59ec0c2d)] - **child_process**: fix memory leak in .fork() (Ben Noordhuis) [#15679](https://github.com/nodejs/node/pull/15679)
* [[`f2b01cba7b`](https://github.com/nodejs/node/commit/f2b01cba7b)] - **(SEMVER-MAJOR)** **child_process**: defer error to next tick (Tristian Flanagan) [#4670](https://github.com/nodejs/node/pull/4670)
* [[`fe730d34ce`](https://github.com/nodejs/node/commit/fe730d34ce)] - **(SEMVER-MAJOR)** **child_process**: use internal/errors (Tobias Nießen) [#14009](https://github.com/nodejs/node/pull/14009)
* [[`448c4c62d2`](https://github.com/nodejs/node/commit/448c4c62d2)] - **(SEMVER-MAJOR)** **child_process**: do not extend result for *Sync() (Brian White) [#13601](https://github.com/nodejs/node/pull/13601)
* [[`1fcb76e8f2`](https://github.com/nodejs/node/commit/1fcb76e8f2)] - **(SEMVER-MAJOR)** **cluster**: remove deprecated property (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`4da8b99a74`](https://github.com/nodejs/node/commit/4da8b99a74)] - **(SEMVER-MAJOR)** **console**: coerce label to string in console.time() (James M Snell) [#14643](https://github.com/nodejs/node/pull/14643)
* [[`3ddc88b5c2`](https://github.com/nodejs/node/commit/3ddc88b5c2)] - **(SEMVER-MAJOR)** **crypto**: migrate Certificate to internal/errors (James M Snell) [#15756](https://github.com/nodejs/node/pull/15756)
* [[`9bc4f86201`](https://github.com/nodejs/node/commit/9bc4f86201)] - **crypto**: make createXYZ inlineable (Matteo Collina) [#16067](https://github.com/nodejs/node/pull/16067)
* [[`43e7e8d106`](https://github.com/nodejs/node/commit/43e7e8d106)] - **crypto**: remove useless if statement (Weijia Wang) [#15041](https://github.com/nodejs/node/pull/15041)
* [[`26174fcfe1`](https://github.com/nodejs/node/commit/26174fcfe1)] - **(SEMVER-MINOR)** **crypto**: expose ECDH class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`c75f87cc4c`](https://github.com/nodejs/node/commit/c75f87cc4c)] - **(SEMVER-MAJOR)** **crypto**: refactor the crypto module (James M Snell) [#15231](https://github.com/nodejs/node/pull/15231)
* [[`484bfa2e37`](https://github.com/nodejs/node/commit/484bfa2e37)] - **(SEMVER-MAJOR)** **crypto**: accept decimal Number in randomBytes (Benjamin Gruenbaum) [#15130](https://github.com/nodejs/node/pull/15130)
* [[`34d125f16c`](https://github.com/nodejs/node/commit/34d125f16c)] - **deps**: c-ares float, win ipv6 bad fec0 prefix (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`af171b7ba2`](https://github.com/nodejs/node/commit/af171b7ba2)] - **deps**: c-ares float, manual ares_ssize_t definition (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`13c74706ef`](https://github.com/nodejs/node/commit/13c74706ef)] - **deps**: upgrade to c-ares v1.13.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`d0d1eba872`](https://github.com/nodejs/node/commit/d0d1eba872)] - **deps**: update license-builder & LICENSE for c-ares (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`a9f125449e`](https://github.com/nodejs/node/commit/a9f125449e)] - **deps**: upgrade to c-ares v1.12.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`d82e1075db`](https://github.com/nodejs/node/commit/d82e1075db)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.1.534.36 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`0a66b223e1`](https://github.com/nodejs/node/commit/0a66b223e1)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.0.286.52 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`8dce05fa71`](https://github.com/nodejs/node/commit/8dce05fa71)] - **deps**: backport rehash strings after deserialization (Yang Guo) [#14345](https://github.com/nodejs/node/pull/14345)
* [[`785a9e5a57`](https://github.com/nodejs/node/commit/785a9e5a57)] - **deps**: cherry-pick 6cb999b97b from V8 upstream (Igor Sheludko) [#14188](https://github.com/nodejs/node/pull/14188)
* [[`31349e2245`](https://github.com/nodejs/node/commit/31349e2245)] - **deps**: cherry-pick 3f4536894ac from V8 upstream (ochang) [#13985](https://github.com/nodejs/node/pull/13985)
* [[`0ba74dbcc6`](https://github.com/nodejs/node/commit/0ba74dbcc6)] - **deps**: backport c0f1ff2 from upstream V8 (Michaël Zasso) [#13517](https://github.com/nodejs/node/pull/13517)
* [[`7cdcca7623`](https://github.com/nodejs/node/commit/7cdcca7623)] - **deps**: cherry-pick 866ee63 from upstream V8 (Michaël Zasso) [#13630](https://github.com/nodejs/node/pull/13630)
* [[`8f907b6baf`](https://github.com/nodejs/node/commit/8f907b6baf)] - **deps**: update V8 to 5.9.211.37 (Michaël Zasso) [#13631](https://github.com/nodejs/node/pull/13631)
* [[`2db2857c72`](https://github.com/nodejs/node/commit/2db2857c72)] - **(SEMVER-MAJOR)** **deps**: cherry-pick 6d38f89 from upstream V8 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`554fa24916`](https://github.com/nodejs/node/commit/554fa24916)] - **deps**: cherry-pick f5fad6d from upstream v8 (daniel.bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`36ba9e6e0c`](https://github.com/nodejs/node/commit/36ba9e6e0c)] - **deps**: cherry-pick bfae9db from upstream v8 (Ben Noordhuis) [#12722](https://github.com/nodejs/node/pull/12722)
* [[`bc8e4878c0`](https://github.com/nodejs/node/commit/bc8e4878c0)] - **(SEMVER-MAJOR)** **deps**: add missing include to V8 i18n.cc (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`9b4a891ca2`](https://github.com/nodejs/node/commit/9b4a891ca2)] - **(SEMVER-MAJOR)** **deps**: run memory hungry V8 test in exclusive mode (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`3dc8c3bed4`](https://github.com/nodejs/node/commit/3dc8c3bed4)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.9.211.32 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`1a452f1928`](https://github.com/nodejs/node/commit/1a452f1928)] - **(SEMVER-MAJOR)** **dgram,process,util**: refactor Error to TypeError (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`758a17f1d5`](https://github.com/nodejs/node/commit/758a17f1d5)] - **(SEMVER-MAJOR)** **dns**: return TypeError on invalid resolve() input (Rich Trott) [#13090](https://github.com/nodejs/node/pull/13090)
* [[`a3a106865a`](https://github.com/nodejs/node/commit/a3a106865a)] - **doc**: add return values in crypto documentation (Jeremy Huang) [#16229](https://github.com/nodejs/node/pull/16229)
* [[`b5c74d85fc`](https://github.com/nodejs/node/commit/b5c74d85fc)] - **doc**: reduce keylen in pbkdf2 examples (Lukas) [#16203](https://github.com/nodejs/node/pull/16203)
* [[`89425817d0`](https://github.com/nodejs/node/commit/89425817d0)] - **doc**: support multidimensional arrays in type link (Vse Mozhet Byt) [#16207](https://github.com/nodejs/node/pull/16207)
* [[`a1c080410c`](https://github.com/nodejs/node/commit/a1c080410c)] - **doc**: update to use NAPI_AUTO_LENGTH (Michael Dawson) [#16187](https://github.com/nodejs/node/pull/16187)
* [[`727b5b63ef`](https://github.com/nodejs/node/commit/727b5b63ef)] - **doc**: move Shigeki to TSC Emeritus (Rich Trott) [#16195](https://github.com/nodejs/node/pull/16195)
* [[`42479130a9`](https://github.com/nodejs/node/commit/42479130a9)] - **doc**: fix paragraph line-height issue (silverwind) [#16200](https://github.com/nodejs/node/pull/16200)
* [[`520cf1d6de`](https://github.com/nodejs/node/commit/520cf1d6de)] - **doc**: Update a typo in module.js' comments (Orta) [#16205](https://github.com/nodejs/node/pull/16205)
* [[`5aaa23eedd`](https://github.com/nodejs/node/commit/5aaa23eedd)] - **doc**: add missing comma (Jon Moss) [#16204](https://github.com/nodejs/node/pull/16204)
* [[`f88178906b`](https://github.com/nodejs/node/commit/f88178906b)] - **doc**: fix some links (Vse Mozhet Byt) [#16202](https://github.com/nodejs/node/pull/16202)
* [[`371d1db60c`](https://github.com/nodejs/node/commit/371d1db60c)] - **doc**: added note to fs.watchFile on previousStat (NiveditN) [#16099](https://github.com/nodejs/node/pull/16099)
* [[`0ff0c70e44`](https://github.com/nodejs/node/commit/0ff0c70e44)] - **doc**: add UV_THREADPOOL_SIZE link definition (Jon Moss) [#16193](https://github.com/nodejs/node/pull/16193)
* [[`23340b9234`](https://github.com/nodejs/node/commit/23340b9234)] - **doc**: add basic C++ style guide (Anna Henningsen) [#16090](https://github.com/nodejs/node/pull/16090)
* [[`34c47ed486`](https://github.com/nodejs/node/commit/34c47ed486)] - **doc**: fix dgram.md typos (Alessandro Vergani) [#16183](https://github.com/nodejs/node/pull/16183)
* [[`cc258af0e4`](https://github.com/nodejs/node/commit/cc258af0e4)] - **doc**: clarify usage of util.promisify.custom (Shiya Luo) [#16134](https://github.com/nodejs/node/pull/16134)
* [[`eb3fee1b87`](https://github.com/nodejs/node/commit/eb3fee1b87)] - **doc**: ensure collaborators validate commits (Bradley Farias) [#16162](https://github.com/nodejs/node/pull/16162)
* [[`4db84724ca`](https://github.com/nodejs/node/commit/4db84724ca)] - **doc**: move 8 collaborators to emeriti (Rich Trott) [#16173](https://github.com/nodejs/node/pull/16173)
* [[`9f1e6e79ea`](https://github.com/nodejs/node/commit/9f1e6e79ea)] - **doc**: include V8 commit URL in V8 backport guide (Gibson Fahnestock) [#16054](https://github.com/nodejs/node/pull/16054)
* [[`edebc902cf`](https://github.com/nodejs/node/commit/edebc902cf)] - **doc**: add parentheses to refreshTmpDir() (Rich Trott) [#16168](https://github.com/nodejs/node/pull/16168)
* [[`d9f8736ffd`](https://github.com/nodejs/node/commit/d9f8736ffd)] - **doc**: fix changelog anchor to v8.7.0 (Lewis Zhang) [#16165](https://github.com/nodejs/node/pull/16165)
* [[`ed2c9a3c78`](https://github.com/nodejs/node/commit/ed2c9a3c78)] - **doc**: add pronoun for fhinkel (F. Hinkelmann) [#16069](https://github.com/nodejs/node/pull/16069)
* [[`641ba5ecfa`](https://github.com/nodejs/node/commit/641ba5ecfa)] - **doc**: document windows shell support (Tim Ermilov) [#16104](https://github.com/nodejs/node/pull/16104)
* [[`a84e10eba0`](https://github.com/nodejs/node/commit/a84e10eba0)] - **doc**: remove undefined reference variable (Adarsh Honawad) [#16106](https://github.com/nodejs/node/pull/16106)
* [[`a766f6dea5`](https://github.com/nodejs/node/commit/a766f6dea5)] - **doc**: exempt test/doc only changes from 48-hr rule (Anna Henningsen) [#16135](https://github.com/nodejs/node/pull/16135)
* [[`21ca1d3956`](https://github.com/nodejs/node/commit/21ca1d3956)] - **doc**: rename good first contrib label (Jeremiah Senkpiel) [#16150](https://github.com/nodejs/node/pull/16150)
* [[`20f8a22259`](https://github.com/nodejs/node/commit/20f8a22259)] - **doc**: fix the description of 'close' event (James M. Greene) [#15800](https://github.com/nodejs/node/pull/15800)
* [[`b9f90fd0b4`](https://github.com/nodejs/node/commit/b9f90fd0b4)] - **doc**: document the `test/common/dns` module (Cameron Burwell) [#15772](https://github.com/nodejs/node/pull/15772)
* [[`a206bab419`](https://github.com/nodejs/node/commit/a206bab419)] - **doc**: remove bold typography from STYLE_GUIDE.md (Rich Trott) [#16085](https://github.com/nodejs/node/pull/16085)
* [[`b0c5f7d24d`](https://github.com/nodejs/node/commit/b0c5f7d24d)] - **doc**: add history for readline `crlfDelay` option (Vse Mozhet Byt) [#16075](https://github.com/nodejs/node/pull/16075)
* [[`6d9654b13d`](https://github.com/nodejs/node/commit/6d9654b13d)] - **doc**: responsive docs, rewrite font sizes (silverwind) [#15660](https://github.com/nodejs/node/pull/15660)
* [[`1261b94a3f`](https://github.com/nodejs/node/commit/1261b94a3f)] - **doc**: fix unassigned deprecation code (James M Snell) [#15741](https://github.com/nodejs/node/pull/15741)
* [[`cd1b55a942`](https://github.com/nodejs/node/commit/cd1b55a942)] - **doc**: delete link to removed doc part (Vse Mozhet Byt) [#15510](https://github.com/nodejs/node/pull/15510)
* [[`a5916107dd`](https://github.com/nodejs/node/commit/a5916107dd)] - **doc**: fix wrong history entry in deepStrictEqual (hisener) [#15381](https://github.com/nodejs/node/pull/15381)
* [[`1cdb41f287`](https://github.com/nodejs/node/commit/1cdb41f287)] - **doc**: document missing error codes (George Bezerra) [#15160](https://github.com/nodejs/node/pull/15160)
* [[`1789dcfc87`](https://github.com/nodejs/node/commit/1789dcfc87)] - **(SEMVER-MAJOR)** **doc**: add missing changelogs to assert docs (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`8b2c61c169`](https://github.com/nodejs/node/commit/8b2c61c169)] - **doc**: fix api docs style (Daijiro Wachi) [#13970](https://github.com/nodejs/node/pull/13970)
* [[`8ca9338655`](https://github.com/nodejs/node/commit/8ca9338655)] - **(SEMVER-MAJOR)** **doc**: document missing error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3fab9f2cd7`](https://github.com/nodejs/node/commit/3fab9f2cd7)] - **(SEMVER-MAJOR)** **doc**: EOL deprecated API and update notes (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`102e1aa4e3`](https://github.com/nodejs/node/commit/102e1aa4e3)] - **doc**: fix ordering error in errors.md (Rich Trott) [#13274](https://github.com/nodejs/node/pull/13274)
* [[`8a8a6865c0`](https://github.com/nodejs/node/commit/8a8a6865c0)] - **doc,net**: assign deprecation code (Anna Henningsen) [#14576](https://github.com/nodejs/node/pull/14576)
* [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] - **(SEMVER-MAJOR)** **domain**: remove `.dispose()` (Anna Henningsen) [#15412](https://github.com/nodejs/node/pull/15412)
* [[`42a2a9badb`](https://github.com/nodejs/node/commit/42a2a9badb)] - **errors**: make `code` and `name` properties settable (John-David Dalton) [#15694](https://github.com/nodejs/node/pull/15694)
* [[`6e172beaf0`](https://github.com/nodejs/node/commit/6e172beaf0)] - **errors**: make properties mutable (Rich Trott) [#15694](https://github.com/nodejs/node/pull/15694)
* [[`55d49eb3cc`](https://github.com/nodejs/node/commit/55d49eb3cc)] - **errors**: replace `.split()` with `.replace()` (Rich Trott) [#15545](https://github.com/nodejs/node/pull/15545)
* [[`cef6e1c55f`](https://github.com/nodejs/node/commit/cef6e1c55f)] - **errors**: refactor `invalidArgType()` (Rich Trott) [#15544](https://github.com/nodejs/node/pull/15544)
* [[`324aa6488f`](https://github.com/nodejs/node/commit/324aa6488f)] - **errors**: alphabetize error codes (Jon Moss) [#15083](https://github.com/nodejs/node/pull/15083)
* [[`219932a9f7`](https://github.com/nodejs/node/commit/219932a9f7)] - **(SEMVER-MAJOR)** **errors**: convert 'fs' (matzavinos) [#15043](https://github.com/nodejs/node/pull/15043)
* [[`11a2ca29ba`](https://github.com/nodejs/node/commit/11a2ca29ba)] - **(SEMVER-MAJOR)** **errors**: migrate _http_outgoing (Weijia Wang) [#14735](https://github.com/nodejs/node/pull/14735)
* [[`9cb390d899`](https://github.com/nodejs/node/commit/9cb390d899)] - **(SEMVER-MAJOR)** **errors**: migrate dns to use internal/errors (Weijia Wang) [#14212](https://github.com/nodejs/node/pull/14212)
* [[`a03d8cee1f`](https://github.com/nodejs/node/commit/a03d8cee1f)] - **(SEMVER-MAJOR)** **errors**: migrate socket_list to internal/errors (Bougarfaoui El houcine) [#11356](https://github.com/nodejs/node/pull/11356)
* [[`f67aa566a6`](https://github.com/nodejs/node/commit/f67aa566a6)] - **(SEMVER-MAJOR)** **errors**: migrate tls_wrap to use internal/errors (Bidisha Pyne) [#13476](https://github.com/nodejs/node/pull/13476)
* [[`b61cab2234`](https://github.com/nodejs/node/commit/b61cab2234)] - **(SEMVER-MAJOR)** **errors**: port internal/fs errors to internal/errors (Gunar C. Gessner) [#11317](https://github.com/nodejs/node/pull/11317)
* [[`fa73087fcf`](https://github.com/nodejs/node/commit/fa73087fcf)] - **errors**: keep error codes in alphabetical order (Weijia Wang) [#14242](https://github.com/nodejs/node/pull/14242)
* [[`1698c8e165`](https://github.com/nodejs/node/commit/1698c8e165)] - **(SEMVER-MAJOR)** **errors**: fix and improve error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3e178848a5`](https://github.com/nodejs/node/commit/3e178848a5)] - **(SEMVER-MAJOR)** **errors**: improve ERR_INVALID_ARG_TYPE (Ruben Bridgewater) [#13730](https://github.com/nodejs/node/pull/13730)
* [[`873e2f270f`](https://github.com/nodejs/node/commit/873e2f270f)] - **errors**: add missing ERR_ prefix on util.callbackify error (James M Snell) [#13604](https://github.com/nodejs/node/pull/13604)
* [[`0ecdf29340`](https://github.com/nodejs/node/commit/0ecdf29340)] - **(SEMVER-MAJOR)** **errors**: migrate lib/console (mskec) [#11340](https://github.com/nodejs/node/pull/11340)
* [[`7f3f72c19b`](https://github.com/nodejs/node/commit/7f3f72c19b)] - **(SEMVER-MAJOR)** **errors, readline**: migrate to use internal/errors.js (Scott McKenzie) [#11390](https://github.com/nodejs/node/pull/11390)
* [[`aff8d358fa`](https://github.com/nodejs/node/commit/aff8d358fa)] - **(SEMVER-MAJOR)** **errors, repl**: migrate to use internal/errors.js (Dan Homola) [#11347](https://github.com/nodejs/node/pull/11347)
* [[`dbfe8c4ea2`](https://github.com/nodejs/node/commit/dbfe8c4ea2)] - **(SEMVER-MAJOR)** **errors,buffer**: port errors to internal/errors (starkwang) [#13976](https://github.com/nodejs/node/pull/13976)
* [[`a9f798ebcc`](https://github.com/nodejs/node/commit/a9f798ebcc)] - **(SEMVER-MAJOR)** **errors,http_server**: migrate to use internal/errors.js (Bidisha Pyne) [#13301](https://github.com/nodejs/node/pull/13301)
* [[`a0f7284346`](https://github.com/nodejs/node/commit/a0f7284346)] - **(SEMVER-MAJOR)** **errors,process**: fix error message of hrtime() (Tobias Nießen) [#13739](https://github.com/nodejs/node/pull/13739)
* [[`062071a9c3`](https://github.com/nodejs/node/commit/062071a9c3)] - **(SEMVER-MAJOR)** **errors,process**: migrate to use internal/errors.js (sreepurnajasti) [#13285](https://github.com/nodejs/node/pull/13285)
* [[`28227963fa`](https://github.com/nodejs/node/commit/28227963fa)] - **(SEMVER-MAJOR)** **errors,repl**: migrate to use internal/errors.js (sreepurnajasti) [#13299](https://github.com/nodejs/node/pull/13299)
* [[`d50a802feb`](https://github.com/nodejs/node/commit/d50a802feb)] - **(SEMVER-MAJOR)** **errors,stream-transform**: migrate to use internal/errors.js (sreepurnajasti) [#13310](https://github.com/nodejs/node/pull/13310)
* [[`d2913384aa`](https://github.com/nodejs/node/commit/d2913384aa)] - **(SEMVER-MAJOR)** **errors,stream_wrap**: use internal/errors.js (LAKSHMI SWETHA GOPIREDDY) [#13291](https://github.com/nodejs/node/pull/13291)
* [[`5f469446e1`](https://github.com/nodejs/node/commit/5f469446e1)] - **errors,tools**: ASCIIbetical instead of alphabetical (Refael Ackermann) [#15578](https://github.com/nodejs/node/pull/15578)
* [[`473f0eff29`](https://github.com/nodejs/node/commit/473f0eff29)] - **(SEMVER-MAJOR)** **errors,url**: port url errors to internal/errors (starkwang) [#13963](https://github.com/nodejs/node/pull/13963)
* [[`1609899142`](https://github.com/nodejs/node/commit/1609899142)] - **(SEMVER-MAJOR)** **errors,util**: migrate to use internal/errors.js (Bidisha Pyne) [#13293](https://github.com/nodejs/node/pull/13293)
* [[`e5ad5456a2`](https://github.com/nodejs/node/commit/e5ad5456a2)] - **(SEMVER-MAJOR)** **events**: migrate to internal/errors (James M Snell) [#15623](https://github.com/nodejs/node/pull/15623)
* [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] - **(SEMVER-MAJOR)** **fs**: refactor close to use destroy (Matteo Collina) [#15407](https://github.com/nodejs/node/pull/15407)
* [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] - **(SEMVER-MAJOR)** **fs**: invoke callbacks with undefined context (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] - **(SEMVER-MAJOR)** **http**: set socket timeout when socket connects (Luigi Pinca) [#8895](https://github.com/nodejs/node/pull/8895)
* [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] - **(SEMVER-MAJOR)** **http**: don't double-fire the req error event (fengmk2) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`156549d8ff`](https://github.com/nodejs/node/commit/156549d8ff)] - **(SEMVER-MAJOR)** **http**: disable OutgoingMessage pipe method (Roee Kasher) [#14358](https://github.com/nodejs/node/pull/14358)
* [[`2fa2a60721`](https://github.com/nodejs/node/commit/2fa2a60721)] - **(SEMVER-MAJOR)** **http**: simplify if statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`80c9ef0b6b`](https://github.com/nodejs/node/commit/80c9ef0b6b)] - **(SEMVER-MAJOR)** **http**: edit _storeHeader to check for Trailer header (Artur G Vieira) [#12990](https://github.com/nodejs/node/pull/12990)
* [[`6b5433dcd2`](https://github.com/nodejs/node/commit/6b5433dcd2)] - **http2**: replace fixturesDir with common.fixtures (ekulnivek) [#15839](https://github.com/nodejs/node/pull/15839)
* [[`f55ee6e24a`](https://github.com/nodejs/node/commit/f55ee6e24a)] - **(SEMVER-MAJOR)** **http2**: make --expose-http2 flag a non-op (James M Snell) [#15535](https://github.com/nodejs/node/pull/15535)
* [[`f912080bf2`](https://github.com/nodejs/node/commit/f912080bf2)] - ***Revert*** "**http2**: refactor error handling" (Rich Trott) [#15047](https://github.com/nodejs/node/pull/15047)
* [[`bdfbce9241`](https://github.com/nodejs/node/commit/bdfbce9241)] - **(SEMVER-MAJOR)** **http_client, errors**: migrate to internal/errors (Weijia Wang) [#14423](https://github.com/nodejs/node/pull/14423)
* [[`4843c2f415`](https://github.com/nodejs/node/commit/4843c2f415)] - **(SEMVER-MAJOR)** **https**: convert to using internal/errors (Rami Moshe) [#15603](https://github.com/nodejs/node/pull/15603)
* [[`4cf56ad6f2`](https://github.com/nodejs/node/commit/4cf56ad6f2)] - **(SEMVER-MAJOR)** **inspector**: migrate to internal/errors (James M Snell) [#15619](https://github.com/nodejs/node/pull/15619)
* [[`4faa2314b1`](https://github.com/nodejs/node/commit/4faa2314b1)] - **inspector**: Move JS API code to separate file (Eugene Ostroukhov) [#16056](https://github.com/nodejs/node/pull/16056)
* [[`2f8ddb2734`](https://github.com/nodejs/node/commit/2f8ddb2734)] - **inspector**: reimplement JS binding (Timothy Gu) [#15643](https://github.com/nodejs/node/pull/15643)
* [[`a6973a3811`](https://github.com/nodejs/node/commit/a6973a3811)] - ***Revert*** "**inspector**: rewrite inspector test helper" (Anna Henningsen) [#14777](https://github.com/nodejs/node/pull/14777)
* [[`2296b677fb`](https://github.com/nodejs/node/commit/2296b677fb)] - **inspector**: rewrite inspector test helper (Eugene Ostroukhov) [#14460](https://github.com/nodejs/node/pull/14460)
* [[`de4a749788`](https://github.com/nodejs/node/commit/de4a749788)] - **(SEMVER-MAJOR)** **internal/util**: use internal/errors.js (Sebastian Van Sande) [#11301](https://github.com/nodejs/node/pull/11301)
* [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] - **(SEMVER-MAJOR)** **intl**: unexpose Intl.v8BreakIterator (Ben Noordhuis) [#15238](https://github.com/nodejs/node/pull/15238)
* [[`212de3c5ec`](https://github.com/nodejs/node/commit/212de3c5ec)] - **lib**: use destructuring for some constants (Weijia Wang) [#16063](https://github.com/nodejs/node/pull/16063)
* [[`c885ea727d`](https://github.com/nodejs/node/commit/c885ea727d)] - **(SEMVER-MAJOR)** **lib**: deprecate fd usage for fs.truncate(Sync) (r1cebank) [#15990](https://github.com/nodejs/node/pull/15990)
* [[`7907534a8d`](https://github.com/nodejs/node/commit/7907534a8d)] - **lib**: faster type checks for some types (Timothy Gu) [#15663](https://github.com/nodejs/node/pull/15663)
* [[`095357e26e`](https://github.com/nodejs/node/commit/095357e26e)] - **(SEMVER-MAJOR)** **lib**: tweak use of internal/errors (Ruben Bridgewater) [#13829](https://github.com/nodejs/node/pull/13829)
* [[`8520e6f280`](https://github.com/nodejs/node/commit/8520e6f280)] - **(SEMVER-MAJOR)** **lib**: fix urlObject parameter name in url.format (Eduardo Leggiero) [#14031](https://github.com/nodejs/node/pull/14031)
* [[`a577bde917`](https://github.com/nodejs/node/commit/a577bde917)] - **lib**: fix off-by-one indentation (Rich Trott) [#14064](https://github.com/nodejs/node/pull/14064)
* [[`c474f88987`](https://github.com/nodejs/node/commit/c474f88987)] - **lib**: fix typos (Ruben Bridgewater) [#13741](https://github.com/nodejs/node/pull/13741)
* [[`ae6c7044c8`](https://github.com/nodejs/node/commit/ae6c7044c8)] - ***Revert*** "**lib**: lazy instantiation of fs.Stats dates" (Anna Henningsen) [#13256](https://github.com/nodejs/node/pull/13256)
* [[`9836cf5717`](https://github.com/nodejs/node/commit/9836cf5717)] - **(SEMVER-MAJOR)** **lib**: lazy instantiation of fs.Stats dates (Daniel Pihlstrom) [#12818](https://github.com/nodejs/node/pull/12818)
* [[`234353a1b8`](https://github.com/nodejs/node/commit/234353a1b8)] - **(SEMVER-MAJOR)** **lib,src**: refactor buffer out of range index (larissayvette) [#11296](https://github.com/nodejs/node/pull/11296)
* [[`695b307cc6`](https://github.com/nodejs/node/commit/695b307cc6)] - **module**: minor performance improvement (243083df) [#16125](https://github.com/nodejs/node/pull/16125)
* [[`d90dca6620`](https://github.com/nodejs/node/commit/d90dca6620)] - **module**: allow loading files with % in the name (Guy Bedford) [#16128](https://github.com/nodejs/node/pull/16128)
* [[`d21a11dc23`](https://github.com/nodejs/node/commit/d21a11dc23)] - **module**: resolve and instantiate loader pipeline hooks (guybedford) [#15445](https://github.com/nodejs/node/pull/15445)
* [[`71578198e3`](https://github.com/nodejs/node/commit/71578198e3)] - **module**: add inspector to builtinLibs (Timothy Gu) [#15643](https://github.com/nodejs/node/pull/15643)
* [[`9d7574eef5`](https://github.com/nodejs/node/commit/9d7574eef5)] - **(SEMVER-MAJOR)** **module**: deprecate Module._debug (Jackson Tian) [#13948](https://github.com/nodejs/node/pull/13948)
* [[`a517466aa7`](https://github.com/nodejs/node/commit/a517466aa7)] - **(SEMVER-MAJOR)** **module**: mark DEP0019 as EOL and remove compat code (Roman Reiss) [#3384](https://github.com/nodejs/node/pull/3384)
* [[`c81fd7c5ea`](https://github.com/nodejs/node/commit/c81fd7c5ea)] - **n-api**: reimplement instanceof using V8 API (Yang Guo) [#16143](https://github.com/nodejs/node/pull/16143)
* [[`6bc82daef0`](https://github.com/nodejs/node/commit/6bc82daef0)] - **n-api**: use module name macro (Michael Dawson) [#16185](https://github.com/nodejs/node/pull/16185)
* [[`49577269e2`](https://github.com/nodejs/node/commit/49577269e2)] - **n-api**: make changes for source compatibility (Gabriel Schulhof) [#16102](https://github.com/nodejs/node/pull/16102)
* [[`17b818bae4`](https://github.com/nodejs/node/commit/17b818bae4)] - **n-api,test**: use module name macro (Gabriel Schulhof) [#16146](https://github.com/nodejs/node/pull/16146)
* [[`7f55349079`](https://github.com/nodejs/node/commit/7f55349079)] - **(SEMVER-MAJOR)** **net**: convert to using internal/errors (matzavinos) [#14782](https://github.com/nodejs/node/pull/14782)
* [[`e399abd582`](https://github.com/nodejs/node/commit/e399abd582)] - **net**: change assert to conform to other files (James Hodgskiss) [#15861](https://github.com/nodejs/node/pull/15861)
* [[`b24e269a48`](https://github.com/nodejs/node/commit/b24e269a48)] - **(SEMVER-MAJOR)** **net**: multiple listen() events fail silently (Eduard Bondarenko) [#13149](https://github.com/nodejs/node/pull/13149)
* [[`75a19fb379`](https://github.com/nodejs/node/commit/75a19fb379)] - **(SEMVER-MAJOR)** **net,child_process**: improve naming in internal code (Anna Henningsen) [#14449](https://github.com/nodejs/node/pull/14449)
* [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] - **(SEMVER-MAJOR)** **os**: make EOL configurable and read only (XadillaX) [#14622](https://github.com/nodejs/node/pull/14622)
* [[`1f8d527e94`](https://github.com/nodejs/node/commit/1f8d527e94)] - **(SEMVER-MAJOR)** **path**: deprecate internal _makeLong, replace (James M Snell) [#14956](https://github.com/nodejs/node/pull/14956)
* [[`44256bb0aa`](https://github.com/nodejs/node/commit/44256bb0aa)] - **path**: fix incorrect use of ERR_INVALID_ARG_TYPE (Tobias Nießen) [#14011](https://github.com/nodejs/node/pull/14011)
* [[`dcfbbacba8`](https://github.com/nodejs/node/commit/dcfbbacba8)] - **(SEMVER-MAJOR)** **path**: use internal/errors.js (Sebastian Van Sande) [#11319](https://github.com/nodejs/node/pull/11319)
* [[`a253704446`](https://github.com/nodejs/node/commit/a253704446)] - **(SEMVER-MAJOR)** **process**: make `this` value consistent (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`43e105f645`](https://github.com/nodejs/node/commit/43e105f645)] - **(SEMVER-MAJOR)** **process**: improve hrtime() error message (Rich Trott) [#14324](https://github.com/nodejs/node/pull/14324)
* [[`3129b2c035`](https://github.com/nodejs/node/commit/3129b2c035)] - **(SEMVER-MAJOR)** **process**: use internal/errors in internalNextTick (Tobias Nießen) [#13982](https://github.com/nodejs/node/pull/13982)
* [[`0229e6746c`](https://github.com/nodejs/node/commit/0229e6746c)] - **repl**: remove unused err argument (Jon Moss) [#16152](https://github.com/nodejs/node/pull/16152)
* [[`c5f54b1fad`](https://github.com/nodejs/node/commit/c5f54b1fad)] - **repl**: remove internal frames from runtime errors (Lance Ball) [#15351](https://github.com/nodejs/node/pull/15351)
* [[`da40050b59`](https://github.com/nodejs/node/commit/da40050b59)] - **repl**: fix deprecation code (Ruben Bridgewater) [#15668](https://github.com/nodejs/node/pull/15668)
* [[`e416b3ee36`](https://github.com/nodejs/node/commit/e416b3ee36)] - **(SEMVER-MAJOR)** **repl**: deprecate turnOffEditorMode (Lance Ball) [#15136](https://github.com/nodejs/node/pull/15136)
* [[`ed1ba4580b`](https://github.com/nodejs/node/commit/ed1ba4580b)] - **(SEMVER-MAJOR)** **repl**: remove REPLServer.createContext side effects (Lance Ball) [#14331](https://github.com/nodejs/node/pull/14331)
* [[`766506a2e9`](https://github.com/nodejs/node/commit/766506a2e9)] - **repl**: deprecate REPLServer.parseREPLKeyword (Lance Ball)
* [[`2ca9f94e33`](https://github.com/nodejs/node/commit/2ca9f94e33)] - **(SEMVER-MAJOR)** **repl**: make REPLServer.bufferedCommand private (Lance Ball) [#13687](https://github.com/nodejs/node/pull/13687)
* [[`3d9e7bb1d4`](https://github.com/nodejs/node/commit/3d9e7bb1d4)] - **(SEMVER-MAJOR)** **repl**: remove unused function convertToContext (Nikolai Vavilov) [#13434](https://github.com/nodejs/node/pull/13434)
* [[`75f154b1f0`](https://github.com/nodejs/node/commit/75f154b1f0)] - **src**: remove unused includes from node_wrap.h (Daniel Bevenius) [#16179](https://github.com/nodejs/node/pull/16179)
* [[`00fe76d2df`](https://github.com/nodejs/node/commit/00fe76d2df)] - **src**: rename StreamWrap to LibuvStreamWrap (Anna Henningsen) [#16157](https://github.com/nodejs/node/pull/16157)
* [[`a36aa049c8`](https://github.com/nodejs/node/commit/a36aa049c8)] - **src**: add internalBindings for binding isolation (Bradley Farias) [#15759](https://github.com/nodejs/node/pull/15759)
* [[`134d7d78a3`](https://github.com/nodejs/node/commit/134d7d78a3)] - **src**: node_dtrace line continuations clean up (Daniel Bevenius) [#15777](https://github.com/nodejs/node/pull/15777)
* [[`0c9b267b1d`](https://github.com/nodejs/node/commit/0c9b267b1d)] - **src**: rename perfctr_macros.py-\>noperfctr_macros.py (Daniel Bevenius) [#16100](https://github.com/nodejs/node/pull/16100)
* [[`037d9085f1`](https://github.com/nodejs/node/commit/037d9085f1)] - **src**: use more appropriate context-entered check (Anna Henningsen) [#15691](https://github.com/nodejs/node/pull/15691)
* [[`806857712f`](https://github.com/nodejs/node/commit/806857712f)] - **src**: do not add .domain to promises in VM contexts (Timothy Gu) [#15695](https://github.com/nodejs/node/pull/15695)
* [[`dcd890a135`](https://github.com/nodejs/node/commit/dcd890a135)] - **src**: fixup node_platform blocking task drain (Anna Henningsen) [#15639](https://github.com/nodejs/node/pull/15639)
* [[`f27b5e4bda`](https://github.com/nodejs/node/commit/f27b5e4bda)] - **src**: prepare platform for upstream V8 changes (Anna Henningsen) [#15428](https://github.com/nodejs/node/pull/15428)
* [[`ddc16e505b`](https://github.com/nodejs/node/commit/ddc16e505b)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 58 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`5f22375922`](https://github.com/nodejs/node/commit/5f22375922)] - **(SEMVER-MAJOR)** **src**: add support to pass flags to dlopen (Ezequiel Garcia) [#12794](https://github.com/nodejs/node/pull/12794)
* [[`784c6d40f8`](https://github.com/nodejs/node/commit/784c6d40f8)] - **(SEMVER-MAJOR)** **src**: use proper errors as coming from StringBytes (Anna Henningsen) [#14579](https://github.com/nodejs/node/pull/14579)
* [[`80ebb4282d`](https://github.com/nodejs/node/commit/80ebb4282d)] - **(SEMVER-MAJOR)** **src**: adjust windows abort behavior (Jared Kantrowitz) [#13947](https://github.com/nodejs/node/pull/13947)
* [[`db476fc8b5`](https://github.com/nodejs/node/commit/db476fc8b5)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 57 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`a84c3be075`](https://github.com/nodejs/node/commit/a84c3be075)] - **src**: unset `NODE_VERSION_IS_RELEASE` (Anna Henningsen) [#14005](https://github.com/nodejs/node/pull/14005)
* [[`24709b2e4a`](https://github.com/nodejs/node/commit/24709b2e4a)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 56 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`db7d1339c3`](https://github.com/nodejs/node/commit/db7d1339c3)] - **(SEMVER-MAJOR)** **stream**: migrate to internal/errors (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`4536128e7c`](https://github.com/nodejs/node/commit/4536128e7c)] - **(SEMVER-MAJOR)** **stream**: remove dead code (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`1b54371c50`](https://github.com/nodejs/node/commit/1b54371c50)] - **stream**: use more explicit statements (Ruben Bridgewater) [#13863](https://github.com/nodejs/node/pull/13863)
* [[`eb4940e2d2`](https://github.com/nodejs/node/commit/eb4940e2d2)] - **(SEMVER-MAJOR)** **string_decoder**: Migrate to use internal/errors (Weijia Wang) [#14682](https://github.com/nodejs/node/pull/14682)
* [[`ff747e3fe8`](https://github.com/nodejs/node/commit/ff747e3fe8)] - **test**: http2 priority stream depends on itself (Trivikram Kamat) [#16224](https://github.com/nodejs/node/pull/16224)
* [[`c9da05d37b`](https://github.com/nodejs/node/commit/c9da05d37b)] - **test**: add missing spaces in concatenations (Vse Mozhet Byt) [#16244](https://github.com/nodejs/node/pull/16244)
* [[`c3eeb28c6d`](https://github.com/nodejs/node/commit/c3eeb28c6d)] - **test**: http2 client settings errors (Trivikram Kamat) [#16096](https://github.com/nodejs/node/pull/16096)
* [[`d64e94ba5b`](https://github.com/nodejs/node/commit/d64e94ba5b)] - **test**: http2 emitGoAway post shutdown pre destroy (Trivikram Kamat) [#16215](https://github.com/nodejs/node/pull/16215)
* [[`7ab0a9a3c8`](https://github.com/nodejs/node/commit/7ab0a9a3c8)] - **test**: http2-respond-file-errors to fixtures module (David8472) [#16004](https://github.com/nodejs/node/pull/16004)
* [[`d60f9b775e`](https://github.com/nodejs/node/commit/d60f9b775e)] - **test**: http2-respond-file-range to use fixtures (Michael Rueppel) [#15852](https://github.com/nodejs/node/pull/15852)
* [[`e2015b5347`](https://github.com/nodejs/node/commit/e2015b5347)] - **test**: http2 add timeout no callback test case (Trivikram Kamat) [#16082](https://github.com/nodejs/node/pull/16082)
* [[`b93285454a`](https://github.com/nodejs/node/commit/b93285454a)] - **test**: replace fixturesDir with fixtures module (hschwalm) [#15989](https://github.com/nodejs/node/pull/15989)
* [[`da7d92e3f0`](https://github.com/nodejs/node/commit/da7d92e3f0)] - **test**: update output to include exit code & signal (Jenna Zeigen) [#15945](https://github.com/nodejs/node/pull/15945)
* [[`9b3d6a0d8f`](https://github.com/nodejs/node/commit/9b3d6a0d8f)] - **test**: change common.fixturesDir to fixtures.path (tejbirsingh) [#15860](https://github.com/nodejs/node/pull/15860)
* [[`1a2f579ba0`](https://github.com/nodejs/node/commit/1a2f579ba0)] - **test**: split up and refactor test-domain (Anna Henningsen) [#13614](https://github.com/nodejs/node/pull/13614)
* [[`70896c7e3b`](https://github.com/nodejs/node/commit/70896c7e3b)] - **test**: fixtures in repl persistent history test (Jenna Zeigen) [#15999](https://github.com/nodejs/node/pull/15999)
* [[`0ce6be07da`](https://github.com/nodejs/node/commit/0ce6be07da)] - **test**: http2 ERR_INVALID_ARG_TYPE tests (Trivikram Kamat) [#15766](https://github.com/nodejs/node/pull/15766)
* [[`006fdb2fe5`](https://github.com/nodejs/node/commit/006fdb2fe5)] - **test**: replace fixturesDir with common.fixtures (Kasim Doctor) [#15810](https://github.com/nodejs/node/pull/15810)
* [[`abbdcaa6e8`](https://github.com/nodejs/node/commit/abbdcaa6e8)] - **test**: http2 session operations after destroy (Trivikram Kamat) [#15758](https://github.com/nodejs/node/pull/15758)
* [[`68df587b1e`](https://github.com/nodejs/node/commit/68df587b1e)] - **test**: http2 client operations after destroy (Trivikram Kamat) [#16094](https://github.com/nodejs/node/pull/16094)
* [[`bb9ed92f0a`](https://github.com/nodejs/node/commit/bb9ed92f0a)] - **test**: replaced fs.readSync with fixtures.readSync (Lam Chan) [#15882](https://github.com/nodejs/node/pull/15882)
* [[`3cc725d9c6`](https://github.com/nodejs/node/commit/3cc725d9c6)] - **test**: http2 connectionListener reject client (Trivikram Kamat) [#16080](https://github.com/nodejs/node/pull/16080)
* [[`d43e7f3992`](https://github.com/nodejs/node/commit/d43e7f3992)] - **test**: improve coverage for process.umask (Evan Lucas) [#16188](https://github.com/nodejs/node/pull/16188)
* [[`018375cd4e`](https://github.com/nodejs/node/commit/018375cd4e)] - **test**: remove message from notStrictEqual (twk-b) [#16048](https://github.com/nodejs/node/pull/16048)
* [[`2b76b5d8dd`](https://github.com/nodejs/node/commit/2b76b5d8dd)] - **test**: use fixtures module (Ben Hallion) [#15808](https://github.com/nodejs/node/pull/15808)
* [[`e8a2438cb6`](https://github.com/nodejs/node/commit/e8a2438cb6)] - **test**: refactor test-cluster-setup-master (Jean-Baptiste Brossard) [#16065](https://github.com/nodejs/node/pull/16065)
* [[`e30876121a`](https://github.com/nodejs/node/commit/e30876121a)] - **test**: add tests for ERR_HTTP2_FRAME_ERROR (Ruxandra Fediuc) [#16107](https://github.com/nodejs/node/pull/16107)
* [[`971aad1b13`](https://github.com/nodejs/node/commit/971aad1b13)] - **test**: use relative path in pipePrefix (Randal Hanford) [#15988](https://github.com/nodejs/node/pull/15988)
* [[`4826ac537f`](https://github.com/nodejs/node/commit/4826ac537f)] - **test**: replace fixtureDir with fixtures methods (Vladimir Ilic) [#16114](https://github.com/nodejs/node/pull/16114)
* [[`24d72944da`](https://github.com/nodejs/node/commit/24d72944da)] - **test**: remove error messages in crypto-binary test (Kim Gentes) [#15981](https://github.com/nodejs/node/pull/15981)
* [[`4e835b334b`](https://github.com/nodejs/node/commit/4e835b334b)] - **test**: use fixtures module over fixturesDir (JamesNimlos) [#15847](https://github.com/nodejs/node/pull/15847)
* [[`b9ad14d69d`](https://github.com/nodejs/node/commit/b9ad14d69d)] - **test**: use common.fixtures module (Shaun Sweet) [#15992](https://github.com/nodejs/node/pull/15992)
* [[`9e551ef739`](https://github.com/nodejs/node/commit/9e551ef739)] - **test**: replace fixturesDir with fixtures.path (Bear Trickey) [#15994](https://github.com/nodejs/node/pull/15994)
* [[`bb56fbbfe5`](https://github.com/nodejs/node/commit/bb56fbbfe5)] - **test**: update fixturesDir import (Tyler Seabrook) [#15887](https://github.com/nodejs/node/pull/15887)
* [[`9aa41cb294`](https://github.com/nodejs/node/commit/9aa41cb294)] - **test**: replace fixturesDir with fixtures methods (Komivi Agbakpem) [#15967](https://github.com/nodejs/node/pull/15967)
* [[`91a465c460`](https://github.com/nodejs/node/commit/91a465c460)] - **test**: fix regression in test-require-resolver.js (Tobias Nießen) [#16192](https://github.com/nodejs/node/pull/16192)
* [[`1a9f48a875`](https://github.com/nodejs/node/commit/1a9f48a875)] - **test**: replace fixturesDir with the fixtures module (WeiPlanet) [#16027](https://github.com/nodejs/node/pull/16027)
* [[`2b0145d47c`](https://github.com/nodejs/node/commit/2b0145d47c)] - **test**: change crypto decipheriv assertion messages (Daniel Kostro) [#16007](https://github.com/nodejs/node/pull/16007)
* [[`30439378b9`](https://github.com/nodejs/node/commit/30439378b9)] - **test**: replaces fixturesDir with fixtures (Mike Fleming) [#15835](https://github.com/nodejs/node/pull/15835)
* [[`f4cab35dd8`](https://github.com/nodejs/node/commit/f4cab35dd8)] - **test**: remove test messages for assert.strictEqual (Ali Groening) [#15995](https://github.com/nodejs/node/pull/15995)
* [[`cbbc1e4496`](https://github.com/nodejs/node/commit/cbbc1e4496)] - **test**: move to common.fixtures (Justin Beckwith) [#15987](https://github.com/nodejs/node/pull/15987)
* [[`cd5ee52d70`](https://github.com/nodejs/node/commit/cd5ee52d70)] - **test**: add tests for eslint rules (Teddy Katz) [#16138](https://github.com/nodejs/node/pull/16138)
* [[`3594223c2e`](https://github.com/nodejs/node/commit/3594223c2e)] - **test**: remove redundant error messages (Christina Chan) [#16043](https://github.com/nodejs/node/pull/16043)
* [[`5ea88b7496`](https://github.com/nodejs/node/commit/5ea88b7496)] - **test**: remove error messages for readability (Fadi Asfour) [#16022](https://github.com/nodejs/node/pull/16022)
* [[`eac257f600`](https://github.com/nodejs/node/commit/eac257f600)] - **test**: added fixtures module (Michael Pal) [#15980](https://github.com/nodejs/node/pull/15980)
* [[`5d80f0048e`](https://github.com/nodejs/node/commit/5d80f0048e)] - **test**: use fixtures in test-tls-multi-key.js (Cheyenne Arrowsmith) [#15844](https://github.com/nodejs/node/pull/15844)
* [[`4e2e15f79b`](https://github.com/nodejs/node/commit/4e2e15f79b)] - **test**: switch to use common.fixtures.fixturesDir (Roger Jiang) [#15814](https://github.com/nodejs/node/pull/15814)
* [[`8d3e82fd6c`](https://github.com/nodejs/node/commit/8d3e82fd6c)] - **test**: use common.fixtures module (Chi-chi Wang) [#16012](https://github.com/nodejs/node/pull/16012)
* [[`07ec10d43b`](https://github.com/nodejs/node/commit/07ec10d43b)] - **test**: escape script filename on Windows (Bartosz Sosnowski) [#16124](https://github.com/nodejs/node/pull/16124)
* [[`7245e852f2`](https://github.com/nodejs/node/commit/7245e852f2)] - **test**: replace common.fixtureDir with fixtures (shaohui.liu2000@gmail.com) [#15816](https://github.com/nodejs/node/pull/15816)
* [[`28e6cab52e`](https://github.com/nodejs/node/commit/28e6cab52e)] - **test**: add env to failure message (shaohui.liu2000@gmail.com) [#15816](https://github.com/nodejs/node/pull/15816)
* [[`42dfde827b`](https://github.com/nodejs/node/commit/42dfde827b)] - **test**: improve assert message in test-dh-regr (Mabry Cervin) [#15912](https://github.com/nodejs/node/pull/15912)
* [[`584f037612`](https://github.com/nodejs/node/commit/584f037612)] - **test**: fixtures in test-net-pipe-connect-errors (Eric Freiberg) [#15922](https://github.com/nodejs/node/pull/15922)
* [[`ab6eed8818`](https://github.com/nodejs/node/commit/ab6eed8818)] - **test**: fixtures in test-process-redirect-warnings-env (Kat Rosario) [#15930](https://github.com/nodejs/node/pull/15930)
* [[`ce9d55d78f`](https://github.com/nodejs/node/commit/ce9d55d78f)] - **test**: fix ordering of strictEqual actual/expected (Chad Zezula) [#16008](https://github.com/nodejs/node/pull/16008)
* [[`b1506f713c`](https://github.com/nodejs/node/commit/b1506f713c)] - **test**: use fixtures.path instead of fixturesDir (Matthew Meyer) [#15984](https://github.com/nodejs/node/pull/15984)
* [[`981595c316`](https://github.com/nodejs/node/commit/981595c316)] - **test**: fix test-esm-addons (Rich Trott) [#16174](https://github.com/nodejs/node/pull/16174)
* [[`84f6964d25`](https://github.com/nodejs/node/commit/84f6964d25)] - **test**: use fixtures.readSync (szhang351)
* [[`c42cdd4919`](https://github.com/nodejs/node/commit/c42cdd4919)] - **test**: replaced fixturesDir with common.fixtures (Dolapo Toki) [#15836](https://github.com/nodejs/node/pull/15836)
* [[`734ec0b854`](https://github.com/nodejs/node/commit/734ec0b854)] - **test**: use fixtures.fixturesDir (Gene Wu) [#15822](https://github.com/nodejs/node/pull/15822)
* [[`cfe14eed9f`](https://github.com/nodejs/node/commit/cfe14eed9f)] - **test**: replaces fixturesDir with fixtures methods (Christian Murphy) [#15817](https://github.com/nodejs/node/pull/15817)
* [[`64560cf08c`](https://github.com/nodejs/node/commit/64560cf08c)] - **test**: replace fixturesDir with fixtures methods (Cristian Peñarrieta) [#15833](https://github.com/nodejs/node/pull/15833)
* [[`c29e366109`](https://github.com/nodejs/node/commit/c29e366109)] - **test**: update test-https-server-keep-alive-timeout (Tom Boutell) [#15805](https://github.com/nodejs/node/pull/15805)
* [[`8a8cd40b27`](https://github.com/nodejs/node/commit/8a8cd40b27)] - **test**: fixtures in test-process-redirect-warnings (Nicolas Chaulet) [#15917](https://github.com/nodejs/node/pull/15917)
* [[`7bc6dd02a4`](https://github.com/nodejs/node/commit/7bc6dd02a4)] - **test**: update test-crypto-from-binary (Raj Parekh) [#16011](https://github.com/nodejs/node/pull/16011)
* [[`9943cb2950`](https://github.com/nodejs/node/commit/9943cb2950)] - **test**: fixtures in test-http2-respond-file-fd-range (kysnm) [#15878](https://github.com/nodejs/node/pull/15878)
* [[`0e1455b909`](https://github.com/nodejs/node/commit/0e1455b909)] - **test**: use fixtures in test-https-set-timeout-server (Bob Clewell) [#15886](https://github.com/nodejs/node/pull/15886)
* [[`c4231aaad3`](https://github.com/nodejs/node/commit/c4231aaad3)] - **test**: make use of common/fixtures.fixturesDir (Jem Bezooyen) [#15815](https://github.com/nodejs/node/pull/15815)
* [[`a9a0146c8b`](https://github.com/nodejs/node/commit/a9a0146c8b)] - **test**: use common/fixtures in test-https-close (Alberto Lopez de Lara) [#15870](https://github.com/nodejs/node/pull/15870)
* [[`cd64b4166b`](https://github.com/nodejs/node/commit/cd64b4166b)] - **test**: use fixtures in test-process-warnings (Suresh Srinivas) [#15869](https://github.com/nodejs/node/pull/15869)
* [[`42e8254f19`](https://github.com/nodejs/node/commit/42e8254f19)] - **test**: use fixtures in tls-friendly-error-message (tobyfarley) [#15905](https://github.com/nodejs/node/pull/15905)
* [[`af49e58211`](https://github.com/nodejs/node/commit/af49e58211)] - **test**: add benchmark tests for es (Ethan Arrowood) [#16076](https://github.com/nodejs/node/pull/16076)
* [[`c0bba73ac2`](https://github.com/nodejs/node/commit/c0bba73ac2)] - **test**: use common/fixtures in tls-connect-no-host (Donovan Buck) [#15986](https://github.com/nodejs/node/pull/15986)
* [[`ce33cffbcb`](https://github.com/nodejs/node/commit/ce33cffbcb)] - **test**: use common/fixtures in test-https-agent (jpaulptr) [#15941](https://github.com/nodejs/node/pull/15941)
* [[`668f4cff22`](https://github.com/nodejs/node/commit/668f4cff22)] - **test**: use common fixtures module (Kat Rosario) [#15856](https://github.com/nodejs/node/pull/15856)
* [[`bf8f1d3208`](https://github.com/nodejs/node/commit/bf8f1d3208)] - **test**: fs.readFileSync -\> fixtures.readKey (Ethan Brown) [#16030](https://github.com/nodejs/node/pull/16030)
* [[`7e4893df60`](https://github.com/nodejs/node/commit/7e4893df60)] - **test**: reduce test-benchmark-http iterations (Rich Trott) [#16137](https://github.com/nodejs/node/pull/16137)
* [[`ce848a4501`](https://github.com/nodejs/node/commit/ce848a4501)] - **test**: reduce run time for misc benchmark tests (Rich Trott) [#16120](https://github.com/nodejs/node/pull/16120)
* [[`75d41cf531`](https://github.com/nodejs/node/commit/75d41cf531)] - **test**: improve assertion message in dgram test (Shakeel Mohamed) [#16121](https://github.com/nodejs/node/pull/16121)
* [[`2016ad3035`](https://github.com/nodejs/node/commit/2016ad3035)] - **test**: use of fixtures in test-pipe-head (Nicolas Chaulet) [#15868](https://github.com/nodejs/node/pull/15868)
* [[`b9c8fd8338`](https://github.com/nodejs/node/commit/b9c8fd8338)] - **test**: use fixtures in test-https-localaddress.js (Charles T Wall III) [#15811](https://github.com/nodejs/node/pull/15811)
* [[`70a19ae782`](https://github.com/nodejs/node/commit/70a19ae782)] - **test**: use common/fixtures in fs-symlink test (AlexeyM) [#15830](https://github.com/nodejs/node/pull/15830)
* [[`beb5226c29`](https://github.com/nodejs/node/commit/beb5226c29)] - **test**: replace common.fixtures with fixtures module (Jonathan Eskew) [#15877](https://github.com/nodejs/node/pull/15877)
* [[`d828c01a65`](https://github.com/nodejs/node/commit/d828c01a65)] - **test**: use fixtures.readKey() (Kasim Doctor) [#15862](https://github.com/nodejs/node/pull/15862)
* [[`7205e0a0fe`](https://github.com/nodejs/node/commit/7205e0a0fe)] - **test**: added a test comment (Edward Andrew Robinson) [#16003](https://github.com/nodejs/node/pull/16003)
* [[`b6a87dbe13`](https://github.com/nodejs/node/commit/b6a87dbe13)] - **test**: improve assert message (Tri Nguyen) [#15909](https://github.com/nodejs/node/pull/15909)
* [[`1c28dfa09a`](https://github.com/nodejs/node/commit/1c28dfa09a)] - **test**: replace fixturesDir with fixtures method (suraiyah) [#15894](https://github.com/nodejs/node/pull/15894)
* [[`c4cb06195d`](https://github.com/nodejs/node/commit/c4cb06195d)] - **test**: replace fixturesDir with fixtures module (Joel Dart) [#15848](https://github.com/nodejs/node/pull/15848)
* [[`07f1efc2ae`](https://github.com/nodejs/node/commit/07f1efc2ae)] - **test**: common.fixturesDir -\>  common.fixtures (Peter) [#16028](https://github.com/nodejs/node/pull/16028)
* [[`e791057ee7`](https://github.com/nodejs/node/commit/e791057ee7)] - **test**: normalize fixtures use (Ruxandra Fediuc) [#15855](https://github.com/nodejs/node/pull/15855)
* [[`b33b3e1838`](https://github.com/nodejs/node/commit/b33b3e1838)] - **test**: cleaned up assert messages (mrgorbo) [#16032](https://github.com/nodejs/node/pull/16032)
* [[`4716a9d349`](https://github.com/nodejs/node/commit/4716a9d349)] - **test**: replace common.fixturesDir w/common.fixtures (Jason Walton) [#15853](https://github.com/nodejs/node/pull/15853)
* [[`acb36abf75`](https://github.com/nodejs/node/commit/acb36abf75)] - **test**: fix lint error (Rich Trott) [#16145](https://github.com/nodejs/node/pull/16145)
* [[`2a74fed8ea`](https://github.com/nodejs/node/commit/2a74fed8ea)] - **test**: replace common.fixturesDir (Shawn McGinty) [#15834](https://github.com/nodejs/node/pull/15834)
* [[`03550a5c18`](https://github.com/nodejs/node/commit/03550a5c18)] - **test**: replace common.fixturesDir with commonfixtures (Feon Sua) [#15832](https://github.com/nodejs/node/pull/15832)
* [[`e04e9270cc`](https://github.com/nodejs/node/commit/e04e9270cc)] - **test**: replace fixturesDir to use fixtures module (Josh Lim) [#15831](https://github.com/nodejs/node/pull/15831)
* [[`2ddb2fad94`](https://github.com/nodejs/node/commit/2ddb2fad94)] - **test**: switch to use common.fixtures module for fixturesDir (r1cebank) [#15821](https://github.com/nodejs/node/pull/15821)
* [[`16ed116203`](https://github.com/nodejs/node/commit/16ed116203)] - **test**: clean up string concat in dlopen-ping-pong (agilbert) [#15820](https://github.com/nodejs/node/pull/15820)
* [[`bafa2288d8`](https://github.com/nodejs/node/commit/bafa2288d8)] - **test**: replace common.fixturesDir with fixtures (Steven Scott) [#15845](https://github.com/nodejs/node/pull/15845)
* [[`327a871579`](https://github.com/nodejs/node/commit/327a871579)] - **test**: fixturesDir replaced to fixtures module (Pawel Golda) [#15809](https://github.com/nodejs/node/pull/15809)
* [[`23b4bf88a3`](https://github.com/nodejs/node/commit/23b4bf88a3)] - **test**: replace common.fixturesDir with fixtures (Stefania Sharp) [#16015](https://github.com/nodejs/node/pull/16015)
* [[`2ea902b47b`](https://github.com/nodejs/node/commit/2ea902b47b)] - **test**: replaces common.fixturesDir usage (Ruy Adorno) [#15818](https://github.com/nodejs/node/pull/15818)
* [[`58d26e2421`](https://github.com/nodejs/node/commit/58d26e2421)] - **test**: added fs benchmark test (Charlie Duong) [#16049](https://github.com/nodejs/node/pull/16049)
* [[`7525df7af2`](https://github.com/nodejs/node/commit/7525df7af2)] - **test**: use common.fixtures.path() (Tobias Kieslich) [#16112](https://github.com/nodejs/node/pull/16112)
* [[`a0ec1e668c`](https://github.com/nodejs/node/commit/a0ec1e668c)] - **test**: replace common.fixturesDir with fixtures (Shakeel Mohamed) [#15857](https://github.com/nodejs/node/pull/15857)
* [[`87ee0b640e`](https://github.com/nodejs/node/commit/87ee0b640e)] - **test**: use fixtures module in test (Nigel Kibodeaux) [#16117](https://github.com/nodejs/node/pull/16117)
* [[`3784b2d839`](https://github.com/nodejs/node/commit/3784b2d839)] - **test**: use template literals in test-string-decoder (Edward Andrew Robinson) [#15884](https://github.com/nodejs/node/pull/15884)
* [[`152bf22d02`](https://github.com/nodejs/node/commit/152bf22d02)] - **test**: switch to fixtures module (Christopher Sidebottom) [#15880](https://github.com/nodejs/node/pull/15880)
* [[`adbc5d7d57`](https://github.com/nodejs/node/commit/adbc5d7d57)] - **test**: rewrite assert message (Martin Michaelis) [#15879](https://github.com/nodejs/node/pull/15879)
* [[`f170f8493c`](https://github.com/nodejs/node/commit/f170f8493c)] - **test**: change fixturesDir to fixtures.path (Guilherme Akio Sakae) [#15863](https://github.com/nodejs/node/pull/15863)
* [[`6af889615d`](https://github.com/nodejs/node/commit/6af889615d)] - **test**: replace common.fixturesDir with fixtures (Chris Jimenez) [#15806](https://github.com/nodejs/node/pull/15806)
* [[`1d7fbabaef`](https://github.com/nodejs/node/commit/1d7fbabaef)] - **test**: replace fixturesDir with common.fixtures (Oliver Luebeck) [#15907](https://github.com/nodejs/node/pull/15907)
* [[`067d1f16de`](https://github.com/nodejs/node/commit/067d1f16de)] - **test**: allow short benchmarks for tests (Rich Trott) [#16097](https://github.com/nodejs/node/pull/16097)
* [[`b3ce408098`](https://github.com/nodejs/node/commit/b3ce408098)] - **test**: update http test client function signatures (Jakub Mrowiec - Alkagar) [#15807](https://github.com/nodejs/node/pull/15807)
* [[`fa265a2cca`](https://github.com/nodejs/node/commit/fa265a2cca)] - **test**: reduce run time for string_decoder benchmark (Rich Trott) [#16118](https://github.com/nodejs/node/pull/16118)
* [[`f2b9d5e41e`](https://github.com/nodejs/node/commit/f2b9d5e41e)] - **test**: increase test coverage of readline-interface (Daniel Kostro) [#16062](https://github.com/nodejs/node/pull/16062)
* [[`fe38ace643`](https://github.com/nodejs/node/commit/fe38ace643)] - **test**: improve crypto HMAC test assertions (Seth Holladay) [#16026](https://github.com/nodejs/node/pull/16026)
* [[`09d8b3576f`](https://github.com/nodejs/node/commit/09d8b3576f)] - **test**: improve coverage for 'internal/errors' (Ruxandra Fediuc) [#16055](https://github.com/nodejs/node/pull/16055)
* [[`ee587f39ae`](https://github.com/nodejs/node/commit/ee587f39ae)] - **test**: add tests of querystring benchmark (Jonathan Eskew) [#16052](https://github.com/nodejs/node/pull/16052)
* [[`2e215f169a`](https://github.com/nodejs/node/commit/2e215f169a)] - **test**: fix and refactor test-http-invalid-urls (Rich Trott) [#15678](https://github.com/nodejs/node/pull/15678)
* [[`5be4dfaa13`](https://github.com/nodejs/node/commit/5be4dfaa13)] - **test**: make it easier to run tests for subsystems (Benjamin Coe) [#15450](https://github.com/nodejs/node/pull/15450)
* [[`2adf68035c`](https://github.com/nodejs/node/commit/2adf68035c)] - **test**: consolidate http2 tests in one file (Trivikram Kamat) [#15624](https://github.com/nodejs/node/pull/15624)
* [[`3e4f34cdb9`](https://github.com/nodejs/node/commit/3e4f34cdb9)] - **test**: fix flaky test-crypto-classes.js (Bryan English) [#15662](https://github.com/nodejs/node/pull/15662)
* [[`611a648c66`](https://github.com/nodejs/node/commit/611a648c66)] - **(SEMVER-MINOR)** **test**: crypto createClass instanceof Class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`fca7e49e44`](https://github.com/nodejs/node/commit/fca7e49e44)] - **(SEMVER-MAJOR)** **test**: adjust windows failed alloc test to V8 6.2 (Bartosz Sosnowski) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`44d486500d`](https://github.com/nodejs/node/commit/44d486500d)] - **test**: increase coverage for internal/errors.js (Weijia Wang) [#15044](https://github.com/nodejs/node/pull/15044)
* [[`467385a49b`](https://github.com/nodejs/node/commit/467385a49b)] - **test**: use invalid host according to RFC2606 (Tobias Nießen) [#14863](https://github.com/nodejs/node/pull/14863)
* [[`f417add1f4`](https://github.com/nodejs/node/commit/f417add1f4)] - **test**: add test-benchmark-zlib (Rich Trott) [#14763](https://github.com/nodejs/node/pull/14763)
* [[`95c8df18f1`](https://github.com/nodejs/node/commit/95c8df18f1)] - **(SEMVER-MAJOR)** **test**: add test to verify ErrnoException path (Daniel Bevenius) [#13958](https://github.com/nodejs/node/pull/13958)
* [[`0d3ef5b0f8`](https://github.com/nodejs/node/commit/0d3ef5b0f8)] - **(SEMVER-MAJOR)** **test**: check `this` value for `nextTick()` (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`c6126b1308`](https://github.com/nodejs/node/commit/c6126b1308)] - **(SEMVER-MAJOR)** **test**: refactor test-fs-stat (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`3566195196`](https://github.com/nodejs/node/commit/3566195196)] - **test**: replace concatenation with template literals (xeodou) [#14281](https://github.com/nodejs/node/pull/14281)
* [[`b923b9dee1`](https://github.com/nodejs/node/commit/b923b9dee1)] - **test**: replace string concat in test-child-process-constructor (mac-haojin) [#14283](https://github.com/nodejs/node/pull/14283)
* [[`2a621d4051`](https://github.com/nodejs/node/commit/2a621d4051)] - **test**: validate more properties in expectsError (Ruben Bridgewater) [#14058](https://github.com/nodejs/node/pull/14058)
* [[`5ffb5b6fce`](https://github.com/nodejs/node/commit/5ffb5b6fce)] - **test**: improve the test common documentation (Ruben Bridgewater) [#14148](https://github.com/nodejs/node/pull/14148)
* [[`1b2733f272`](https://github.com/nodejs/node/commit/1b2733f272)] - **test**: common.expectsError should be a must call (Ruben Bridgewater) [#14088](https://github.com/nodejs/node/pull/14088)
* [[`d69ecc6f51`](https://github.com/nodejs/node/commit/d69ecc6f51)] - ***Revert*** "**test**: improve test-process-kill-null for Windows" (Refael Ackermann) [#14142](https://github.com/nodejs/node/pull/14142)
* [[`d6fece1436`](https://github.com/nodejs/node/commit/d6fece1436)] - **test**: add optional throw fn to expectsError (Ruben Bridgewater) [#14089](https://github.com/nodejs/node/pull/14089)
* [[`44483b6898`](https://github.com/nodejs/node/commit/44483b6898)] - **test**: improve test-process-kill-null for Windows (starkwang) [#14099](https://github.com/nodejs/node/pull/14099)
* [[`eaaec57332`](https://github.com/nodejs/node/commit/eaaec57332)] - **(SEMVER-MAJOR)** **test**: use worker.exitedAfterDisconnect consistently (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] - **(SEMVER-MAJOR)** **timers**: warn on overflowed timeout duration (Jeremiah Senkpiel) [#15627](https://github.com/nodejs/node/pull/15627)
* [[`11f7dcf91e`](https://github.com/nodejs/node/commit/11f7dcf91e)] - **(SEMVER-MAJOR)** **timers**: do not expose .unref()._handle._list (Jeremiah Senkpiel) [#8422](https://github.com/nodejs/node/pull/8422)
* [[`4d893e093a`](https://github.com/nodejs/node/commit/4d893e093a)] - **(SEMVER-MAJOR)** **timers**: Migrate to use internal/errors (Weijia Wang) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`5723b5dbbc`](https://github.com/nodejs/node/commit/5723b5dbbc)] - **tls**: improve TLSSocket & Server performance (Anatoli Papirovski) [#15575](https://github.com/nodejs/node/pull/15575)
* [[`468110b327`](https://github.com/nodejs/node/commit/468110b327)] - **(SEMVER-MAJOR)** **tls**: deprecate parseCertString & move to internal (XadillaX) [#14249](https://github.com/nodejs/node/pull/14249)
* [[`1403d28e7d`](https://github.com/nodejs/node/commit/1403d28e7d)] - **tls**: re-allow falsey option values (Anna Henningsen) [#15131](https://github.com/nodejs/node/pull/15131)
* [[`0f7c06eb2d`](https://github.com/nodejs/node/commit/0f7c06eb2d)] - **(SEMVER-MAJOR)** **tls**: fix object prototype type confusion (Ben Noordhuis) [#14447](https://github.com/nodejs/node/pull/14447)
* [[`5723c4c5f0`](https://github.com/nodejs/node/commit/5723c4c5f0)] - **tls**: replace forEach with for (Brian White) [#15053](https://github.com/nodejs/node/pull/15053)
* [[`a7dccd040d`](https://github.com/nodejs/node/commit/a7dccd040d)] - **(SEMVER-MAJOR)** **tls**: type checking for `key`, `cert` and `ca` options (Jimmy Cann) [#14807](https://github.com/nodejs/node/pull/14807)
* [[`3ccfeb483d`](https://github.com/nodejs/node/commit/3ccfeb483d)] - **(SEMVER-MAJOR)** **tls**: migrate tls.js to use internal/errors.js (Michael Dawson) [#13994](https://github.com/nodejs/node/pull/13994)
* [[`193926ecab`](https://github.com/nodejs/node/commit/193926ecab)] - **tls,doc**: fix unallocated deprecation code (James M Snell) [#15534](https://github.com/nodejs/node/pull/15534)
* [[`80bd2a240b`](https://github.com/nodejs/node/commit/80bd2a240b)] - **tools**: minor performance improvement (Anna Henningsen) [#16125](https://github.com/nodejs/node/pull/16125)
* [[`a26c1bfac9`](https://github.com/nodejs/node/commit/a26c1bfac9)] - **tools**: use template literal in error message (Tim Chon) [#15846](https://github.com/nodejs/node/pull/15846)
* [[`b41d215f28`](https://github.com/nodejs/node/commit/b41d215f28)] - **tools**: replace string concat (Kai Cataldo) [#15850](https://github.com/nodejs/node/pull/15850)
* [[`8c6c060918`](https://github.com/nodejs/node/commit/8c6c060918)] - **tools**: replace string concatenation with template (Nicola Del Gobbo) [#15827](https://github.com/nodejs/node/pull/15827)
* [[`c1cd731abc`](https://github.com/nodejs/node/commit/c1cd731abc)] - **url**: using util._extend for improving profermace (Weijia Wang) [#16081](https://github.com/nodejs/node/pull/16081)
* [[`92146e00fd`](https://github.com/nodejs/node/commit/92146e00fd)] - **url**: fix port overflow checking (Rimas Misevičius) [#15794](https://github.com/nodejs/node/pull/15794)
* [[`c88ba036b4`](https://github.com/nodejs/node/commit/c88ba036b4)] - **(SEMVER-MAJOR)** **url**: ensure search property is consistently null vs empty (Justin Beckwith) [#13606](https://github.com/nodejs/node/pull/13606)
* [[`b1c8f15c5f`](https://github.com/nodejs/node/commit/b1c8f15c5f)] - **(SEMVER-MAJOR)** **util**: use constructor name (Ruben Bridgewater) [#14886](https://github.com/nodejs/node/pull/14886)
* [[`3b0e800f18`](https://github.com/nodejs/node/commit/3b0e800f18)] - **(SEMVER-MAJOR)** **util**: make util.debuglog() consistent with doc (Vse Mozhet Byt) [#13841](https://github.com/nodejs/node/pull/13841)
* [[`af3aa682ac`](https://github.com/nodejs/node/commit/af3aa682ac)] - **(SEMVER-MINOR)** **util**: add callbackify (Refael Ackermann) [#12712](https://github.com/nodejs/node/pull/12712)
* [[`58831b2f24`](https://github.com/nodejs/node/commit/58831b2f24)] - **(SEMVER-MAJOR)** **uv**: improvements to process.binding('uv') (James M Snell) [#14933](https://github.com/nodejs/node/pull/14933)
* [[`b3e5c4621d`](https://github.com/nodejs/node/commit/b3e5c4621d)] - **(SEMVER-MAJOR)** **v8**: add new to the throw statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`44f5523260`](https://github.com/nodejs/node/commit/44f5523260)] - **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
* [[`74891412f1`](https://github.com/nodejs/node/commit/74891412f1)] - **(SEMVER-MAJOR)** **zlib**: migrate to internal/errors (James M Snell) [#15618](https://github.com/nodejs/node/pull/15618)
* [[`2421984727`](https://github.com/nodejs/node/commit/2421984727)] - **zlib**: check cleanup return values (Anna Henningsen) [#14673](https://github.com/nodejs/node/pull/14673)
* [[`add4b0ab8c`](https://github.com/nodejs/node/commit/add4b0ab8c)] - **zlib**: improve performance (Brian White) [#13322](https://github.com/nodejs/node/pull/13322)
