<script>
{
	"title": "jQuery Support"
}
</script>

## Supported versions

We support only the latest version of jQuery. The 1.x and 2.x branches are no longer supported.

jQuery 3.x will only receive critical security patches and bug fixes. We encourage all users to upgrade to the latest version of jQuery 4.x.

jQuery 4.x is the current version branch of jQuery.

### Unsupported versions

When using a version earlier than the latest version, there are a few options:

* [Upgrade](/download#upgrade) to the latest version of jQuery. The best solution is to upgrade as it will include all features, bug fixes, security patches, and improvements. The [jQuery Migrate Plugin](https://github.com/jquery/jquery-migrate) and [upgrade guides](/upgrade-guide) are available to assist with upgrading.
* Continue using an older version of jQuery, but include all security patches through [commercial security support](#commercial-support).
* Continue using an older version of jQuery without security patches. **However, this can come with multiple risks.**

## Community support

The following learning resources are available online and free of charge:

* [jQuery Learning Center](https://learn.jquery.com/)
* [jQuery API Documentation](https://api.jquery.com/)
* [jQuery UI Demos](https://jqueryui.com/demos/)
* [jQuery UI API Documentation](https://api.jqueryui.com/)

### Matrix chat

jQuery is on Matrix! The support channel for jQuery is [#jquery_jquery:gitter.im](https://app.element.io/#/room/#jquery_jquery:gitter.im). You can [read the channel on Element](https://app.element.io/#/room/#jquery_jquery:gitter.im) without an account, or [join the channel](https://matrix.to/#/#jquery_jquery:gitter.im) via any Matrix client.

We use the public [#jquery_dev channel](https://app.element.io/#/room/#jquery_dev:gitter.im) to discuss project developments. We also hold [weekly meetings](https://meetings.jquery.org/) on Matrix.

### IRC chat

We are on [Libera Chat IRC](https://libera.chat/) in the `#jquery` channel where you can ask for support. You can [join via webchat](https://web.libera.chat/#jquery), or via any IRC client.

### StackOverflow

StackOverflow is a great place to ask questions and find support for all jQuery projects. Search or create [questions tagged with "jquery"](https://stackoverflow.com/questions/tagged/jquery), or refer to the ["jquery" tag introduction](https://stackoverflow.com/tags/jquery/info).

## Commercial support

The following companies offer commercial support services for jQuery.

[HeroDevs](https://www.herodevs.com/support/jquery-nes?utm_source=jQuery&utm_medium=link&utm_campaign=eol_support_jQuery) offers security and compatibility support for EOL versions of jQuery through the [OpenJS Ecosystem Sustainability Program](https://openjsf.org/ecosystem-sustainability-program) and is an approved commercial support vendor. Find out more about their [Never Ending Support options](https://www.herodevs.com/support/jquery-nes?utm_source=jQuery&utm_medium=link&utm_campaign=eol_support_jQuery).

-------

## Follow us

jQuery on Mastodon and the Fediverse:

* [@jquery@social.lfx.dev](https://social.lfx.dev/@jquery)
* [@qunit@fosstodon.org](https://fosstodon.org/@qunit)
* [@openjsf@social.lfx.dev](https://social.lfx.dev/@openjsf)

jQuery on Twitter:

* [@jquery](https://twitter.com/jquery)
* [@jqueryui](https://twitter.com/jqueryui)
* [@jquerymobile](https://twitter.com/jquerymobile)
* [@qunitjs](https://twitter.com/qunitjs)
* [@jqcon](https://twitter.com/jqcon)

-------

## Media & Press inquiry

Journalists seeking information on jQuery should contact: [info@jquery.com](mailto:info@jquery.com).

For guidance on branding and trademark usage, visit <https://brand.jquery.org/>.

-------

## Found a bug?

For reporting bugs in libraries, documentation, or content, the project's GitHub issue tracker should be used. All jQuery projects can be found at https://github.com/jquery

Still haven't found what you're looking for? Please feel free to contact: [info@jquery.com](mailto:info@jquery.com)

-------

## Archives

* [Freenode IRC chat channels](https://irc.jquery.org/) (2011-2021)
* [jQuery Forum](https://forum.jquery.com/) (2010-2021): For questions and advice regarding jQuery Core, jQuery UI, Themeroller, QUnit, development of jQuery Plugins, and more.
* [jQuery Accessibility mailing list](https://groups.google.com/group/jquery-a11y) (2008-2016).

