<script>{
	"title": "jQuery Core 1.9 Upgrade Guide",
	"toc": true
}</script>

## Overview

jQuery 1.9 removes or modifies several APIs that behaved inconsistently or inefficiently in the past. The majority of these changes have been foreshadowed by their [deprecation](https://api.jquery.com/category/deprecated/) in previous versions of jQuery, particularly 1.7 and 1.8.

In making these changes, the team's goal was to fix behavior that makes jQuery inconsistent or hard to use, and in the process improve both file size and overall performance.

This list is deceptively foreboding. Most of these changes address special situations and edge cases, and a few are changes that have been widely requested where jQuery's historical behavior has been problematic. As a first step, the best way to see if your code works is to try it with both jQuery 1.9 and the Migrate Plugin as described below.

For now, this guide serves as an appendix to the standard jQuery API documentation, and those pages may not describe the behavior of version 1.9. Please be patient while we update the documentation for the individual pages at api.jquery.com to reflect the changes in 1.9.

## jQuery Migrate Plugin

We realize that existing sites and plugins may be affected by these changes, and are providing the [jQuery Migrate](https://github.com/jquery/jquery-migrate) plugin for a transitional upgrade path. Individual descriptions below indicate if the behavior changed in 1.9 can be restored by using the jQuery Migrate plugin. Note that all of the changes in jQuery 1.9 will also apply to jQuery 2.0, and the jQuery Migrate plugin will be usable there as well.

The uncompressed development version of the jQuery Migrate plugin includes console log output to warn when specific deprecated and/or removed features are being used. This makes it valuable as a migration debugging tool for finding and remediating issues in existing jQuery code and plugins. It can be used for its diagnostics with versions of jQuery core all the way back to 1.6.4.

The compressed version of the plugin does not generate any log output, and can be used on production sites when jQuery 1.9 or higher is desired but older incompatible jQuery code or plugins must also be used. Ideally this would only be used as a short-term solution, but that's a decision for you to make.

For more information see the [jQuery Migrate plugin](https://github.com/jquery/jquery-migrate/).

## Changes of Note in jQuery 1.9

The list below does not represent all changes made for jQuery 1.9, just the changes that we anticipate may affect behavior in a way that could break existing code. For a complete and detailed list of changes, see the changelogs in the release announcements on the [jQuery blog](https://blog.jquery.com) or visit [bugs.jquery.com](https://bugs.jquery.com).

### .toggle( function, function, ... ) removed

This is the "click an element to run the specified functions" signature of `.toggle()`. It should not be confused with the "change the visibility of an element" of `.toggle()` which is not deprecated. The former is being removed to reduce confusion and improve the potential for modularity in the library. The jQuery Migrate plugin can be used to restore the functionality.

### jQuery.browser() removed

The `jQuery.browser()` method has been deprecated since jQuery 1.3 and is removed in 1.9. If needed, it is available as part of the jQuery Migrate plugin. We recommend using feature detection with a library such as [Modernizr](https://modernizr.com).

### .live() removed

The `.live()` method has been deprecated since jQuery 1.7 and has been removed in 1.9. We recommend upgrading code to use the `.on()` method instead. To exactly match `$( "a.foo" ).live( "click", fn )`, for example, you can write `$( document ).on( "click", "a.foo", fn )`. For more information, see the [`.on()` documentation](https://api.jquery.com/on/). In the meantime, the jQuery Migrate plugin can be used to restore the `.live()` functionality.

### .die() removed

The `.die()` method has been deprecated since jQuery 1.7 and has been removed in 1.9. We recommend upgrading code to use the `.off()` method instead. To exactly match `$( "a.foo" ).die( "click" )`, for example, you can write `$( document ).off( "click", "a.foo" )`. For more information, see the [`.off()` documentation](https://api.jquery.com/off/). In the meantime, the jQuery Migrate plugin can be used to restore the `.die()` functionality.

### jQuery.sub() removed

The `jQuery.sub()` method has been moved to the jQuery Migrate plugin. The number of use cases where it proved valuable were not enough to justify keeping it in core. The jQuery Migrate plugin adds back this functionality.

### .add()

The `.add()` method is always supposed to return its results in document order. Prior to 1.9, .add() would not sort nodes in document order if either the context or the input set started with a disconnected node (not in a document). Now, nodes are always returned in document order and disconnected nodes are placed at the end of the set.

### .addBack( selector ) replaces .andSelf()

As of jQuery 1.8, the `.andSelf()` method was deprecated in favor of the `.addBack()` method, which we feel is a better name for what this method does--"add back" the previous set of results. The new method accepts an optional selector that can be used to filter the previous set before adding it to the current set. So, `$( "section, aside" ).children( "ul" ).addBack( "aside" )` results in a set that includes all `aside` nodes plus the `ul` children of both `section` and `aside` nodes, in document order. Although the `.andSelf()` method still works in 1.9, we recommend switching names as soon as possible. The jQuery Migrate plugin will warn about the use of `.andSelf()`.

### .after(), .before(), and .replaceWith() with disconnected nodes

Prior to 1.9, `.after()`, `.before()`, and `.replaceWith()` would attempt to add or change nodes in the current jQuery set if the first node in the set was not connected to a document, and in those cases return a new jQuery set rather than the original set. This created several inconsistencies and outright bugs--the method might or might not return a new result depending on its arguments! As of 1.9, these methods always return the original unmodified set and attempting to use `.after()`, `.before()`, or `.replaceWith()` on a node without a parent has no effect--that is, neither the set or the nodes it contains are changed.

### .appendTo, .insertBefore, .insertAfter, and .replaceAll

As of 1.9, these methods _always_ return a new set, making them consistently usable with chaining and the `.end()` method. Prior to 1.9, they would return the old set only if there was a single target element. Note that these methods have always returned the aggregate set of all elements appended to the target elements. If no elements are selected by the target selector (e.g., `$( elements ).appendTo( "#not_found" )`) the resulting set will be empty.

### Ajax events should be attached to document

As of jQuery 1.9, the global Ajax events (`ajaxStart`, `ajaxStop`, `ajaxSend`, `ajaxComplete`, `ajaxError`, and `ajaxSuccess`) are only triggered on the `document` element. Change the program to listen for the Ajax events on the document. For example, if the code currently looks like this:
```js
$( "#status" ).on( "ajaxStart", function() {
	$( this ).text( "Ajax started" );
} );
```
Change it to this:
```js
$( document ).on( "ajaxStart", function() {
	$( "#status" ).text( "Ajax started" );
} );
```

### Checkbox/radio state in a .trigger()ed "click" event

When the _user_ clicks on a checkbox or radio button, the event handler sees the node in the state it will be in if `event.preventDefault()` is not called on the node--in essence, its new state. So for example, if the user clicks on an unchecked checkbox, the event handler will see a _checked_ box. Before 1.9, a synthetic event triggered by either `.trigger( "click" )` or `.click()` would see the checkbox in the opposite state than that of a user action. This has been fixed in 1.9 to reflect the same checked state as a user-initiated action.

### Order of triggered "focus" events

When the user clicks or tabs into a form element to bring it into focus, the browser first fires a blur event for the previously focused element and then a focus event for the new element. Prior to 1.9, a trigger()ed focus event using either `.trigger( "focus" )` or `.focus()` would fire a focus event for the new element and then the blur event for the previous element before finally actually focusing the element. In 1.9 this behavior has been changed to reflect the same order as if the user had caused the focus change.

With native DOM focus events, the browser only calls a focus event handler if the target element is not already focused and can also successfully be focused. jQuery has always ensured that a call to `.trigger( "focus" )` or `.focus()` consistently runs any attached event handlers, even if the element cannot be focused, and jQuery 1.9 continues to do that. This is different behavior than the DOM `.focus()` method, which will not call event handlers in many cases including where the element is already focused or the element is disabled.

Unfortunately, all versions of Internet Explorer (6 through 10) fire focus events asynchronously. When you `.trigger( "focus" )` in IE, jQuery won't "see" the async focus event which will occur later, so it fires one of its own to ensure that a focus event always occurs as described above. This causes two calls to the event handler. To avoid this double-call--but risk that the event handler is not called at all--use the DOM focus method directly, e.g., `$( "selector" ).get( 0 ).focus()`.

### jQuery( htmlString ) versus jQuery( selectorString )

Prior to 1.9, a string would be considered to be an HTML string if it had HTML tags anywhere within the string. This has the potential to cause inadvertent execution of code and reject valid selector strings. As of 1.9, a string is only considered to be HTML if it starts with a less-than ("`<`") character. The Migrate plugin can be used to restore the pre-1.9 behavior.

If a string is known to be HTML but may start with arbitrary text that is not an HTML tag, pass it to `jQuery.parseHTML()` which will return an array of DOM nodes representing the  markup. A jQuery collection can be created from this, for example: `$( $.parseHTML( htmlString ) )`. This would be considered best practice when processing HTML templates for example. Simple uses of literal strings such as `$( "<p>Testing</p>" ).appendTo( "body" )` are unaffected by this change.

Bottom line: HTML strings passed to `jQuery()` that start with something other than a less-than character will be interpreted as a selector. Since the string usually cannot be interpreted as a selector, the most likely result will be an "invalid selector syntax" error thrown by the Sizzle selector engine. Use `jQuery.parseHTML()` to parse arbitrary HTML.

When the jQuery Migrate plugin is used, it will use the old rules for determining if the string passed to `$()` "looks like HTML".

### Events not fired by the .data() method; names with periods

The `.data()` method had an undocumented and incredibly non-performant way to monitor setting and getting of values that was removed in 1.9. This has affected the interpretation of data names that contain periods, in a good way. As of 1.9, a call to `.data( "abc.def" )` retrieves the data for the name "abc.def" _only_, and never just "abc".  Note that the lower-level `jQuery.data()` method never supported events and so it has not changed. The jQuery Migrate plugin does _not_ restore the old behavior for this case.

### Ordering of disconnected nodes within a jQuery set

For many versions, nearly all jQuery methods that return new sets of nodes use the document order to sort the resulting set. (There are a few methods such as `.parents()`, which returns its results in reverse-document order, but those exceptions are already documented and have not changed in 1.9.)

Before 1.9, sets that contained some connected and some disconnected nodes would be sorted inconsistently, depending on whether a disconnected node led the original unsorted set. As of 1.9, connected nodes are always placed at the beginning of the set in document order, and disconnected nodes are placed behind them. The jQuery Migrate plugin does _not_ restore the old behavior, which was somewhat random and unpredictable.

### Loading and running scripts inside HTML content

Prior to 1.9, any HTML-accepting method (e.g., $(), .append(), or .wrap()) executed any scripts in the HTML and removed them from the document to prevent them from being executed again. This still broke in situations where a script might be removed and reinserted into the document using methods such as `.wrap()`. As of 1.9, scripts inserted into a document are executed, but left in the document and tagged as already executed so they won't be executed again even if they are removed and reinserted.

Despite this change, it is _very poor practice_ to mix executable JavaScript into HTML markup; it has design, security, reliability, and performance implications. For example, external script tags included in HTML are fetched _synchronously_ and then evaluated, which can take a significant amount of time. There is no interface to notify when or whether those scripts load, or to take corrective actions when there is an error.

Code that attempts to load a script by cloning an existing script tag and injecting that clone into the document will no longer work, because the cloned script tag has already been marked as executed. To load a new script, use `jQuery.getScript()` instead.

### .attr() versus .prop()

jQuery 1.6 introduced the `.prop()` method for setting or getting *properties* on nodes and deprecated the use of `.attr()` to set properties. However, versions up to 1.9 continued to support using `.attr()` for specific situations. This behavior in the name of backwards compatibility causes confusion when selectors are used that distinguish between attributes and properties.

For example, boolean attributes such as `checked` and `disabled` on a checkbox are affected by this change. The correct behavior of `"input[checked]"` is to select checkboxes that have a `checked` attribute, regardless of its string value, and regardless of their current state. In contrast, `"input:checked"` selects checkboxes that are *currently* checked as reflected in their boolean (`true` or `false`) `checked` property, which is affected when the user clicks the box for example. Versions prior to 1.9 sometimes do not select the correct nodes with these selectors.

Here are some examples of correct usage when setting `checked` on a checkbox; the same rules apply for `disabled`. Note that only the _property_ consistently reflects and updates the current state of the checkbox across all browsers; rarely will you need to set the attribute.

```js
// Correct if changing the attribute is desired
$( elem ).attr( "checked", "checked" );
// Correct for checking the checkbox
$( elem ).prop( "checked", true );

// Correct if removing the attribute is desired (rare)
$( elem ).removeAttr( "checked" );
// Correct for clearing the checkbox
$( elem ).prop( "checked", false );
```

The `value` property versus attribute on `input` elements is another example of this ambiguity. The attribute generally reflects the value that was read from the HTML markup; the property reflects the current value. Since the `.val()` method is the recommended jQuery way to get or set the values of form elements, this confusion usually does not affect users.

However, when a selector like `"input[value=abc]"` is used, it should always select by the value _attribute_ and not any change made to the _property_ by the user, for example from them typing into a text input. As of jQuery 1.9, this behaves correctly and consistently. Earlier versions of jQuery would sometimes use the property when they should have used the attribute.

The jQuery Migrate plugin restores the old attribute-vs-property rules.

### $( "input" ).attr( "type", newValue ) in oldIE

Prior to version 1.9, jQuery would throw an exception in all browsers for any attempt to set the `type` attribute on an input or button element. This was done to accommodate the lowest common denominator; IE 6/7/8 throw an error if you attempt to change the type of an input element. As of jQuery 1.9, we allow you to set the type of an element if the browser allows it. However, your own code will need to be aware that attempting to do this on oldIE will still throw an error. The jQuery Migrate plugin warns when you attempt to set the `type` attribute but does not throw a JavaScript error.

### "hover" pseudo-event

As of 1.9, the event name string `"hover"` is no longer supported as a synonym for `"mouseenter mouseleave"`. This allows applications to attach and trigger a custom "hover" event. Changing existing code is a simple find/replace, and the "hover" pseudo-event is also supported in the jQuery Migrate plugin to simplify migration.

### .selector property on jQuery objects

The remaining purpose of the deprecated `.selector` property on a jQuery object is to support the deprecated `.live()` event. In 1.9, jQuery no longer attempts to maintain this property in chained methods, since the use of chained methods was never supported with `.live()`. Do not use the `.selector` property on a jQuery object. The jQuery Migrate plugin does not attempt to maintain this property.

### jQuery.attr()

In 1.9 we have removed the undocumented signature `jQuery.attr( elem, name, value, pass )` using the pass argument. Any code that depended on this should be rewritten, but the jQuery Migrate plugin can provide backward-compatible behavior and will warn if this signature is used.

### jQuery.ajax returning a JSON result of an empty string

Prior to 1.9, an ajax call that expected a return data type of JSON or JSONP would consider a return value of an empty string to be a success case, but return a null to the success handler or promise. As of 1.9, an empty string returned for JSON data is considered to be malformed JSON (because it is); this will now throw an error. Use the error handler to catch such cases.

### jQuery.proxy() context

New in 1.9, the function returned by calling jQuery.proxy with a falsy context will preserve its `this` object for the provided function. Previously, a falsy value for context would get translated into the global object (window) if null/undefined, or else wrapped in an object (e.g., `new Boolean( false )`).

### .data( "events" )

Prior to 1.9, `.data( "events" )` could be used to retrieve jQuery's undocumented internal event data structure for an element if no other code had defined a data element with the name "events". This special case has been removed in 1.9. There is no public interface to retrieve this internal data structure, and it remains undocumented. However, the jQuery Migrate plugin restores this behavior for code that depends upon it.

### Removed properties of the Event object

The `attrChange`, `attrName`, `relatedNode`, and `srcElement` properties of the `Event` object were deprecated in jQuery 1.7 since they are non-standard and not cross-browser; as of jQuery 1.9 they are no longer copied to the `Event` object that is passed to an event handler. On any version of jQuery, these properties can still be accessed on browsers that support them by using `event.originalEvent` instead of `event`.The jQuery Migrate plugin adds back these properties to the `Event` object as well.

### Undocumented arguments of API methods

Prior to 1.9, several API methods had undocumented arguments that changed their behavior and created the potential for accidental misuse or incorrect duck punching. These arguments have now been removed. Affected methods include `jQuery.data()`, `jQuery.removeData()`, and `jQuery.attr()`. The jQuery Migrate plugin does not support these undocumented arguments because the refactored code no longer requires it.

### Other undocumented properties and methods

The following internal properties and methods were never documented and have been removed in 1.9. Any code that depends on them should be rewritten.

* `jQuery.deletedIds`
* `jQuery.uuid`
* `jQuery.attrFn`
* `jQuery.clean()`
* `jQuery.event.handle()`
* `jQuery.offset.bodyOffset()`

