<script>{
	"title": "jQuery Core 4.0 Upgrade Guide",
	"toc": true
}</script>

> [!NOTE]
> jQuery 4.0 is not yet released. This is a draft of the jQuery 4.0 upgrade guide. jQuery 4.0 is currently in development and this guide will be updated as changes are finalized. The jQuery team welcomes feedback on this guide and the changes in jQuery 4.0.

## Overview

With the major version of 4.0, the jQuery Core team has taken the opportunity to make changes to clean up the API and fix bugs that may prove to be breaking changes for some. This includes the removal of previously deprecated public APIs, changes to or removal of undocumented APIs, and changes to the documented or undocumented behavior of existing APIs for specific inputs.

## Browser Support

As of jQuery 4.0, the following browsers are supported:

* Internet Explorer: 11 only
* Chrome, Edge, Firefox, Safari: Current and Current - 1
* Opera: Current
* Safari Mobile iOS: Current, Current - 1, and Current - 2
* Android: Current and Current - 1

### Browsers no longer supported

* Edge: Legacy (non-Chromium) versions
* Internet Explorer: 10 and below
* Safari Mobile iOS: All versions older than Current - 2
* Android: All versions older than Current - 1

Browser support will not change until the next major version of jQuery (5.0).

## jQuery Migrate Plugin

A new version of the [jQuery Migrate Plugin](https://github.com/jquery/jquery-migrate/#README) is available to simplify migration of older code to version 4.0. We strongly recommend that you use this plugin as an upgrading tool, it will give specific advice about most of the major changes that may affect your code.

[Version 4.0 of the jQuery Migrate Plugin](https://github.com/jquery/jquery-migrate/#README) *does not* warn about or restore behaviors that were removed in previous major version changes such as jQuery 1.0, 2.0, or 3.0. Use the following steps to upgrade from a version of jQuery older than 1.11.0 or 2.1.0 to this new version 4.0:

### Start here if currently using jQuery <1.9

1. Upgrade the version of jQuery on the page to the latest 1.x or 2.x version.
1. Add the uncompressed [jQuery Migrate 1.x Plugin](https://github.com/jquery/jquery-migrate/tree/1.x-stable/#README) to the page.
1. (Optional but recommended) Upgrade any plugins in use since later versions are usually the most compatible with recent versions of jQuery.
1. Test the page and resolve any warnings that appear on the console, using the [JQMIGRATE 1.x  warning documentation](https://github.com/jquery/jquery-migrate/tree/1.x-stable/warnings.md) as a guide.
1. Remove the jQuery Migrate 1.x plugin and ensure that the updated jQuery code on the page continues to work properly with only the latest jQuery 1.x/2.x in use.

### Start here if currently using jQuery >=1.9

1. Upgrade the version of jQuery on the page to the latest 4.x version.
1. Add the uncompressed [jQuery Migrate 3.6.0 plugin](https://github.com/jquery/jquery-migrate/#README) to the page. jQuery Migrate 4.x will also work with the caveat that it will only support the same browsers as jQuery 4.x, but it is not yet released.
1. (Optional but recommended) Upgrade any plugins in use since later versions are usually the most compatible with recent versions of jQuery.
1. Test the page and resolve any warnings that appear on the console, using the [JQMIGRATE 4.x warning documentation](https://github.com/jquery/jquery-migrate/blob/master/warnings.md) as a guide. Report any bugs in third-party plugins to the plugin authors.

**Note:** Once jQuery 4.x is released, the jQuery Migrate 3.x plugin will be in maintenance mode and will only receive updates for critical bugs. This guide will be updated to reflect that change.

**Running multiple version of jQuery Migrate simultaneously is not supported.**

The uncompressed development version of the Migrate plugin includes console log output to warn when specific deprecated and/or removed features are being used. This makes it valuable as a migration debugging tool for finding and remediating issues in existing jQuery code and plugins.

The compressed version of the Migrate plugin does not generate any warnings, although it does issue a solitary console message that it has been included on the page. Migrate can be used on production sites when jQuery 3.0 or higher is desired but older incompatible jQuery code or plugins must also be used. Ideally this is only used as a short-term solution, since restoring old behavior may cause conflicts with new jQuery code that expects the new behavior.

## Summary of Important Changes

With a library as widely used as jQuery, it is often difficult for the team to know which changes may impact developers the most before a release occurs. Despite the length of this list, we believe that the majority are edge cases. Many jQuery projects should be able to run version 4.0 with only minor changes, if any.

Changes are listed by their component category, and prefixed with a description to help you understand its impact:

* **Breaking change:** This change *may* affect existing code, since it changes the API surface in some way. Most of the time the impacts are only for specific edge cases as noted.
* **Feature:** The change is an API addition and should not affect existing code in most cases. However, there is the possibility that new features can interact negatively with existing code.
* **Deprecated:** This feature or API is still present in jQuery 3.0, but its use is discouraged. It may be removed in a future major-version update.

Remember that the jQuery Migrate plugin described above can detect and warn about many of these changes so that they can be fixed in your code.

For a complete and detailed list of all code changes, see the 3.0 milestone in the [jQuery Core issue tracker](https://github.com/jquery/jquery/issues?q=is%3Aissue+milestone%3A4.0.0) or the [version diff](https://github.com/jquery/jquery/compare/3.7.1...4.0.0).

### Ajax

#### Breaking change: JSON to JSONP auto-promotion removed

Previously, `jQuery.ajax` with `dataType: "json"` with a provided callback was automatically converted to a JSONP request unless one also specified `jsonp: false`. Today, the preferred way of interacting with a cross-domain backend is CORS, which works in all browsers jQuery 4 supports.

Auto-promoting JSON requests to JSONP introduced a security issue. The developer may be unaware they are executing code from a remote domain. The auto-promoting logic has been disabled.

To trigger a JSONP request, it's now required to specify `dataType: "jsonp"`.

#### Breaking change: Scripts are no longer auto-executed without `dataType: "script"`

jQuery 3.0.0 had already stopped auto-executing scripts retrieved with `jQuery.ajax` unless `dataType: "script"` was explicitly set for cross-domain scripts. That change has now been extended to same-domain scripts.

To fetch *and* evaluate a script, pass `dataType: "script"` in `jQuery.ajax` options or use `jQuery.getScript`.

#### Breaking change: Script tags now used for all async requests

Until jQuery 4.0, the AJAX script transport only used a script tag to load scripts for cross-domain requests or ones with `scriptAttrs` set. We now always use a script tag for async requests to avoid any [Content Security Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP) errors.

This change may affect existing code if certain scripts were expected to execute even when CSP headers were set. Either modify the CSP header to allow scripts from the same domain or remove the scripts.

#### Potentially breaking change: `jQuery.ajax` now supports binary data

jQuery 4.0 adds support for binary data in `jQuery.ajax` requests by adding support for `FormData` objects passed to the `data` argument. This change may affect existing code that relies on the previous behavior of `jQuery.ajax` when passing non-serializable data types, especially code that relies on the order of the execution of Ajax prefilters. Before, data was converted to a string before prefilters could be applied. Still, we don't expect this change to affect most users.

### Attributes

#### Breaking change: `toggleClass( Boolean | undefined )` signature removed

This particular signature was deprecated in jQuery 3.0 and is now being removed in jQuery 4.0. After feedback and discussion with the community, it was determined that this signature caused unexpected behavior. For instance, if the argument to `toggleClass` was a variable that turned out to be `undefined` or `false`, it would result in all classes being removed. Also, while the `toggleClass( boolean )` signature was documented (and has been marked deprecated since 3.0), the `toggleClass( undefined )` signature was not.

The recommendation for migration is to be explicit about which classes should be toggled.

### Core

#### Breaking change: Deprecated APIs removed

The following APIs were deprecated in previous versions and have been removed in jQuery 4.0:

* `jQuery.camelCase`
	This function was never documented and was only used internally. It was deprecated in jQuery 3.0.

* `jQuery.cssProps`
	This object was used to map CSS properties to their vendor-prefixed versions, which is no longer necessary in jQuery 4.0's supported browsers.

* `jQuery.isArray`
	Use Array.isArray.

* `jQuery.isFunction`
	Use typeof value === "function".

* `jQuery.isNumeric`
	Use Number.isFinite or a custom implementation.

* `jQuery.isWindow`
	Window detection is generally unreliable and discouraged. If absolutely necessary, use `obj != null && obj === obj.window`.

* `jQuery.fx.interval`
	The default value was 13 (milliseconds), but has been removed as it does not work well with `requestAnimationFrame`. It should no longer be necessary.

* `jQuery.nodeName`
	Use `element.nodeName.toLowerCase()`.

* `jQuery.now`
	Use `Date.now()`.

* `jQuery.parseJSON`
	Use JSON.parse.

* `jQuery.trim`
	Use String.prototype.trim.

* `jQuery.type`
	Use `typeof` for primitive types, `Array.isArray` for arrays, and `instanceof` for objects. Or, use `Object.prototype.toString.call(value)`.

* `jQuery.unique`
  Use `jQuery.uniqueSort`.

#### Breaking change: Remove undocumented Array methods

jQuery 4.0 removes `push`, `sort`, and `splice` from the jQuery prototype. These methods were copies of the methods of the same names on the native Array prototype, but were never documented and were not intended for public use. Some plugins may have used them, so we are still marking this as a breaking change.

#### Slim build breaking change: Remove `callbacks`, `deferred`, and `queue` modules

The slim build of jQuery 4.0 no longer includes the `callbacks`, `deferred`, and `queue` modules. Use the full build if you need these modules, or use native Promise objects.

#### Breaking change: Remove undocumented `root` parameter of `jQuery.fn.init()`

`root` was the third parameter of `jQuery.fn.init()`, but was never documented and was only used internally. Also, it has not been necessary since jQuery 1.9 when `jQuery.sub()` was removed.

#### Important fix: Add `exports` to package.json

jQuery exports multiple builds that can be used in different environments. This includes the default build as both a universal module (UMD) and an ESM module, the slim build in UMD and ESM, and a factory build for running jQuery with DOM emulators like JSDOM. The `exports` field in `package.json` is used to specify which build is used in different environments. This change should not affect existing code in most cases, but it is an important fix to ensure that jQuery can be used in a wider range of environments.

#### Potentially breaking change: jQuery's source is no longer written using AMD modules

jQuery's source code has been converted to use ES modules instead of AMD modules. While this has several advantages, some users may have been importing jQuery's source directly using AMD loaders such as RequireJS. This change may affect those users, but it is expected that most users will be able to continue using jQuery without any issues. The main jQuery file is still built as a UMD module, so it can be used in both AMD and non-AMD environments.

### CSS

#### Breaking change: `px` no longer automatically added to most unitless values

jQuery 4.0 switches strategies when it comes to setting CSS properties that require units. Previously, jQuery would automatically add `px` to unitless values, with some exceptions. This behavior has been removed in jQuery 4.0.

Instead, jQuery will now only add `px` to a limited set of properties that are known to require it. This change may affect existing code that relies on the old behavior.

#### Breaking change: Remove opacity CSS hook

`.css( "opacity" )` will now return an empty string for detached elements in standard-compliant browsers and "1" in IE. That behavior is shared by most other CSS properties, but may affect existing code relying on a return value of "1".

### Data

#### Important fix: `Object.prototype` pollution

jQuery 4.0 includes a fix to ensure event and data keys matching `Object.prototype` properties are supported without overriding the native properties. This may affect code calling `hasOwnProperty` on the data object, which should be rare.

Switch from:

```js
if ( elem.data().hasOwnProperty( "key" ) ) { /* ... */ }
```

to:

```js
if ( "key" in elem.data() ) { /* ... */ }
if ( Object.hasOwn( elem.data(), "key" ) ) { /* ... */ }
```

### Deferred

#### Breaking change: Removed `jQuery.Deferred.getStackHook`

[`jQuery.Deferred.getStackHook`](https://api.jquery.com/jQuery.Deferred.getStackHook/) was renamed to [`jQuery.Deferred.getErrorHook`](https://api.jquery.com/jQuery.Deferred.getErrorHook/) in 3.7.0. It is used to pass the original error to [`jQuery.Deferred.exceptionHook`](https://api.jquery.com/jQuery.Deferred.exceptionHook/). Previously, we recommended passing the stack but that didn't play well with source maps. `jQuery.Deferred.exceptionHook` can be used to debug asynchronous errors.

### Event

#### Breaking change: Stop shimming focusin & focusout events

jQuery 4.0 no longer shims the `focusin` and `focusout` events. This only affects code that relies on the order of these events as they relate to `focus` and `blur`. This change is expected to affect very few users. Mostly, the order can be different in IE in that `blur` can come before `focousout` and `focus` before `focusin`. See [#4362](https://github.com/jquery/jquery/pull/4362) for details.

#### Breaking change: `jQuery.event.special` no longer inherits from `Object.prototype`

This may affect code calling `hasOwnProperty` on `jQuery.event.special`, which should be rare.

### Manipulation

#### Important feature: Add support for Trusted Types

jQuery 4.0 adds support for [Trusted Types](https://developer.mozilla.org/en-US/docs/Web/API/Trusted_Types_API) for all manipulation methods. This change is not expected to affect existing code, but it is an important feature for security.

#### Potentially breaking change: Avoid concatenating strings in buildFragment

This change was needed in order to add support for [Trusted Types](https://developer.mozilla.org/en-US/docs/Web/API/Trusted_Types_API). It's not entirely clear what real use cases might be affected by this change, but we're listing it here just in case.

#### Important fix: Don't remove HTML comments and `CDATA` sections from scripts

Browsers can now handle these without jQuery's help. This change is not expected to affect existing code, but is an important fix because jQuery's logic removing them was not correct in 100% of cases.

### Selector

#### Important fix: Backport jQuery selection context logic to selector-native

jQuery has long had a minimal selector engine that could be used in place of Sizzle. This engine was missing some logic that Sizzle had for handling the context of a selection. This change backports that logic to the native selector engine, which may affect code that relied on the old behavior. For example, `$div.find( "> *" )` will no longer throw an error when using the native selector engine. Also, given the following HTML:

```html
<div id="parent">
	<span></span>
</div>
```

The following returns 0 results in jQuery 4.0:

```js
const $div = $( "#parent" );
$div.find( "div span" );
```

This is generally the expected behavior.

#### Breaking change: Drop support for legacy custom pseudos

References in Sizzle wiki: https://github.com/jquery/sizzle/wiki#-backwards-compatible-plugins-for-pseudos-with-arguments
