/*
 lastmod: 2019-12

 Conncerning Javascript code:
 - This code is part of the "A1 Website Search Engine" program and therefore the same copyright and license.
 - You ARE allowed to use, edit, upload and distribute this ONLY WHEN used as part of an "A1 Website Search Engine" created search solution.
 - Please do not remove this comment.
*/
//--
function MSA1S__Compare_Generic(a, b) {
  if (a < b)
    return -1;
  else if (a > b)
    return 1;
  else return 0;
}
//--
function MSA1S__Compare_LookupArray(a, b) {
  //--
  // the PHP/AJAX solution can in principle return sparse arrays where most elements are undefined
  //--
  if ((a == undefined) && (b == undefined)) {
    return 0;
  }
  else
  if (a == undefined) {
    // a < b
    return -1; 
  }
  else
  if (b == undefined) {
    // a > b
    return 1; 
  }
  else {
    return MSA1S__Compare_Generic(a.W,b.W);
  }
}
//--
var ga1__wrp = "<!-- %A1WSE_DOMAIN_ROOT% -->";
var ga1__ic = false;
var L = [];
var W1 = [];
var W2 = [];
var W3 = [];
var ga1__opt_dld = "none";
var ga1__path_d = "";
var ga1__path_f = "";
var ga1__phrase_current = "";
//--
function MSA1S_Lookup_Sorted_InIndex(a__lookup_array,a__lookup_str_lc) {
  //--
  var IL, IH, R, IM, RV, OIM;
  //--
  IL = 0;
  IH = a__lookup_array.length - 1;

  //s = "MSA1S_Lookup_InIndex: " + a__lookup_array.length + " :::: "; for (us_itr = 0; us_itr < a__lookup_array.length; us_itr++) { OIM = a__lookup_array[us_itr]; if (OIM != undefined) { s += " iter: " + us_itr + " --- " + OIM.W; }}alert(s);

  R = -1;
  while (IL <= IH) {
    IM = Math.floor((IL + IH) / 2)
    OIM = a__lookup_array[IM];
    if (OIM == undefined){
      RV = -1;      
      //alert("MSA1S_Lookup_InIndex: OIM was undefined, thus: RV = -1 / "invalid". However: "php_defer" moves search-index up to front);            
      if (IM != 0) {      
        IH = IM - 1;
        //alert("smaller - IH=" + IH);
        continue;
      }
      else {
        break;
      }
    }
    else {
      RV = MSA1S__Compare_Generic(OIM.W,a__lookup_str_lc);
      //alert("MSA1S_Lookup_InIndex: OIM.W=" + OIM.W + " and a__lookup_str_lc=" + a__lookup_str_lc + ", this: RV=" + RV);
    }
    if (RV < 0) {
      // center is smaller than searched
      IL = IM + 1;
      //alert("greater - IL=" + IL);
      continue;
    }
    else
    if (RV > 0) {
      // center is greater than searched
      IH = IM - 1;
      //alert("smaller - IH=" + IH);
      continue;
    }
    else {
      R = IM;
      break;
    }

  }
  return R
}
//--
function MSA1S_Lookup_Mixed_InIndex(a__lookup_array,a__lookup_str_lc) {
  var R_Itr;
  //--
  R = -1;
  //--
  for (R_Itr = 0; R_Itr < a__lookup_array.length; R_Itr++) {
    if (a__lookup_str_lc == a__lookup_array[R_Itr]) {
      R = R_Itr;
      break;
    }
  }
  //alert("MSA1S_Lookup_Mixed_InIndex=" + R);
  return R;
}
//--
function MSA1S_Lookup_UpdateScoresData_PhraseSpecific(a__uri_scores_arr, a__word_uris, a__search_phrase_lc, a__search_phrase_word_count, a__weight_modifier) {
  //--
  var R_Itr, R_Item, R_U_S_Item,
  add_score_content,
  add_score_anchors,
  found, found_idx;
  var idxof_str, idxof_pos, idxof_left;
  var old_score;
  //--
  //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific:1:" + a__word_uris.length);
  for (R_Itr = 0; R_Itr < a__word_uris.length; R_Itr++) {
    R_Item = a__word_uris[R_Itr];
    //--
    // a) 3-word-phrase-match also scores on 1-word and 2-word matches.
    // b) multi-word-phrases has heigher % weight in content thus have higher scores.
    // Conclusion: We need to reduce how much we *add* to score
    //--
    if (R_Item.hasOwnProperty('S')) {    
      add_score_content = R_Item.S;
    }
    else {
      add_score_content = 0;    
    }
    if (R_Item.hasOwnProperty('A')) {    
      add_score_anchors = R_Item.A;
    }
    else {
      add_score_anchors = 0;    
    }                    
    //--
    if (a__search_phrase_word_count > 1) {
      //alert(a__search_phrase_lc + ' scoring: ' + add_score + ' divided by ' + a__search_phrase_word_count + ' equals= ' + add_score / (a__search_phrase_word_count * a__search_phrase_word_count));
      //add_score /= (a__search_phrase_word_count * a__search_phrase_word_count);
    }
    //--
    //  a__weight_modifier could e.g. have been set like this:
    //  - add_score += add_score * L[R_Item.U].I / 10; // relative importance
    //  - add_score += add_score * L[R_Item.U].C / 10; // relative content size
    //--
    add_score_content *= a__weight_modifier;
    add_score_anchors *= a__weight_modifier;
    //--
    //
    //--
    R_U_S_Item = null;
    found = false;
    //--
    if (found == false) {
      if (a__uri_scores_arr != null) {
        for (us_itr = 0; us_itr < a__uri_scores_arr.length; us_itr++) {
          if (a__uri_scores_arr[us_itr].U == R_Item.U) {
            found = true;
            found_idx = us_itr;
            //--
            R_U_S_Item = a__uri_scores_arr[found_idx];
            //alert(R_U_S_Item.L.length);
            break;
          }
        }
      }
    }
    if (found == false) {
      found = true;
      a__uri_scores_arr.push( {U:R_Item.U, L:[], S:0, D:""} );
      found_idx = a__uri_scores_arr.length - 1;
      //--
      R_U_S_Item = a__uri_scores_arr[found_idx];
      //alert("score: " + R_U_S_Item.S);
      //alert(R_U_S_Item.L.length);
    }
    //--
    //
    //--
    // We have R_U_S_Item which is part of result set. We then search-edit or search-add phrase score in it.
    //--
    if (R_U_S_Item != null) {
      found = false;
      //--
      if (found == false) {
        for (us_itr = 0; us_itr < R_U_S_Item.L.length; us_itr++) {
          idxof_str = R_U_S_Item.L[us_itr];
          idxof_pos = idxof_str.indexOf("=");
          idxof_left = idxof_str.substr(0, idxof_pos);
          if (idxof_left == a__search_phrase_lc) {
            // we only keep the highest score detected for each URI/word combo (since due to the way alternative/extra/related are calculated, a word can appear twice)
            idxof_right = idxof_str.substr(idxof_pos + 1);
            idxof_pos = idxof_right.indexOf("|");
            if (idxof_pos < 0) {
              //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific:2a:");
            }
            else {
              idxof_str = idxof_right;
              // content
              idxof_right = idxof_str.substr(0, idxof_pos);
              old_score = parseFloat(idxof_right);
              add_score_content = Math.max(add_score_content, old_score);
              // anchor
              idxof_right = idxof_str.substr(idxof_pos + 1);
              old_score = parseFloat(idxof_right);
              add_score_anchors = Math.max(add_score_anchors, old_score);
            }
            //--
            R_U_S_Item.L[us_itr] = idxof_left + '=' + add_score_content + '|' + add_score_anchors;
            //--
            found = true;
            break;
          }
        }
      }
      if (found == false) {
        R_U_S_Item.L.push(a__search_phrase_lc + "=" + add_score_content + '|' + add_score_anchors);
        R_U_S_Item.S += add_score_content;
      }
    }
    //--
    //
    //--
  }
}
//--
function MSA1S_Lookup_UpdateScoresData_URIsSpecific(a__uri_scores_arr) {
  //--
  var add_score, idx, item;
  var c, s, i;
  var j;
  var idxof_str, idxof_pos, idxof_left;
  //--
  if (a__uri_scores_arr != null) {
    //alert(L.length + " ---- " + a__uri_scores_arr.length + "---- 1");
    for (us_itr = 0; us_itr < a__uri_scores_arr.length; us_itr++) {
      //--
      idx = a__uri_scores_arr[us_itr].U;
      item = L[idx];
      if (item == undefined) {
        //alert(idx + "e1");
      }
      if (item["I"] == undefined) {
        //alert(idx + "e2");
      }
      if ( (item["P"] == undefined) && (ga1__opt_dld != "php_defer") ) {
        // NOTE: as *php_defer* only loads a subset of URI data on initial AJAX data transfer, *P* (path) is not available
        //alert(idx + "e3");
      }
      //--
      // add all words scores. (Content + Anchors) Example: "phrase=22.10|25.69"
      //--
      for (j = 0; j < a__uri_scores_arr[us_itr].L.length; j++) {
        idxof_str = a__uri_scores_arr[us_itr].L[j];
        idxof_pos = idxof_str.indexOf("=");
        if (idxof_pos > 0) {
          idxof_left = idxof_str.substr(0, idxof_pos); // phrase
          idxof_right = idxof_str.substr(idxof_pos + 1); // (content)xy.zz|(anchors)xy.zz
          //--
          idxof_pos = idxof_right.indexOf("|");
          if (idxof_pos < 0) {
            //alert("MSA1S_Lookup_UpdateScoresData_URIsSpecific");
          }
          else {
			//--
			// We increase the score value of a word/phrase the longer the content (wcs) / the more he anchor text (ilv) since e.g. 10% of 1000 words is more "significant" than 10% of 10 words
			//--
			// in "1+10-6.08_wcs" wcs can max be 10 meaning we always divide with minimum = 1			  
			//--
			// old: idxof_tmp2 = (idxof_tmp / (1 + 10 - item.C)) + (idxof_tmp / 2);
			// old: a__uri_scores_arr[us_itr].D += "content:" + idxof_left + "=" + idxof_tmp2.toFixed(2) + " [ (" + idxof_tmp.toFixed(2) + "/(1+10-" + item.C + "_wcs)) + (" + idxof_tmp.toFixed(2) + "_wcs) / 2) ]" + ", ";
			// old: example: content:sitemap=12.77 [ (18.16/(1+10-6.08_wcs)) + (18.16/2) ]
        	//--		  
            idxof_str = idxof_right;
            //--
            // content
			//--
            idxof_right = idxof_str.substr(0, idxof_pos);
            idxof_tmp = parseFloat(idxof_right);
            if (idxof_tmp > 0) {
              idxof_tmp2 = (idxof_tmp / (1 + 10 - item.C)) * (item.C / 2);     		  
              a__uri_scores_arr[us_itr].S += idxof_tmp2;			  
			  a__uri_scores_arr[us_itr].D += "content:" + idxof_left + "=" + idxof_tmp2.toFixed(2) + " [ (" + idxof_tmp.toFixed(2) + "/(1+10-" + item.C + "_wcs)) * (" + item.C + "_wcs) / 2.5)" + "]" + ", ";
            }
            //--
			// anchor
			//--
            idxof_right = idxof_str.substr(idxof_pos + 1);
            idxof_tmp = parseFloat(idxof_right);
            if (idxof_tmp > 0) {
              idxof_tmp2 = (idxof_tmp / (1 + 10 - item.I)) * (item.I / 2);
              a__uri_scores_arr[us_itr].S += idxof_tmp2;
              a__uri_scores_arr[us_itr].D += "anchors:" + idxof_left + "=" + idxof_tmp2.toFixed(2) + " [ (" + idxof_tmp.toFixed(2) + "/(1+10-" + item.I + "_ilv)) * (" + item.I + "_ilv) / 2.5)" + "]" + ", ";
            }
          }
        }
        else {
          //alert("odd:" + idxof_str);
        }
      }

      //--
      // relative importance
      //--
      if (true) {
        add_score = item.I;
        a__uri_scores_arr[us_itr].S += add_score;
        a__uri_scores_arr[us_itr].D += "*internal_link_value*=" + add_score.toFixed(2);
        //--
        //
        //--
        a__uri_scores_arr[us_itr].D += ", ";
      }

      //--
      // relative content size
      //--
      if (item.C != null) {
        add_score = item.C;
        a__uri_scores_arr[us_itr].S += add_score;
        a__uri_scores_arr[us_itr].D += "*word_content_size*=" + add_score.toFixed(2);
        //--
        //
        //--
        a__uri_scores_arr[us_itr].D += ", ";
      }

      //--
      // relative click distance
      //--
      if (item.N != null) {
        add_score = item.N;
        add_score = 2 / (add_score+1);
        a__uri_scores_arr[us_itr].S += add_score;
        a__uri_scores_arr[us_itr].D += "*root_close_clicks*=" + add_score.toFixed(2);
        //--
        //
        //--
        a__uri_scores_arr[us_itr].D += ", ";
      }

      //--
      // URL directory count
      //--
      if (item.P != null) {
        if (item.P != null) {
          s = item.P;
        }
        else {
          s = "";
        }
        l = s.length;
        c = 0;
        for (i = 0; i < l; i++) {
          if ( (s[i] == '/') || (s[i] == '\\') ) {
            c++;
          }
        }
        c++;
        add_score = (1 / c);
        a__uri_scores_arr[us_itr].S += add_score;
        a__uri_scores_arr[us_itr].D += "*root_close_dirs*=" + add_score.toFixed(2);
        //--
        //
        //--
        a__uri_scores_arr[us_itr].D += ", ";
      }

      //--
      // URL character count
      //--
      if (item.P != null) {
        if (item.P != null) {
          c = item.P.length;
        }
        else {
          c = 0;
        }
        c++;
        add_score = (2 / c);
        a__uri_scores_arr[us_itr].S += add_score;
        a__uri_scores_arr[us_itr].D += "*root_close_chars*=" + add_score.toFixed(2);
        //--
        //
        //--
        a__uri_scores_arr[us_itr].D += ", ";
      }

      //--
      // finals
      //--
      add_score = a__uri_scores_arr[us_itr].S;
      a__uri_scores_arr[us_itr].D = add_score.toFixed(2) + ' based on: ' + a__uri_scores_arr[us_itr].D;
    }
    //alert(L.length + " ---- " + a__uri_scores_arr.length + "---- 2");
  }
}
//--
// remove those in "a__lookups_done" from "lookups_want_groups"
//--
cleaner_groups = function(a__lookups_done, a__lookups_want_groups) {
  var i, j, s, so;
  //alert("sub_cleaner_groups-start: donelen=" + a__lookups_done.length + ", wantlen=" + a__lookups_want_groups.length);
  for (i = 0; i < a__lookups_done.length; i++) {
    s = a__lookups_done[i];
    //alert("sub_cleaner-groups-value-in-done: " + s + " (" + i + ")");
    for (j = a__lookups_want_groups.length-1; j > -1; j--) {
      so = a__lookups_want_groups[j];
      //alert("sub_cleaner-groups-value-in-want: " + so + " (" + j + ")");
      if (s == so) {
        a__lookups_want_groups.splice(j, 1);
        //alert("sub_cleaner-groups-del-as-in-done: " + so);
      }
    }
  }
  //alert("sub_cleaner_groups-end: donelen=" + a__lookups_done.length + ", wantlen=" + a__lookups_want_groups.length);
}
//--
// remove those in "a__lookups_done" from "lookups_want_pairs"
//--
cleaner_pairs = function(a__lookups_done, a__lookups_want_pairs) {
  var i, j, s, so;
  //alert("sub_cleaner_pairs-start: donelen=" + a__lookups_done.length + ", wantlen=" + a__lookups_want_pairs.length);
  for (i = 0; i < a__lookups_done.length; i++) {
    s = a__lookups_done[i];
    //alert("sub_cleaner-pairs-value-in-done: " + s + " (" + i + ")");
    for (j = a__lookups_want_pairs.length-1; j > -1; j--) {
      so = a__lookups_want_pairs[j];
      //alert("sub_cleaner-pairs-value-in-want: " + so + " (" + j + ")");
      if (s == so) {
        a__lookups_want_pairs.splice(j, 1);
        //alert("sub_cleaner-pairs-del-as-in-done: " + so);
      }
    }
  }
  //alert("sub_cleaner_pairs-end: donelen=" + a__lookups_done.length + ", wantlen=" + a__lookups_want_pairs.length);
}
//--
//
//--
function MSA1S_Lookup_UpdateScoresData_PhrasesArray(a__uri_scores, a__related_close, a__lookups_done, a__add_groups, a__add_pairs, a__search_phrase_arr, a__weight_modifier) {
  //--
  var lookups_want_groups, lookups_want_pairs, search_phrase_lc, search_phrase_word_arr, search_phrase_word_count, lookup_arr, r, word_uris, gs, ge, gsw, gew, i, j, o, so, s, diff;
  //--
  if ( (a__search_phrase_arr == undefined) || (a__search_phrase_arr.length < 1) ) {
    //alert('search array empty');
    return;
  }
  //--
  // Calculate which lookup index based on words-in-each-phrase in *a__search_phrase_arr*.
  // This function can be called for 1-word-in-each-phrase, 2-word-in-each-phrase etc. for combined scores.
  //--
  // Notice we can call our functions recursively if we find additional words
  // Since we share "a__lookups_done", we can avoid endless calls
  //--
  lookups_want_groups = [];
  lookups_want_pairs = [];
  search_phrase_lc = a__search_phrase_arr[0];
  search_phrase_word_arr = search_phrase_lc.split(" ");
  search_phrase_word_count = search_phrase_word_arr.length;
  lookup_arr = window["W" + search_phrase_word_count];
  //alert(search_phrase_lc + '--' + search_phrase_word_count + '--' + lookup_arr.length);
  if (lookup_arr == undefined) {
    //alert('no such lookup arr');
    return;
  }
  if (lookup_arr.length > 0) {
    // NOTE: If using "php_defer" only a subset of search index is loaded - and it is all sorted and moved to front
    if (lookup_arr[0] == undefined) {  
      //alert('item 0 undefined in lookup arr');
      return;
    }  
    else {
      //alert(lookup_arr[0].W);
    }
  }    
  //--
  //alert(""); s = ""; for (i = 0; i < a__lookups_done.length; i++) { s += "__" + a__lookups_done[i]; } alert("BEGIN CALL: done contain: " + s);
  //--
  // find all related words
  //--
  for (i = 0; i < a__search_phrase_arr.length; i++) {
    search_phrase_lc = a__search_phrase_arr[i];
    //--
    if (search_phrase_lc == "") {
      continue;
    }
    //--
    // suppose "org:game", "group:gameplay", "pair:game play". Then, after "game" already has been done (!), *MSA1S_Lookup_GetScoresData* will call this with "game" as well (from "game play")
    //--
    //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: step1: " + search_phrase_lc);
    so = "";
    for (j = 0; j < a__lookups_done.length; j++) {
      s = a__lookups_done[j];
      if (s == search_phrase_lc) {
        so = search_phrase_lc;
        break;
      }
    }
    //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: step2: " + search_phrase_lc + '-----' + so + '-----W' + search_phrase_word_count);
    if (so == search_phrase_lc) {
      continue;
    }
    //--
    // check if word/phrase exists in our "Wx" lookup array
    //--
    r = MSA1S_Lookup_Sorted_InIndex(lookup_arr,search_phrase_lc);
    //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: stepa3: P:" + search_phrase_lc + '------R:' + r + '-----W:' + search_phrase_word_count);
    if (r < 0) {
      //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: step3b: P:" + search_phrase_lc + '------R:' + r + '-----W:' + search_phrase_word_count + '---W1[0]: ' + lookup_arr[0].W);
      continue;
    }
    //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: step4: " + search_phrase_lc + '------' + r + '-----W' + search_phrase_word_count);
    //--
    //
    //--
    word_uris = lookup_arr[r].M;
    //alert(search_phrase_lc + " has " + lookup_arr[r].M.length);
    MSA1S_Lookup_UpdateScoresData_PhraseSpecific(a__uri_scores, word_uris, search_phrase_lc, search_phrase_word_count, a__weight_modifier);
    //alert("MSA1S_Lookup_UpdateScoresData_PhraseSpecific: done-push-immediate: " + search_phrase_lc);
    a__lookups_done.push(search_phrase_lc);
    //--
    // find related "pair" words ("sitemap" and "site map")
    //--
    if (a__add_pairs) {
      o = lookup_arr[r];
      if (o.hasOwnProperty('P')) {
        so = o.P;
        lookups_want_pairs.push(so);
        //alert("pairs-add: Org: " + search_phrase_lc + " New: " + so);
      }
    }
    //--
    // add related "group" words to "lookups_want_groups"
    //--
    if (a__add_groups) {
      o = lookup_arr[r];
      gs = -1;
      ge = -1;
      if (o.hasOwnProperty('GS')) {
        gsw = o.GS;
        gs = MSA1S_Lookup_Sorted_InIndex(lookup_arr,gsw);
        o = lookup_arr[gs];
        if (o != null) {
          if (o.hasOwnProperty('GE')) {
            gew = o.GE;
            ge = MSA1S_Lookup_Sorted_InIndex(lookup_arr,gew);
          }
        }
        else {
          //alert("missing: " + gsw + " grouped from: " + lookup_arr[r].W);
        }
      }
      else
      if (o.hasOwnProperty('GE')) {
        gs = r;
        gew = o.GE;
        ge = MSA1S_Lookup_Sorted_InIndex(lookup_arr,gew);
      }
      if ( (gs > -1) && (gs < ge) ) {
        for (j = gs; j <= ge; j++) {
          so = lookup_arr[j].W;
          if (so != search_phrase_lc) {
            lookups_want_groups.push(so);
            //alert("groups-add: Org: " + search_phrase_lc + " New: " + so + "-- GS:" + gs + '/' + "GE:" + ge + "/" + "J:" + j);
          }
        }
      }
    }
    //--
    // we store the close related words in a separate list as well
    //--
    if ((a__add_pairs) && (a__add_groups)) {
      a__related_close.push(search_phrase_lc);
      a__related_close.push.apply(a__related_close, lookups_want_groups);
      a__related_close.push.apply(a__related_close, lookups_want_pairs);
    }
    //--
    //
    //--
  }
  //alert("pairs and groups comming: " + search_phrase_lc + ' ::');



  //--
  // do those left in "lookups_want_groups" and add them to "a__lookups_done"
  //--
  // We handle groups first so: sitemap > sitemaps (credited correct score)
  // Otherwise we can have: sitemap > site map > site maps > sitemaps (credited too low score)
  //--
  if ( (a__add_groups) && (lookups_want_groups.length > 0) ) {
    //alert("Test groups comming1:"); s = "Test groups 1:"; for (i = 0; i < lookups_want_groups.length; i++) { s += "__" + lookups_want_groups[i]; } alert("START: groups contain: " + s);
    cleaner_groups(a__lookups_done, lookups_want_groups);
    //alert("Test groups comming2:"); s = "Test groups 2"; for (i = 0; i < lookups_want_groups.length; i++) { s += "__" + lookups_want_groups[i]; } alert("END: groups contain: " + s);
    //--
    while (lookups_want_groups.length > 0) {
      so = lookups_want_groups[0];
      r = MSA1S_Lookup_Sorted_InIndex(lookup_arr,so);
      word_uris = lookup_arr[r].M;
      diff = Math.abs(search_phrase_lc.length - so.length);
      // even if zero length, it may just mean both words are equal distance to root
      diff = Math.max(diff,1);       
      //--
      //  We set the score for *so* since we *know* this is heighest possible score.
      //  Imagine we have: sitemap-group: "sitemapping", "sitemaps" - being at depth: 1 (i.e. "sitemap" was the original searched word)
      //  If we do not force-update score here, "sitemaps" can have set its score at a deep recursive level coming "sitemapping" groups/pairs at depth: 1+x
      //  This is also why we do not call *cleaner_groups* inside loop. We need to make sure we get scores set from here.
      //  This essentinally means that *MSA1S_Lookup_UpdateScoresData_PhraseSpecific* needs to control that only the heighest score set for a word is counted.      
      //--
      //alert("groups-loop-direct: " + so + " diff=" + diff + " weight=" + a__weight_modifier);
      //--
      MSA1S_Lookup_UpdateScoresData_PhraseSpecific(a__uri_scores, word_uris, so, search_phrase_word_count, (0.70 * a__weight_modifier) / diff);
      if (MSA1S_Lookup_Mixed_InIndex(a__lookups_done, so) < 0) {
        //--
        //alert("groups-loop-expansive: " + so + " diff=" + diff + " weight=" + a__weight_modifier);
        //--
        MSA1S_Lookup_GetScoresData(a__uri_scores, a__related_close, a__lookups_done, false, true, so, (0.70 * a__weight_modifier) / diff);
      }
      //--
      lookups_want_groups.shift();
    }
    // alert(""); s = ""; for (i = 0; i < a__lookups_done.length; i++) { s += "__" + a__lookups_done[i]; } alert("IN GROUP LOOP: done contain: " + s);
    //cleaner_groups(a__lookups_done, lookups_want_groups); // Javascript/IE requires we pass these as paramaters...
    // alert(""); s = ""; for (i = 0; i < lookups_want_groups.length; i++) { s += "__" + lookups_want_groups[i]; } alert("IN GROUP LOOP: want contain: " + s);

  }
  //--
  //
  //--


  //--
  // now call recrusively for pairs (safe because we have used "a__lookups_done")
  //--
  if ( (a__add_pairs) && (lookups_want_pairs.length > 0) ) {
    //alert("Test pairs comming1:"); s = "Test pairs 1: "; for (i = 0; i < lookups_want_pairs.length; i++) { s += "__" + lookups_want_pairs[i]; } alert("START: pairs contain: " + s);
    cleaner_pairs(a__lookups_done, lookups_want_pairs);
    //alert("Test pairs comming2:"); s = "Test pairs 2: "; for (i = 0; i < lookups_want_pairs.length; i++) { s += "__" + lookups_want_pairs[i]; } alert("END: pairs contain: " + s);
    //--
    while (lookups_want_pairs.length > 0) {
      so = lookups_want_pairs[0];
      //--
      if (MSA1S_Lookup_Mixed_InIndex(a__lookups_done, so) < 0) {
        //--
        //alert("pairs-loop-expansive: " + so)
        //--
        MSA1S_Lookup_GetScoresData(a__uri_scores, a__related_close, a__lookups_done, true, false, so, 0.70 * a__weight_modifier);
      }
      //--
      lookups_want_pairs.shift();
    }
    //alert("pairs-loop-details-comming:"); s = ""; for (i = 0; i < a__lookups_done.length; i++) { s += "__" + a__lookups_done[i]; } alert("IN PAIR LOOP: done contain: " + s);
    //cleaner_pairs(a__lookups_done, lookups_want_pairs); // Javascript/IE requires we pass these as paramaters...
    //alert(""); s = ""; for (i = 0; i < lookups_want_pairs.length; i++) { s += "__" + lookups_pairs_groups[i]; } alert("IN PAIR LOOP: want contain: " + s);
  }
  //--
  //
  //--


}
//--
function MSA1S_Lookup_GetScoresData(a__uri_scores, a__related_close, a__lookups_done, a__add_groups, a__add_pairs, a__search_phrase, a__weight_modifier) {
  //--
  var search_phrase_arr__1, search_phrase_arr__2, search_phrase_arr__3, i;
  //alert("MSA1S_Lookup_GetScoresData: " + a__search_phrase);

  //--
  // split each phrases into sub-phrases of each one-word
  //--
  search_phrase_arr__1 = a__search_phrase.split(" ");
  MSA1S_Lookup_UpdateScoresData_PhrasesArray(a__uri_scores, a__related_close, a__lookups_done, a__add_groups, a__add_pairs, search_phrase_arr__1, 1.00 * a__weight_modifier);

  //--
  // two-word
  //--
  search_phrase_arr__2 = [];
  for (i = 0; i < search_phrase_arr__1.length - 1; i++ ) {
    search_phrase_arr__2.push(search_phrase_arr__1[i] + " " + search_phrase_arr__1[i+1]);
    //alert('2' + search_phrase_arr__2[search_phrase_arr__2.length-1]);
  }
  MSA1S_Lookup_UpdateScoresData_PhrasesArray(a__uri_scores, a__related_close, a__lookups_done, a__add_groups, a__add_pairs, search_phrase_arr__2, 0.60 * a__weight_modifier);

  //--
  // three-word
  //--
  search_phrase_arr__3 = [];
  for (i = 0; i < search_phrase_arr__1.length - 2; i++ ) {
    search_phrase_arr__3.push(search_phrase_arr__1[i] + " " + search_phrase_arr__1[i+1] + " " + search_phrase_arr__1[i+2]);
    //alert('3' + search_phrase_arr__3[search_phrase_arr__3.length-1]);
  }
  MSA1S_Lookup_UpdateScoresData_PhrasesArray(a__uri_scores, a__related_close, a__lookups_done, a__add_groups, a__add_pairs, search_phrase_arr__3, 0.40 * a__weight_modifier);
}
//--
function MSA1S_Lookup_GetResultsHTML(a__uri_scores, a__related_close, a__lookups_done, a__search_start, a__search_count, a__score_include, a__desc_include, a__tag_list) {
  //--
  var r, i, j, s, uri_score_str, uri_arr_idx, uri_ref, uri_title, uri_desc, uri_path_rela, uri_path_shown, ldl, re, my_path;
  //--
  r = "";
  //alert("getresultshtml: " + a__uri_scores.length);
  //--
  if ( (a__uri_scores != null) && (a__uri_scores.length > 0) ) {
    a__uri_scores.sort(
      function(a,b) {
        if (a.S < b.S)
          return 1;
        else if (a.S > b.S)
          return -1;
        else
          return 0;
      }
    );
    a__search_count = Math.min(a__uri_scores.length, a__search_count);
    a__uri_scores = a__uri_scores.slice(a__search_start, a__search_start + a__search_count);
    //--
    if (ga1__opt_dld == "php_defer") {
      s = "";
      for (i = 0; i < a__uri_scores.length; i++ ) {
        if (i == 0)
          s += a__uri_scores[i].U;
        else
          s += "," + a__uri_scores[i].U;
      }
      my_path = ga1__path_d;
      my_path += "msa1-search-code.php?<!-- %A1WSE_GET_SEARCH% -->_ud=";
      my_path += s;
      my_path += "&<!-- %A1WSE_GET_SEARCH% -->_f=jsraw";
      //--
      request = new XMLHttpRequest();
      request.open("GET", my_path, false);
      request.send(null);

      //alert(my_path + "==========" + request.responseText);

      my_script_data = document.getElementById("id_msa1s_search__php_defer__details");
      if (my_script_data != undefined) {
        s = my_script_data.parentNode.removeChild(my_script_data);
        //alert(s.id);
      }
      my_script_data = document.createElement("script");
      my_script_data.type = "text/javascript";
      my_script_data.setAttribute("id", "id_msa1s_search__php_defer__details");
      if ("textContent" in my_script_data) {
        my_script_data.textContent = request.responseText;
        //alert("GetResultsHTML:textContent");
        // my_script_data.innerHTML = request.responseText;
      }
      else
      if (true) {
        my_script_data.text = request.responseText;
        //alert("GetResultsHTML:text");
      }
      to = document.head || document.getElementsByTagName("head")[0] || document.documentElement;
      if (to != undefined) {
        to.appendChild(my_script_data);
        //alert("details:new");
      }
    }
    //--
    //
    //--
    r += '<'; 
	r += a__tag_list;
	if (a__tag_list == 'ol') {
	  if (a__search_start > 0) {
        r += ' ';
        r += 'start="' + (a__search_start+1) + '"';
	  }
	}
    r += ' ';
    r += 'class="msa1s_list"';
	r += '>';
    //--
    s = "(.*?)\\.[a-z0-9]+($|#|\\?)";
    var re_uri_title_ext = new RegExp(s,'i'); 
    s = "(=|&|\\?)";
    var re_uri_title_chars = new RegExp(s,'');     
    //--
    for (i = 0; i < a__uri_scores.length; i++) {
      uri_score_str = a__uri_scores[i].D;
      uri_arr_idx = a__uri_scores[i].U;
      uri_ref = L[uri_arr_idx];
      //--
      uri_path_rela = uri_ref.P;
      //--
      uri_title = "";
      if ( (uri_title == "") && (uri_ref.hasOwnProperty('T')) ) {
        uri_title = uri_ref.T;
      }  
      if ( (uri_title == "") ) {        
        uri_title = uri_path_rela;
        uri_title = decodeURI(uri_title);
        uri_title = uri_title.replace(re_uri_title_ext, "$1 ");        
        uri_title = uri_title.replace(re_uri_title_chars, " ");
      }  
      //--
      uri_path_shown = ga1__wrp + uri_path_rela;
      //--
      uri_desc = "";
      if ( (uri_desc == "") && (uri_ref.hasOwnProperty('D')) ) {
        uri_desc = uri_ref.D;
      }
      if (uri_desc == "") {	  
	    tmp_arr = [];
		lookup_arr = window["W1"];
        if (lookup_arr != undefined) {          
          for (lookup_Itr = 0; lookup_Itr < lookup_arr.length; lookup_Itr++) {    
            uris_arr = lookup_arr[lookup_Itr].M;  			
            for (uris_Itr = 0; uris_Itr < uris_arr.length; uris_Itr++) {
	          if (uris_arr[uris_Itr].U == uri_arr_idx) {                
			    tmp_arr.push(lookup_arr[lookup_Itr]);
				break;
              }       		
            }
          }
        }
		tmp_arr.sort(
          function(a,b) {
            if (a.C < b.C)
              return 1;
            else if (a.C > b.C)
              return -1;
            else
              return 0;
		  } 
        )
		if (tmp_arr.length > 0) {
          uri_desc = tmp_arr[0].W;
          for (tmp_Itr = 1; tmp_Itr < tmp_arr.length; tmp_Itr++) {    
    		if (tmp_Itr < 20) {
              uri_desc += ", " + tmp_arr[tmp_Itr].W;
		    }
		    else {
  		      break;
		    }
          }				  
		}  				
      }
      //--
      ldl = a__related_close.length;
      for (j = 0; j < a__related_close.length; j++) {
        s = a__related_close[j];
        s = "(^|\\s|-|/|\\|_|\\.)(" + s + ")($|\\s|-|/|\\|_|\\.)";
        //--
        var re = new RegExp(s,'gi');
        uri_title = uri_title.replace(re, "$1<b class=\"msa1s__bold\">$2</b>$3");
        //--
        var re = new RegExp(s,'gi');
        uri_path_shown = uri_path_shown.replace(re, "$1<b class=\"msa1s__bold\">$2</b>$3");
        //--
        var re = new RegExp(s,'gi');
        uri_desc = uri_desc.replace(re, "$1<b class=\"msa1s__bold\">$2</b>$3");
      }
      //--
      if ( (a__tag_list == "ol") || (a__tag_list == "ul") ) {
        r += '<li class="msa1s_list">';
      }
      else
      if (a__tag_list == "table") {
        r += '<tr class="msa1s_list"><td class="msa1s_list">';
      }
      r += '<div class="msa1s_list">';
      //--
      r += '<span class="msa1s_title"><a class="msa1s_title" href="' + ga1__wrp + uri_path_rela + '">' + uri_title + '</a></span>';
      r += '<br class="msa1s_title" />';
      r += '<span class="msa1s_path"><a class="msa1s_path" href="' + ga1__wrp + uri_path_rela + '">' + uri_path_shown + '</a></span>';
      r += '<br class="msa1s_path" />';
      if ( (a__desc_include == 1) && (uri_desc != "") ) {
        r += '<span class="msa1s_desc">' + uri_desc + '</span>';
        r += '<br class="msa1s_desc" />';
      }
      if (a__score_include == 1) {
        s = uri_score_str.substr(uri_score_str.length - 2); // copy from 0-based-index
        if (s == ", ") {
          uri_score_str = uri_score_str.substr(0, uri_score_str.length - 2); // copy full count minus 2
        }
        r += '<span class="msa1s_score">Score: ' + uri_score_str + '</span>';
        r += '<br class="msa1s_score" />';
      }
      //--
      r += '</div>';
      if ( (a__tag_list == "ol") || (a__tag_list == "ul") ) {
        r += '</li>';
      }
      else
      if (a__tag_list == "table") {
        r += '</td></tr>';
      }
      //--
    }
    r += '</' + a__tag_list + '>';
  }
  //--
  return r;
}
//--
function MSA1S_EventHandler_Action() {
  //--
  var opt_sp, opt_rs, opt_rc, opt_rsi, opt_rdi, opt_rs_none, opt_rs_total, opt_rs_more, opt_rs_showing, opt_rs_wait, opt_rs_next, opt_rs_previous, opt_tl, opt_sc;
  var to, sub_handler__instance_already_run, my_path, my_script_data, p, is_new_request_or_phrase;
  //--
  opt_sp = "example";
  opt_rs = 0;
  opt_rc = 10;
  opt_rsi = 1;
  opt_rdi = 1;
  opt_rs_none = "0 results.";
  opt_rs_total = "Total results: ";  
  opt_rs_more = "More results: ";
  opt_rs_showing = "Showing ";
  opt_rs_wait = "Please wait...";
  opt_rs_next = "next"
  opt_rs_previous = "previous"
  opt_tl = "ul";
  opt_sc = 1;
  //--
  if (true) {
    to = document.getElementById("id_msa1s_search_phrase");
    if (to != undefined) {
      opt_sp = to.value;
      //--
      is_new_request_or_phrase = (
        ( (ga1__phrase_current != "") && (ga1__phrase_current != opt_sp) )
        ||
        ( (ga1__phrase_current == "") )
      );
      //--
      ga1__phrase_current = opt_sp;
    }
    //--
    to = document.getElementById("id_msa1s_search_res_start__option");
    if ( (to != undefined) && (is_new_request_or_phrase == false) ) {
      opt_rs = Number(to.value);
    }
    //--
    to = document.getElementById("id_msa1s_search_res_count__option");
    if (to != undefined) {
      opt_rc = Number(to.value);
    }
    //--
    to = document.getElementById("id_msa1s_search_data_load_deferred__option");
    if (to != undefined) {
      ga1__opt_dld = to.value.toLowerCase();
      if ( (ga1__opt_dld != "js_defer") && (ga1__opt_dld != "php_defer") ) ga1__opt_dld = "none";
    }
    //alert("defer mode: " + ga1__opt_dld);
    //--

    to = document.getElementById("id_msa1s_search_res_score_include__option");	
    if (to != undefined) {
      if (to.type == "checkbox") {
	    if (to.checked) {
          opt_rsi = "1"; 	  		
	    }
	    else {
          opt_rsi = "0"; 	  			  
        }		
	  }
	  else {
	    opt_rsi = to.value;
      }		
	}  
    //--
    to = document.getElementById("id_msa1s_search_res_desc_include__option");    
    if (to != undefined) {
  	  if (to.type == "checkbox") {
	    if (to.checked) {
          opt_sdi = "1"; 	  		
	    }
	    else {
          opt_sdi = "0"; 	  			  
        }		
      }
      else {
        opt_sdi = to.value; 	  
	  }
	}  
    //--
    to = document.getElementById("id_msa1s_search_res_none_str__option");
    if (to != undefined) opt_rs_none = to.value;
    //--
    to = document.getElementById("id_msa1s_search_res_total_str__option");
    if (to != undefined) opt_rs_total = to.value;    
    //--
    to = document.getElementById("id_msa1s_search_res_more_str__option");
    if (to != undefined) opt_rs_more = to.value;
    //--
    to = document.getElementById("id_msa1s_search_res_showing_str__option");
    if (to != undefined) opt_rs_showing = to.value;    
    //--
    to = document.getElementById("id_msa1s_search_res_wait_str__option");
    if (to != undefined) opt_rs_wait = to.value;
    //--
    to = document.getElementById("id_msa1s_search_res_next_str__option");
    if (to != undefined) opt_rs_next = to.value;
    //--
    to = document.getElementById("id_msa1s_search_res_previous_str__option");
    if (to != undefined) opt_rs_previous = to.value;
    //--
    to = document.getElementById("id_msa1s_search_html_tag_list__option");
    if (to != undefined) {
      opt_tl = to.value.toLowerCase();
      if ( (opt_tl != "ol") && (opt_tl != "table") ) opt_tl = "ul";
    }
    //--
    to = document.getElementById("id_msa1s_search_stats_call");
    if (to != undefined) opt_sc = to.value;
  }
  //--
  to = document.getElementById("id_msa1s_search_results");
  to.innerHTML = opt_rs_wait; // innerHTML
  //--
  // adust search phrase (and sanitize)
  //--
  opt_sp = opt_sp.toLowerCase();
  opt_sp = opt_sp.replace(/[+*\.,-\/#!$%\^&\*;:{}=\-_~()<>]/g," ");
  opt_sp = opt_sp.replace(/\'/g," ");
  opt_sp = opt_sp.replace(/\"/g," ");
  opt_sp = opt_sp.replace(/\s\s/g," ");
  opt_sp = opt_sp.replace(/^\s+|\s+$/g,"");
  //--
  to = document.getElementById("id_msa1s_file_code");
  if (to != undefined) {
    ga1__path_d = to.src;
    ga1__path_d = ga1__path_d.substring(0,ga1__path_d.lastIndexOf('/') + 1);
    ga1__path_f = to.src;
    ga1__path_f = ga1__path_f.substring(ga1__path_f.lastIndexOf('/') + 1);
    p = ga1__path_f.lastIndexOf('?');
    if (p == -1)
      p = ga1__path_f.lastIndexOf('#');
    if (p > -1)
      ga1__path_f = ga1__path_f.substring(0, P - 1);
    //--
    //alert(ga1__path_d + " ---- " + ga1__path_f);
    //--
  }
  //--
  sub_handler__instance_already_run = false;
  sub_handler = function () {
    //--
    var u, l, t, s, r, i, i_arr, l_arr, r_arr, h_arr;
    //--
    u = [];
    rca = [];
    l = [];
    //--
    //alert("sub_handler1");
    if (sub_handler__instance_already_run == false) {
      sub_handler__instance_already_run = true;
      //--
      //alert("sub_handler2");
      if ( (ga1__ic == false) || (ga1__opt_dld == "php_defer") ) {
        ga1__ic = true;
        //--
        //alert("sub_handler2:a");
        if (window['MSA1S_Init'] != null) {
          //alert("sub_handler2:b");
          if (window['MSA1S_Init'] != null) {
            //alert("sub_handler3:b");
            MSA1S_Init();
          }
        }
        //alert('sub_handler2: ' + window['W1'].length + '---');
        for (i = 1; i < 5; i++) {
          l_arr = window['W' + i];
          //if (i == 1) { alert("MSA1S_EventHandler_Action:START: " + window['W' + i].length + " --- " + l_arr.length); }
          if (l_arr != null) {
            l_arr.sort(MSA1S__Compare_LookupArray); // to be sure, we sort natively in Javascript (so e.g. unicode sort and compare use same algorithm)
            //--
            // incase of an "unclean" array, remove leading/trailing undefined elements
            //--
            r_arr = -1;
            h_arr = l_arr.length - 1;
            //--
            if (l_arr[0] == undefined) {
              for (i_arr = 1; i_arr <= h_arr; i_arr++) {
                if (l_arr[i_arr] != undefined) {
                  r_arr = i_arr - 1;
                  break;
                }
              }
              if (r_arr > 0) {
                l_arr.splice(0, r_arr + 1); // remove up till and including *r_arr* item - e.g. if "0..1" gives count: 2 (r_arr + 1)
                //alert("MSA1S_EventHandler_Action: Start splice done");
              }
            }
            else
            if (l_arr[h_arr] == undefined) {
              for (i_arr = h_arr - 1; i_arr > 0; i_arr--) {
                if (l_arr[i_arr] != undefined) {
                  r_arr = i_arr + 1;
                  break;
                }
              }
              if (r_arr > 0) {
                l_arr.splice(r_arr, h_arr - r_arr + 1); // e.g. if "8..10" gives count 3 (h_arr - r_arr + 1)
                //alert("MSA1S_EventHandler_Action: End splice done");
              }
            }
          }
          //if (i == 1) { alert("MSA1S_EventHandler_Action:END: " + window['W' + i].length + " --- " + l_arr.length); }
        }
      }
      //--
      //alert("MSA1S_Lookup_GetScoresData:START");
      MSA1S_Lookup_GetScoresData(u,rca,l,true,true,opt_sp,1);
      //alert("MSA1S_Lookup_GetScoresData:DONE");
      //--
      //alert("MSA1S_Lookup_UpdateScoresData_URIsSpecific:START");
      MSA1S_Lookup_UpdateScoresData_URIsSpecific(u);
      //alert("MSA1S_Lookup_UpdateScoresData_URIsSpecific:DONE");
      //--
      s = MSA1S_Lookup_GetResultsHTML(u,rca,l,opt_rs,opt_rc,opt_rsi,opt_sdi,opt_tl);
      if (s == "") {
        s = opt_rs_none;
      }
      else {      
        //--      
        // Example: http://microsys.localhost/search/msa1-search.html?search_p=sitemap%20generator&rs=0rc=20      
        //--      
        var cm;
        cm = Math.min(opt_rs + opt_rc, u.length);
        s = '<div class="msa1s_nav">' + opt_rs_total + ' ' + u.length.toString() + '. ' + opt_rs_showing + (opt_rs + 1).toString() + '...' + (cm).toString() + ':</div><br>' + s;        
        //--
        //
        //--
        r = '';
        //--      
        sub_sub_onclick = function (a__rs) {
          var to;
          //alert("on click pressed - init");
          to = document.getElementById("id_msa1s_search_res_start__option");
          if (to != undefined)  {
              to.value = a__rs;
              //alert("on click pressed - new load, value was:" + rs);
              MSA1S_EventHandler_Action();
              //alert("on click pressed - done");
              return false;
          }
        }
        //--
        if (opt_rs > 0) {
          if (opt_rs >= opt_rc)
            i = opt_rs - opt_rc;
          else
            i = 0;
          t = ga1__path_d + '<!-- %A1WSE_PAGE_FILE_NAME% -->' + '?<!-- %A1WSE_GET_SEARCH% -->_p=' + encodeURIComponent(opt_sp) + '&<!-- %A1WSE_GET_SEARCH% -->_rs=' + i + '&<!-- %A1WSE_GET_SEARCH% -->_rc=' + opt_rc;
          t = '<a class="msa1s_nav" onClick="sub_sub_onclick(' + i + ');" href="#">' + opt_rs_previous +'</a>'; // href="' + t + '"
          if (r != "")
            r = r + " | " + t;
          else
            r = t;
        }
        if (opt_rs + opt_rc < u.length) {
          i = opt_rs + opt_rc;
          c = 'to = document.getElementById("id_msa1s_search_res_start__option"); if (to != undefined) { to.value = i; MSA1S_EventHandler_Action(); return false; }';
          t = ga1__path_d + '<!-- %A1WSE_PAGE_FILE_NAME% -->' + '?<!-- %A1WSE_GET_SEARCH% -->_p=' + encodeURIComponent(opt_sp) + '&<!-- %A1WSE_GET_SEARCH% -->_rs=' + i + '&<!-- %A1WSE_GET_SEARCH% -->_rc=' + opt_rc;
          t = '<a class="msa1s_nav" onClick="sub_sub_onclick(' + i + ');" href="#">' + opt_rs_next +'</a>'; // href="' + t + '"
          if (r != "")
            r = r + " | " + t;
          else
            r = t;
        }
        if (r != "") {
           r = '<div class="msa1s_nav">' + opt_rs_more + r + '</div>';
           s = s + r;
        }
      }
      to = document.getElementById("id_msa1s_search_results");
      to.innerHTML = s; 
    }
  }
  //--
  if
  (
    ( (ga1__opt_dld == "js_defer") && (window['MSA1S_Init'] == null) )
    ||
    ( (ga1__opt_dld == "php_defer") && (is_new_request_or_phrase) )
  )
  {
    //--
    //alert("MSA1S_Init was null. Path is: " + ga1__path_d);
    //--
    if (ga1__path_d != "") {
      //--
      if (ga1__opt_dld == "js_defer") {
        my_path = ga1__path_d;
        my_path += "msa1-search-data.js";

        //alert("1: my_path is: " + my_path);
        //--
        my_script_data = document.createElement("script");
        my_script_data.type = "text/javascript";
        my_script_data.src = my_path;
        //alert("2: my_path is: " + my_path);
        //--
        my_script_data.onreadystatechange = function () {
          if (this.readyState == 'complete') {
            //--
            //alert("complete");
            //--
            sub_handler();
          }
          else {
            //alert("other state");
            //alert(this.readyState);
          }
        }
        //alert("3: my_path is: " + my_path);
        my_script_data.onload = sub_handler; // was this necessary because of
        my_script_data.onLoad = sub_handler; // safari, ie, firefox, chrome, opera?
        //alert("4: my_path is: " + my_path);
        //--
        to = document.head || document.getElementsByTagName("head")[0] || document.documentElement;
        if (to != undefined) {
          //--
          //alert("head defined");
          //--
          to.appendChild(my_script_data); // CONSIDER: We assume ".src" first starts load here in browser?
          //--
          // to.insertBefore(my_script_data, to.firstChild);
          //--
        }
        //alert("5: my_path is: " + my_path);
      }
      //--
      else
      if (ga1__opt_dld == "php_defer") {
        my_path = ga1__path_d;
        //alert("php_defer1: yes. Path:" + my_path);
        my_path += "msa1-search-code.php?<!-- %A1WSE_GET_SEARCH% -->_p=";
        //alert("php_defer2: yes. Path:" + my_path);
        my_path += encodeURIComponent(opt_sp);
        //alert("php_defer3: yes. Path:" + my_path);
        my_path += "&<!-- %A1WSE_GET_SEARCH% -->_f=jsraw";
        //alert("php_defer4: yes. Path:" + my_path);
        //--

        //if ("http://microsys.localhost/search/msa1-search-code.php?search_p=xml%20%sitemap%generator&search_f=jsraw" != my_path)
          //alert("diff:" + my_path);
        //else
          //alert("same:" + my_path);


       //alert("new1---------" + my_path + "--------new2");

        //--
        request = new XMLHttpRequest();

       //alert("open1---------" + my_path + "--------open2");
        request.open("GET", my_path, true);

       //alert("done1---------" + my_path + "--------done2");

        //--
        request.onreadystatechange = function () {
          if (this.readyState == 4) {
            //--
            //alert("hey1---------" + request.responseText + "--------hey2");
            //--
            my_script_data = document.getElementById("id_msa1s_search__php_defer__core");
            if (my_script_data != undefined) {
              s = my_script_data.parentNode.removeChild(my_script_data);
              //alert(s.id);
            }
            my_script_data = document.createElement("script");
            my_script_data.type = "text/javascript";
            my_script_data.setAttribute("id", "id_msa1s_search__php_defer__core");
//--
//  innerHTML = Chrome 17, Safari 4, IE 9, Opera 11, but NOT IE 8
//  textContent = similar (at least when setting type "text/javascript" ?)
//  text = IE 8
//
//  stackoverflow.com/questions/1359469/innertext-works-in-ie-but-not-in-firefox
//  https://developer.mozilla.org/en/DOM/element.innerHTML
//  stackoverflow.com/questions/1891947/are-dynamically-inserted-script-tags-meant-to-work/1891999#1891999
//  allofetechnical.wordpress.com/2010/05/21/ies-innerhtml-method-with-script-and-style-tags/
//--
            if ("textContent" in my_script_data) {
              my_script_data.textContent = request.responseText;
              //alert("GetResultsHTML:textContent");
              // my_script_data.innerHTML = request.responseText;
            }
            else
            if ("text" in my_script_data) {
              my_script_data.text = request.responseText;
              //alert("GetResultsHTML:text");
            }
//--
// domscripting.com/blog/display/99
// ajaxian.com/archives/the-problem-with-innerhtml
// stackoverflow.com/questions/703705/how-do-i-inject-javascript-to-a-page-on-ie-8
//
// createElement("script") <script defer>
//--            
            to = document.head || document.getElementsByTagName("head")[0] || document.documentElement;
            if (to != undefined) {
              to.appendChild(my_script_data);
              //alert("appended");
              //alert("length: " + L.length);
            }
            sub_handler();
          }
        }
        request.send(null);
      }
      //--
    }
  }
  else {
    sub_handler();
  }
  //--
  // all done or in progress, now handle statistics
  //--
  if (opt_sc) {
    //alert("stats1");
    my_path = ga1__path_d;
    my_path += "msa1-logsearch.html?search_p=";
    my_path += encodeURIComponent(opt_sp);
    //alert("stats2: Path:" + my_path);
    stats_request = new XMLHttpRequest();
    stats_request.onreadystatechange = function () {
      if (this.readyState == 4) {
        //alert("stats4: Path:" + my_path);
      }
    }
    try {
      stats_request.open("GET", my_path, true); // we set to "a-sync"
      stats_request.send(null);
    }
    catch(err) {
      // IE complains when testing on local disk
    }
    //alert("stats3: Path:" + my_path);
  }
  //--
}
//--
function MSA1S_EventHandler_OnLoad() {
  //--
  var h, p, q, a, i, s_kv, s_k, s_v, to, da;
  //--
  //alert("MSA1S_EventHandler_OnLoad");
  da = false;
  h = window.location.href;
  h = decodeURI(h);
  //alert(h);
  p = h.indexOf("?");
  if ( p > -1 ) {
    q = h.substr(p + 1);
    //alert(q);
    a = q.split("&");
    for (i = 0; i < a.length; i++ ) {
      s_kv = a[i];
      //alert(s_kv);
      p = s_kv.indexOf("=");
      if ( p > -1 ) {
        s_k = s_kv.substr(0,p);
        //alert(s_k);
        if (s_k == "<!-- %A1WSE_GET_SEARCH% -->_p") {
          s_v = s_kv.substr(p+1);
          s_v = decodeURIComponent(s_v)		  		           
		  s_v = s_v.replace(/[+*\.,-\/#!$%\^&\*;:{}=\-_~()<>]/g," ");		  		  
          s_v = s_v.replace(/\s{2,}/g," ");		  		  		  
          //alert(s_v);
          to = document.getElementById("id_msa1s_search_phrase");
          if (to != undefined) {
            to.value = s_v;
            da = true;
          }
        }
        else
        if (s_k == "<!-- %A1WSE_GET_SEARCH% -->_rs") {
          s_v = s_kv.substr(p+1);
          to = document.getElementById("id_msa1s_search_res_start__option");
          if (to != undefined) {
            to.value = s_v;
          }
        }
        else
        if (s_k == "<!-- %A1WSE_GET_SEARCH% -->_rc") {
          s_v = s_kv.substr(p+1);
          to = document.getElementById("id_msa1s_search_res_count__option");
          if (to != undefined) {
            to.value = s_v;
          }
        }
      }
    }
  }
  else {
    to = document.getElementById("id_msa1s_search_phrase");
    if ( (to != undefined) && (to.value != "") ) {
      da = true;
    }      
  }  
  if (da) {
/*
  http://microsys.localhost/search/msa1-search.html?search_p=sitemap%20generator&rs=0rc=20

  The point here is to make GET override Javascript/DOM. (Will be useful in the future.)
*/
    MSA1S_EventHandler_Action();
  }
}