<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:output="http://www.w3.org/TR/REC-html40"
  xmlns:protocol="http://www.sitemaps.org/schemas/sitemap/0.9"
>
<xsl:output method="html" version="1.0" encoding="UTF-8" indent="no"/>
<xsl:template match="/">
<!-- -->
<html xmlns="http://www.w3.org/1999/xhtml">
<!--
  Copyright 2009-2019 by Thomas Schulz
  http://www.microsystools.com - A1 Sitemap Generator
  Feel free to use this file with XML sitemaps. Just keep the copyright notices!
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style type="text/css">
  div.Content_Init {
    color: black;
    font-size: 0.825em;
    line-height: 130%;
  }
  body {
    margin-top: 8px;
    margin-bottom: 8px;
    margin-left: 8px;
    margin-right: 8px;
    padding: 0px;
    border-width: 0px;
    font-family: Verdana, Tahoma, Helvetica;
  }
  table.Content_List {
    font-size: 1.0em;
    line-height: 130%;
    border: 1px solid #aaaaaa;
    border-collapse: separate; /* collapse */
    color: #555555;
    font-weight: normal;
  }
  tr.Content_List_HeaderRowCols {
    font-weight: bold;
    background-color: #f2f2f2;
  }
  tr.Content_List_DataRow_0 {
    background-color: white;
    font-size: smaller;
  }
  tr.Content_List_DataRow_1 {
    background-color: whitesmoke;
    font-size: smaller;
  }
  span.ArticleContent_Concept {
    color: #555555;
    border-bottom: 1px dashed;
  }
  span.MS_smaller {
    font-size: smaller;
  }
  span.ArticleContent_Path_File {
    background: #f5f5f5;
    color: #555555;
    padding-left: 1px;
    padding-right: 1px;
  }
</style>
<title>Sitemap of Website</title>
</head>
<body>
<center>
<div class="Content_Init">
  <!-- -->
  <!-- -->
  <!-- -->
  <!-- -->
  <xsl:variable name="file_kind">
  <xsl:choose>
    <xsl:when test="protocol:urlset">urlset</xsl:when>
    <xsl:when test="protocol:sitemapindex">sitemapindex</xsl:when>
    <xsl:otherwise><xsl:message terminate="yes"></xsl:message></xsl:otherwise>
  </xsl:choose>
  </xsl:variable>
  <!-- -->
  <!-- -->
  <!-- -->
  <!-- -->
  <table cellspacing="0" cellpadding="4" border="1" summary="sitemap data" class="Content_List">
  <tr class="Content_List_HeaderRowCols">
    <th align="center">Location</th>
    <th align="center">Last Modified</th>
    <xsl:if test="$file_kind='urlset'">
      <th align="center">Change Frequency</th>
      <th align="center">Priority</th>
    </xsl:if>
  </tr>
  <!-- -->
  <xsl:choose>
    <!-- -->
    <xsl:when test="$file_kind='urlset'">
      <xsl:for-each select="protocol:urlset/protocol:url">
      <tr>
        <xsl:choose>
          <xsl:when test="position() mod 2 != 0">
            <xsl:attribute name="class">Content_List_DataRow_0</xsl:attribute>
          </xsl:when>
          <xsl:when test="position() mod 2 != 1">
            <xsl:attribute name="class">Content_List_DataRow_1</xsl:attribute>
          </xsl:when>
          <xsl:otherwise><xsl:message terminate="yes"></xsl:message></xsl:otherwise>
        </xsl:choose>
        <xsl:variable name="iter_loc"><xsl:value-of select="protocol:loc"/></xsl:variable>
        <td align="left"><a href="{$iter_loc}"><xsl:value-of select="$iter_loc"/></a></td>
        <td align="left"><xsl:value-of select="protocol:lastmod"/></td>
        <td align="left"><xsl:value-of select="protocol:changefreq"/></td>
        <td align="right"><xsl:value-of select="protocol:priority"/></td>
      </tr>
      </xsl:for-each>
    </xsl:when>
    <!-- -->
    <xsl:when test="$file_kind='sitemapindex'">
      <xsl:for-each select="protocol:sitemapindex/protocol:sitemap">
      <tr>
        <xsl:choose>
          <xsl:when test="position() mod 2 != 0">
            <xsl:attribute name="class">Content_List_DataRow_0</xsl:attribute>
          </xsl:when>
          <xsl:when test="position() mod 2 != 1">
            <xsl:attribute name="class">Content_List_DataRow_1</xsl:attribute>
          </xsl:when>
          <xsl:otherwise><xsl:message terminate="yes"></xsl:message></xsl:otherwise>
        </xsl:choose>
        <xsl:variable name="iter_loc"><xsl:value-of select="protocol:loc"/></xsl:variable>
        <td align="left"><a href="{$iter_loc}"><xsl:value-of select="$iter_loc"/></a></td>
        <td align="left"><xsl:value-of select="protocol:lastmod"/></td>
      </tr>
      </xsl:for-each>
    </xsl:when>
    <!-- -->
  </xsl:choose>
  <!-- -->
  </table>
  <!-- -->
  <!-- -->
  <!-- -->
  <!-- -->
  <br /><br />
  <table cellspacing="0" cellpadding="4" border="1" summary="sitemap statistics" class="Content_List">
  <tr class="Content_List_HeaderRowCols">
    <th align="center">Statistics</th>
  </tr>
  <xsl:choose>
    <xsl:when test="$file_kind='urlset'">
      <xsl:variable name="sum_rec_count"><xsl:value-of select="count(protocol:urlset/protocol:url)"/></xsl:variable>
      <xsl:variable name="sum_priority_total"><xsl:value-of select="sum(protocol:urlset/protocol:url/protocol:priority)"/></xsl:variable>
      <xsl:variable name="sum_priority_average"><xsl:value-of select="format-number($sum_priority_total div $sum_rec_count, '0.00')"/></xsl:variable>
      <tr class="Content_List_DataRow_0">
        <td>URL <span class="ArticleContent_Concept">count</span>: <xsl:value-of select="$sum_rec_count"></xsl:value-of></td>
      </tr>
    </xsl:when>
    <xsl:when test="$file_kind='sitemapindex'">
      <xsl:variable name="sum_rec_count"><xsl:value-of select="count(protocol:sitemapindex/protocol:sitemap)"/></xsl:variable>
      <tr class="Content_List_DataRow_0">
        <td>URL <span class="ArticleContent_Concept">count</span>: <xsl:value-of select="$sum_rec_count"></xsl:value-of></td>
      </tr>
    </xsl:when>
    <xsl:otherwise><xsl:message terminate="yes"></xsl:message></xsl:otherwise>
  </xsl:choose>
  </table>
  <!-- -->
  <!-- -->
  <!-- -->
  <!-- -->
  <br /><br />
  <span class="MS_smaller">
  The file <span class="ArticleContent_Path_File">sitemap.xsl</span> is
  copyright 2009-2019 <a href="http://www.microsystools.com/people/thomas-schulz/">Thomas Schulz</a>.
  <br />
  It can <strong>freely be used</strong> if the copyright notices are kept.
  <br />
  Made for XML sitemaps created with <a href="http://www.microsystools.com/products/sitemap-generator/">A1 Sitemap Generator</a>.
  </span>
  <!-- -->
  <!-- -->
  <!-- -->
  <!-- -->
</div>
</center>
</body>
</html>
<!-- -->
</xsl:template>
</xsl:stylesheet>