/*
 * yuga.js 0.3.0 - 優雅なWeb制作のためのJS
 *
 * Copyright (c) 2007 Kyosuke Nakamura (kyosuke.jp)
 * Licensed under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Since:     2006-10-30
 * Modified:  2007-06-18
 *
 * jQuery 1.1.2
 * ThickBox 3
 * Interface 1.2 (Effects scroll)
 */

/* yuga.js内で使っているfunction群 */
var yuga = {
	// imageのプリローダー
	preloader: {
		loadedImages: [],
		load: function (url){
			var img = this.loadedImages;
			var l = img.length;
			img[l] = new Image();
			img[l].src = url;
		}
	},
	// URIを解析したオブジェクトを返すfunction
	URI: function(s){
		this.originalPath = s;
		//絶対パスを取得
		this.getAbsolutePath = function(path){
			if (!path.match(/^(mailto:)|(javascript:)/)) {
				var img = new Image();
				img.src = path;
				path = img.src;
				img.src = '#';
			}
			return path;
		};
		this.absolutePath = this.getAbsolutePath(s);
		//同じ文書にリンクしているかどうか
		this.isSelfLink = (this.absolutePath == location.href);
		//絶対パスを分解
		var fields = {'schema' : 2, 'username' : 5, 'password' : 6, 'host' : 7, 'path' : 9, 'query' : 10, 'fragment' : 11};
		var r = /^((\w+):)?(\/\/)?((\w+):?(\w+)?@)?([^\/\?:]+):?(\d+)?(\/?[^\?#]+)?\??([^#]+)?#?(\w*)/.exec(this.absolutePath);
		for (var field in fields) {
			this[field] = r[fields[field]]; 
		}
	}
};

$(function(){
	
	//class="imgLink"でロールオーバーを設定（src属性を_hover付きのものに差し替える）
	$('.imgLink img, img.imgLink,#gNav img, #helpNav img,.logo img').each(function(){
		this.originalSrc = $(this).attr('src');
		this.rolloverSrc = this.originalSrc.replace(/(\.gif|\.jpg|\.png)/, "_hover$1");
		yuga.preloader.load(this.rolloverSrc);
	}).hover(function(){
		$(this).attr('src',this.rolloverSrc);
	},function(){
		$(this).attr('src',this.originalSrc);
	});

	//現在のページへのリンク
	$('a[@href]').each(function(){
		var href = new yuga.URI(this.getAttribute('href'));
		if (href.isSelfLink && !href.fragment) {
			$(this).addClass('active');
		}
	});

	//外部リンクは別ウインドウを設定
/*
	$('a[@href^="http://"]').click(function(){
		window.open(this.href, '_blank');
		return false;
	}).addClass('externalLink');

	//ページ内リンクはするするアニメーション(interface.js利用)
	$(function(){
		$('.pageTop a').click(function(){
			$('#page').ScrollTo(600, 'easeout');
			return false;
		});
	})

	//画像へ直リンクするとthickboxで表示(thickbox.js利用)
	tb_init('a[@href$=".jpg"], a[@href$=".gif"], a[@href$=".png"]');

	//奇数、偶数を自動追加
	$('div#main').each(function(){
		$(this).find('div.item:odd').addClass('even');
		$(this).find('div.item:even').addClass('odd');
	});
	$('table').each(function(){
		$(this).find('tr:odd').addClass('even');
		$(this).find('tr:even').addClass('odd');
	});
	
*/

});

