/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.stream.Stream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class CompositeFileProvider
extends AbstractFileProvider {
    private static final int INITIAL_BUFSZ = 80;

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        StringBuilder buf = new StringBuilder(80);
        UriParser.extractScheme(this.getContext().getFileSystemManager().getSchemes(), uri, buf);
        Stream.of(this.getSchemes()).forEach(scheme -> buf.insert(0, scheme + ":"));
        return this.getContext().getFileSystemManager().resolveFile(buf.toString(), fileSystemOptions);
    }

    protected abstract String[] getSchemes();
}

