/*
 *  jquery-github - v0.4.0
 *  A jQuery plugin to display your Github Repositories.
 *  https://github.com/zenorocha/jquery-github
 *
 *  Copyright (c) 2014
 *  MIT License
 */
function GithubRepo(a){this.description=a.description,this.forks=a.forks_count,this.name=a.name,this.open_issues=a.open_issues,this.pushed_at=a.pushed_at,this.url=a.url,this.stargazers=a.stargazers_count}function Github(a,b){var c={iconStars:!0,iconForks:!0,iconIssues:!1};this.element=a,this.$container=$(a),this.repo=this.$container.attr("data-repo"),this.options=$.extend({},c,b),this._defaults=c,this.init(),this.displayIcons()}GithubRepo.prototype.toHTML=function(){return this.pushed_at=this._parsePushedDate(this.pushed_at),this.url=this._parseURL(this.url),$("<div class='github-box'><div class='github-box-header'><h3><a href='"+this.url+"'>"+this.name+"</a></h3><div class='github-stats'><a class='repo-stars' title='Stars' data-icon='7' href='"+this.url+"/stargazers'>"+this.stargazers+"</a><a class='repo-forks' title='Forks' data-icon='f' href='"+this.url+"/network'>"+this.forks+"</a><a class='repo-issues' title='Issues' data-icon='i' href='"+this.url+"/issues'>"+this.open_issues+"</a></div></div><div class='github-box-content'><p>"+this.description+" &mdash; <a href='"+this.url+"#readme'>Read More</a></p></div><div class='github-box-download'><p class='repo-update'>Latest commit to <strong>master</strong> on "+this.pushed_at+"</p><a class='repo-download' title='Download as zip' data-icon='w' href='"+this.url+"/zipball/master'></a></div></div>")},GithubRepo.prototype._parsePushedDate=function(a){var b=new Date(a);return b.getDate()+"/"+(b.getMonth()+1)+"/"+b.getFullYear()},GithubRepo.prototype._parseURL=function(a){return a.replace("api.","").replace("repos/","")},Github.prototype.init=function(){var a=this.getCache();return null!==a?void this.applyTemplate(JSON.parse(a)):void this.requestData(this.repo)},Github.prototype.displayIcons=function(){var a=this.options,b=$(".repo-stars"),c=$(".repo-forks"),d=$(".repo-issues");b.css("display",a.iconStars?"inline-block":"none"),c.css("display",a.iconForks?"inline-block":"none"),d.css("display",a.iconIssues?"inline-block":"none")},Github.prototype.requestData=function(a){var b=this;$.ajax({url:"https://api.github.com/repos/"+a,dataType:"jsonp",success:function(a){var c=a.data,d=a.meta.status>=400&&c.message;return d?void b.handleErrorRequest(c):void b.handleSuccessfulRequest(c)}})},Github.prototype.handleErrorRequest=function(a){console.warn(a.message)},Github.prototype.handleSuccessfulRequest=function(a){this.applyTemplate(a),this.setCache(a)},Github.prototype.setCache=function(a){window.sessionStorage&&window.sessionStorage.setItem("gh-repos:"+this.repo,JSON.stringify(a))},Github.prototype.getCache=function(){return window.sessionStorage?window.sessionStorage.getItem("gh-repos:"+this.repo):!1},Github.prototype.applyTemplate=function(a){var b=new GithubRepo(a),c=b.toHTML();c.appendTo(this.$container)},function(a){a.fn.github=function(b){return this.each(function(){a(this).data("plugin_github")||a(this).data("plugin_github",new Github(this,b))})}}(window.jQuery||window.Zepto,window);