<script>{
	"title": "Additional jQuery Support"
}</script>

While we hope to cover most jQuery-related topics on this site, you may need additional or more immediate support. The following resources can prove useful.

### Official Forums

http://forum.jquery.com/

There are many subforums where you can discuss jQuery, ask questions, talk about JavaScript, or announce your plugins.

* [Getting Started](http://forum.jquery.com/getting-started)
	* This is the best place to post if you are brand new to jQuery and JavaScript.
* [Using jQuery](http://forum.jquery.com/using-jquery)
	* This is the best place to post if you have general questions or concerns.
	* If you've built a site that uses jQuery, or would like to announce a new plugin, this is the place to do it.
* [Using jQuery Plugins](http://forum.jquery.com/using-jquery-plugins)
	* If you are a plugin author or user and you wish to discuss specific plugins, plugin bugs, new features, or new plugins.
* [Using jQuery UI](http://forum.jquery.com/using-jquery-ui)
	* This is the place to discuss use of [jQuery UI](http://jqueryui.com/) Interactions, Widgets, and Effects
* [jQuery Mobile](http://forum.jquery.com/jquery-mobile)
	* This is the place to discuss jQuery Mobile.
* [Developing jQuery Core](http://forum.jquery.com/developing-jquery-core)
	* This forum centers around development of the jQuery library itself.
	* Post here if you have questions about certain bugs, development with jQuery, features, or anything in the bug tracker or Git.
* [Developing jQuery Plugins](http://forum.jquery.com/developing-jquery-plugins)
	* This forum covers development of jQuery plugins.
* [Developing jQuery UI](http://forum.jquery.com/developing-jquery-ui)
	* This is the place to discuss development of [jQuery UI](http://jqueryui.com/) itself – including bugs, new plugins, and how you can help.
	* All jQuery UI svn commits are posted to this list to facilitate feedback, discussion, and review.
	* Also note that a lot of the development and planning of jQuery UI takes place on the [jQuery UI Development and Planning Wiki](http://wiki.jqueryui.com/).
* [Developing jQuery Mobile](http://forum.jquery.com/developing-jquery-mobile)
	* This forum covers issues related to the development of jQuery Mobile.
* [QUnit and Testing](http://forum.jquery.com/qunit-and-testing)
	* This is the place to discuss JavaScript testing in general and QUnit in particular

At the bottom of each of the forums is an RSS feed you can subscribe to.

To ensure that you'll get a useful answer in no time, please consider the following advice:

* Ensure your markup is valid.
* Use Firebug/Developer Tools to see if you have an exception.
* Use Firebug/Developer Tools to inspect the HTML classes, CSS, etc.
* Try expected resulting HTML and CSS without JavaScript/jQuery and see if the problem could be isolated to those two.
* Reduce to a minimal test case (keep removing things until the problem goes away, etc.)
* Provide that test case as part of your mail. Either upload it somewhere or post it on [jsbin.com](http://jsbin.com/).

In general, keep your question short and focused and provide only essential details – others can be added when required.

### Mailing List Archives

The mailing lists existed before the forums were created, and were closed in early 2010.

There are two different ways of browsing the mailing list archives.

1. The official mailing list archives can be found here:
	* [jQuery General Discussion Archives](http://groups.google.com/group/jquery-en)
		* [jQuery Dev List Archives](http://groups.google.com/group/jquery-dev)
		* [jQuery UI General Discussion Archives](http://groups.google.com/group/jquery-ui)
	* [jQuery UI Dev List Archives](http://groups.google.com/group/jquery-ui-dev)
	* [jQuery Plugins List Archives](http://groups.google.com/group/jquery-plugins)

2. Also, an interactive, browsable version of the General Discussion mailing list can be found on [Nabble](http://jquery.10927.n7.nabble.com/jQuery-General-Discussion-f3.html) (a forum-like mailing list mirror).

### Chat / IRC Channel

jQuery also has a very active IRC channel, `#jquery`, hosted by [freenode](http://freenode.net/).

The IRC Channel is best if you need quick help with any of the following:

* JavaScript
* jQuery syntax
* Problem solving
* Strange bugs

If your problem is more in-depth, we may ask you to post to the mailing list, or the bug tracker, so that we can help you in a more-suitable environment.

#### Connect info:

**Server:** irc.freenode.net

**Room:** `#jquery`

You can also connect at http://webchat.freenode.net/?channels=#jquery.

If you wish to post code snippets to the channel, you should use a paste site, like [jsfiddle.net](http://jsfiddle.net/) or [jsbin.com](http://jsbin.com/).

Additional info regarding jQuery's use of IRC can be found on [irc.jquery.org](http://irc.jquery.org).

### StackOverflow

There is an active and well-informed support community at [StackOverflow](http://stackoverflow.com/questions/tagged/jquery). You can likely find an answer for whatever issue you're experiencing. If your question isn't addressed, you can ask a new question and often receive a quick response.
