<script>{
	"title": "About This Site",
	"customFields": [
		{
			"key": "is_chapter",
			"value": 0
		}
	]
}</script>

Learning how and when to use jQuery is a different process for each and every web developer, depending largely on experience with the primary tools for front-end development (HTML, CSS, and JavaScript) and knowledge of general programming principles. Over the years developers of all stripes have come to rely on our [API documentation](http://api.jquery.com) for help figuring out how to do exactly what they need to do.

However, API documentation alone cannot serve as a guide to solving problems and fostering a true understanding of web development. Over the years, an ecosystem of blog posts, books, support forums, and channels has grown to help cover the **hows** and **whys** of developing with jQuery, as well as explaining best practices, techniques, and workarounds for common problems. This type of documentation has been invaluable resource for millions of people, but the experience of navigating these waters can be frustrating as often as it is fulfilling, as developers struggle to identify trustworthy resources, determine whether what they're reading is actually up to date, and figure out those magical search keywords that are _just right_!

This site represents the jQuery Foundation's ongoing effort to consolidate and curate this information in order to provide this crucial "narrative documentation" to our community and serve the following goals:

1. Provide our **users** with a digestible reference on all aspects of using jQuery, from the basics of getting started and performing common tasks to more advanced topics like approaches to structuring code and where jQuery fits into modern web application development.
2. Provide our **contributors** a central, open place to collaborate and provide a dependable, highly sharable resource that will improve our users' support experiences.
3. Foster an environment by which users are encouraged to become contributors and build the skills to help them work on jQuery – or any other open source project!

In order to achieve these goals, all of [this site's content is maintained publicly on GitHub](https://github.com/jquery/learn.jquery.com) and is licensed under the [MIT License](https://github.com/jquery/learn.jquery.com/blob/master/LICENSE.txt). To learn more about how the site works, take a look at our [contributing guide](/contributing/).

## History

The jQuery Learning site has its roots in two primary places.

The first is Rebecca Murphey's _jQuery Fundamentals_ ([archive](https://web.archive.org/web/20151123192026/http://jqfundamentals.com/legacy/), [source](https://github.com/rmurphey/jqfundamentals)), a free, open source book on jQuery basics originally released in 2010. Seeking a better home where the information could be both maintained going forward, and consumed in a more piecemeal fashion, Rebecca donated the content to the jQuery Foundation to form the basis of what was then an abstract idea for some sort of "learning center."

The second is docs.jquery.com ([archive](https://web.archive.org/web/20121027123801/http://docs.jquery.com/Main%5FPage), [source](https://github.com/jquery/docs.jquery.com)), that erstwhile chestnut was home to all official documentation for jQuery Core, jQuery UI, and QUnit, as well as various community plugins, tutorials, and contribution guides. It was powered by MediaWiki and ran from 2006 to 2013. We moved official API documentation for jQuery to their own sites (that [anyone can contribute to](https://contribute.jquery.org/web-sites/#site-amp-repository-guide) via Git), but still needed a place for the the "how-to" guides and FAQs that was similarly open to contribution. Many of these pages live on in the jQuery Learning Center.

## Contributing

This project wouldn't have been possible without all our [awesome contributors](https://github.com/jquery/learn.jquery.com/graphs/contributors?type=a). If you feel like something on the site is open for improvements, you can contribute [on GitHub](https://github.com/jquery/learn.jquery.com). Feel free to check out [the contributing guide](contributing/) for more in-depth information.
