<script>{
	"title": "Using jQuery UI ThemeRoller",
	"level": "beginner"
}</script>

![ThemeRoller logo](/resources/jquery-ui/themeroller-logo.png)

### About ThemeRoller

ThemeRoller is a web app that offers a fun and intuitive interface for designing and downloading custom themes for jQuery UI. You can find ThemeRoller in the "Themes" section of the jQuery UI site, or by following this link: [jQuery UI ThemeRoller](http://jqueryui.com/themeroller/)

![ThemeRoller Sidebar](/resources/jquery-ui/themeroller-interface-new.png)
![ThemeRoller Sidebar](/resources/jquery-ui/themeroller-gallery-new.png)

### The ThemeRoller Interface

The interface for ThemeRoller is categorized into panels for global font and corner radius settings, widget container styles, and interaction states for clickable elements, and various styles for overlays and shadows. These panels allow configuration of various CSS properties such as font size, color, and weight, background color and texture, border color, text color, icon color, corner radius, and more!

### The Theme Gallery: Pre-Rolled Themes

ThemeRoller themes can be viewed via permalink URLs, and it includes a gallery of pre-designed themes to choose from. The theme gallery is accessible through the tab strip located at the top of the application interface. From the gallery, you can preview and download themes, or even choose to tweak a theme further in the "Roll Your Own" tab.

### Downloading Themes

When you're done designing a theme, you can download it for use in your projects. ThemeRoller has a "Download theme" button at the top which will lead you to the download builder page. From there you can also pick the components to download with your theme. Finally the Download button at the bottom will generate a zip file containing the theme along with assets like images and any components you picked. Images included in your download will be generated to your specifications and saved as high-quality PNG files.

### Installing Downloaded Themes Into Your Project

Once you've unzipped the package, you will see several `css` and `js` files, along with two folders. If you're only interested in the full theme, copy `jquery-ui.css` and the `images` folder into your project and link to the `jquery-ui.css` file from your pages.

### Building Custom "ThemeRoller-Ready" Components
![ThemeRoller Ready Banner](/resources/jquery-ui/themeroller-ready-black-200px.png)
![ThemeRoller Ready Banner](/resources/jquery-ui/themeroller-ready-white-200px.png)

ThemeRoller generates a customized version of the jQuery UI CSS Framework for developing your own ThemeRoller-ready jQuery components. The classes generated by this framework are designed to accommodate common user interface design situations and include states, icons, and various helper classes as well.

For information on developing with the jQuery UI CSS Framework, visit our [Theming API documentation](http://api.jqueryui.com/theming/css-framework/).
