(function($){$.bsDatepicker={version:"1.0.0",default:{locale:"de-DE",range:false,inline:false,startOnSunday:false,autoClose:true,format:"locale",separator:" – ",zIndex:1080,months:1,icons:{prevYear:"bi bi-chevron-double-left",prev:"bi bi-chevron-left",today:"bi bi-record-circle",next:"bi bi-chevron-right",nextYear:"bi bi-chevron-double-right",clear:"bi bi-x-lg"},classes:{display:"form-control d-flex align-items-center justify-content-between",displayText:"",displayIcon:"bi bi-calendar-event"},placeholder:"Select period",disabled:null}};const NS="bs.datepicker";function emit(state,name,detail){const $target=state.containerMode?state.$root:state.$input||state.$anchor||state.$root;if(!$target||!$target.length)return;try{const ev=$.Event(name+"."+NS,{detail:detail||{}});$target.trigger(ev,[detail||{}])}catch(e){}}function startOfDay(d){const x=new Date(d.getTime());x.setHours(0,0,0,0);return x}function isSameDay(a,b){if(!a||!b)return false;return a.getFullYear()===b.getFullYear()&&a.getMonth()===b.getMonth()&&a.getDate()===b.getDate()}function addMonths(date,n){const d=new Date(date.getFullYear(),date.getMonth()+n,1);return d}function daysInMonth(year,month){return new Date(year,month+1,0).getDate()}function clampRange(a,b){if(!a||!b)return[a,b];return a<=b?[a,b]:[b,a]}function inRange(d,a,b){if(!a||!b)return false;const[s,e]=clampRange(a,b);return d>=startOfDay(s)&&d<=startOfDay(e)}function toDateOrNull(v){if(!v)return null;if(v instanceof Date)return startOfDay(v);if(typeof v==="number")return startOfDay(new Date(v));if(typeof v==="string"){const parts=v.match(/^(\d{4})-(\d{2})-(\d{2})$/);let d=parts?new Date(Number(parts[1]),Number(parts[2])-1,Number(parts[3])):new Date(v);if(isNaN(d.getTime()))return null;return startOfDay(d)}return null}function normalizeDisabled(cfg){if(!cfg)return{before:null,after:null,min:null,max:null,datesSet:new Set};const out={before:null,after:null,min:null,max:null,datesSet:new Set};if(cfg.before)out.before=toDateOrNull(cfg.before);if(cfg.after)out.after=toDateOrNull(cfg.after);if(cfg.min)out.min=toDateOrNull(cfg.min);if(cfg.max)out.max=toDateOrNull(cfg.max);if(Array.isArray(cfg.dates)){cfg.dates.forEach(function(x){const d=toDateOrNull(x);if(d)out.datesSet.add(d.getTime())})}return out}function isDisabledDate(d,state){if(!state||!state.disabled)return false;const dd=startOfDay(d);const t=dd.getTime();const dis=state.disabled;if(dis.min&&dd<dis.min)return true;if(dis.max&&dd>dis.max)return true;if(dis.before&&dd<=dis.before)return true;if(dis.after&&dd>=dis.after)return true;if(dis.datesSet&&dis.datesSet.has(t))return true;return false}function getWeekdayNames(locale,startOnSunday){const fmt=new Intl.DateTimeFormat(locale,{weekday:"short"});const base=new Date(2021,7,1);const days=[];for(let i=0;i<7;i++){const d=new Date(base.getFullYear(),base.getMonth(),base.getDate()+i);days.push(fmt.format(d))}if(startOnSunday)return days;return days.slice(1).concat(days.slice(0,1))}function getMonthYearTitle(date,locale){const fmt=new Intl.DateTimeFormat(locale,{month:"long",year:"numeric"});return fmt.format(date)}function formatDateValue(value,opts){const{format,locale,separator}=opts;if(typeof format==="function")return format(value);const fmt=new Intl.DateTimeFormat(locale,{year:"numeric",month:"2-digit",day:"2-digit"});const toLocalISO=d=>{if(!d)return"";const y=d.getFullYear();const m=String(d.getMonth()+1).padStart(2,"0");const day=String(d.getDate()).padStart(2,"0");return y+"-"+m+"-"+day};if(Array.isArray(value)){const[a,b]=value;if(!a&&!b)return"";if(format==="iso"){return[toLocalISO(a),toLocalISO(b)].filter(Boolean).join(separator)}return[a?fmt.format(a):"",b?fmt.format(b):""].filter(Boolean).join(separator)}else if(value instanceof Date){if(format==="iso")return toLocalISO(value);return fmt.format(value)}return""}function buildCalendarGrid(current,opts){const year=current.getFullYear();const month=current.getMonth();const firstOfMonth=new Date(year,month,1);const firstWeekday=firstOfMonth.getDay();const shift=opts.startOnSunday?0:1;const startIdx=(firstWeekday-shift+7)%7;const dim=daysInMonth(year,month);const prevDim=daysInMonth(year,month-1<0?11:month-1);const cells=[];for(let i=0;i<42;i++){const cell={inMonth:false,date:null};if(i<startIdx){const day=prevDim-(startIdx-1-i);const d=new Date(year,month,1);d.setDate(d.getDate()-(startIdx-i));cell.inMonth=false;cell.date=startOfDay(d)}else if(i>=startIdx&&i<startIdx+dim){const day=i-startIdx+1;cell.inMonth=true;cell.date=startOfDay(new Date(year,month,day))}else{const d=new Date(year,month,dim);d.setDate(d.getDate()+(i-(startIdx+dim))+1);cell.inMonth=false;cell.date=startOfDay(d)}cells.push(cell)}return cells}function renderOneMonthBlock(currMonthDate,state){const{opts,selected,rangeStart}=state;const weekdays=getWeekdayNames(opts.locale,opts.startOnSunday);const title=getMonthYearTitle(currMonthDate,opts.locale);const cells=buildCalendarGrid(currMonthDate,opts);const today=startOfDay(new Date);const isRange=!!opts.range;const theme="subtle";let html="";html+='<div class="mb-2">';html+='  <div class="fw-semibold text-capitalize text-center mb-0">'+title+"</div>";html+='  <div class="table-responsive">';html+='    <table class="table table-sm table-borderless mb-0 text-center align-middle user-select-none w-100" style="table-layout:fixed">';html+="      <thead><tr>";weekdays.forEach(w=>{html+='<th class="text-muted small">'+w+"</th>"});html+="      </tr></thead>";html+="      <tbody>";const year=currMonthDate.getFullYear();const month=currMonthDate.getMonth();const firstOfMonth=new Date(year,month,1);const firstWeekday=firstOfMonth.getDay();const shift=opts.startOnSunday?0:1;const startIdx=(firstWeekday-shift+7)%7;const dim=daysInMonth(year,month);const neededCells=startIdx+dim;const rows=Math.ceil(neededCells/7);for(let r=0;r<rows;r++){html+="<tr>";for(let c=0;c<7;c++){const idx=r*7+c;const dayIndex=idx-startIdx;const d=startOfDay(new Date(year,month,dayIndex+1));const inMonth=dayIndex>=0&&dayIndex<dim;const isToday=isSameDay(d,today);const isSelected=!isRange&&selected&&isSameDay(d,selected);const isStart=isRange&&rangeStart&&isSameDay(d,rangeStart);const isEnd=isRange&&selected&&!isStart&&isSameDay(d,selected);const isBetween=isRange&&rangeStart&&selected&&inRange(d,rangeStart,selected)&&!isStart&&!isEnd;const muted=!inMonth;let tdCls="p-0";let btnCls="btn btn-sm w-100 border-0 rounded-0 ";const inRangeAny=isStart||isEnd||isBetween;if(isRange){if(inRangeAny){btnCls+=" bg-primary-subtle text-primary-emphasis "}if(isStart||isEnd){btnCls+=" border border-primary fw-semibold "}}else{if(isSelected){btnCls+=" bg-primary-subtle text-primary-emphasis fw-semibold border border-primary "}}if(muted)btnCls+=" text-muted ";if(isToday&&!(isSelected||inRangeAny))btnCls+=" text-primary fw-semibold ";const disabled=isDisabledDate(d,state);html+='<td class="'+tdCls.trim()+'">';const actionAttr=disabled?"":' data-action="pick"';const disAttr=disabled?' disabled aria-disabled="true"':"";const disabledEnhance=disabled?" bg-secondary-subtle text-secondary-emphasis ":"";const structCls=(isStart?" dp-start ":"")+(isEnd?" dp-end ":"");const clsFinal=(btnCls+(disabled?" disabled ":"")+disabledEnhance+structCls).trim();let cornerStyle="";if(isRange){if(isStart)cornerStyle+="border-top-left-radius: var(--bs-border-radius); box-shadow: inset 2px 0 0 0 var(--bs-primary);";if(isEnd)cornerStyle+="border-bottom-right-radius: var(--bs-border-radius); box-shadow: inset -2px 0 0 0 var(--bs-primary);"}const styleAttr=cornerStyle?' style="'+cornerStyle+'"':"";html+='<button type="button" class="'+clsFinal+'"'+styleAttr+actionAttr+disAttr+' data-date="'+d.getTime()+'">';html+=d.getDate();html+="</button>";html+="</td>"}html+="</tr>"}html+="      </tbody>";html+="    </table>";html+="  </div>";html+="</div>";return html}function renderTemplate(state){const{opts,current}=state;const months=Math.max(1,parseInt(opts.months||1,10));let html="";var panelCls=opts.inline?"bg-transparent p-2 d-inline-block":"bg-body border rounded-3 shadow p-2 d-inline-block";html+='<div class="'+panelCls+'">';html+='  <div class="d-flex align-items-center justify-content-between gap-2 pb-2'+(opts.inline?"":" border-bottom")+'">';html+='    <div class="d-flex align-items-center gap-1">';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="prevYear" title="Previous year" aria-label="Previous year"><i class="'+(opts.icons&&(opts.icons.prevYear||opts.icons.prev)||$.bsDatepicker.default.icons.prevYear)+'"></i></button>';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="prev" title="Previous month" aria-label="Previous month"><i class="'+(opts.icons&&opts.icons.prev||$.bsDatepicker.default.icons.prev)+'"></i></button>';html+="    </div>";html+='    <div class="text-center flex-grow-1">';(function(){const fmtShort=new Intl.DateTimeFormat(opts.locale,{month:"short",year:"numeric"});const titleLeft=fmtShort.format(current);const titleRight=months>1?fmtShort.format(addMonths(current,months-1)):"";html+='      <div class="small fw-semibold text-capitalize">'+titleLeft+(months>1?" … "+titleRight:"")+"</div>"})();html+="    </div>";html+='    <div class="d-flex align-items-center gap-1">';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="next" title="Next month" aria-label="Next month"><i class="'+(opts.icons&&opts.icons.next||$.bsDatepicker.default.icons.next)+'"></i></button>';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="nextYear" title="Next year" aria-label="Next year"><i class="'+(opts.icons&&(opts.icons.nextYear||opts.icons.next)||$.bsDatepicker.default.icons.nextYear)+'"></i></button>';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="today" title="Today" aria-label="Today"><i class="'+(opts.icons&&opts.icons.today||$.bsDatepicker.default.icons.today)+'"></i></button>';html+='      <button type="button" class="btn btn-sm border-0 p-1" data-action="clear" title="Clear" aria-label="Clear"><i class="'+(opts.icons&&opts.icons.clear||$.bsDatepicker.default.icons.clear)+'"></i></button>';html+="    </div>";html+="  </div>";html+='  <div class="pt-2">';if(opts.inline){const isRange=!!opts.range;const dispOpts=$.extend({},opts,{format:"locale"});let text="";if(isRange){const pair=clampRange(state.rangeStart,state.selected);text=formatDateValue(pair,dispOpts)}else{text=formatDateValue(state.selected,dispOpts)}const placeholder=opts.placeholder;const clsMuted=text?"":" text-muted";html+='    <div class="mb-2 small text-center dp-inline-output'+clsMuted+'">'+(text||placeholder)+"</div>"}const monthsWrapStyle=months>1?"max-width: calc(600px + .5rem)":"max-width: 100%";html+='    <div class="dp-months d-inline-flex flex-wrap align-items-start gap-2" style="'+monthsWrapStyle+'">';for(let i=0;i<months;i++){html+='      <div class="dp-month" style="width:300px; flex:0 0 300px">';html+=renderOneMonthBlock(addMonths(current,i),state);html+="      </div>"}html+="    </div>";html+="  </div>";html+="</div>";return html}function attachEvents(state){const{$panel,opts}=state;$panel.off("."+NS);$panel.on("click."+NS,'[data-action="prev"]',function(e){e.preventDefault();state.current=addMonths(state.current,-1);updatePanel(state);emit(state,"navigate",{action:"prev",current:new Date(state.current)})});$panel.on("click."+NS,'[data-action="prevYear"]',function(e){e.preventDefault();state.current=addMonths(state.current,-12);updatePanel(state);emit(state,"navigate",{action:"prevYear",current:new Date(state.current)})});$panel.on("click."+NS,'[data-action="next"]',function(e){e.preventDefault();state.current=addMonths(state.current,+1);updatePanel(state);emit(state,"navigate",{action:"next",current:new Date(state.current)})});$panel.on("click."+NS,'[data-action="nextYear"]',function(e){e.preventDefault();state.current=addMonths(state.current,+12);updatePanel(state);emit(state,"navigate",{action:"nextYear",current:new Date(state.current)})});$panel.on("click."+NS,'[data-action="today"]',function(e){e.preventDefault();const t=new Date;state.current=new Date(t.getFullYear(),t.getMonth(),1);updatePanel(state);emit(state,"navigate",{action:"today",current:new Date(state.current)})});$panel.on("click."+NS,'[data-action="clear"]',function(e){e.preventDefault();state.rangeStart=null;state.selected=null;if(state.$display)updateDisplay(state);if(state.$inStart)state.$inStart.val("").trigger("change");if(state.$inEnd)state.$inEnd.val("").trigger("change");if(state.$input&&!state.$display)state.$input.val("").trigger("change");updatePanel(state);emit(state,"clear",{});emit(state,"changeDate",{value:opts.range?[null,null]:null})});$panel.on("click."+NS,'[data-action="pick"]',function(e){e.preventDefault();const stamp=$(this).data("date");const d=startOfDay(new Date(typeof stamp==="number"?stamp:Number(stamp)));if(isDisabledDate(d,state))return;if(opts.range){const S=state.rangeStart;const E=state.selected;if(S&&isSameDay(d,S)){if(!E){state.rangeStart=d;updatePanel(state);return}state.rangeStart=null;updatePanel(state);return}if(E&&isSameDay(d,E)){state.selected=null;updatePanel(state);return}if(!S&&!E){state.rangeStart=d;state.selected=null;updatePanel(state)}else if(S&&!E){if(d<S){state.selected=S;state.rangeStart=d}else{state.selected=d}updatePanel(state)}else if(!S&&E){if(d<=E){state.rangeStart=d}else{state.rangeStart=E;state.selected=d}updatePanel(state)}else if(S&&E){if(d<=S){state.rangeStart=d}else if(d>=E){state.selected=d}else{const distToStart=d-S;const distToEnd=E-d;if(distToStart<=distToEnd){state.rangeStart=d}else{state.selected=d}}updatePanel(state)}const[a,b]=clampRange(state.rangeStart,state.selected);emit(state,"changeDate",{value:[a||null,b||null]})}else{state.selected=d;if(state.$display||state.$inStart){const toLocalISO=x=>x?function(d){const y=d.getFullYear();const m=String(d.getMonth()+1).padStart(2,"0");const day=String(d.getDate()).padStart(2,"0");return y+"-"+m+"-"+day}(x):"";if(state.$inStart)state.$inStart.val(toLocalISO(state.selected)).trigger("change");if(state.$display)updateDisplay(state)}else if(state.$input){state.$input.val(formatDateValue(state.selected,state.opts)).trigger("change")}if(!opts.inline&&opts.autoClose)hideDropdown(state);updatePanel(state);emit(state,"changeDate",{value:state.selected})}})}function updatePanel(state){const html=renderTemplate(state);state.$panel.html(html);emit(state,"render",{current:new Date(state.current),range:!!state.opts.range});(function syncOutputs(){const isRange=!!state.opts.range;const dispOpts=$.extend({},state.opts,{format:"locale"});const toLocalISO=d=>d?function(x){const y=x.getFullYear();const m=String(x.getMonth()+1).padStart(2,"0");const day=String(x.getDate()).padStart(2,"0");return y+"-"+m+"-"+day}(d):"";if(isRange){const S=state.rangeStart;const E=state.selected;let a=S||null,b=E||null;if(S&&!E){b=S}else if(!S&&E){a=E}else if(S&&E){const pair=clampRange(S,E);a=pair[0];b=pair[1]}if(state.$display)updateDisplay(state);if(state.$inStart)state.$inStart.val(toLocalISO(a));if(state.$inEnd)state.$inEnd.val(toLocalISO(b));if(state.$input&&!state.$display)state.$input.val(formatDateValue([a,b],state.opts))}else{const d=state.selected;if(state.$display)updateDisplay(state);if(state.$inStart)state.$inStart.val(toLocalISO(d));if(state.$input&&!state.$display)state.$input.val(formatDateValue(d,state.opts))}})();attachEvents(state);if(!state.opts.inline&&state.$container&&state.$container.is(":visible")){applyCalculatedWidth(state)}}function showDropdown(state){if(state.opts.inline)return;const $anchor=state.$anchor||state.$input;const off=$anchor.offset();const h=$anchor.outerHeight();state.$container.css({position:"absolute",top:off.top+h+4,left:off.left,zIndex:state.opts.zIndex,width:"auto"}).addClass("show").show();applyCalculatedWidth(state);emit(state,"show",{});$(document).on("mousedown."+NS,function(ev){const $t=$(ev.target);if($t.closest(state.$container).length===0&&$t.closest($anchor).length===0){hideDropdown(state)}})}function applyCalculatedWidth(state){const $card=state.$panel.children(".card");if($card.length===0)return;const $body=$card.children(".card-body");let bodyPaddingX=0;if($body.length){const bs=getComputedStyle($body[0]);bodyPaddingX=(parseFloat(bs.paddingLeft)||0)+(parseFloat(bs.paddingRight)||0)}const $wrap=$body.children().first();if($wrap.length===0)return;let $months=$wrap.children(".col-auto");if($months.length===0){$months=$wrap.children(".d-inline-block")}if($months.length===0)return;const m0=$months.eq(0).outerWidth(true);let monthsWidth=m0;if($months.length>=2){const m1=$months.eq(1).outerWidth(true);monthsWidth=m0+m1}const targetWidth=monthsWidth+bodyPaddingX;$card.css("width",Math.ceil(targetWidth+1)+"px");state.$container.css({width:Math.ceil(targetWidth+1)+"px"})}function hideDropdown(state){if(state.opts.inline)return;state.$container.removeClass("show").hide();const $anchor=state.$anchor||state.$input;if($anchor&&$anchor.length){$anchor.trigger("blur")}state.suppressOpenUntil=Date.now()+150;$(document).off("mousedown."+NS);emit(state,"hide",{})}function create(state){const{opts}=state;state.current=startOfDay(new Date);state.selected=null;state.rangeStart=null;if(opts.inline){state.$container=$('<div class="bs-datepicker inline form-control p-2 d-inline-block w-auto"></div>').appendTo(state.$root)}else{state.$container=$('<div class="bs-datepicker dropdown-menu p-0" style="display:none; --bs-dropdown-min-width:auto;"></div>').appendTo("body")}state.$panel=$("<div></div>").appendTo(state.$container);updatePanel(state);if(!opts.inline){state.$container.removeClass("show").hide()}if(!opts.inline){const $anchor=state.$anchor||state.$input;if($anchor&&$anchor.length){$anchor.on("click."+NS,function(){if(state.$container.is(":visible"))return;if(state.suppressOpenUntil&&Date.now()<state.suppressOpenUntil)return;showDropdown(state)});$anchor.on("keydown."+NS,function(ev){const key=ev.key||ev.code;if(key==="Enter"||key===" "||key==="Spacebar"){ev.preventDefault();if(state.$container.is(":visible"))return;if(state.suppressOpenUntil&&Date.now()<state.suppressOpenUntil)return;showDropdown(state)}})}}emit(state,"init",{range:!!state.opts.range,inline:!!opts.inline,months:opts.months})}function destroy(state){hideDropdown(state);if(state.$container)state.$container.remove();if(state.$anchor)state.$anchor.off("."+NS);if(state.$input)state.$input.off("."+NS);const $dataEl=state.containerMode?state.$root:state.$input;if($dataEl)$dataEl.removeData(NS);$(document).off("."+NS);emit(state,"destroy",{})}const methods={getDate(){const state=this.data(NS);if(!state)return null;if(state.opts.range){return[state.rangeStart,state.selected].filter(Boolean)}return state.selected},val(a,b){const state=this.data(NS);if(!state)return arguments.length===0?"":this;function toIso(d){if(!d)return"";const y=d.getFullYear();const m=("0"+(d.getMonth()+1)).slice(-2);const dd=("0"+d.getDate()).slice(-2);return y+"-"+m+"-"+dd}if(arguments.length===0){if(state.opts.range){if(state.$inStart||state.$inEnd){const s=state.$inStart?state.$inStart.val():"";const e=state.$inEnd?state.$inEnd.val():"";return[s,e]}return[toIso(state.rangeStart),toIso(state.selected)]}if(state.$inStart){return state.$inStart.val()}return toIso(state.selected)}if(state.opts.range){let a1=a,b1=b;if(Array.isArray(a)){a1=a[0];b1=a[1]}state.rangeStart=a1?toDateOrNull(a1):null;state.selected=b1?toDateOrNull(b1):null;if(state.rangeStart&&isDisabledDate(state.rangeStart,state))state.rangeStart=null;if(state.selected&&isDisabledDate(state.selected,state))state.selected=null}else{state.selected=a?toDateOrNull(a):null;if(state.selected&&isDisabledDate(state.selected,state))state.selected=null}updatePanel(state);return this},setDate(dateOrRange){const state=this.data(NS);if(!state)return this;if(Array.isArray(dateOrRange)){state.rangeStart=dateOrRange[0]?startOfDay(new Date(dateOrRange[0])):null;state.selected=dateOrRange[1]?startOfDay(new Date(dateOrRange[1])):null;if(state.rangeStart&&isDisabledDate(state.rangeStart,state))state.rangeStart=null;if(state.selected&&isDisabledDate(state.selected,state))state.selected=null}else if(dateOrRange){state.selected=startOfDay(new Date(dateOrRange));if(state.selected&&isDisabledDate(state.selected,state))state.selected=null}else{state.selected=null;state.rangeStart=null}updatePanel(state);return this},destroy(){const state=this.data(NS);if(state)destroy(state);return this}};$.fn.bsDatepicker=function(optionsOrMethod){if(this.length===0)return this;if(this.length>1){return this.each(function(){$(this).bsDatepicker(optionsOrMethod)})}const $element=this;if(typeof optionsOrMethod==="string"){const method=optionsOrMethod;if(methods[method]){return methods[method].apply($element,Array.prototype.slice.call(arguments,1))}return $element}const opts=$.extend({},$.bsDatepicker.default,optionsOrMethod||{});const isDirectInput=$element.is("input, textarea");const state={$input:null,$root:$element,$anchor:null,$display:null,$displayText:null,$inStart:null,$inEnd:null,containerMode:false,opts:opts,$container:null,$panel:null,current:null,selected:null,rangeStart:null,suppressOpenUntil:0};function initBindings(){if(isDirectInput){state.$input=$element;state.$anchor=state.$input;state.containerMode=false}else{const $inputs=state.$root.find("input");const $hidden=$inputs.filter('[type="hidden"]');const list=$hidden.length?$hidden:$inputs;if(list.length>=1)state.$inStart=$(list[0]);if(list.length>=2)state.$inEnd=$(list[1]);if(list.length>=2)state.opts.range=true;else state.opts.range=false;if(state.opts.inline){state.$display=null;state.$displayText=null;state.$anchor=null;state.containerMode=true}else{const cls=state.opts.classes||{};const dispCls=(cls.display||$.bsDatepicker.default.classes.display||"").trim();const textCls=(cls.displayText||$.bsDatepicker.default.classes.displayText||"").trim();const iconCls=(cls.displayIcon||$.bsDatepicker.default.classes.displayIcon||"").trim();state.$display=$('<div role="button" tabindex="0" class="dp-display '+dispCls+'"></div>');state.$displayText=$('<span class="dp-display-text '+textCls+'"></span>');const $icon=$('<i class="dp-display-icon '+iconCls+'"></i>');state.$display.append(state.$displayText).append($icon);state.$root.append(state.$display);state.$anchor=state.$display;state.containerMode=true}}}initBindings();(state.containerMode?state.$root:state.$input).data(NS,state);if(!state.containerMode){state.$input=state.$anchor}state.disabled=normalizeDisabled(state.opts.disabled);create(state);return state.containerMode?state.$root:state.$input};function updateDisplay(state){if(!state.$display)return;const isRange=!!state.opts.range;const dispOpts=$.extend({},state.opts,{format:"locale"});let text="";if(isRange){const[a,b]=clampRange(state.rangeStart,state.selected);text=formatDateValue([a,b],dispOpts)}else{text=formatDateValue(state.selected,dispOpts)}const placeholder=state.opts.placeholder;if(state.$displayText&&state.$displayText.length){state.$displayText.text(text||placeholder);state.$display.toggleClass("text-muted",!text)}else{state.$display.text(text||placeholder)}}const _old=$.fn.bsDatepicker;$.fn.bsDatepicker=function(optionsOrMethod){if(typeof optionsOrMethod==="string"){const args=Array.prototype.slice.call(arguments,1);if(optionsOrMethod==="setLocale"){return this.each(function(){const $el=$(this);const state=$el.data(NS)||$el.find(".dp-display").data(NS)||$el.data(NS);if(!state)return;const newLocale=args[0];if(typeof newLocale==="string"&&newLocale.trim()){state.opts.locale=newLocale.trim();updatePanel(state);emit(state,"setLocale",{locale:state.opts.locale})}})}if(optionsOrMethod==="setDisableDates"){return this.each(function(){const $el=$(this);const state=$el.data(NS)||$el.find(".dp-display").data(NS)||$el.data(NS);if(!state)return;state.disabled=normalizeDisabled(args[0]||null);const purge=function(d){return d&&isDisabledDate(d,state)?null:d};state.selected=purge(state.selected);state.rangeStart=purge(state.rangeStart);updatePanel(state);emit(state,"setDisableDates",{disabled:state.disabled})})}if(optionsOrMethod==="getDisableDates"){const $el=this.eq(0);const state=$el.data(NS)||$el.find(".dp-display").data(NS)||$el.data(NS);return state?state.disabled:null}if(optionsOrMethod==="setMin"){return this.each(function(){const state=$(this).data(NS);if(!state)return;const newMin=toDateOrNull(args[0]);const cfg={before:state.disabled?state.disabled.before:null,after:state.disabled?state.disabled.after:null,min:newMin,max:state.disabled?state.disabled.max:null,dates:state.disabled&&state.disabled.datesSet?Array.from(state.disabled.datesSet).map(function(t){return new Date(t)}):[]};state.disabled=normalizeDisabled(cfg);state.selected=state.selected&&isDisabledDate(state.selected,state)?null:state.selected;state.rangeStart=state.rangeStart&&isDisabledDate(state.rangeStart,state)?null:state.rangeStart;updatePanel(state);emit(state,"setMin",{min:state.disabled.min||null})})}if(optionsOrMethod==="setMax"){return this.each(function(){const state=$(this).data(NS);if(!state)return;const newMax=toDateOrNull(args[0]);const cfg={before:state.disabled?state.disabled.before:null,after:state.disabled?state.disabled.after:null,min:state.disabled?state.disabled.min:null,max:newMax,dates:state.disabled&&state.disabled.datesSet?Array.from(state.disabled.datesSet).map(function(t){return new Date(t)}):[]};state.disabled=normalizeDisabled(cfg);state.selected=state.selected&&isDisabledDate(state.selected,state)?null:state.selected;state.rangeStart=state.rangeStart&&isDisabledDate(state.rangeStart,state)?null:state.rangeStart;updatePanel(state);emit(state,"setMax",{max:state.disabled.max||null})})}if(optionsOrMethod==="clearDisableDates"){return this.each(function(){const state=$(this).data(NS);if(!state)return;state.disabled=normalizeDisabled(null);updatePanel(state);emit(state,"clearDisableDates",{})})}}return _old.apply(this,arguments)}})(jQuery);