(function($){"use strict";$.bsCalendar={version:"2.0.7",setDefaults:function(options){this.DEFAULTS=$.extend(true,{},this.DEFAULTS,options||{})},getDefaults:function(){return this.DEFAULTS},DEFAULTS:{locale:"en-GB",title:null,startWeekOnSunday:true,navigateOnWheel:true,rounded:5,border:"border border-0 rounded-0 shadow",search:{limit:10,offset:0},startDate:new Date,startView:"month",mainColor:"primary",views:["year","month","week","day"],holidays:null,showAddButton:true,translations:{search:"Type and press Enter",searchNoResult:"No appointment found"},icons:{day:"bi bi-calendar-day",week:"bi bi-kanban",month:"bi bi-calendar-month",year:"bi bi-calendar4",add:"bi bi-plus-lg",menu:"bi bi-layout-sidebar-inset",search:"bi bi-search",prev:"bi bi-chevron-left",next:"bi bi-chevron-right",link:"bi bi-box-arrow-up-right",appointment:"bi bi-clock",appointmentAllDay:"bi bi-brightness-high"},url:null,queryParams:null,topbarAddons:null,sidebarAddons:null,formatter:{day:formatterDay,week:formatterWeek,allDay:formatterAllDay,month:formatterMonth,search:formatterSearch,holiday:formatterHoliday,window:formatInfoWindow,duration:formatDuration},hourSlots:{height:30,start:0,end:24},calendars:null,onAll:null,onInit:null,onAdd:null,onEdit:null,onDelete:null,onView:null,onBeforeLoad:null,onAfterLoad:null,onShowInfoWindow:null,onHideInfoWindow:null,onNavigateForward:null,onNavigateBack:null,storeState:false,debug:true},utils:{convertIcsToAppointments:icsData=>{const appointments=[];const lines=icsData.replace(/\r\n/g,"\n").replace(/\r/g,"\n").split("\n");const unfoldedLines=[];for(let i=0;i<lines.length;i++){const line=lines[i];if(/^[ \t]/.test(line)&&unfoldedLines.length>0){unfoldedLines[unfoldedLines.length-1]+=line.slice(1)}else{unfoldedLines.push(line.trim())}}let currentEvent=null;const parseIcsDate=val=>{const cleanVal=val.split(":").pop().replace("Z","");const isAllDay=cleanVal.length===8;const y=cleanVal.substring(0,4);const m=cleanVal.substring(4,6);const d=cleanVal.substring(6,8);if(isAllDay){return{dateStr:`${y}-${m}-${d} 00:00:00`,allDay:true}}const h=cleanVal.substring(9,11);const min=cleanVal.substring(11,13);const s=cleanVal.substring(13,15)||"00";return{dateStr:`${y}-${m}-${d} ${h}:${min}:${s}`,allDay:false}};const unescapeText=text=>{return text.replace(/\\n/gi,"\n").replace(/\\N/gi,"\n").replace(/\\,/g,",").replace(/\\;/g,";").replace(/\\\\/g,"\\")};for(const line of unfoldedLines){if(line.trim()==="BEGIN:VEVENT"){currentEvent={ATTENDEES:[]};continue}if(line.trim()==="END:VEVENT"){if(currentEvent){const startRaw=currentEvent.DTSTART||"";const endRaw=currentEvent.DTEND||null;if(startRaw){const startData=parseIcsDate(startRaw);let endData=endRaw?parseIcsDate(endRaw):null;if(!endData){endData={dateStr:startData.dateStr,allDay:startData.allDay}}const appt={title:unescapeText(currentEvent.SUMMARY||"No Title"),description:unescapeText(currentEvent.DESCRIPTION||""),location:unescapeText(currentEvent.LOCATION||""),link:currentEvent.URL||null,categories:currentEvent.CATEGORIES?unescapeText(currentEvent.CATEGORIES):null,status:currentEvent.STATUS||null,organizer:currentEvent.ORGANIZER||null,attendees:currentEvent.ATTENDEES.length>0?currentEvent.ATTENDEES:null,start:startData.dateStr,end:endData.dateStr,allDay:startData.allDay};if(currentEvent.UID){appt.id=currentEvent.UID}appointments.push(appt)}}currentEvent=null;continue}if(currentEvent){const colonIndex=line.indexOf(":");if(colonIndex>-1){const keyPart=line.substring(0,colonIndex);const valuePart=line.substring(colonIndex+1);const mainKey=keyPart.split(";")[0];if(["SUMMARY","DESCRIPTION","LOCATION","UID","URL","CATEGORIES","STATUS","ORGANIZER"].includes(mainKey)){currentEvent[mainKey]=valuePart}else if(mainKey==="ATTENDEE"){currentEvent.ATTENDEES.push(valuePart)}else if(mainKey==="DTSTART"){currentEvent.DTSTART=line}else if(mainKey==="DTEND"){currentEvent.DTEND=line}}}}return appointments},openHolidayApi:{async getSubdivisions(countryIsoCode,languageIsoCode){if(!countryIsoCode){throw new Error("The parameter 'countryIsoCode' is required and cannot be null or undefined.")}if(!languageIsoCode){throw new Error("The parameter 'languageIsoCode' is required and cannot be null or undefined.")}const params={countryIsoCode:countryIsoCode.toUpperCase(),languageIsoCode:languageIsoCode.toUpperCase()};const queryString=Object.keys(params).map(key=>`${key}=${encodeURIComponent(params[key])}`).join("&");const url=`https://openholidaysapi.org/Subdivisions?${queryString}`;const response=await fetch(url,{method:"GET",headers:{Accept:"application/json"}});if(!response.ok){throw new Error(`Errors when receiving the Subdivisions: ${response.statusText}`)}return await response.json()},async getLanguages(languageIsoCode){if(!languageIsoCode){throw new Error("The parameter 'languageIsoCode' is required and cannot be null or undefined.")}const params={languageIsoCode:languageIsoCode.toUpperCase()};const queryString=Object.keys(params).map(key=>`${key}=${encodeURIComponent(params[key])}`).join("&");const url=`https://openholidaysapi.org/Languages?${queryString}`;const response=await fetch(url,{method:"GET",headers:{Accept:"application/json"}});if(!response.ok){throw new Error(`Errors when receiving the Languages: ${response.statusText}`)}return await response.json()},async getCountries(languageIsoCode){if(!languageIsoCode){throw new Error("The parameter 'languageIsoCode' is required and cannot be null or undefined.")}const params={languageIsoCode:languageIsoCode.toUpperCase()};const queryString=Object.keys(params).map(key=>`${key}=${encodeURIComponent(params[key])}`).join("&");const url=`https://openholidaysapi.org/Countries?${queryString}`;const response=await fetch(url,{method:"GET",headers:{Accept:"application/json"}});if(!response.ok){throw new Error(`Errors when receiving the Countries: ${response.statusText}`)}return await response.json()},async getSchoolHolidays(country,federalState,validFrom,validTo){if(!country){throw new Error("The parameter 'country' is required and cannot be null or undefined.")}if(!validFrom){throw new Error("The parameter 'validFrom' is required and cannot be null or undefined.")}if(!validTo){throw new Error("The parameter 'validTo' is required and cannot be null or undefined.")}let countryIsoCode=country.toUpperCase();let params={countryIsoCode:countryIsoCode,validFrom:validFrom,validTo:validTo};if(federalState){let subdivisionCode=federalState.toUpperCase();if(subdivisionCode.length===2){params.subdivisionCode=`${countryIsoCode}-${subdivisionCode}`}}const queryString=Object.keys(params).map(key=>`${key}=${encodeURIComponent(params[key])}`).join("&");const url=`https://openholidaysapi.org/SchoolHolidays?${queryString}`;const response=await fetch(url,{method:"GET",headers:{Accept:"application/json"}});if(!response.ok){throw new Error(`Errors when receiving the holidays: ${response.statusText}`)}return await response.json()},async getPublicHolidays(country,federalState=null,language,validFrom,validTo){if(!country){throw new Error("The parameter 'country' is required and cannot be null or undefined.")}if(!language){throw new Error("The parameter 'language' is required and cannot be null or undefined.")}if(!validFrom){throw new Error("The parameter 'validFrom' is required and cannot be null or undefined.")}if(!validTo){throw new Error("The parameter 'validTo' is required and cannot be null or undefined.")}const countryIsoCode=country.toUpperCase();const languageIsoCode=language.toUpperCase();const params={countryIsoCode:countryIsoCode,languageIsoCode:languageIsoCode,validFrom:validFrom,validTo:validTo};if(federalState){params.subdivisionCode=`${countryIsoCode}-${federalState.toUpperCase()}`}const queryString=Object.keys(params).map(key=>`${key}=${encodeURIComponent(params[key])}`).join("&");const url=`https://openholidaysapi.org/PublicHolidays?${queryString}`;const response=await fetch(url,{method:"GET",headers:{Accept:"application/json"}});if(!response.ok){throw new Error(`Errors when calling up the holidays: ${response.statusText}`)}return await response.json()}},formatTime:(date,withSeconds=true)=>{if(typeof date==="string"){date=new Date(date)}if(isNaN(date.getTime())){console.error("Invalid date in formatTime:",date);return null}const hours=date.getHours().toString().padStart(2,"0");const minutes=date.getMinutes().toString().padStart(2,"0");const seconds=date.getSeconds().toString().padStart(2,"0");if(!withSeconds){return`${hours}:${minutes}`}return`${hours}:${minutes}:${seconds}`},getCalendarWeek:date=>{const target=new Date(Date.UTC(date.getFullYear(),date.getMonth(),date.getDate()));const dayNr=(target.getUTCDay()+6)%7;target.setUTCDate(target.getUTCDate()-dayNr+3);const firstThursday=new Date(Date.UTC(target.getUTCFullYear(),0,4));const firstDayOfWeek=firstThursday.getUTCDate()-(firstThursday.getUTCDay()+6)%7;return Math.floor(1+(target-new Date(Date.UTC(target.getUTCFullYear(),0,firstDayOfWeek)))/(7*24*60*60*1e3))},getShortWeekDayNames:(locale,startWeekOnSunday)=>{const formatter=new Intl.DateTimeFormat(locale,{weekday:"short"});const weekDays=[...Array(7).keys()].map(day=>formatter.format(new Date(Date.UTC(2023,0,day+1))));return startWeekOnSunday?weekDays:weekDays.slice(1).concat(weekDays[0])},formatDateToDateString:date=>{const dateObj=typeof date==="string"?new Date(date):date;const year=dateObj.getFullYear();const month=String(dateObj.getMonth()+1).padStart(2,"0");const day=String(dateObj.getDate()).padStart(2,"0");return`${year}-${month}-${day}`},datesAreEqual:(date1,date2)=>{return date1.getFullYear()===date2.getFullYear()&&date1.getMonth()===date2.getMonth()&&date1.getDate()===date2.getDate()},colorNameToHex:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},computeColor:inputColor=>{if($.bsCalendar.utils.isDirectColorValid(inputColor)){const resolvedColor=$.bsCalendar.utils.resolveColor(inputColor);const isDark=$.bsCalendar.utils.isDarkColor(resolvedColor);return{backgroundColor:resolvedColor,backgroundImage:"none",color:isDark?"#FFFFFF":"#000000"}}else if(inputColor){return $.bsCalendar.utils.getComputedStyles(inputColor)}return null},getComputedStyles:inputClassNames=>{const classList=inputClassNames.split(" ").map(className=>{if(className.includes("opacity")||className.includes("gradient")){return className.startsWith("bg-")?className:`bg-${className}`}else{return className.startsWith("bg-")?className.replace("bg-","text-bg-"):`text-bg-${className}`}});const tempElement=document.createElement("div");tempElement.style.display="none";tempElement.style.position="absolute";document.body.appendChild(tempElement);classList.forEach(className=>{tempElement.classList.add(className)});const computedStyles=window.getComputedStyle(tempElement);const backgroundColor=computedStyles.backgroundColor||"rgba(0, 0, 0, 0)";const backgroundImage=computedStyles.backgroundImage||"none";const color=computedStyles.color||"#000000";const opacity=computedStyles.opacity||"1";document.body.removeChild(tempElement);let adjustedBackgroundColor=backgroundColor;if(backgroundColor.startsWith("rgb")&&parseFloat(opacity)<1){const matchRgb=backgroundColor.match(/rgba?\((\d+),\s*(\d+),\s*(\d+)/);if(matchRgb){const r=matchRgb[1];const g=matchRgb[2];const b=matchRgb[3];adjustedBackgroundColor=`rgba(${r}, ${g}, ${b}, ${opacity})`}}return{backgroundColor:adjustedBackgroundColor,backgroundImage:backgroundImage,color:color,classList:classList,origin:inputClassNames}},isDirectColorValid:inputColor=>{if(!inputColor||typeof inputColor!=="string"){return false}const hexPattern=/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/;const rgbPattern=/^rgba?\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})(?:,\s*(0|0?\.\d+|1))?\s*\)$/;return hexPattern.test(inputColor)||rgbPattern.test(inputColor)||inputColor.toLowerCase()in $.bsCalendar.utils.colorNameToHex},resolveColor:inputColor=>{if(inputColor.toLowerCase()in $.bsCalendar.utils.colorNameToHex){return $.bsCalendar.utils.colorNameToHex[inputColor.toLowerCase()]}return inputColor},isDarkColor:color=>{color=$.bsCalendar.utils.resolveColor(color);let r,g,b;if(color.startsWith("#")){if(color.length===4){color="#"+color[1]+color[1]+color[2]+color[2]+color[3]+color[3]}r=parseInt(color.slice(1,3),16);g=parseInt(color.slice(3,5),16);b=parseInt(color.slice(5,7),16)}else if(color.startsWith("rgb")){const rgbValues=color.match(/\d+/g);r=parseInt(rgbValues[0]);g=parseInt(rgbValues[1]);b=parseInt(rgbValues[2])}else{throw new Error("Unsupported color format")}const yiq=(r*299+g*587+b*114)/1e3;return yiq<=128},getColors:(color,fallbackColor=null)=>{const primaryResult=$.bsCalendar.utils.computeColor(color);const fallbackResult=primaryResult||$.bsCalendar.utils.computeColor(fallbackColor);const defaultValues={backgroundColor:"#000000",backgroundImage:"none",color:"#FFFFFF"};const result={...defaultValues,...fallbackResult};return{origin:color,...result}},normalizeDateTime:dateTime=>{if(typeof dateTime==="string"){return dateTime.replace(" ","T")}return dateTime},formatDateByLocale:(date,locale)=>{if(typeof date==="string"){date=new Date(date)}const options={weekday:"long",month:"long",day:"numeric"};return new Intl.DateTimeFormat(locale,options).format(date)},generateRandomString(length=8,prefix="bs_calendar_id_"){const chars="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";let result="";for(let i=0;i<length;i++){result+=chars.charAt(Math.floor(Math.random()*chars.length))}return prefix+result},getStandardizedUnits:locale=>{const units=["today","day","week","month","year"];const result={};const validRelativeTimeFormatUnits=["day","week","month","year"];units.forEach(unit=>{let localizedUnit;if(locale==="ar"){const arabicTranslations={today:"اليوم",day:"يوم",week:"أسبوع",month:"شهر",year:"سنة"};localizedUnit=arabicTranslations[unit]}else if(locale==="he"){const hebrewTranslations={today:"היום",day:"יום",week:"שבוע",month:"חודש",year:"שנה"};localizedUnit=hebrewTranslations[unit]}else if(locale==="zh"){const chineseTranslations={today:"今天",day:"天",week:"周",month:"月",year:"年"};localizedUnit=chineseTranslations[unit]}else{try{if(unit==="today"){localizedUnit=new Intl.RelativeTimeFormat(locale,{numeric:"auto"}).format(0,"day")}else if(validRelativeTimeFormatUnits.includes(unit)){const formatter=new Intl.RelativeTimeFormat(locale,{numeric:"always"});const formatted=formatter.format(1,unit);localizedUnit=formatted.replace(/^\D*\d+\s?/,"").replace(/後|后$/,"").replace(/\s후$/,"").replace(/^ในอีก\s?/,"").trim()}else{console.error(`${unit} ist keine gültige Einheit für Intl.RelativeTimeFormat.`)}}catch(error){console.error(`Fehler für ${unit} mit Locale ${locale}:`,error.message);localizedUnit=unit}}result[unit]=localizedUnit||unit});return result},getLanguageAndCountry:locale=>{const parts=locale.split("-");let language=parts[0].toUpperCase();let country=parts[1]?parts[1].toUpperCase():language;return{language:language,country:country}},isValueEmpty:value=>{if(value===null||value===undefined){return true}if(Array.isArray(value)){return value.length===0}if(typeof value==="string"){return value.trim().length===0}if(typeof value==="object"){return Object.keys(value).length===0&&value.constructor===Object}return false},getAppointmentTimespanBeautify(extras,withDuration=true){const locale=extras.locale;const displayDates=extras.displayDates;const startDate=$.bsCalendar.utils.formatDateByLocale(displayDates[0].date,locale);const endDate=$.bsCalendar.utils.formatDateByLocale(displayDates[displayDates.length-1].date,locale);const isSameDate=startDate===endDate;let showTime=isSameDate?startDate:`${startDate} - ${endDate}`;if(!extras.allDay){let startTime=extras.displayDates[0].times.start.substring(0,5);let endTime=extras.displayDates[displayDates.length-1].times.end.substring(0,5);if(isSameDate){showTime=`${startDate} ${startTime} - ${endTime}`}else{showTime=`${startDate} ${startTime}<br>${endDate} ${endTime}`}}return!withDuration?showTime:`${showTime}  (${extras.duration.formatted})`}}};const globalCalendarElements={wrapper:".bs-calendar-wrapper",infoModal:"#wcCalendarInfoWindowModal"};let globalEventsInitialized=false;const namespace=".bs.calendar";$.fn.bsCalendar=function(optionsOrMethod,params){if(this.length>1){return this.each(function(i,e){return $(e).bsCalendar(optionsOrMethod,params)})}const wrapper=this;const existingData=wrapper.data("bsCalendar");const isInitialized=!!existingData&&typeof existingData==="object";const optionsGiven=optionsOrMethod!==null&&optionsOrMethod!==undefined&&typeof optionsOrMethod==="object"&&!Array.isArray(optionsOrMethod);const methodGiven=typeof optionsOrMethod==="string";if(!isInitialized){wrapper.addClass(globalCalendarElements.wrapper.substring(1));const bsCalendarData={elements:{wrapperId:$.bsCalendar.utils.generateRandomString(8),wrapperSmallMonthCalendarId:$.bsCalendar.utils.generateRandomString(8),wrapperSmallMonthCalendarTitleId:$.bsCalendar.utils.generateRandomString(8),wrapperViewContainerId:$.bsCalendar.utils.generateRandomString(8),wrapperViewContainerTitleId:$.bsCalendar.utils.generateRandomString(8),wrapperTopNavId:$.bsCalendar.utils.generateRandomString(8),wrapperSideNavId:$.bsCalendar.utils.generateRandomString(8),wrapperCalendarsId:$.bsCalendar.utils.generateRandomString(8),wrapperSearchNavId:$.bsCalendar.utils.generateRandomString(8)},loading:false,loadingHolidays:false,settings:$.bsCalendar.getDefaults(),appointments:[],date:new Date,lastView:null,view:null,dataBefore:snapshotWrapperState(wrapper),searchMode:false,searchPagination:null,xhrs:{appointments:null},mainColor:null,borderBefore:null};if(wrapper.data()){bsCalendarData.settings=$.extend(true,{},bsCalendarData.settings,wrapper.data())}if(optionsGiven){bsCalendarData.settings=$.extend(true,{},bsCalendarData.settings,optionsOrMethod)}const ignoreStoreFlag=bsCalendarData.settings.ignoreStore===true||bsCalendarData.settings.ingoreStore===true;if(bsCalendarData.settings.hasOwnProperty("ingoreStore")){delete bsCalendarData.settings.ingoreStore}if(bsCalendarData.settings.hasOwnProperty("ignoreStore")){delete bsCalendarData.settings.ignoreStore}if(bsCalendarData.settings.hasOwnProperty("border")){bsCalendarData.borderBefore=bsCalendarData.settings.border}const ignoreStore=ignoreStoreFlag===true;normalizeSettings(bsCalendarData.settings);bsCalendarData.settings.translations=$.extend(true,{},bsCalendarData.settings.translations,$.bsCalendar.utils.getStandardizedUnits(bsCalendarData.settings.locale)||{});bsCalendarData.mainColor=$.bsCalendar.utils.getColors(bsCalendarData.settings.mainColor,"primary");setBsCalendarData(wrapper,bsCalendarData);if(!ignoreStore&&bsCalendarData.settings.storeState){try{const view=getFromLocalStorage(wrapper,"view");if(!$.bsCalendar.utils.isValueEmpty(view)){bsCalendarData.settings.startView=view;updateSettings(wrapper,bsCalendarData.settings)}}catch(e){if(bsCalendarData.settings&&bsCalendarData.settings.debug){log("Error reading view from storage during init:",e)}}}init(wrapper).then(()=>{onResize(wrapper,true)}).catch(err=>{if(bsCalendarData.settings&&bsCalendarData.settings.debug){log("bsCalendar init failed:",err)}})}if(methodGiven){const inSearchMode=getSearchMode(wrapper);switch(optionsOrMethod){case"refresh":methodRefresh(wrapper,params);break;case"clear":if(!inSearchMode){methodClear(wrapper)}else{if(getSettings(wrapper).debug){log("Attempt to call clear() in search mode — ignored.")}}break;case"updateOptions":methodUpdateOptions(wrapper,params);break;case"destroy":destroy(wrapper);break;case"setDate":if(!inSearchMode){methodSetDate(wrapper,params)}else{if(getSettings(wrapper).debug){log("Attempt to call setDate() in search mode — ignored.")}}break;case"setToday":if(!inSearchMode){setToday(wrapper,params)}else{if(getSettings(wrapper).debug){log("Attempt to call setToday() in search mode — ignored.")}}break;default:const settings=getSettings(wrapper)||{};if(settings.debug){console.warn(`bsCalendar: unknown method "${optionsOrMethod}" called.`)}break}}return wrapper};function setRounded($wrapper,round){const parsed=Number.isFinite(Number(round))?Math.floor(Number(round)):NaN;const normalized=Number.isNaN(parsed)?3:Math.min(Math.max(parsed,0),5);$wrapper.find(".wc-round-me").removeClass("rounded-0 rounded-1 rounded-2 rounded-3 rounded-4 rounded-5").addClass(`rounded-${normalized}`)}function setBorder($wrapper,border){const data=getBsCalendarData(wrapper);const parsed=Number.isFinite(Number(border))?Math.floor(Number(border)):NaN;const normalized=Number.isNaN(parsed)?3:Math.min(Math.max(parsed,0),5);$wrapper.find(".wc-round-me").removeClass(data.borderBefore).addClass(border);data.borderBefore=border;setBsCalendarData(wrapper,data)}function snapshotWrapperState($el){var snap=$.extend(true,{},$el.data());var dom={id:$el.attr("id")||null,class:$el.attr("class")||"",style:$el.attr("style")||""};var dataAttrs={};var node=$el.get(0);if(node&&node.attributes){$.each(node.attributes,function(_,attr){if(attr&&attr.name&&attr.name.indexOf("data-")===0){dataAttrs[attr.name]=attr.value}})}dom.dataAttributes=dataAttrs;var normalizedData={};Object.keys(dataAttrs).forEach(function(k){var nk=k.slice(5);normalizedData[nk]=dataAttrs[k]});dom.normalizedData=normalizedData;var keepAttrs=["title","role","aria-label","aria-describedby"];var extras={};for(var i=0;i<keepAttrs.length;i++){var val=$el.attr(keepAttrs[i]);if(typeof val!=="undefined"){extras[keepAttrs[i]]=val}}dom.attributes=extras;snap.__dom__=dom;snap.__allData__=$.extend({},normalizedData,snap);return snap}function restoreWrapperState($el,snapshot){if(!snapshot||!snapshot.__dom__){return}var dom=snapshot.__dom__;if(typeof dom.class==="string"){$el.attr("class",dom.class)}else{$el.removeAttr("class")}if(typeof dom.style==="string"){if(dom.style.length){$el.attr("style",dom.style)}else{$el.removeAttr("style")}}else{$el.removeAttr("style")}if(dom.id){$el.attr("id",dom.id)}else{$el.removeAttr("id")}var node=$el.get(0);if(node&&node.attributes){var toRemove=[];$.each(node.attributes,function(_,attr){if(attr&&attr.name&&attr.name.indexOf("data-")===0){toRemove.push(attr.name)}});for(var r=0;r<toRemove.length;r++){$el.removeAttr(toRemove[r])}}if(dom.dataAttributes&&typeof dom.dataAttributes==="object"){Object.keys(dom.dataAttributes).forEach(function(k){$el.attr(k,dom.dataAttributes[k])})}var keepAttrs=["title","role","aria-label","aria-describedby"];for(var i=0;i<keepAttrs.length;i++){$el.removeAttr(keepAttrs[i])}if(dom.attributes&&typeof dom.attributes==="object"){Object.keys(dom.attributes).forEach(function(k){var v=dom.attributes[k];if(typeof v!=="undefined"&&v!==null){$el.attr(k,v)}})}}function setBsCalendarData(wrapper,data){if(data.settings.debug){log("**************** setBsCalendarData",data)}wrapper.data("bsCalendar",data)}function getBsCalendarData(wrapper){return wrapper.data("bsCalendar")}function setAppointments(wrapper,appointments){const data=getBsCalendarData(wrapper);if(data.settings.debug){log("setAppointments",appointments)}data.appointments=appointments||[];setBsCalendarData(wrapper,data)}function getAppointments($wrapper){const data=getBsCalendarData($wrapper);return data.appointments||[]}function normalizeSettings(settings){const clamp=(v,min,max)=>Math.min(Math.max(v,min),max);const possibleViews=["day","week","month","year"];if(settings.hasOwnProperty("startDate")){if(typeof settings.startDate==="string"){const date=$.bsCalendar.utils.normalizeDateTime(settings.startDate);settings.startDate=new Date(date)}}if(settings.hasOwnProperty("calendars")){if(Array.isArray(settings.calendars)){let i=1;settings.calendars=settings.calendars.filter(c=>c&&typeof c==="object"&&c.hasOwnProperty("id")&&c.id);settings.calendars.forEach(calendar=>{if(!calendar.hasOwnProperty("title")||typeof calendar.title!=="string"||calendar.title.trim()===""){calendar.title="Calendar "+i}let color=null;if(calendar.hasOwnProperty("color")&&typeof calendar.color==="string"){color=calendar.color}calendar.color=$.bsCalendar.utils.getColors(color,settings.mainColor);if(!calendar.hasOwnProperty("active")||typeof calendar.active!=="boolean"){calendar.active=true}i++});if(settings.calendars.length===0){settings.calendars=null}}else{settings.calendars=null}}if(settings.hasOwnProperty("views")){if(typeof settings.views==="string"){settings.views=settings.views.split(",").map(v=>v.trim()).filter(Boolean)}if(Array.isArray(settings.views)){const seen=new Set;settings.views=settings.views.filter(v=>{if(seen.has(v))return false;seen.add(v);return true});const possibleViews=["day","week","month","year"];settings.views=settings.views.filter(v=>possibleViews.includes(v));if(settings.views.length===0){settings.views=["day","week","month","year"]}}else{settings.views=["day","week","month","year"]}}if(settings.hasOwnProperty("rounded")){const parsed=Number(settings.rounded);if(!Number.isFinite(parsed)||!Number.isInteger(parsed)){settings.rounded=$.bsCalendar.getDefaults().rounded}else{settings.rounded=clamp(parsed,0,5)}}if(settings.hasOwnProperty("hourSlots")&&typeof settings.hourSlots==="object"){settings.hourSlots.start=Number.isFinite(Number(settings.hourSlots.start))?parseInt(settings.hourSlots.start,10):NaN;settings.hourSlots.end=Number.isFinite(Number(settings.hourSlots.end))?parseInt(settings.hourSlots.end,10):NaN;settings.hourSlots.height=Number.isFinite(Number(settings.hourSlots.height))?parseInt(settings.hourSlots.height,10):NaN;if(Number.isNaN(settings.hourSlots.start))settings.hourSlots.start=0;if(Number.isNaN(settings.hourSlots.end))settings.hourSlots.end=24;if(Number.isNaN(settings.hourSlots.height))settings.hourSlots.height=30;settings.hourSlots.start=Math.floor(settings.hourSlots.start);settings.hourSlots.end=Math.floor(settings.hourSlots.end);settings.hourSlots.start=clamp(settings.hourSlots.start,0,24);settings.hourSlots.end=clamp(settings.hourSlots.end,0,24);settings.hourSlots.height=Math.max(Math.floor(settings.hourSlots.height),1);if(settings.hourSlots.start>=settings.hourSlots.end){if(settings.hourSlots.start<24){settings.hourSlots.end=settings.hourSlots.start+1}else{settings.hourSlots.start=23;settings.hourSlots.end=24}}if(settings.hourSlots.end-settings.hourSlots.start<1){if(settings.hourSlots.start<=23){settings.hourSlots.end=settings.hourSlots.start+1}else{settings.hourSlots.start=settings.hourSlots.end-1}}settings.hourSlots.start=clamp(settings.hourSlots.start,0,23);settings.hourSlots.end=clamp(settings.hourSlots.end,1,24)}}function formatterDay(appointment,extras){void extras;return`<small class="px-2">${appointment.title}</small>`}function formatterAllDay(appointment,extras,view){const style={backgroundColor:extras.colors.backgroundColor,backgroundImage:extras.colors.backgroundImage,color:extras.colors.color};const styleString=toStyleString(style);const classes=[];if(view==="week"){classes.push("w-100")}return['<div class="badge px-2 '+classes.join(" ")+'" style="'+styleString+'">',appointment.title,"</div>"].join("")}function toStyleString(styleObj){return Object.entries(styleObj).filter(([_,value])=>value!==undefined&&value!==null).map(([key,value])=>key.replace(/([A-Z])/g,"-$1").toLowerCase()+": "+value+";").join(" ")}function formatterHoliday(holiday,view){const isDayOrWeek=view==="day"||view==="week";const css=["font-size: 12px","line-height: 12px","width: "+(isDayOrWeek?"100%":"auto"),"text-align: "+(view==="day"?"left":"center")].join(";");let badgeClass=isDayOrWeek?"px-2 py-1":"";if(view==="day"){badgeClass+=" d-inline"}return`<div class="${badgeClass}" style="${css}">${holiday.title}</div>`}function formatterWeek(appointment,extras){void extras;return`<small class="px-2" style="font-size: 10px">${appointment.title}</small>`}function formatterMonth(appointment,extras){const startTime=new Date(appointment.start).toLocaleTimeString(extras.locale,{hour:"2-digit",minute:"2-digit"});const timeToShow=appointment.allDay?"":`<small class="me-1">${startTime}</small>`;const icon=`<i class="${extras.icon} me-1"></i>`;const styles=["font-size: 12px","line-height: 18px"].join(";");return[`<div class=" d-flex align-items-center flex-nowrap" style="${styles}">`,icon,timeToShow,`<span class="text-nowrap d-inline-block w-100 text-truncate">${appointment.title}</span>`,`</div>`].join("")}function formatterSearch(appointment,extras){const firstCollStyle=[`border-left-color:${appointment.color}`,`border-left-width:5px`,`border-left-style:dotted`,`cursor:pointer`,`font-size:1.75rem`,`width: 60px`].join(";");const link=buildLink(appointment.link);const day=new Date(appointment.start).getDate();const date=new Date(appointment.start).toLocaleDateString(extras.locale,{month:"short",year:"numeric",weekday:"short"});return[`<div class="d-flex align-items-center justify-content-start g-3 py-1">`,`<div class="day fw-bold text-center" style="${firstCollStyle}" data-date="${$.bsCalendar.utils.formatDateToDateString(new Date(appointment.start))}">`,`${day}`,`</div>`,`<div class="text-muted" style="width: 150px;">`,`${date}`,`</div>`,`<div class="title-container flex-fill text-nowrap d-flex justify-content-between align-items-center">`,`<span>${appointment.title}</span>`+link,`</div>`,`</div>`].join("")}function setToday($wrapper,view){const data=getBsCalendarData($wrapper);const settings=data.settings;let viewChanged=false;if(view&&settings.views.includes(view)){const viewBefore=data.view;if(viewBefore!==view){data.view=view;viewChanged=true}}const date=new Date;data.date=date;setBsCalendarData($wrapper,data);buildByView($wrapper,viewChanged)}function prepareDate(date){if(typeof object==="string"){date=new Date(object)}else if(date instanceof Date){date=object}return date}function prepareParamsForMethodSetDate($wrapper,object){const data=getBsCalendarData($wrapper);const settings=data.settings;let date=null;let view=null;let viewChanged=false;if(typeof object==="string"){date=new Date(object)}else if(object instanceof Date){date=object}else if(typeof object==="object"){if(object.hasOwnProperty("date")){date=prepareDate(object.date)}if(object.hasOwnProperty("view")&&settings.views.includes(object.view)){const viewBefore=data.view;if(viewBefore!==object.view){view=object.view}}}return{date:date,view:view}}function methodSetDate($wrapper,object){const p=prepareParamsForMethodSetDate($wrapper,object);let date=p.date;let view=p.view;let viewChanged=false;if(view){setView($wrapper,view);viewChanged=true}if(date){setDate($wrapper,date)}buildByView($wrapper,viewChanged)}function methodClear($wrapper,removeAppointments=true){$wrapper.find("[data-appointment]").remove();$wrapper.find('[data-role="holiday"]').remove();$wrapper.find(".wc-holiday-marked").each(function(){$(this).removeClass("text-secondary wc-holiday-marked");try{$(this).tooltip("dispose")}catch(e){}});$wrapper.find(".js-badge").text("").removeAttr("style");$wrapper.find(".tooltip").remove();if(removeAppointments){checkAndSetAppointments($wrapper,[]).then(_cleanedAppointments=>{void _cleanedAppointments})}}function abortXhr(xhr){try{if(xhr){if(typeof xhr.abort==="function"){xhr.abort()}else if(xhr instanceof AbortController){xhr.abort()}else if(xhr.signal&&typeof xhr.signal.aborted==="boolean"){if(typeof xhr.abort==="function"){xhr.abort()}}}return true}catch(e){return false}}function destroy($wrapper,callback=null){const data=getBsCalendarData($wrapper);const settings=data.settings;$(globalCalendarElements.infoModal).modal("hide");methodClear($wrapper);try{$(window).off(namespace);$("body").off(namespace);$(document).off(namespace);$wrapper.off(namespace);$wrapper.find("*").off()}catch(e){if(settings&&settings.debug){log("Error while removing namespaced events during destroy:",e)}}const abortXHRAppointments=abortXhr(data.xhrs.appointments);if(!abortXHRAppointments&&settings.debug){log("Error while aborting xhrs.appointments during destroy:",e)}$wrapper.removeClass("position-relative bs-calendar overflow-hidden");$wrapper.removeAttr("data-bs-calendar-id");$wrapper.empty();if($(globalCalendarElements.infoModal).length){try{try{$(globalCalendarElements.infoModal).modal("dispose")}catch(ignore){}$(globalCalendarElements.infoModal).remove()}catch(e){}}restoreWrapperState($wrapper);$wrapper.removeData("bsCalendar");if(typeof callback==="function"){callback()}}function methodUpdateOptions($wrapper,options){if(typeof options!=="object"||!options)return;const data=getBsCalendarData($wrapper);const prevSettings=data.settings||{};const merged=$.extend(true,{},prevSettings,options);normalizeSettings(merged);merged.ingoreStore=true;data.mainColor=$.bsCalendar.utils.getColors(merged.mainColor);data.settings=merged;data.renderState=null;setBsCalendarData($wrapper,data);if(options.hasOwnProperty("startView")&&merged.views.includes(merged.startView)){setView($wrapper,merged.startView)}if(options.hasOwnProperty("startDate")){setDate($wrapper,merged.startDate)}if(typeof merged.title!=="undefined"){$wrapper.find("#"+data.elements.wrapperViewContainerTitleId).html(merged.title||"")}buildByView($wrapper,true);if(merged.storeState){saveToLocalStorage($wrapper,"settings",merged)}}function methodRefresh($wrapper,object){const data=getBsCalendarData($wrapper);const viewBefore=data.view;let changeSettings=false;let changeView=false;if(typeof object==="object"){if(object.hasOwnProperty("url")){data.settings.url=object.url;changeSettings=true}if(object.hasOwnProperty("view")&&data.settings.views.includes(object.view)&&viewBefore!==object.view){data.settings.view=object.view;changeView=true;changeSettings=true}if(object.hasOwnProperty("queryParams")&&typeof object.queryParams==="function"){data.settings.queryParams=object.queryParams;changeSettings=true}}if(changeSettings){setBsCalendarData($wrapper,data)}buildByView($wrapper,changeView)}function formatDuration(duration){const parts=[];if(duration.days>0){parts.push(`${duration.days}d`)}if(duration.hours>0){parts.push(`${duration.hours}h`)}if(duration.minutes>0){parts.push(`${duration.minutes}m`)}if(duration.seconds>0){parts.push(`${duration.seconds}s`)}return parts.length>0?parts.join(" "):"0s"}function buildLink(link){if(!link){return""}const defaultText="Link";const defaultTarget="_blank";const defaultRel="noopener noreferrer";if(typeof link==="string"){return`<a class="btn btn-primary px-5 rounded-pill" href="${link}" target="${defaultTarget}" rel="${defaultRel}">${defaultText}</a>`}if(typeof link==="object"&&link.href){const text=link.text||defaultText;const target=link.target||defaultTarget;const rel=link.rel||defaultRel;const content=link.html||text;return`<a class="btn btn-primary px-5 rounded-pill" href="${link.href}" target="${target}" rel="${rel}">${content}</a>`}return""}async function formatInfoWindow(appointment,extras){const locale=extras.locale;return new Promise((resolve,reject)=>{try{const showTime=$.bsCalendar.utils.getAppointmentTimespanBeautify(extras,true);const link=buildLink(appointment.link);let location="";if(appointment.location){if(Array.isArray(appointment.location)){location=appointment.location.join("<br>")}if(typeof appointment.location==="string"){location=appointment.location}if(location!==""){location=`<p>${location}</p>`}}const desc=appointment.description?`<p>${appointment.description}</p>`:"";const result=[`<h3>${appointment.title}</h3>`,`<p>${showTime}</p>`,location,`${desc}`,link].join("");resolve(result)}catch(error){reject(`Error in formatter.window: ${error.message}`)}})}function log(message,...params){if(window.console&&window.console.log){window.console.log("bsCalendar LOG: "+message,...params)}}function trigger($wrapper,event,...params){const settings=getSettings($wrapper);if(settings.debug){if(params.length>0){log("Triggering event:",event,"with params:",...params)}else{log("Triggering event:",event,"without params")}}if(event!=="all"){$wrapper.trigger(`all${namespace}`,event+namespace,...params);executeFunction(settings.onAll,event+namespace,...params);$wrapper.trigger(`${event}${namespace}`,[...params]);const eventFunctionName=`on${event.split("-").map(word=>word.charAt(0).toUpperCase()+word.slice(1)).join("")}`;executeFunction(settings[eventFunctionName],...params)}}function init($wrapper,initEvents=true,triggerEventInit=true,triggerViewChange=true){return new Promise((resolve,reject)=>{try{const data=getBsCalendarData($wrapper);const settings=data.settings;$wrapper.addClass("position-relative bs-calendar overflow-hidden");$wrapper.attr("data-bs-calendar-id",data.elements.wrapperId);if(!data.settings.hasOwnProperty("views")||data.settings.views.length===0){data.settings.views=["day","week","month","year"]}if(!data.settings.hasOwnProperty("startView")||!data.settings.startView){data.settings.startView="month"}if(!data.settings.views.includes(data.settings.startView)){data.settings.startView=data.settings.views[0]}data.view=settings.startView;data.date=settings.startDate;data.searchMode=false;let searchObject=settings.search&&settings.search.hasOwnProperty("limit")&&settings.search.hasOwnProperty("offset")?{limit:settings.search.limit,offset:settings.search.offset}:null;data.searchPagination=searchObject;setBsCalendarData($wrapper,data);buildFramework($wrapper);if(initEvents){handleEvents($wrapper)}const monthCalendarWrapper=$wrapper.find("#"+data.elements.wrapperSmallMonthCalendarId);buildMonthSmallView($wrapper,data.date,monthCalendarWrapper,false);if(triggerEventInit){trigger($wrapper,"init")}buildByView($wrapper,triggerViewChange);if(settings.debug){log("bsCalendar initialized")}resolve($wrapper)}catch(error){reject(error)}})}async function checkAndSetAppointments($wrapper,appointments){const data=getBsCalendarData($wrapper);const settings=data.settings;return new Promise((resolve,reject)=>{const hasAppointmentsAsArray=appointments&&Array.isArray(appointments)&&appointments.length>0;if(!hasAppointmentsAsArray){appointments=[];setAppointments($wrapper,appointments);resolve(appointments);return resolve([])}const view=data.view;if(view==="year"){const processedAppointments=appointments.filter(appointment=>{const isValidDate=appointment.hasOwnProperty("date")&&!isNaN(Date.parse(appointment.date));const isValidTotal=appointment.hasOwnProperty("total")&&parseInt(appointment.total)>0;return isValidDate&&isValidTotal}).map(appointment=>{appointment.total=parseInt(appointment.total+"");return appointment});setAppointmentExtras($wrapper,processedAppointments);setAppointments($wrapper,processedAppointments);return resolve(processedAppointments)}cleanAppointments($wrapper,appointments);const inSearchMode=getSearchMode($wrapper);sortAppointmentByStart(appointments,!inSearchMode).then(_sortedAppointments=>{void _sortedAppointments;setAppointmentExtras($wrapper,appointments);setAppointments($wrapper,appointments);resolve(appointments)}).catch(error=>{if(settings.debug){console.error("Error processing appointments:",error)}reject(error)})})}function cleanAppointments($wrapper,appointments){appointments.forEach(appointment=>{appointment.start=$.bsCalendar.utils.normalizeDateTime(appointment.start.trim());appointment.end=$.bsCalendar.utils.normalizeDateTime(appointment.end.trim());if(appointment.allDay){const startDate=new Date(appointment.start);const endDate=new Date(appointment.end);appointment.start=new Date(startDate.getFullYear(),startDate.getMonth(),startDate.getDate(),0,0,0).toISOString();appointment.end=new Date(endDate.getFullYear(),endDate.getMonth(),endDate.getDate(),23,59,59).toISOString()}})}async function sortAppointmentByStart(appointments,sortAllDay=true){if(!appointments||!Array.isArray(appointments)||appointments.length===0){return[]}return new Promise((resolve,reject)=>{try{appointments.sort((a,b)=>{if(sortAllDay){if(a.allDay&&!b.allDay){return-1}if(!a.allDay&&b.allDay){return 1}}return new Date(a.start)-new Date(b.start)});resolve(appointments)}catch(error){reject(error)}})}function buildFramework($wrapper){const data=getBsCalendarData($wrapper);const settings=data.settings;$wrapper.empty();const innerWrapper=$("<div>",{class:"d-flex flex-column align-items-stretch h-100 w-100 rounded-2 gap-3 pb-3"}).appendTo($wrapper);const roundedClass="rounded-"+settings.rounded;const borderClass=settings.border;const topNav=$("<div>",{id:data.elements.wrapperTopNavId,class:`d-flex flex-wrap w-100 g-2 align-items-center justify-content-between bg-body-tertiary border-0 shadow-sm p-2 rounded-2`}).appendTo(innerWrapper);if(settings.topbarAddons&&$(settings.topbarAddons).length>0){$(settings.topbarAddons).insertAfter(topNav)}const leftCol=$("<div>",{class:"col-auto col-lg-4 d-flex flex-nowrap align-items-center flex-fill"}).appendTo(topNav);const middleCol=$("<div>",{class:"col-auto col-lg-4 d-flex justify-content-center flex-fill flex-nowrap align-items-center"}).appendTo(topNav);const rightCol=$("<div>",{class:"col-auto col-lg-4 d-flex justify-content-end flex-wrap flex-lg-nowrap flex-fill align-items-center gap-2"}).appendTo(topNav);$("<button>",{class:`btn border-0 text-body shadow-none me-2`,html:`<i class="${settings.icons.menu}"></i>`,"data-bs-toggle":"sidebar"}).appendTo(leftCol);if(settings.search){const topSearchNav=$("<div>",{id:data.elements.wrapperSearchNavId,class:`d-none align-items-center justify-content-center bg-body-tertiary border-0 shadow-sm p-2 mb-3 wc-round-me`}).insertAfter(topNav);const showSearchbar=$("<button>",{class:`btn border-0 text-body shadow-none js-btn-search me-2 wc-round-me`,html:`<i class="${settings.icons.search}"></i>`}).appendTo(leftCol);showSearchbar.on("click",function(){toggleSearchBar($wrapper,true)});const inputCss="max-width: 400px;";$("<input>",{type:"search",style:inputCss,class:`form-control border-0 bg-body text-body shadow-none ${roundedClass} wc-round-me`,placeholder:settings.translations.search||"search","data-search-input":true}).appendTo(topSearchNav);const btnCloseSearch=$("<button>",{class:`btn border-0 text-body shadow-none p-2 ms-2 js-btn-close-search ${roundedClass} wc-round-me`,html:`<i class="bi bi-x-lg mx-2"></i>`,"aria-label":"Close"}).appendTo(topSearchNav);btnCloseSearch.on("click",function(){toggleSearchBar($wrapper,false);if(getSearchMode($wrapper)){toggleSearchMode($wrapper,false,true)}})}if(settings.showAddButton){$("<button>",{class:`btn border-0 text-body shadow-none me-2 ${roundedClass} wc-round-me`,html:`<i class="${settings.icons.add}"></i>`,"data-add-appointment":true}).appendTo(leftCol)}if(settings.title){$("<div>",{html:settings.title,class:"mb-0 fw-bold text-uppercase text-body"}).appendTo(middleCol)}$("<div>",{class:"spinner-border me-auto me-2 text-secondary wc-calendar-spinner",css:{display:"none",width:"1.5rem",height:"1.5rem"},role:"status",html:'<span class="visually-hidden">Loading...</span>'}).appendTo(leftCol);$("<div>",{class:`d-flex align-items-center py-1 ps-3 justify-content-center wc-nav-view-wrapper flex-wrap flex-lg-nowrap text-nowrap bg-body rounded-pill shadow-sm`,html:[`<strong class="me-3 user-select-none text-body" id="${data.elements.wrapperViewContainerTitleId}"></strong>`,`<a data-prev href="#" class="text-decoration-none text-body d-flex align-items-center justify-content-center" style="width:24px; height:24px;"><i class="${settings.icons.prev}"></i></a>`,`<a class="mx-2 text-decoration-none text-body d-flex align-items-center justify-content-center" data-next href="#" style="width:24px; height:24px;"><i class="${settings.icons.next}"></i></a>`].join("")}).appendTo(rightCol);$("<button>",{class:`btn border-0 text-body shadow-none ms-2 ${roundedClass} wc-round-me fw-bold`,html:settings.translations.today,"data-today":true}).appendTo(rightCol);if(settings.views.length>1){const dropDownView=$("<div>",{class:"dropdown dropdown-center wc-select-calendar-view ms-2",html:[`<a class="btn dropdown-toggle border-0 text-body shadow-none wc-round-me ${roundedClass}" data-dropdown-text href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">`,"</a>",'<ul class="dropdown-menu shadow border-0 mt-1">',"</ul>"].join("")}).appendTo(rightCol);if(settings.debug){log("buidlFramwork",settings.views)}settings.views.forEach(view=>{$("<li>",{html:`<a class="dropdown-item" data-view="${view}" href="#"><i class="${settings.icons[view]} me-2"></i> ${settings.translations[view]}</a>`}).appendTo(dropDownView.find("ul"))})}const container=$("<div>",{class:"d-flex flex-fill wc-calendar-container gap-3"}).appendTo(innerWrapper);const sidebar=$("<div>",{id:data.elements.wrapperSideNavId,css:{position:"relative"},class:" py-4 px-4 bg-body-tertiary rounded-2",html:['<div class="pb-3">','<div class="d-flex justify-content-between align-items-center gap-2">',`<span id="${data.elements.wrapperSmallMonthCalendarTitleId}" class="fw-bold text-body"></span>`,"<div>",`<a data-prev href="#" class="text-decoration-none text-body me-2"><i class="${settings.icons.prev}"></i></a>`,`<a data-next href="#" class="text-decoration-none text-body"><i class="${settings.icons.next}"></i></a>`,"</div>","</div>","</div>",`<div id="${data.elements.wrapperSmallMonthCalendarId}"></div>`,`<div id="${data.elements.wrapperCalendarsId}"></div>`].join("")}).appendTo(container);sidebar.data("visible",true);if(settings.calendars&&Array.isArray(settings.calendars)&&settings.calendars.length>0){const calendarWrapper=$("<div>",{class:"d-flex flex-column gap-2 mt-3 p-2 bg-body"}).appendTo("#"+data.elements.wrapperCalendarsId);settings.calendars.forEach(calendar=>{const color=calendar.color.backgroundColor;const itemContainer=$("<a>",{href:"#",class:`d-flex align-items-center py12 px-3 rounded-end text-decoration-none user-select-none transition-base`,css:{cursor:"pointer",transition:"all 0.2s ease-in-out",...getStyleCalendarButton(calendar)},"data-calendar-toggle":calendar.id}).appendTo(calendarWrapper);itemContainer.data("calendar",calendar);$("<span>",{class:"text-truncate flex-fill",css:{fontSize:"0.9rem"},text:calendar.title}).appendTo(itemContainer);const statusDot=$("<span>",{class:"rounded-circle ms-2 js-calendar-dot",css:{width:"6px",height:"6px",backgroundColor:color,opacity:calendar.active?1:0,transition:"opacity 0.2s"}}).appendTo(itemContainer)})}if(settings.sidebarAddons&&$(settings.sidebarAddons).length>0){$(settings.sidebarAddons).appendTo(sidebar)}const viewWrapper=$("<div>",{class:`w-100 bg-body-tertiary rounded-2 shadow-sm p-3 p-lg-4 flex-fill d-flex flex-column overflow-hidden`}).appendTo(container);$("<div>",{id:data.elements.wrapperViewContainerId,class:`wc-calendar-view-container w-100 flex-fill d-flex flex-column align-items-stretch`}).appendTo(viewWrapper)}function getActiveCalendarsIds($wrapper){const settings=getSettings($wrapper);if(!settings||!settings.calendars||!Array.isArray(settings.calendars)){return[]}return settings.calendars.filter(calendar=>calendar.active===true).map(calendar=>calendar.id)}function getStyleCalendarButton(calendar){const color=calendar.color.backgroundColor;return calendar.active?{borderLeft:`4px solid ${color}`,background:`linear-gradient(90deg, ${color}1A 0%, transparent 100%)`,color:"var(--bs-body-color)",fontWeight:"600",opacity:1}:{borderLeft:`4px solid transparent`,background:"transparent",color:"var(--bs-secondary-color)",fontWeight:"400",opacity:.7}}function setCurrentDateName($wrapper){const data=getBsCalendarData($wrapper);const settings=data.settings;const date=data.date;const view=data.view;const el=$wrapper.find("#"+data.elements.wrapperViewContainerTitleId);const elSmall=$wrapper.find("#"+data.elements.wrapperSmallMonthCalendarTitleId);const dayName=date.toLocaleDateString(settings.locale,{day:"numeric"});const weekdayName=date.toLocaleDateString(settings.locale,{weekday:"long"});const monthName=date.toLocaleDateString(settings.locale,{month:"long"});const yearName=date.toLocaleDateString(settings.locale,{year:"numeric"});const calendarWeek=$.bsCalendar.utils.getCalendarWeek(date);function getIsoWeekString(d){const tmp=new Date(Date.UTC(d.getFullYear(),d.getMonth(),d.getDate()));tmp.setUTCDate(tmp.getUTCDate()+4-(tmp.getUTCDay()||7));const yearStart=new Date(Date.UTC(tmp.getUTCFullYear(),0,1));const weekNo=Math.ceil(((tmp-yearStart)/864e5+1)/7);return tmp.getUTCFullYear()+"-W"+String(weekNo).padStart(2,"0")}function getWeekDateRange(d,locale,startWeekOnSunday){const dt=new Date(d);const day=dt.getDay();const startOffset=startWeekOnSunday?day:day===0?6:day-1;const start=new Date(dt);start.setDate(dt.getDate()-startOffset);const end=new Date(start);end.setDate(start.getDate()+6);const options={day:"numeric",month:"short",year:"numeric"};const startStr=start.toLocaleDateString(locale,options);const endStr=end.toLocaleDateString(locale,options);return startStr+" — "+endStr}switch(view){case"day":el.text(weekdayName+", "+dayName+" "+monthName+" "+yearName);el.removeAttr("data-iso-week");el.attr("title","");break;case"week":{const weekNumber=String(calendarWeek);const visibleLabel=`W${weekNumber}`;const iso=getIsoWeekString(date);const range=getWeekDateRange(date,settings.locale,settings.startWeekOnSunday);el.text(visibleLabel+" · "+monthName+" "+yearName);el.attr("data-iso-week",iso);el.attr("title",range);break}case"month":el.text(monthName+" "+yearName);el.removeAttr("data-iso-week");el.attr("title","");break;case"year":el.text(yearName);el.removeAttr("data-iso-week");el.attr("title","");break}elSmall.text(monthName+" "+yearName)}function navigateBack($wrapper){const data=getBsCalendarData($wrapper);const view=data.view;const date=data.date;const newDate=new Date(date);switch(view){case"month":newDate.setMonth(newDate.getMonth()-1);if(newDate.getDate()!==date.getDate()){newDate.setDate(1)}break;case"year":newDate.setFullYear(newDate.getFullYear()-1);newDate.setDate(1);break;case"week":newDate.setDate(newDate.getDate()-7);break;case"day":newDate.setDate(newDate.getDate()-1);break}data.date=newDate;setBsCalendarData($wrapper,data);trigger($wrapper,"navigate-back",view,date,newDate);buildByView($wrapper,false)}function navigateForward($wrapper){const data=getBsCalendarData($wrapper);const view=data.view;const date=data.date;const newDate=new Date(date);switch(view){case"month":newDate.setMonth(newDate.getMonth()+1);if(newDate.getDate()!==date.getDate()){newDate.setDate(1)}break;case"year":newDate.setFullYear(newDate.getFullYear()+1);newDate.setDate(1);break;case"week":newDate.setDate(newDate.getDate()+7);break;case"day":newDate.setDate(newDate.getDate()+1);break}data.date=newDate;setBsCalendarData($wrapper,data);trigger($wrapper,"navigate-forward",view,date,newDate);buildByView($wrapper,false)}function toggleSearchBar($wrapper,status){const data=getBsCalendarData($wrapper);const input=getSearchElement($wrapper);const topNav=$wrapper.find("#"+data.elements.wrapperTopNavId);const topSearchNav=$wrapper.find("#"+data.elements.wrapperSearchNavId);if(status){topNav.removeClass("d-flex").addClass("d-none");topSearchNav.removeClass("d-none").addClass("d-flex");input.focus()}else{input.val(null);topNav.removeClass("d-none").addClass("d-flex");topSearchNav.removeClass("d-flex").addClass("d-none")}}function toggleSearchMode($wrapper,status,rebuildView=true){const data=getBsCalendarData($wrapper);const settings=data.settings;data.searchMode=status;setBsCalendarData($wrapper,data);if(status){buildByView($wrapper,false)}else{const search={limit:settings.search.limit,offset:settings.search.offset};setSearchPagination($wrapper,search);if(rebuildView){buildByView($wrapper,true)}}}function resetSearchPagination($wrapper){const data=getBsCalendarData($wrapper);const settings=data.settings;const search={limit:settings.search.limit,offset:settings.search.offset};data.searchPagination=search;setBsCalendarData($wrapper,data)}function setSearchPagination($wrapper,object){const data=getBsCalendarData($wrapper);const pagination=$.bsCalendar.utils.isValueEmpty(object)?null:object;data.searchPagination=pagination;setBsCalendarData($wrapper,data)}function getSearchPagination($wrapper){const data=getBsCalendarData($wrapper);return data.searchPagination}function setSearchMode($wrapper,status){const data=getBsCalendarData($wrapper);data.searchMode=status;setBsCalendarData($wrapper,data)}function getSearchMode($wrapper){const data=getBsCalendarData($wrapper);return data.searchMode}function handleSidebarVisibility($wrapper,forceClose=false,forceOpen=false){const data=getBsCalendarData($wrapper);const $sidebar=$wrapper.find("#"+data.elements.wrapperSideNavId);const isVisible=$sidebar.data("visible");const shouldBeVisible=forceOpen||!forceClose&&!isVisible;if(shouldBeVisible){$sidebar.css({position:"relative"})}$sidebar.animate({left:shouldBeVisible?"0px":"-400px"},300,function(){if(!shouldBeVisible){$sidebar.css({position:"absolute"})}if(getView($wrapper)==="month"){onResize($wrapper,false)}$sidebar.data("visible",shouldBeVisible)})}function getAllCalendarWrappers(){return $("body").find(globalCalendarElements.wrapper)}function handleEvents($wrapper){let resizeTimer;if(!globalEventsInitialized){$(window).off("resize"+namespace);$(window).on("resize"+namespace,function(){clearTimeout(resizeTimer);resizeTimer=setTimeout(function(){const allWrappers=getAllCalendarWrappers();allWrappers.each(function(i,w){onResize($(w),true)})},100)});globalEventsInitialized=true}$("body").on("click"+namespace,globalCalendarElements.infoModal+" [data-edit]",function(e){e.preventDefault();const modal=$(globalCalendarElements.infoModal);const wrapperId=modal.attr("data-bs-calendar-wrapper-id");const wrapper=$(`.bs-calendar[data-bs-calendar-id="${wrapperId}"]`);const appointment=$(globalCalendarElements.infoModal).data("appointment");const returnData=getAppointmentForReturn(appointment);trigger(wrapper,"edit",returnData.appointment,returnData.extras);$(globalCalendarElements.infoModal).modal("hide")}).on("click"+namespace,globalCalendarElements.infoModal+" [data-remove]",function(e){e.preventDefault();const modal=$(globalCalendarElements.infoModal);const wrapperId=modal.attr("data-bs-calendar-wrapper-id");const wrapper=$(`.bs-calendar[data-bs-calendar-id="${wrapperId}"]`);const appointment=$(globalCalendarElements.infoModal).data("appointment");const returnData=getAppointmentForReturn(appointment);trigger(wrapper,"delete",returnData.appointment,returnData.extras);$(globalCalendarElements.infoModal).modal("hide")}).on("click"+namespace,function(e){const $target=$(e.target);const isInsideModal=$target.closest(globalCalendarElements.infoModal).length>0;const isTargetElement=$target.closest("[data-appointment]").length>0;if(!isInsideModal&&!isTargetElement&&$(globalCalendarElements.infoModal).length){$(globalCalendarElements.infoModal).modal("hide")}}).on("hide.bs.modal",globalCalendarElements.infoModal,function(){const modal=$(globalCalendarElements.infoModal);const wrapperId=modal.attr("data-bs-calendar-wrapper-id");const wrapper=$(`.bs-calendar[data-bs-calendar-id="${wrapperId}"]`);trigger(wrapper,"hide-info-window")}).on("hidden.bs.modal",globalCalendarElements.infoModal,function(){if($(globalCalendarElements.infoModal).length){$(globalCalendarElements.infoModal).remove()}});function debounce(func,wrapper,delay){let timer;return function(...args){const context=this;const settings=getSettings(wrapper);if(settings.navigateOnWheel){$("body").css("overflow","hidden")}clearTimeout(timer);timer=setTimeout(function(){$("body").css("overflow","");func.apply(context,args)},delay)}}$wrapper.off("mouseenter mouseleave","[data-calendar-toggle]").on("mouseenter mouseleave","[data-calendar-toggle]",function(e){const item=$(e.currentTarget);const cal=item.data("calendar");if(cal&&!cal.active){const color=cal.color.backgroundColor;if(e.type==="mouseenter"){const fadeColor=`color-mix(in srgb, ${color}, transparent 85%)`;item.css({"border-left-color":color,background:`linear-gradient(90deg, ${fadeColor} 0%, transparent 100%)`,color:"var(--bs-body-color)",opacity:1})}else{item.css({"border-left-color":"transparent",background:"transparent",color:"var(--bs-secondary-color)",opacity:.7})}}}).off("click","[data-calendar-toggle]").on("click","[data-calendar-toggle]",function(e){e.preventDefault();const item=$(e.currentTarget);const id=item.attr("data-calendar-toggle");const dot=item.find(".js-calendar-dot");const data=getBsCalendarData($wrapper);if(data.settings.calendars&&Array.isArray(data.settings.calendars)){const calendar=data.settings.calendars.find(c=>c.id==id);if(calendar){calendar.active=!calendar.active;setBsCalendarData($wrapper,data);if(data.settings.storeState){const activeCalendarIds=getActiveCalendarsIds($wrapper);saveToLocalStorage($wrapper,"calendars",activeCalendarIds)}item.data("calendar",calendar);const newStyle=getStyleCalendarButton(calendar);item.css(newStyle);dot.css("opacity",calendar.active?1:0);buildByView($wrapper,false)}}}).off("wheel",".wc-calendar-view-container").on("wheel",".wc-calendar-view-container",debounce(function(e){const settings=getSettings($wrapper);const body=$("body");const isModalOpen=body.hasClass("modal-open");const inViewContainer=$(e.target).closest(".wc-calendar-container").length;if(!settings.navigateOnWheel||!inViewContainer||isModalOpen){body.css("overflow","");return}e.preventDefault();e.stopPropagation();if(e.originalEvent.deltaY>0){navigateForward($wrapper)}else{navigateBack($wrapper)}},$wrapper,300)).off("click"+namespace,'[data-bs-toggle="sidebar"]').on("click"+namespace,'[data-bs-toggle="sidebar"]',function(){handleSidebarVisibility($wrapper)}).off("click"+namespace,".wc-search-pagination [data-page]").on("click"+namespace,".wc-search-pagination [data-page]",function(e){e.preventDefault();const $clickedLink=$(e.currentTarget);const newPage=parseInt($clickedLink.attr("data-page"));const searchPagination=getSearchPagination($wrapper);searchPagination.offset=(newPage-1)*searchPagination.limit;const search={limit:searchPagination.limit,offset:searchPagination.offset};setSearchPagination($wrapper,search);$wrapper.find(".wc-search-pagination").remove();fetchAppointments($wrapper)}).off("keyup"+namespace,"[data-search-input]").on("keyup"+namespace,"[data-search-input]",function(e){e.preventDefault();const input=$(e.currentTarget);const isEmpty=$.bsCalendar.utils.isValueEmpty(input.val());let inSearchMode=getSearchMode($wrapper);if(!inSearchMode&&!isEmpty){setSearchMode($wrapper,true)}if(isEmpty){toggleSearchMode($wrapper,false,true);return}const isEnterKey=e.type==="keyup"&&(e.key==="Enter"||e.which===13||e.keyCode===13);if(isEnterKey){triggerSearch($wrapper)}}).off("click"+namespace,"[data-day-hour]").on("click"+namespace,"[data-day-hour]",function(e){const settings=getSettings($wrapper);const details=$(e.currentTarget).data("details");if(settings.debug){log("Day hour clicked:",details)}const start=new Date(`${$.bsCalendar.utils.formatDateToDateString(details.date)} ${String(details.hour).padStart(2,"0")}:00:00`);const end=new Date(start);end.setMinutes(end.getMinutes()+30);const data={start:{date:$.bsCalendar.utils.formatDateToDateString(start),time:start.toTimeString().slice(0,5)},end:{date:$.bsCalendar.utils.formatDateToDateString(end),time:end.toTimeString().slice(0,5)},view:getView($wrapper)};trigger($wrapper,"add",data)}).off("click"+namespace,'[data-role="day-wrapper"]').on("click"+namespace,'[data-role="day-wrapper"]',function(e){if(e.target!==e.currentTarget){return}const dayWrapper=$(e.currentTarget).closest("[data-month-date]");const dateAttribute=dayWrapper.attr("data-month-date");const currentTime=new Date;const start=new Date(`${$.bsCalendar.utils.formatDateToDateString(dateAttribute)} ${String(currentTime.getHours()).padStart(2,"0")}:${String(currentTime.getMinutes()).padStart(2,"0")}:${String(currentTime.getSeconds()).padStart(2,"0")}`);const end=new Date(start);end.setMinutes(end.getMinutes()+30);const data={start:{date:$.bsCalendar.utils.formatDateToDateString(start),time:start.toTimeString().slice(0,5)},end:{date:$.bsCalendar.utils.formatDateToDateString(end),time:end.toTimeString().slice(0,5)},view:getView($wrapper)};trigger($wrapper,"add",data)}).off("click"+namespace,"[data-add-appointment]").on("click"+namespace,"[data-add-appointment]",function(e){e.preventDefault();if(getSearchMode($wrapper)){e.stopPropagation();return}const period=getStartAndEndDateByView($wrapper);const data={start:{date:$.bsCalendar.utils.formatDateToDateString(period.start),time:null},end:{date:$.bsCalendar.utils.formatDateToDateString(period.end),time:null},view:getView($wrapper)};trigger($wrapper,"add",data)}).off("click"+namespace,"[data-today]").on("click"+namespace,"[data-today]",function(e){e.preventDefault();const inSearchMode=getSearchMode($wrapper);if(inSearchMode){e.stopPropagation()}else{setToday($wrapper)}}).off(`click${namespace} touchend${namespace}`,"[data-appointment]").on(`click${namespace} touchend${namespace}`,"[data-appointment]",function(e){const clickedOnDate=$(e.target).is("[data-date]");const clickedOnMonth=$(e.target).is("[data-month]");const clickedOnToday=$(e.target).is("[data-today]");const clickedOnAnchor=$(e.target).is("a[href]")||$(e.target).closest("a[href]").length>0;if(clickedOnToday||clickedOnDate||clickedOnMonth||clickedOnAnchor){e.stopPropagation();return}e.preventDefault();const element=$(e.currentTarget);showInfoWindow($wrapper,element)}).off("click"+namespace,"[data-week-date]").on("click"+namespace,"[data-week-date]",function(e){e.preventDefault();const settings=getSettings($wrapper);const viewBefore=getView($wrapper);const inSearchMode=getSearchMode($wrapper);if(inSearchMode){toggleSearchMode($wrapper,false,false)}if(settings.views.includes("week")){const date=new Date($(e.currentTarget).attr("data-week-date"));setView($wrapper,"week");setDate($wrapper,date);buildByView($wrapper,viewBefore!=="week")}}).off("click"+namespace,"[data-date]").on("click"+namespace,"[data-date]",function(e){e.preventDefault();const settings=getSettings($wrapper);const viewBefore=getView($wrapper);const inSearchMode=getSearchMode($wrapper);if(inSearchMode){toggleSearchMode($wrapper,false,false)}if(settings.views.includes("day")){const date=new Date($(e.currentTarget).attr("data-date"));setView($wrapper,"day");setDate($wrapper,date);buildByView($wrapper,viewBefore!=="day")}}).off("click"+namespace,"[data-month]").on("click"+namespace,"[data-month]",function(e){e.preventDefault();const settings=getSettings($wrapper);const viewBefore=getView($wrapper);if(settings.views.includes("month")){const date=new Date($(e.currentTarget).attr("data-month"));setView($wrapper,"month");setDate($wrapper,date);buildByView($wrapper,viewBefore!=="month")}}).off("click"+namespace,"[data-prev]").on("click"+namespace,"[data-prev]",function(e){e.preventDefault();const inSearchMode=getSearchMode($wrapper);if(inSearchMode){e.stopPropagation()}else{navigateBack($wrapper)}}).off("click"+namespace,"[data-next]").on("click"+namespace,"[data-next]",function(e){e.preventDefault();const inSearchMode=getSearchMode($wrapper);if(inSearchMode){e.stopPropagation()}else{navigateForward($wrapper)}}).off("click"+namespace,".wc-select-calendar-view [data-view]").on("click"+namespace,".wc-select-calendar-view [data-view]",function(e){e.preventDefault();const inSearchMode=getSearchMode($wrapper);if(inSearchMode){e.stopPropagation()}else{const oldView=getView($wrapper);const newView=$(e.currentTarget).attr("data-view");if(oldView!==newView){setView($wrapper,newView);buildByView($wrapper,true)}}})}function removeFromLocalStorage($wrapper,key){const settings=getSettings($wrapper);if(settings.debug){log("Removing data from local storage: "+key)}if($.bsCalendar.utils.isValueEmpty($wrapper.attr("id"))){if(settings.debug){log("Wrapper element has no id attribute. Cannot remove data from local storage.")}return}const elementId=$wrapper.attr("id");const keyComplete=`bsCalendar.${elementId}.${key}`;localStorage.removeItem(keyComplete)}function saveToLocalStorage($wrapper,key,value){const settings=getSettings($wrapper);if(settings.debug){log("Saving element data to local storage: "+key+" = "+value)}if(!settings.storeState){if(settings.debug){removeFromLocalStorage($wrapper,key);log("Saving is disabled. Please enable it in the settings.")}return}if($.bsCalendar.utils.isValueEmpty($wrapper.attr("id"))){if(settings.debug){log("Element has no ID, cannot save data to local storage")}return}const elementId=$wrapper.attr("id");const keyComplete=`bsCalendar.${elementId}.${key}`;if(value===undefined){if(settings.debug){log("Value is undefined, cannot save data to local storage")}return}if(value===null){if(settings.debug){log("Value is null, cannot save data to local storage")}localStorage.setItem(keyComplete,"null")}else if(typeof value==="object"){if(settings.debug){log("Saving object to local storage",JSON.stringify(value))}localStorage.setItem(keyComplete,JSON.stringify(value))}else if(typeof value==="boolean"){if(settings.debug){log("Saving boolean to local storage",value.toString())}localStorage.setItem(keyComplete,value.toString())}else if(typeof value==="function"){if(settings.debug){log("Functions cannot be stored in localStorage.")}}else{if(settings.debug){log("Saving string to local storage",value.toString())}localStorage.setItem(keyComplete,value.toString())}}function getFromLocalStorage($wrapper,key){const settings=getSettings($wrapper);if(settings.debug){log("Getting element data from local storage: "+key)}if($.bsCalendar.utils.isValueEmpty($wrapper.attr("id"))){if(settings.debug){log("Element has no ID, cannot get data from local storage")}return}if(!settings.storeState){if(settings.debug){removeFromLocalStorage($wrapper,key);log("Getting is disabled. Please enable it in the settings.")}return}const elementId=$wrapper.attr("id");const keyComplete=`bsCalendar.${elementId}.${key}`;const value=localStorage.getItem(keyComplete);try{if(settings.debug){log("Parsing value from local storage",value)}return JSON.parse(value)}catch(e){if(value==="null"){if(settings.debug){log("Value is null, returning null",null)}return null}if(value==="true"){if(settings.debug){log("Value is 'true', returning true",true)}return true}if(value==="false"){if(settings.debug){log("Value is 'false', returning false",false)}return false}const isNumber=value=>/^-?\d+(\.\d+)?$/.test(value);if(isNumber(value)){if(settings.debug){log("Value is a number, returning number",Number(value))}return Number(value)}if(settings.debug){log("Value is not a valid JSON value, returning string",value)}return value}}function triggerSearch($wrapper){resetSearchPagination($wrapper);buildByView($wrapper,false)}function getSelectViewElement($wrapper){return $wrapper.find(".wc-select-calendar-view")}function updateDropdownView($wrapper){const dropdown=getSelectViewElement($wrapper);const view=getView($wrapper);dropdown.find(".dropdown-item.active").removeClass("active");dropdown.find(`[data-view="${view}"]`).addClass("active");const activeItem=dropdown.find(`[data-view="${view}"]`);dropdown.find("[data-dropdown-text]").html(activeItem.html())}function getView($wrapper){const data=getBsCalendarData($wrapper);return data.view}function setView($wrapper,view){const data=getBsCalendarData($wrapper);const settings=data.settings;const currentView=data.view;if(view!=="search"&&!["day","week","month","year"].includes(view)){if(settings.debug){console.error("Invalid view type provided. Defaulting to month view.","Provided view:",view)}view="month"}if(currentView!==view){data.lastView=currentView}if(settings.debug){log("Set view to:",view)}saveToLocalStorage($wrapper,"view",view);data.view=view;setBsCalendarData($wrapper,data)}function getDate($wrapper){const data=getBsCalendarData($wrapper);return data.date||new Date}function setDate($wrapper,date){const data=getBsCalendarData($wrapper);const settings=getSettings($wrapper);if(typeof date==="string"){data.date=new Date(date)}else if(date instanceof Date){data.date=date}if(settings.debug){log("Set date to:",data.date)}setBsCalendarData($wrapper,data)}function getSettings($wrapper){const data=getBsCalendarData($wrapper);return data.settings}function updateSettings($wrapper,settings){const data=getBsCalendarData($wrapper);if(data.settings.debug){log("Set settings to:",settings)}data.settings=settings;setBsCalendarData($wrapper,data)}function getViewContainer($wrapper){const data=getBsCalendarData($wrapper);return $wrapper.find("#"+data.elements.wrapperViewContainerId)}function buildByView($wrapper,triggerViewChanged=true){const data=getBsCalendarData($wrapper);const settings=data.settings;const view=data.view;if(settings.debug){log("Call buildByView with view:",view)}if(data.searchMode){buildSearchView($wrapper)}else{const period=getStartAndEndDateByView($wrapper);const renderState=data.renderState||{view:null,start:null,end:null,selectedDate:null,hourSlots:null};const currentSelectedDate=$.bsCalendar.utils.formatDateToDateString(data.date);const currentHourSlots=JSON.stringify(settings.hourSlots);const needsRebuild=renderState.view!==view||renderState.start!==period.start||renderState.end!==period.end||view==="year"&&renderState.selectedDate!==currentSelectedDate||(view==="day"||view==="week")&&renderState.hourSlots!==currentHourSlots;if(needsRebuild){switch(view){case"month":buildMonthView($wrapper);break;case"week":buildWeekView($wrapper);break;case"year":buildYearView($wrapper);break;case"day":buildDayView($wrapper);break;default:break}data.renderState={view:view,start:period.start,end:period.end,selectedDate:currentSelectedDate,hourSlots:currentHourSlots};setBsCalendarData($wrapper,data)}else{if(settings.debug){log("Skipping DOM rebuild for view (content unchanged).")}}onResize($wrapper);updateDropdownView($wrapper);setCurrentDateName($wrapper);const monthCalendarWrapper=$("#"+data.elements.wrapperSmallMonthCalendarId);buildMonthSmallView($wrapper,data.date,monthCalendarWrapper);if(triggerViewChanged){trigger($wrapper,"view",view)}}fetchAppointments($wrapper)}function executeFunction(functionOrName,...args){if(functionOrName){if(typeof functionOrName==="function"){return functionOrName(...args)}if(typeof functionOrName==="string"){let func=null;try{func=new Function(`return typeof ${functionOrName} === 'function' ? ${functionOrName} : undefined`)()}catch(error){}if(!func&&typeof window!=="undefined"&&typeof window[functionOrName]==="function"){func=window[functionOrName]}if(typeof func==="function"){return func(...args)}}}return undefined}function fetchAppointments($wrapper){const bsCalendarData=getBsCalendarData($wrapper);const settings=bsCalendarData.settings;if(bsCalendarData.loading){if(settings&&settings.debug){log("fetchAppointments: already loading for wrapper, skipping duplicate call")}return}bsCalendarData.loading=true;setBsCalendarData($wrapper,bsCalendarData);methodClear($wrapper);let skipLoading=false;if(settings&&settings.debug){try{log("fetchAppointments called for wrapper:",$wrapper.attr("data-bs-calendar-id")||$wrapper.attr("id")||$wrapper)}catch(e){}}let requestData;const inSearchMode=getSearchMode($wrapper);if(!inSearchMode){const view=bsCalendarData.view;const period=getStartAndEndDateByView($wrapper);if(view==="year"){requestData={year:new Date(period.date).getFullYear(),view:view}}else{requestData={fromDate:period.start,toDate:period.end,view:view}}}else{const searchElement=getSearchElement($wrapper);const search=searchElement?.val()??null;skipLoading=$.bsCalendar.utils.isValueEmpty(search);requestData={...bsCalendarData.searchPagination,search:search}}let activeCalendarIds=[];if(settings.calendars&&Array.isArray(settings.calendars)){activeCalendarIds=settings.calendars.filter(c=>c.active===true).map(c=>c.id)}requestData.calendarIds=activeCalendarIds;if(typeof settings.queryParams==="function"){if(settings.debug){log("Original requestData before queryParams:",requestData)}const queryParams=settings.queryParams(requestData);const protectedKeys=new Set(["fromDate","toDate","year","view"]);if(queryParams&&typeof queryParams==="object"){Object.keys(queryParams).forEach(key=>{if(protectedKeys.has(key)){if(settings.debug){log(`queryParams tried to override protected key "${key}" -> ignored. value:`,queryParams[key])}return}requestData[key]=queryParams[key]})}else{if(settings.debug){log("queryParams did not return an object, skipping merge:",queryParams)}}if(settings.debug){log("Merged requestData after queryParams:",requestData)}}if(skipLoading){if(settings.debug){log("Skip loading appointments because search is empty")}checkAndSetAppointments($wrapper,[]).then(_cleanedAppointments=>{trigger($wrapper,"after-load",_cleanedAppointments);void _cleanedAppointments;buildAppointmentsForView($wrapper)}).finally(()=>{bsCalendarData.loading=false;setBsCalendarData($wrapper,bsCalendarData)});return}trigger($wrapper,"before-load",requestData);const callFunction=typeof settings.url==="function";const callAjax=typeof settings.url==="string";if(callFunction||callAjax){showBSCalendarLoader($wrapper)}if(callFunction){if(settings.debug){log("Call appointments by function with query:",requestData)}settings.url(requestData).then(appointments=>{if(settings.debug){log("result:",appointments)}if(inSearchMode){checkAndSetAppointments($wrapper,appointments.rows).then(cleanedAppointments=>{trigger($wrapper,"after-load",cleanedAppointments);buildAppointmentsForSearch($wrapper,cleanedAppointments,appointments.total)})}else{checkAndSetAppointments($wrapper,appointments).then(_cleanedAppointments=>{trigger($wrapper,"after-load",_cleanedAppointments);void _cleanedAppointments;buildAppointmentsForView($wrapper)})}}).catch(error=>{hideBSCalendarLoader($wrapper);if(settings.debug){log("Error fetching appointments:",error)}}).finally(()=>{hideBSCalendarLoader($wrapper);bsCalendarData.loading=false;setBsCalendarData($wrapper,bsCalendarData)})}else if(callAjax){abortXhr(bsCalendarData.xhrs.appointments);bsCalendarData.xhrs.appointments=null;if(settings.debug){log("Call appointments by URL:",settings.url)}bsCalendarData.xhrs.appointments=$.ajax({url:settings.url,method:"GET",contentType:"application/json",data:requestData,success:function(response){if(inSearchMode){checkAndSetAppointments($wrapper,response.rows).then(cleanedAppointments=>{trigger($wrapper,"after-load",cleanedAppointments);buildAppointmentsForSearch($wrapper,cleanedAppointments,response.total)})}else{checkAndSetAppointments($wrapper,response).then(_cleanedAppointments=>{trigger($wrapper,"after-load",_cleanedAppointments);void _cleanedAppointments;buildAppointmentsForView($wrapper)})}},error:function(xhr,status,error){if(status!=="abort"){if(settings.debug){log("Error when retrieving the dates:",status,error)}}},complete:function(){bsCalendarData.xhrs.appointments=null;hideBSCalendarLoader($wrapper);bsCalendarData.loading=false;setBsCalendarData($wrapper,bsCalendarData)}})}else{bsCalendarData.loading=false;setBsCalendarData($wrapper,bsCalendarData)}}function groupOverlappingAppointments($wrapper,appointments){const groupedByWeekdays={};const view=getView($wrapper);appointments.forEach(appointment=>{appointment.extras.displayDates.forEach(obj=>{if(view==="week"&&!obj.visibleInWeek){return}const slotStart=new Date(`${obj.date}T${obj.times.start}`);const slotEnd=new Date(`${obj.date}T${obj.times.end}`);const weekday=slotStart.getDay();if(!groupedByWeekdays[weekday]){groupedByWeekdays[weekday]={appointments:[],columns:[],fullWidth:[]}}groupedByWeekdays[weekday].appointments.push({start:slotStart,end:slotEnd,appointment:appointment})})});Object.keys(groupedByWeekdays).forEach(day=>{const{appointments,columns,fullWidth}=groupedByWeekdays[day];appointments.sort((a,b)=>a.start-b.start);appointments.forEach(appointment=>{let placedInColumn=false;for(let column of columns){if(doesNotOverlap(column,appointment)){column.push(appointment);placedInColumn=true;break}}if(!placedInColumn){const hasOverlap=appointments.some(otherAppointment=>otherAppointment!==appointment&&!(appointment.start>=otherAppointment.end||appointment.end<=otherAppointment.start));if(!hasOverlap&&columns.length===0){fullWidth.push(appointment)}else{columns.push([appointment])}}})});return groupedByWeekdays}function doesNotOverlap(column,newAppointment){for(const appointment of column){if(!(newAppointment.start>=appointment.end||newAppointment.end<=appointment.start)){return false}}return true}function drawAppointmentsForDayOrWeek($wrapper,appointments){const settings=getSettings($wrapper);const view=getView($wrapper);const $viewContainer=getViewContainer($wrapper);const allDays=appointments.filter(appointment=>appointment.allDay===true);const notAllDays=appointments.filter(appointment=>appointment.allDay!==true);if(settings.debug){log("Call drawAppointmentsForDayOrWeek with view:",view);log("All-Day Appointments:",allDays);log("Not-All-Day Appointments:",notAllDays);log("All Appointments:",appointments)}allDays.forEach(appointment=>{if(settings.debug){log(">>>> All-Day Appointment displayDates:",appointment.extras.displayDates)}appointment.extras.displayDates.forEach(obj=>{const fakeStart=new Date(obj.date);const allDayWrapper=$viewContainer.find('[data-all-day="'+fakeStart.getDay()+'"][data-date-local="'+$.bsCalendar.utils.formatDateToDateString(fakeStart)+'"]');if(allDayWrapper.length){allDayWrapper.addClass("pb-3");const returnData=getAppointmentForReturn(appointment);const appointmentElement=$("<span>",{"data-appointment":true,html:settings.formatter.allDay(returnData.appointment,returnData.extras,view),class:`mx-1 mb-1 flex-fill`}).appendTo(allDayWrapper);appointmentElement.data("appointment",appointment)}})});const groupedAppointments=groupOverlappingAppointments($wrapper,notAllDays);const columnGap=2;Object.entries(groupedAppointments).forEach(([weekday,{columns,fullWidth}])=>{const totalColumns=columns.length;columns.forEach((column,columnIndex)=>{column.forEach(slotData=>{const appointment=slotData.appointment;const startDate=new Date(slotData.start);const endDate=new Date(slotData.end);if(isNaN(startDate.getTime())||isNaN(endDate.getTime())){console.warn(`Invalid date in Appointment: ${appointment?.title||"unknown"}`);return}const targetDateLocal=$.bsCalendar.utils.formatDateToDateString(startDate);const $weekDayContainer=$viewContainer.find(`[data-week-day="${weekday}"][data-date-local="${targetDateLocal}"]`);if(!$weekDayContainer.length){console.warn(`Container für Weekday ${weekday} mit Datum ${targetDateLocal} nicht gefunden.`);return}const noOverlapWithNextColumns=columns.slice(columnIndex+1).every(nextColumn=>nextColumn.every(slot=>endDate<=new Date(slot.start)||startDate>=new Date(slot.end)));const totalGap=(totalColumns-1)*columnGap;let appointmentWidthPercent;if(noOverlapWithNextColumns){const remainingColumns=totalColumns-columnIndex;const remainingGap=(remainingColumns-1)*columnGap;appointmentWidthPercent=100-(columnIndex*(100/totalColumns)+remainingGap*100/$weekDayContainer.width())}else{appointmentWidthPercent=totalColumns>1?(100-totalGap*100/$weekDayContainer.width())/totalColumns:100}const appointmentLeftPercent=totalColumns>1?columnIndex*(100/totalColumns):0;const position=calculateSlotPosition($wrapper,startDate.toISOString(),endDate.toISOString());const returnData=getAppointmentForReturn(appointment);const appointmentContent=view==="day"?settings.formatter.day(returnData.appointment,returnData.extras):settings.formatter.week(returnData.appointment,returnData.extras);const appointmentElement=$("<div>",{"data-appointment":true,class:"position-absolute overflow-hidden rounded",css:{top:`${position.top}px`,height:`${position.height}px`,left:`${appointmentLeftPercent}%`,width:`${appointmentWidthPercent}%`},html:appointmentContent}).appendTo($weekDayContainer);appointmentElement.data("appointment",appointment);setAppointmentStyles(appointmentElement,appointment.extras.colors)})});fullWidth.forEach(slotData=>{const appointment=slotData.appointment;const startDate=new Date(slotData.start);const appointmentWidthPercent=100;const appointmentLeftPercent=0;let position={top:0,height:0};if(slotData.start instanceof Date&&!isNaN(slotData.start)&&slotData.end instanceof Date&&!isNaN(slotData.end)){position=calculateSlotPosition($wrapper,slotData.start.toISOString(),slotData.end.toISOString())}else{console.error("Invalid date detected:",slotData.start,slotData.end,appointment)}const targetDateLocal=$.bsCalendar.utils.formatDateToDateString(startDate);const $weekDayContainer=$viewContainer.find(`[data-week-day="${weekday}"][data-date-local="${targetDateLocal}"]`);if(!$weekDayContainer.length){console.warn(`Full-Width-Container für Weekday ${weekday} mit Datum ${targetDateLocal} nicht gefunden.`);return}const returnData=getAppointmentForReturn(appointment);const appointmentContent=view==="day"?settings.formatter.day(returnData.appointment,returnData.extras):settings.formatter.week(returnData.appointment,returnData.extras);const appointmentElement=$("<div>",{"data-appointment":true,class:"position-absolute overflow-hidden rounded",css:{top:`${position.top}px`,height:`${position.height}px`,left:`${appointmentLeftPercent}%`,width:`${appointmentWidthPercent}%`},html:appointmentContent}).appendTo($weekDayContainer);appointmentElement.data("appointment",appointment);setAppointmentStyles(appointmentElement,appointment.extras.colors)})})}function setAppointmentStyles($el,colors){$el.css({backgroundColor:colors.backgroundColor,backgroundImage:colors.backgroundImage,color:colors.color})}function buildAppointmentsForSearch($wrapper,appointments,total){const $container=getViewContainer($wrapper).find(".wc-search-result-container");const settings=getSettings($wrapper);if(settings.debug){log("Call buildAppointmentsForSearch with appointments:",appointments,total)}const input=getSearchElement($wrapper);const search=input.val().trim();if($.bsCalendar.utils.isValueEmpty(search)){$container.html('<div class="d-flex p-5 align-items-center justify-content-center"></div>');input.appendTo($container.find(".d-flex"));input.focus();return}if(!appointments.length){$container.html('<div class="d-flex p-5 align-items-center justify-content-center">'+settings.translations.searchNoResult+"</div>");return}$container.css("font-size",".9rem").addClass("py-4");const searchPagination=getSearchPagination($wrapper);const page=Math.floor(searchPagination.offset/searchPagination.limit)+1;const itemsPerPage=searchPagination.limit;const totalPages=Math.ceil(total/itemsPerPage);const startIndex=(page-1)*itemsPerPage;const endIndex=Math.min(startIndex+itemsPerPage,total);const visibleAppointments=appointments.slice(0,endIndex-startIndex);$container.empty();buildSearchPagination($container,page,totalPages,itemsPerPage,total);const $appointmentContainer=$("<div>",{class:"list-group list-group-flush mb-3"}).appendTo($container);visibleAppointments.forEach(appointment=>{const borderLeftColor=appointment.color||settings.mainColor;const copy=getAppointmentForReturn(appointment);const html=settings.formatter.search(copy.appointment,copy.extras);const appointmentElement=$("<div>",{"data-appointment":true,class:"list-group-item overflow-hidden p-0",html:html,css:{cursor:"pointer",borderLeftColor:borderLeftColor}}).appendTo($appointmentContainer);appointmentElement.data("appointment",appointment)});buildSearchPagination($container,page,totalPages,itemsPerPage,total)}function buildSearchPagination($container,currentPage,totalPages,itemsPerPage,total){if(totalPages<=1){return}const $paginationWrapper=$("<div>",{class:"d-flex align-items-center justify-content-between my-1 wc-search-pagination"}).appendTo($container);const startIndexDisplay=(currentPage-1)*itemsPerPage+1;const endIndexDisplay=Math.min(currentPage*itemsPerPage,total);const statusText=`${startIndexDisplay}-${endIndexDisplay} | ${total}`;$("<div>",{class:"alert alert-secondary me-4 py-2 px-4",text:statusText}).appendTo($paginationWrapper);const $pagination=$("<nav>",{"aria-label":"Page navigation"}).appendTo($paginationWrapper);const $paginationList=$("<ul>",{class:"pagination mb-0"}).appendTo($pagination);const maxAdjacentPages=2;const addPage=page=>{const $pageItem=$("<li>",{class:"page-item"});if(page===currentPage){$pageItem.addClass("active")}const $pageLink=$("<a>",{"data-page":page,class:"page-link",href:"#"+page,text:page});$pageLink.appendTo($pageItem);$pageItem.appendTo($paginationList)};const addEllipsis=()=>{$("<li>",{class:"page-item disabled"}).append($("<span>",{class:"page-link",text:"..."})).appendTo($paginationList)};if(currentPage>maxAdjacentPages+1){addPage(1);if(currentPage>maxAdjacentPages+2){addEllipsis()}}for(let i=Math.max(1,currentPage-maxAdjacentPages);i<currentPage;i++){addPage(i)}addPage(currentPage);for(let i=currentPage+1;i<=Math.min(totalPages,currentPage+maxAdjacentPages);i++){addPage(i)}if(currentPage<totalPages-maxAdjacentPages){if(currentPage<totalPages-maxAdjacentPages-1){addEllipsis()}addPage(totalPages)}}function drawAppointmentsForMonth($wrapper,appointments){const $container=getViewContainer($wrapper);const settings=getSettings($wrapper);if(settings.debug){log("Call buildAppointmentsForMonth with appointments:",appointments)}appointments.forEach(appointment=>{appointment.extras.displayDates.forEach(obj=>{const startString=obj.date;const dayContainer=$container.find(`[data-month-date="${startString}"] [data-role="day-wrapper"]`);const returnData=getAppointmentForReturn(appointment);const appointmentContent=settings.formatter.month(returnData.appointment,returnData.extras);const appointmentElement=$("<small>",{"data-appointment":true,class:"px-1 w-100 overflow-hidden mb-1 rounded",css:{minHeight:"18px"},html:appointmentContent}).appendTo(dayContainer);appointmentElement.data("appointment",appointment);setAppointmentStyles(appointmentElement,appointment.extras.colors)})})}function copyAppointment(appointment){return $.extend(true,{},appointment)}function getAppointmentForReturn(origin){const appointment=copyAppointment(origin);const extras=appointment.extras;delete appointment.extras;return{appointment:appointment,extras:extras}}function setAppointmentExtras($wrapper,appointments){const data=getBsCalendarData($wrapper);const settings=data.settings;const view=data.view;const now=new Date;if(view==="year"){appointments.forEach(appointment=>{const date=new Date(appointment.date);appointment.extras={colors:$.bsCalendar.utils.getColors(appointment.color||settings.mainColor,settings.mainColor),isToday:date.toDateString()===now.toDateString(),isNow:date.getFullYear()===now.getFullYear()}})}else{appointments.forEach(appointment=>{const start=new Date(appointment.start);const end=new Date(appointment.end);const isAllDay=appointment.allDay;let iconClass=!isAllDay?settings.icons.appointment:settings.icons.appointmentAllDay;if(appointment.hasOwnProperty("icon")&&appointment.icon){iconClass=appointment.icon}const extras={locale:settings.locale,icon:iconClass,colors:$.bsCalendar.utils.getColors(appointment.color,settings.mainColor),start:{date:$.bsCalendar.utils.formatDateToDateString(appointment.start),time:isAllDay?"00:00:00":$.bsCalendar.utils.formatTime(appointment.start)},end:{date:$.bsCalendar.utils.formatDateToDateString(appointment.end),time:isAllDay?"23:59:59":$.bsCalendar.utils.formatTime(appointment.end)},duration:{days:0,hours:0,minutes:0,totalMinutes:0,totalSeconds:0,seconds:0},displayDates:[],allDay:isAllDay,inADay:false,isToday:start.toDateString()===now.toDateString(),isNow:start<=now&&end>=now};let tempDate=new Date(start);let tempEnd=new Date(end);tempDate.setHours(0,0,0,0);tempEnd.setHours(0,0,0,0);const firstOfMonth=new Date(now.getFullYear(),now.getMonth(),1);const lastOfMonth=new Date(now.getFullYear(),now.getMonth()+1,0);const firstDayOffset=settings.startWeekOnSunday?0:1;const monthStart=new Date(firstOfMonth);monthStart.setDate(firstOfMonth.getDate()-(firstOfMonth.getDay()-firstDayOffset+7)%7);const monthEnd=new Date(lastOfMonth);monthEnd.setDate(lastOfMonth.getDate()+(6-(lastOfMonth.getDay()-firstDayOffset+7)%7));while(tempDate<=tempEnd){const dateIsStart=$.bsCalendar.utils.datesAreEqual(tempDate,start);const dateIsEnd=$.bsCalendar.utils.datesAreEqual(tempDate,end);const dateDetails={date:$.bsCalendar.utils.formatDateToDateString(tempDate),day:tempDate.getDay(),times:{start:null,end:null},visibleInWeek:false,visibleInMonth:false};if(isAllDay){dateDetails.times.start=null;dateDetails.times.end=null}else{if(dateIsStart){dateDetails.times.start=$.bsCalendar.utils.formatTime(start);dateDetails.times.end=end>new Date(tempDate).setHours(23,59,59,999)?"23:59":$.bsCalendar.utils.formatTime(end)}else if(dateIsEnd){dateDetails.times.start="00:00";dateDetails.times.end=$.bsCalendar.utils.formatTime(end)}else{dateDetails.times.start="00:00";dateDetails.times.end="23:59"}}if(tempDate>=monthStart&&tempDate<=monthEnd){dateDetails.visibleInMonth=true}const weekRangeStart=new Date(tempDate);const weekRangeEnd=new Date(tempDate);if(settings.startWeekOnSunday){weekRangeStart.setDate(weekRangeStart.getDate()-weekRangeStart.getDay())}else{const dayOffset=(weekRangeStart.getDay()===0?7:weekRangeStart.getDay())-1;weekRangeStart.setDate(weekRangeStart.getDate()-dayOffset)}weekRangeStart.setHours(0,0,0,0);weekRangeEnd.setTime(weekRangeStart.getTime()+7*24*60*60*1e3-1);if(tempDate>=weekRangeStart&&tempDate<=weekRangeEnd){dateDetails.visibleInWeek=true}extras.displayDates.push(dateDetails);tempDate.setDate(tempDate.getDate()+1)}extras.inADay=extras.displayDates.length===1;const diffMillis=end-start;if(appointment.allDay){const startDate=new Date(start.getFullYear(),start.getMonth(),start.getDate());const endDate=new Date(end.getFullYear(),end.getMonth(),end.getDate());const diffDaysMillis=endDate-startDate;extras.duration.days=Math.floor(diffDaysMillis/(24*3600*1e3))+1;extras.duration.hours=0;extras.duration.minutes=0;extras.duration.totalMinutes=Math.floor(diffMillis/(60*1e3));extras.duration.totalSeconds=Math.floor(diffMillis/1e3);extras.duration.seconds=0}else{const totalSeconds=Math.floor(diffMillis/1e3);extras.duration.days=Math.floor(totalSeconds/(24*3600));extras.duration.hours=Math.floor(totalSeconds%(24*3600)/3600);extras.duration.minutes=Math.floor(totalSeconds%3600/60);extras.duration.totalSeconds=totalSeconds;extras.duration.totalMinutes=Math.round(totalSeconds/60);extras.duration.seconds=totalSeconds%60}extras.duration.formatted=settings.formatter.duration(extras.duration);extras.inADay=extras.displayDates.length===1;appointment.extras=extras})}}function buildAppointmentsForView($wrapper){const data=getBsCalendarData($wrapper);methodClear($wrapper,false);const settings=data.settings;const appointments=data.appointments;const isSearchMode=data.searchMode;const view=data.view;const container=getViewContainer($wrapper);if(settings.debug){log("Call renderData with view:",view)}switch(view){case"day":case"week":drawAppointmentsForDayOrWeek($wrapper,appointments);break;case"month":drawAppointmentsForMonth($wrapper,appointments);break;case"year":drawAppointmentsForYear($wrapper,appointments);break}if(!isSearchMode){loadHolidays($wrapper)}container.find("[data-appointment]").css("cursor","pointer")}function loadHolidays($wrapper){const data=getBsCalendarData($wrapper);if(data.loadingHolidays){return}data.loadingHolidays=true;setBsCalendarData($wrapper,data);const settings=data.settings;const period=getStartAndEndDateByView($wrapper);const locale=$.bsCalendar.utils.getLanguageAndCountry(settings.locale);if(typeof settings.holidays==="object"&&!$.bsCalendar.utils.isValueEmpty(settings.holidays)){let countryIsoCode;let languageIsoCode;let federalState=null;if(settings.holidays.hasOwnProperty("country")&&!$.bsCalendar.utils.isValueEmpty(settings.holidays.country)){countryIsoCode=settings.holidays.country.toUpperCase()}else{countryIsoCode=locale.country}if(settings.holidays.hasOwnProperty("language")&&!$.bsCalendar.utils.isValueEmpty(settings.holidays.language)){languageIsoCode=settings.holidays.language.toUpperCase()}else{languageIsoCode=locale.language}if(settings.holidays.hasOwnProperty("federalState")&&!$.bsCalendar.utils.isValueEmpty(settings.holidays.federalState)){federalState=settings.holidays.federalState.toUpperCase()}if(settings.debug){log("Load public holidays with params:",{country:countryIsoCode,language:languageIsoCode,period:period,federalState:federalState})}const promises=[];promises.push($.bsCalendar.utils.openHolidayApi.getPublicHolidays(countryIsoCode,federalState,languageIsoCode,period.start,period.end).then(response=>{if(settings.debug){log("Received public holidays:",response)}return response.map(holiday=>({startDate:holiday.startDate,endDate:holiday.endDate,title:holiday.name[0]?.text}))}));if(federalState!==null){if(settings.debug){log("Load school holidays with params:",{country:countryIsoCode,language:languageIsoCode,period:period,federalState:federalState})}promises.push($.bsCalendar.utils.openHolidayApi.getSchoolHolidays(countryIsoCode,federalState,period.start,period.end).then(response=>{if(settings.debug){log("Received school holidays:",response)}return response.map(holiday=>({startDate:holiday.startDate,endDate:holiday.endDate,title:holiday.name[0]?.text}))}))}Promise.all(promises).then(results=>{const all=[].concat.apply([],results);const seen=new Set;const unique=all.filter(h=>{const key=[h.startDate,h.endDate,h.title].join("|");if(seen.has(key))return false;seen.add(key);return true});if(settings.debug){log("Draw unique holidays:",unique)}drawHolidays($wrapper,unique)}).finally(()=>{data.loadingHolidays=false;setBsCalendarData($wrapper,data)})}else if(typeof settings.holidays==="function"){if(settings.debug){log("Load custom function holidays with params:",{start:period.start,end:period.end,country:locale.country,language:locale.language,federalState:federalState});log("Make sure a promise is returned!")}Promise.resolve(settings.holidays(period.start,period.end,locale.country,locale.language,federalState)).then(holidays=>{if(settings.debug){log("Received custom holidays:",holidays)}drawHolidays($wrapper,holidays)}).finally(()=>{data.loadingHolidays=false;setBsCalendarData($wrapper,data)})}else{data.loadingHolidays=false;setBsCalendarData($wrapper,data)}}function drawHolidays($wrapper,holidays){const settings=getSettings($wrapper);const view=getView($wrapper);const isDayOrWeek=view==="day"||view==="week";const isMonth=view==="month";const isYear=view==="year";const $viewContainer=getViewContainer($wrapper);holidays.forEach(holiday=>{if(settings.debug){log("Draw holiday:",holiday)}const startDate=new Date(holiday.startDate);const endDate=new Date(holiday.endDate);for(let date=new Date(startDate);date<=endDate;date.setDate(date.getDate()+1)){const formattedDate=date.toISOString().split("T")[0];let container;if(isDayOrWeek){container=$viewContainer.find(`[data-all-day="${date.getDay()}"][data-date-local="${formattedDate}"]`)}else if(isMonth){container=$viewContainer.find(`[data-month-date="${formattedDate}"] [data-role="day-wrapper"]`)}else if(isYear){container=$viewContainer.find(`[data-date="${formattedDate}"]`)}if(container?.length){if(!isYear){if(container.is(":empty")&&(view==="day"||view==="week")){container.addClass("pb-3")}const $holidayWrapper=$("<small>",{"data-role":"holiday",class:"px-1  overflow-hidden mb-1 rounded w-100"}).prependTo(container);$(settings.formatter.holiday(holiday,view)).appendTo($holidayWrapper)}else{container.addClass("text-secondary wc-holiday-marked");container.tooltip({title:holiday.title,container:$wrapper})}}}})}function drawAppointmentsForYear($wrapper,appointments){const $container=getViewContainer($wrapper);appointments.forEach(appointment=>{const $badge=$container.find(`[data-date="${appointment.date}"] .js-badge`);const bg=appointment.extras.colors.backgroundColor;$badge.css({backgroundColor:bg,color:"#ffffff",borderColor:"var(--bs-body-bg)"});$badge.css({width:"8px",height:"8px","font-size":"9px","font-weight":"bold",display:"flex","justify-content":"center","align-items":"center","border-radius":"50%","border-style":"solid","border-width":"2px","box-sizing":"border-box",overflow:"hidden","line-height":"1"});$badge.text(appointment.total);$badge.closest("div").attr("title",appointment.total).tooltip()})}function showBSCalendarLoader($wrapper){hideBSCalendarLoader($wrapper);const spinner=$wrapper.find(".wc-calendar-spinner");spinner.show()}function hideBSCalendarLoader($wrapper){const spinner=$wrapper.find(".wc-calendar-spinner");spinner.hide()}function getStartAndEndDateByView($wrapper){const data=getBsCalendarData($wrapper);const settings=data.settings;const rawDate=data.date;const date=rawDate instanceof Date?new Date(rawDate.getTime()):new Date(rawDate);const view=data.view;const startDate=new Date(date.getTime());const endDate=new Date(date.getTime());switch(view){case"day":break;case"week":{const dayOfWeek=startDate.getDay();const diffToMonday=settings.startWeekOnSunday?dayOfWeek:dayOfWeek===0?-6:1-dayOfWeek;startDate.setDate(startDate.getDate()+diffToMonday);const newEnd=new Date(startDate.getTime());newEnd.setDate(startDate.getDate()+6);endDate.setTime(newEnd.getTime());if(settings.debug){log("getStartAndEndDateByView (week) computed:",{viewDate:$.bsCalendar.utils.formatDateToDateString(date),start:$.bsCalendar.utils.formatDateToDateString(startDate),end:$.bsCalendar.utils.formatDateToDateString(endDate),startWeekOnSunday:settings.startWeekOnSunday})}break}case"month":{startDate.setDate(1);const startDayOfWeek=startDate.getDay();if(settings.startWeekOnSunday){startDate.setDate(startDate.getDate()-startDayOfWeek)}else{const offset=startDayOfWeek===0?6:startDayOfWeek-1;startDate.setDate(startDate.getDate()-offset)}endDate.setMonth(endDate.getMonth()+1);endDate.setDate(0);const endDayOfWeek=endDate.getDay();if(settings.startWeekOnSunday){const offset=6-endDayOfWeek;endDate.setDate(endDate.getDate()+offset)}else{const offset=endDayOfWeek===0?-1:7-endDayOfWeek;endDate.setDate(endDate.getDate()+offset)}break}case"year":case"search":{startDate.setMonth(0);startDate.setDate(1);endDate.setMonth(11);endDate.setDate(31)}break;default:if(settings.debug){console.error("Unknown view:",view)}break}return{date:$.bsCalendar.utils.formatDateToDateString(date),start:$.bsCalendar.utils.formatDateToDateString(startDate),end:$.bsCalendar.utils.formatDateToDateString(endDate)}}function getSearchElement($wrapper){return $wrapper.find("[data-search-input]")||null}function buildSearchView($wrapper){const container=getViewContainer($wrapper);container.empty();$("<div>",{class:"wc-search-result-container list-group list-group-flush overflow-auto"}).appendTo(container)}function buildMonthView($wrapper){const data=getBsCalendarData($wrapper);const mainColor=data.mainColor;const container=getViewContainer($wrapper);const settings=data.settings;const date=data.date;const{locale,startWeekOnSunday}=settings;const year=date.getFullYear();const month=date.getMonth();const firstDayOfMonth=new Date(year,month,1);const lastDayOfMonth=new Date(year,month+1,0);let calendarStart=new Date(firstDayOfMonth);while(calendarStart.getDay()!==(startWeekOnSunday?0:1)){calendarStart.setDate(calendarStart.getDate()-1)}let calendarEnd=new Date(lastDayOfMonth);while(calendarEnd.getDay()!==(startWeekOnSunday?6:0)){calendarEnd.setDate(calendarEnd.getDate()+1)}container.empty();const weekDays=$.bsCalendar.utils.getShortWeekDayNames(locale,startWeekOnSunday);const table=$("<table>",{class:"table m-0 p-0  w-100",css:{tableLayout:"fixed",borderCollapse:"collapse",borderSpacing:"0"}}).appendTo(container);const tbody=$("<tbody>").appendTo(table);let currentDate=new Date(calendarStart);let isFirstRow=true;while(currentDate<=calendarEnd){const checkDate=new Date(currentDate);checkDate.setDate(checkDate.getDate()+6);const isLastRow=checkDate.getTime()>=calendarEnd.getTime()-432e5;const tr=$("<tr>",{class:"wc-calendar-content"}).appendTo(tbody);const calendarWeek=$.bsCalendar.utils.getCalendarWeek(currentDate);const paddingTop=isFirstRow?"1.75rem":".15rem";let kwClasses="align-top bg-body-tertiary text-muted fw-bold text-center border-top border-start";if(isLastRow)kwClasses+=" border-bottom";const weekColumn=$("<td>",{class:kwClasses,css:{verticalAlign:"top",paddingTop:paddingTop,width:"30px"},html:`<small>${calendarWeek}</small>`}).appendTo(tr);if(settings.views.includes("week")){weekColumn.attr("data-week-date",$.bsCalendar.utils.formatDateToDateString(currentDate)).css("cursor","pointer")}for(let i=0;i<7;i++){const isToday=currentDate.toDateString()===(new Date).toDateString();const isOtherMonth=currentDate.getMonth()!==month;const isLastColumn=i===6;let borderClasses=["border-top","border-start"];if(isLastColumn)borderClasses.push("border-end");if(isLastRow)borderClasses.push("border-bottom");let dayCss=["border-radius: 50%","width: 24px","height: 24px","line-height: 24px","font-size: 12px","cursor: pointer"];if(isToday){dayCss.push(`background-color: ${mainColor.backgroundColor}`);dayCss.push(`background-image: ${mainColor.backgroundImage}`);dayCss.push(`color: ${mainColor.color}`)}const td=$("<td>",{"data-month-date":$.bsCalendar.utils.formatDateToDateString(currentDate),class:`align-top px-1 py-0 ${borderClasses.join(" ")} ${isOtherMonth?"text-muted bg-body-tertiary":"bg-body"}`,css:{verticalAlign:"top",overflow:"hidden",position:"relative"}}).appendTo(tr);const contentWrapper=$("<div>",{class:"d-flex flex-column w-100 h-100"}).appendTo(td);if(isFirstRow){$("<div>",{class:"text-center text-uppercase fw-bold text-body-secondary small pt-1",css:{lineHeight:"16px",fontSize:"10px"},text:weekDays[i]}).appendTo(contentWrapper)}$("<small>",{"data-date":$.bsCalendar.utils.formatDateToDateString(currentDate),class:`text-center my-1 align-self-center`,style:dayCss.join(";"),text:currentDate.getDate()}).appendTo(contentWrapper);$("<div>",{class:"d-flex flex-column w-100 flex-fill","data-role":"day-wrapper",css:{overflowY:"auto",minHeight:0}}).appendTo(contentWrapper);currentDate.setDate(currentDate.getDate()+1)}isFirstRow=false}}function onResize($wrapper,handleSidebar=false){const data=getBsCalendarData($wrapper);const view=data.view;const windowWidth=$(window).width();const lgBreakPoint=992;const calendarContainer=getViewContainer($wrapper);if(handleSidebar){handleSidebarVisibility($wrapper,windowWidth<lgBreakPoint,windowWidth>=lgBreakPoint)}if(view==="month"){const dayElements=calendarContainer.find("[data-month-date]");let squareSize=0;dayElements.each(function(){const width=$(this).outerWidth();$(this).css("height",`${width}px`);squareSize=width});const rowCount=Math.ceil(dayElements.length/7);const totalHeight=rowCount*squareSize;calendarContainer.css("height",`${totalHeight}px`)}else{calendarContainer.css("height","")}}function buildMonthSmallView($wrapper,forDate,$container,forYearView=false){const data=getBsCalendarData($wrapper);const mainColor=data.mainColor;const settings=data.settings;const date=forDate;const activeDate=data.date;const{startWeekOnSunday}=settings;const cellSize=forYearView?36:28;const fontSize=forYearView?13:11;const weekRowWidth=24;const year=date.getFullYear();const month=date.getMonth();const firstDayOfMonth=new Date(year,month,1);const lastDayOfMonth=new Date(year,month+1,0);let calendarStart=new Date(firstDayOfMonth);while(calendarStart.getDay()!==(startWeekOnSunday?0:1)){calendarStart.setDate(calendarStart.getDate()-1)}let calendarEnd=new Date(lastDayOfMonth);while(calendarEnd.getDay()!==(startWeekOnSunday?6:0)){calendarEnd.setDate(calendarEnd.getDate()+1)}$container.empty();$container.addClass("d-flex justify-content-center p-1 bg-body");const totalWidth=cellSize*7+weekRowWidth;const table=$("<table>",{class:"table table-borderless m-0 p-0 text-center user-select-none",css:{width:`${totalWidth}px`,minWidth:`${totalWidth}px`,fontSize:fontSize+"px",borderCollapse:"collapse",tableLayout:"fixed",lineHeight:cellSize+"px",margin:"0 auto"}}).appendTo($container);const thead=$("<thead>").appendTo(table);const weekdaysRow=$("<tr>",{css:{height:`${cellSize}px`}}).appendTo(thead);$("<th>",{class:"p-0",css:{width:weekRowWidth+"px"},text:""}).appendTo(weekdaysRow);const weekDays=$.bsCalendar.utils.getShortWeekDayNames(settings.locale,settings.startWeekOnSunday);weekDays.forEach(day=>{$("<th>",{text:day.substring(0,2),class:"text-body-secondary fw-normal p-0",css:{width:`${cellSize}px`,verticalAlign:"middle"}}).appendTo(weekdaysRow)});const tbody=$("<tbody>").appendTo(table);let currentDate=new Date(calendarStart);while(currentDate<=calendarEnd){const weekRow=$("<tr>",{css:{height:`${cellSize}px`}}).appendTo(tbody);const calendarWeek=$.bsCalendar.utils.getCalendarWeek(currentDate);const weekColumn=$("<td>",{class:"text-body-tertiary p-0 align-middle small",css:{fontSize:fontSize-3+"px",width:weekRowWidth+"px"},text:calendarWeek}).appendTo(weekRow);if(settings.views.includes("week")){weekColumn.attr("data-week-date",$.bsCalendar.utils.formatDateToDateString(currentDate)).css("cursor","pointer")}for(let i=0;i<7;i++){const isToday=currentDate.toDateString()===(new Date).toDateString();const isOtherMonth=currentDate.getMonth()!==month;const isSelected=currentDate.toDateString()===activeDate.toDateString();let dayClass="rounded-circle d-inline-flex align-items-center justify-content-center transition-base";let dayStyles={width:cellSize-4+"px",height:cellSize-4+"px",margin:"2px auto",position:"relative"};if(isToday){dayStyles.backgroundColor=mainColor.backgroundColor;dayStyles.backgroundImage=mainColor.backgroundImage;dayStyles.color=mainColor.color;dayStyles.fontWeight="600";dayClass+=" shadow-sm"}else if(isSelected){dayStyles.boxShadow=`inset 0 0 0 2px ${mainColor.backgroundColor}`;dayStyles.color="var(--bs-body-color)";dayStyles.fontWeight="600"}else if(isOtherMonth){dayClass+=" text-body-tertiary opacity-50"}else{dayClass+=" hover-bg-body-secondary"}const $cellContent=$("<div>",{class:dayClass,css:dayStyles,html:`<span>${currentDate.getDate()}</span>`});if(forYearView){$("<span>",{class:"js-badge position-absolute top-100 start-50 translate-middle z-2",css:{display:"none"}}).appendTo($cellContent)}$("<td>",{"data-date":$.bsCalendar.utils.formatDateToDateString(currentDate),class:"p-0 align-middle position-relative",css:{cursor:"pointer"}}).append($cellContent).appendTo(weekRow);currentDate.setDate(currentDate.getDate()+1)}}}function buildDayView($wrapper){const $container=getViewContainer($wrapper).empty();const date=getDate($wrapper);const headline=$("<div>",{class:"wc-day-header mb-2 ms-5",css:{paddingLeft:"40px"},html:buildHeaderForDay($wrapper,date,false)}).appendTo($container);headline.attr("data-date",$.bsCalendar.utils.formatDateToDateString(date)).css("cursor","pointer");$("<div>",{"data-all-day":date.getDay(),"data-date-local":$.bsCalendar.utils.formatDateToDateString(date),class:"mx-5",css:{paddingLeft:"40px"}}).appendTo($container);buildDayViewContent($wrapper,date,$container)}function buildWeekView($wrapper){const $viewContainer=getViewContainer($wrapper);$viewContainer.empty();const $container=$("<div>",{class:"position-relative px-1 px-lg-5"}).appendTo($viewContainer);const date=getDate($wrapper);const settings=getSettings($wrapper);const{startWeekOnSunday}=settings;const currentDay=date.getDay();const startOfWeek=new Date(date);const startOffset=startWeekOnSunday?currentDay:currentDay===0?6:currentDay-1;startOfWeek.setDate(date.getDate()-startOffset);const endOfWeek=new Date(startOfWeek);endOfWeek.setDate(startOfWeek.getDate()+6);if(settings.debug){log(`buildWeekView - viewDate=${$.bsCalendar.utils.formatDateToDateString(date)}, startOfWeek=${$.bsCalendar.utils.formatDateToDateString(startOfWeek)}, endOfWeek=${$.bsCalendar.utils.formatDateToDateString(endOfWeek)}, startWeekOnSunday=${startWeekOnSunday}`)}const wrappAllDay=$("<div>",{class:"d-flex flex-nowrap flex-fill w-100",css:{paddingLeft:"40px"}}).appendTo($container);for(let day=0;day<7;day++){const col=$("<div>",{class:"flex-grow-1 d-flex flex-column jusify-content-center align-items-center flex-fill position-relative overflow-hidden",css:{width:100/7+"%"}}).appendTo(wrappAllDay);const currentDate=new Date(startOfWeek);currentDate.setDate(startOfWeek.getDate()+day);const headline=$("<div>",{class:"wc-day-header mb-2",html:buildHeaderForDay($wrapper,currentDate,false)}).appendTo(col);headline.attr("data-date",$.bsCalendar.utils.formatDateToDateString(currentDate)).css("cursor","pointer");$("<div>",{"data-all-day":currentDate.getDay(),"data-date-local":$.bsCalendar.utils.formatDateToDateString(currentDate),class:"d-flex flex-column align-items-stretch flex-fill w-100"}).appendTo(col)}const weekContainer=$("<div>",{class:"wc-week-view d-flex flex-nowrap",css:{paddingLeft:"40px"}}).appendTo($container);for(let day=0;day<7;day++){const currentDate=new Date(startOfWeek);currentDate.setDate(startOfWeek.getDate()+day);const dayContainer=$("<div>",{"data-week-day":currentDate.getDay(),"data-date-local":$.bsCalendar.utils.formatDateToDateString(currentDate),class:"wc-day-week-view flex-grow-1 flex-fill border-end position-relative",css:{width:100/7+"%"}}).appendTo(weekContainer);const showLabels=day===0;buildDayViewContent($wrapper,currentDate,dayContainer,true,showLabels)}}function buildHeaderForDay($wrapper,date,forWeekView=false){const data=getBsCalendarData($wrapper);const mainColor=data.mainColor;const settings=data.settings;const day=date.toLocaleDateString(settings.locale,{day:"numeric"});const shortWeekday=date.toLocaleDateString(settings.locale,{weekday:"short"});const justify=forWeekView?"center":"start";const isToday=date.toDateString()===(new Date).toDateString();const circleCss=["width: 44px","height: 44px","line-height: 44px"];const circleClasses=[];if(isToday){circleClasses.push("rounded-circle");circleCss.push(`background-color: ${mainColor.backgroundColor}`);circleCss.push(`background-image: ${mainColor.backgroundImage}`);circleCss.push(`color: ${mainColor.color}`)}return[`<div class="d-flex flex-column justify-content-center w-100 p-2 align-items-${justify}">`,`<div class="d-flex justify-content-center" style="width: 44px"><small>${shortWeekday}</small></div>`,`<span style="${circleCss.join(";")}" class="h4 m-0 text-center ${circleClasses.join(" ")}">${day} </span>`,`</div>`].join("")}function buildDayViewContent($wrapper,date,$container,forWeekView=false,showLabels=true){const settings=getSettings($wrapper);const isToday=date.toDateString()===(new Date).toDateString();if(!forWeekView){$container=$("<div>",{class:"position-relative px-1 px-lg-5"}).appendTo($container);$container=$("<div>",{css:{paddingLeft:"40px"}}).appendTo($container)}$container.attr("data-weekday");$container.css("boxSizing","border-box");const timeSlots=$("<div>",{"data-week-day":date.getDay(),"data-date-local":$.bsCalendar.utils.formatDateToDateString(date),class:"wc-day-view-time-slots d-flex flex-column position-relative"}).appendTo($container);for(let hour=settings.hourSlots.start;hour<=settings.hourSlots.end;hour++){const isLast=hour===settings.hourSlots.end;const height=isLast?0:settings.hourSlots.height;const css=isLast?{}:{boxSizing:"border-box",height:height+"px",cursor:"copy"};const row=$("<div>",{"data-day-hour":hour,css:css,class:"d-flex align-items-center border-top position-relative"}).appendTo(timeSlots);row.data("details",{hour:hour,date:date,isToday:isToday,isLast:isLast});if(!isLast&&Number.isFinite(height)&&height>30&&height%2===0){$("<div>",{class:"position-absolute w-100",css:{top:Math.max(0,Math.floor(height/2)-1)+"px",left:0,borderTop:"1px dashed var(--bs-border-color, #dee2e6)",pointerEvents:"none"},"aria-hidden":"true"}).appendTo(row)}if(showLabels){const combinedCss=["left: -34px"].join(";");const hourDate=new Date(2023,0,1,hour);$("<div>",{class:"wc-time-label ps-2 position-absolute top-0 translate-middle",style:combinedCss,html:$.bsCalendar.utils.formatTime(hourDate,false)}).appendTo(row)}}if(isToday){addCurrentTimeIndicator($wrapper,timeSlots)}}function addCurrentTimeIndicator($wrapper,$container){const data=getBsCalendarData($wrapper);const mainColor=data.mainColor;const getDynamicNow=()=>new Date;const settings=data.settings;if(settings===null){return}const{hourSlots}=settings;const calculatePosition=()=>{const now=getDynamicNow();const currentHour=now.getHours()+now.getMinutes()/60;if(currentHour<hourSlots.start){return{top:0,bottom:""}}else if(currentHour>=hourSlots.end){return{top:"",bottom:0}}else{return{top:calculateSlotPosition($wrapper,now).top,bottom:""}}};const position=calculatePosition();const currentTimeIndicator=$("<div>",{class:"current-time-indicator position-absolute",css:{backgroundColor:mainColor.backgroundColor,backgroundImage:mainColor.backgroundImage,color:mainColor.color,boxSizing:"border-box",height:"1px",width:"100%",zIndex:10,...position}}).appendTo($container);const badgeColor=$.bsCalendar.utils.getColors("danger gradient",null);const combinedCss=["background-color: "+mainColor.backgroundColor,"background-image: "+mainColor.backgroundImage,"color: "+mainColor.color].join(";");$(`<small class="position-absolute badge js-current-time top-0 start-0 translate-middle" style="${combinedCss}">`+$.bsCalendar.utils.formatTime(getDynamicNow(),false)+"</small>").appendTo(currentTimeIndicator);const combinedCss2=["background-color: "+mainColor.backgroundColor,"background-image: "+mainColor.backgroundImage,"color: "+mainColor.color,"width: 10px","height: 10px"].join(";");$(`<div class="position-absolute start-100 top-50 rounded-circle translate-middle" style="${combinedCss2}"></div>`).appendTo(currentTimeIndicator);const updateIndicator=()=>{const now=getDynamicNow();const newPosition=calculatePosition();currentTimeIndicator.css(newPosition);currentTimeIndicator.find(".js-current-time").text($.bsCalendar.utils.formatTime(now,false))};const intervalId=setInterval(()=>{const isWrapperInDOM=$wrapper.closest("body").length>0;const hasTimeIndicator=$wrapper.find(".current-time-indicator").length>0;if(!isWrapperInDOM||!hasTimeIndicator){clearInterval(intervalId);return}updateIndicator()},60*1e3);updateIndicator()}function calculateSlotPosition($wrapper,startDate,endDate){const settings=getSettings($wrapper);if(typeof startDate==="string"){startDate=new Date(startDate)}if(typeof endDate==="string"){endDate=new Date(endDate)}const startHours=startDate.getHours();const startMinutes=startDate.getMinutes();const endHours=endDate?endDate.getHours():null;const endMinutes=endDate?endDate.getMinutes():null;if(startHours<settings.hourSlots.start&&(!endHours||endHours<=settings.hourSlots.start)||startHours>=settings.hourSlots.end){return{top:0,height:0}}let adjustedStartHours=Math.max(startHours,settings.hourSlots.start);let adjustedStartMinutes=startHours<settings.hourSlots.start?0:startMinutes;let adjustedEndHours=endHours!==null?Math.min(endHours,settings.hourSlots.end):null;let adjustedEndMinutes=endHours!==null&&endHours>=settings.hourSlots.end?0:endMinutes;const top=(adjustedStartHours-settings.hourSlots.start)*settings.hourSlots.height+adjustedStartMinutes/60*settings.hourSlots.height+4;let height=0;if(endDate){const durationMinutes=adjustedEndHours*60+adjustedEndMinutes-(adjustedStartHours*60+adjustedStartMinutes);height=durationMinutes/60*settings.hourSlots.height}return{top:top-4,height:height>0?height:0}}function buildYearView($wrapper){const container=getViewContainer($wrapper);const settings=getSettings($wrapper);const date=getDate($wrapper);const year=date.getFullYear();container.empty();const grid=$("<div>",{class:"d-flex flex-wrap justify-content-center gap-3 py-4"}).appendTo(container);const roundedClass=`rounded-${settings.rounded}`;for(let month=0;month<12;month++){const monthWrapper=$("<div>",{class:`d-flex flex-column align-items-center wc-year-month-container wc-round-me bg-body shadow-sm p-3 ${roundedClass}`,css:{minWidth:"260px"}}).appendTo(grid);const monthName=new Intl.DateTimeFormat(settings.locale,{month:"long"}).format(new Date(year,month));$("<div>",{"data-month":`${year}-${String(month+1).padStart(2,"0")}-01`,class:"fw-bold text-uppercase text-body-secondary mb-3",text:`${monthName}`,css:{cursor:"pointer",letterSpacing:"1px",fontSize:"0.85rem"}}).appendTo(monthWrapper);const monthContainer=$("<div>").appendTo(monthWrapper);const tempDate=new Date(year,month,1);buildMonthSmallView($wrapper,tempDate,monthContainer,true)}}function showInfoWindow($wrapper,$targetElement){const settings=getSettings($wrapper);const appointment=$targetElement.data("appointment");let $modal=$(globalCalendarElements.infoModal);const returnData=getAppointmentForReturn(appointment);trigger($wrapper,"show-info-window",returnData.appointment,returnData.extras);settings.formatter.window(returnData.appointment,returnData.extras).then(html=>{const modalExists=$modal.length>0;if(!modalExists){const roundedClass="rounded-"+settings.rounded;const borderClass=settings.border;const modalHtml=[`<div class="modal fade pe-none" id="${globalCalendarElements.infoModal.substring(1)}" tabindex="-1" data-bs-backdrop="false">`,`<div class="modal-dialog modal-fullscreen-sm-down position-absolute pe-auto">`,`<div class="modal-content ${borderClass} wc-round-me ">`,`<div class="modal-body d-flex flex-column align-items-stretch pb-4">`,`<div class="d-flex justify-content-end align-items-center" data-modal-options>`,`<button type="button" data-bs-dismiss="modal" class="btn"><i class="bi bi-x-lg"></i></button>`,`</div>`,`<div class="modal-appointment-content flex-fill overflow-y-auto">`,html,`</div>`,`</div>`,`</div>`,`</div>`,`</div>`].join("");$("body").append(modalHtml);$modal=$(globalCalendarElements.infoModal);$modal.attr("data-bs-calendar-wrapper-id",$wrapper.attr("data-bs-calendar-id"));$modal.modal({backdrop:false,keyboard:true})}else{$modal.find(".modal-appointment-content").html(html)}$modal.data("appointment",appointment);const modalOptions=$modal.find("[data-modal-options]");const deleteable=appointment.hasOwnProperty("deleteable")?appointment.deleteable:true;const editable=appointment.hasOwnProperty("editable")?appointment.editable:true;if(editable){if(!$modal.find("[data-edit]").length){$(`<button type="button" data-edit class="btn"><i class="bi bi-pen"></i></button>`).prependTo(modalOptions)}}else{$modal.find("[data-edit]").remove()}if(deleteable){if(!$modal.find("[data-remove]").length){$(`<button type="button" data-remove data-bs-dismiss="modal" class="btn"><i class="bi bi-trash3"></i></button>`).prependTo(modalOptions)}}else{$modal.find("[data-remove]").remove()}const $modalDialog=$modal.find(".modal-dialog");const $target=$($targetElement);const targetOffset=$target.offset();const targetWidth=$target.outerWidth();const targetHeight=$target.outerHeight();setTimeout(()=>{const modalWidth=$modalDialog.outerWidth();const modalHeight=$modalDialog.outerHeight();const minSpaceFromEdge=60;const viewportWidth=$(window).width();const viewportHeight=$(window).height();const scrollTop=$(window).scrollTop();const scrollLeft=$(window).scrollLeft();const spaceAbove=targetOffset.top-scrollTop;const spaceBelow=viewportHeight-(targetOffset.top-scrollTop+targetHeight);const spaceLeft=targetOffset.left-scrollLeft;const spaceRight=viewportWidth-(targetOffset.left-scrollLeft+targetWidth);let position="bottom";if(spaceAbove>=Math.max(spaceBelow,spaceLeft,spaceRight)){position="top"}else if(spaceBelow>=Math.max(spaceAbove,spaceLeft,spaceRight)){position="bottom"}else if(spaceLeft>=Math.max(spaceAbove,spaceBelow,spaceRight)){position="left"}else if(spaceRight>=Math.max(spaceAbove,spaceBelow,spaceLeft)){position="right"}let top=0;let left=0;switch(position){case"top":top=targetOffset.top-scrollTop-modalHeight-10;left=targetOffset.left-scrollLeft+targetWidth/2-modalWidth/2;break;case"bottom":top=targetOffset.top-scrollTop+targetHeight+10;left=targetOffset.left-scrollLeft+targetWidth/2-modalWidth/2;break;case"left":top=targetOffset.top-scrollTop+targetHeight/2-modalHeight/2;left=targetOffset.left-scrollLeft-modalWidth-10;break;case"right":top=targetOffset.top-scrollTop+targetHeight/2-modalHeight/2;left=targetOffset.left-scrollLeft+targetWidth+10;break}if(top<minSpaceFromEdge){top=minSpaceFromEdge}if(left<minSpaceFromEdge){left=minSpaceFromEdge}if(top+modalHeight>viewportHeight-minSpaceFromEdge){top=viewportHeight-modalHeight-minSpaceFromEdge}if(left+modalWidth>viewportWidth-minSpaceFromEdge){left=viewportWidth-modalWidth-minSpaceFromEdge}if(viewportWidth<=768){top=0;left=0}if(modalExists){$modalDialog.animate({top:`${top}px`,left:`${left}px`})}else{$modalDialog.css({top:`${top}px`,left:`${left}px`})}},0);$modal.modal("show")})}})(jQuery);